
#include "Xlib_private.h"

/*
 * These are all functions where macros already exist
 */

Window XDefaultRootWindow(Display* display)
{
	DBUG_ENTER("XDefaultRootWindow")
	Window root = DefaultRootWindow(display);
	DBUG_RETURN(root);
}

Screen *XScreenOfDisplay(Display* display, int screen_number) 
{
	DBUG_ENTER("XScreenOfDisplay")
	Screen *screen = ScreenOfDisplay(display, screen_number);
	DBUG_RETURN(screen);
}

Window XRootWindow(Display* display, int screen_number)
{
	DBUG_ENTER("XRootWindow")
	Window root = RootWindow(display, screen_number);
	DBUG_RETURN(root);
}

Visual *XDefaultVisual(Display* display, int screen_number)
{
	DBUG_ENTER("XDefaultVisual")
	Visual *visual = DefaultVisual(display, screen_number);
	DBUG_RETURN(visual);
}

GC XDefaultGC(Display* display, int screen_number)
{
	DBUG_ENTER("XDefaultGC")
	GC gc = DefaultGC(display, screen_number);
	DBUG_RETURN(gc);
}

unsigned long XBlackPixel(Display* display, int screen_number)
{
	DBUG_ENTER("XBlackPixel")
	unsigned long black = BlackPixel(display, screen_number);
	DBUG_RETURN(black);
}

unsigned long XWhitePixel(Display* display, int screen_number)
{
	DBUG_ENTER("XWhitePixel")
	unsigned long white = WhitePixel(display, screen_number);
	DBUG_RETURN(white);
}

int XDisplayWidth(Display* display, int screen_number)
{
	DBUG_ENTER("XDisplayWidth")
	int width = DisplayWidth(display, screen_number);
	DBUG_RETURN(width);
}

int XDisplayWidthMM(Display* display, int screen_number)
{
	DBUG_ENTER("XDisplayWidthMM")
	int width = DisplayWidthMM(display, screen_number);
	DBUG_RETURN(width);
}

int XDisplayHeight(Display* display, int screen_number)
{
	DBUG_ENTER("XDisplayHeight")
	int height = DisplayHeight(display, screen_number);
	DBUG_RETURN(height);
}

int XDisplayHeightMM(Display* display, int screen_number)
{
	DBUG_ENTER("XDisplayHeightMM")
	int height = DisplayHeightMM(display, screen_number);
	DBUG_RETURN(height);
}

int XDisplayPlanes(Display* display, int screen_number)
{
	DBUG_ENTER("XDisplayPlanes")
	int planes = DisplayPlanes(display, screen_number);
	DBUG_RETURN(planes);
}

int XDefaultDepth(Display* display, int screen_number)
{
	DBUG_ENTER("XDefaultDepth")
	int result = DefaultDepth(display, screen_number);
	DBUG_RETURN(result);
}

Screen *XDefaultScreenOfDisplay(Display* display)
{
	DBUG_ENTER("XDefaultScreenOfData")
	Screen *result = DefaultScreenOfDisplay(display);
	DBUG_RETURN(result);
}

int XDefaultScreen(Display* display)
{
	DBUG_ENTER("XDefaultScreen")
	int result = DefaultScreen(display);
	DBUG_RETURN(result);
}

int XConnectionNumber(Display* display)
{
	DBUG_ENTER("XConnectionNumber")
	int result = ConnectionNumber(display);
	DBUG_RETURN(result);
}

unsigned long XAllPlanes(void)
{
	DBUG_ENTER("XAllPlanes")
	unsigned long result = AllPlanes;
	DBUG_RETURN(result);
}

int XQLength(Display* display)
{
	DBUG_ENTER("XQLength")
	int result = QLength(display);
	DBUG_RETURN(result);
}

int XDisplayCells(Display* display, int screen_number)
{
	DBUG_ENTER("XDisplayCells")
	int result = DisplayCells(display, screen_number);
	DBUG_RETURN(result);
}

int XScreenCount(Display* display)
{
	DBUG_ENTER("XScreenCount")
	int result = ScreenCount(display);
	DBUG_RETURN(result);
}

char *XDisplayString(Display* display)
{
	DBUG_ENTER("XDisplayString")
	char *result = DisplayString(display);
	DBUG_RETURN(result);
}

Colormap XDefaultColormap(Display* display, int screen_number)
{
	DBUG_ENTER("XDefaultColormap")
	Colormap result = DefaultColormap(display, screen_number);
	DBUG_RETURN(result);
}

Colormap XDefaultColormapOfScreen(Screen* screen)
{
	DBUG_ENTER("XDefaultColormapOfScreen")
	Colormap result = DefaultColormapOfScreen(screen);
	DBUG_RETURN(result);
}

int XBitmapUnit(Display* display)
{
	DBUG_ENTER("XBitmapUnit")
	int result = BitmapUnit(display);
	DBUG_RETURN(result);
}

int XBitmapBitOrder(Display* display)
{
	DBUG_ENTER("XBitmapBitOrder")
	int result = BitmapBitOrder(display);
	DBUG_RETURN(result);
}

int XBitmapPad(Display* display)
{
	DBUG_ENTER("XBitmapPad")
	int result = BitmapPad(display);
	DBUG_RETURN(result);
}

int XImageByteOrder(Display* display)
{
	DBUG_ENTER("XImageByteOrder")
	int result = ImageByteOrder(display);
	DBUG_RETURN(result);
}

unsigned long XNextRequest(Display* display)
{
	DBUG_ENTER("XNextRequest")
	unsigned long result = NextRequest(display);
	DBUG_RETURN(result);
}

unsigned long XLastKnownRequestProcessed(Display* display)
{
	DBUG_ENTER("XLastKnownRequestProcessed")
	unsigned long result = LastKnownRequestProcessed(display);
	DBUG_RETURN(result);
}

Display *XDisplayOfScreen(Screen* screen)
{
	DBUG_ENTER("XDisplayOfScreen")
	Display *result = DisplayOfScreen(screen);
	DBUG_RETURN(result);
}

Window XRootWindowOfScreen(Screen* screen)
{
	DBUG_ENTER("XRootWindowOfScreen")
	Window result = RootWindowOfScreen(screen);
	DBUG_RETURN(result);
}

unsigned long XBlackPixelOfScreen(Screen* screen)
{
	DBUG_ENTER("XBlackPixelOfScreen")
	unsigned long result = BlackPixelOfScreen(screen);
	DBUG_RETURN(result);
}

unsigned long XWhitePixelOfScreen(Screen* screen)
{
	DBUG_ENTER("XWhitePixelOfScreen")
	unsigned long result = WhitePixelOfScreen(screen);
	DBUG_RETURN(result);
}

int XDefaultDepthOfScreen(Screen* screen)
{
	DBUG_ENTER("XDefaultDepthOfScreen")
	int result = DefaultDepthOfScreen(screen);
	DBUG_RETURN(result);
}

GC XDefaultGCOfScreen(Screen* screen)
{
	DBUG_ENTER("XDefaultGCOfScreen")
	GC result = DefaultGCOfScreen(screen);
	DBUG_RETURN(result);
}

Visual *XDefaultVisualOfScreen(Screen* screen)
{
	DBUG_ENTER("XDefaultVisualOfScreen")
	Visual *result = DefaultVisualOfScreen(screen);
	DBUG_RETURN(result);
}

int XWidthMMOfScreen(Screen* screen)
{
	DBUG_ENTER("XWidthMMOfScreen")
	int result = WidthMMOfScreen(screen);
	DBUG_RETURN(result);
}

int XWidthOfScreen(Screen* screen)
{
	DBUG_ENTER("XWidthOfScreen")
	int result = WidthOfScreen(screen);
	DBUG_RETURN(result);
}

int XHeightMMOfScreen(Screen* screen)
{
	DBUG_ENTER("XHeightMMOfScreen")
	int result = HeightMMOfScreen(screen);
	DBUG_RETURN(result);
}

int XHeightOfScreen(Screen* screen)
{
	DBUG_ENTER("XHeightOfScreen")
	int result = HeightOfScreen(screen);
	DBUG_RETURN(result);
}

int XPlanesOfScreen(Screen* screen)
{
	DBUG_ENTER("XPlanesOfScreen")
	int result = PlanesOfScreen(screen);
	DBUG_RETURN(result);
}

int XCellsOfScreen(Screen* screen)
{
	DBUG_ENTER("XCellsOfScreen")
	int result = CellsOfScreen(screen);
	DBUG_RETURN(result);
}

int XMaxCmapsOfScreen(Screen* screen)
{
	DBUG_ENTER("XMaxCmapsOfScreen")
	int result = MaxCmapsOfScreen(screen);
	DBUG_RETURN(result);
}

int XMinCmapsOfScreen(Screen* screen)
{
	DBUG_ENTER("XMinCmapsOfScreen")
	int result = MinCmapsOfScreen(screen);
	DBUG_RETURN(result);
}

Bool XDoesSaveUnders(Screen* screen)
{
	DBUG_ENTER("XDoesSaveUnders")
	Bool result = DoesSaveUnders(screen);
	DBUG_RETURN(result);
}

int XDoesBackingStore(Screen* screen)
{
	DBUG_ENTER("XDoesBackingStore")
	int result = DoesBackingStore(screen);
	DBUG_RETURN(result);
}

long XEventMaskOfScreen(Screen* screen)
{
	DBUG_ENTER("XEventMaskOfScreen")
	long result = EventMaskOfScreen(screen);
	DBUG_RETURN(result);
}

int XScreenNumberOfScreen (scr)
    register Screen *scr;
{
    DBUG_ENTER("XScreenNumberOfScreen")
    register Display *dpy = scr->display;
    register Screen *dpyscr = dpy->screens;
    register int i;

    for (i = 0; i < dpy->nscreens; i++, dpyscr++) {
	if (scr == dpyscr) DBUG_RETURN(i);
    }
    DBUG_RETURN(-1);
}

/*
 * These macros are used to give some sugar to the image routines so that
 * naive people are more comfortable with them.
 */
#undef XDestroyImage
int XDestroyImage(ximage)
	XImage *ximage;
{
	DBUG_ENTER("XDestroyImage")
	int result = (*((ximage)->f.destroy_image))((ximage));
	DBUG_RETURN(result);
}
#undef XGetPixel
unsigned long XGetPixel(ximage, x, y)
	XImage *ximage;
	int x, y;
{
	DBUG_ENTER("XGetPixel")
	unsigned long result = (*((ximage)->f.get_pixel))((ximage), (x), (y));
	DBUG_RETURN(result);
}
#undef XPutPixel
int XPutPixel(ximage, x, y, pixel)
	XImage *ximage;
	int x, y;
	unsigned long pixel;
{
	DBUG_ENTER("XPutPixel")
	int result = (*((ximage)->f.put_pixel))((ximage), (x), (y), (pixel));
	DBUG_RETURN(result);
}
#undef XSubImage
XImage *XSubImage(ximage, x, y, width, height)
	XImage *ximage;
	int x, y;
	unsigned int width, height;
{
	DBUG_ENTER("XSubImage")
	XImage *result = (*((ximage)->f.sub_image))((ximage), (x),
		(y), (width), (height));
	DBUG_RETURN(result);
}
#undef XAddPixel
int XAddPixel(ximage, value)
	XImage *ximage;
	long value;
{
	DBUG_ENTER("XAddPixel")
	int result = (*((ximage)->f.add_pixel))((ximage), (value));
	DBUG_RETURN(result);
}






