
#ifndef XLIB_PRIVATE
#define XLIB_PRIVATE

#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <limits.h>
#include <unistd.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/signal.h>
#include <io.h>

#include <pthread.h>

#define INCL_BASE
#define INCL_WIN
#define INCL_GPI
#define INCL_WINATOM
#include <os2.h>

/*#define XTHREADS */
#include "X.h"
#include "Xlib.h"
#include "X11/Xatom.h"
#include "X11/Xutil.h"
#include "X11/Xresource.h"
#include "X11/Xproto.h"

/*
 * This structure is private to the library.
 */
typedef struct _XFreeFuncs {
    void (*atoms)();            /* _XFreeAtomTable */
    int (*modifiermap)();       /* XFreeModifierMap */
    void (*key_bindings)();     /* _XFreeKeyBindings */
    void (*context_db)();       /* _XFreeContextDB */
    void (*defaultCCCs)();      /* _XcmsFreeDefaultCCCs */
    void (*clientCmaps)();      /* _XcmsFreeClientCmaps */
    void (*intensityMaps)();    /* _XcmsFreeIntensityMaps */
    void (*im_filters)();       /* _XFreeIMFilters */
    void (*xkb)();              /* _XkbFreeInfo */
} _XFreeFuncRec;

typedef struct _XExten {        /* private to extension mechanism */
        struct _XExten *next;   /* next in list */
        XExtCodes codes;        /* public information, all extension told */
        int (*create_GC)();     /* routine to call when GC created */
        int (*copy_GC)();       /* routine to call when GC copied */
        int (*flush_GC)();      /* routine to call when GC flushed */
        int (*free_GC)();       /* routine to call when GC freed */
        int (*create_Font)();   /* routine to call when Font created */
        int (*free_Font)();     /* routine to call when Font freed */
        int (*close_display)(); /* routine to call when connection closed */
        int (*error)();         /* who to call when an error occurs */
        char *(*error_string)();  /* routine to supply error string */
        char *name;             /* name of this extension */
        void (*error_values)(); /* routine to supply error values */
        void (*before_flush)(); /* routine to call when sending data */
        struct _XExten *next_flush; /* next in list of those with flushes */
} _XExtension;

#define UM_CreateWindow         (WM_USER+0)
#define UM_SetWindowPos         (WM_USER+1)
#define UM_DestroyWindow        (WM_USER+2)
#define UM_CreateGC             (WM_USER+3)
#define UM_ChangeProperty       (WM_USER+4)
#define UM_GetWinProperty       (WM_USER+5)
#define UM_ReparentWindow       (WM_USER+6)

#define QWP_WINATTRIB           (QWL_USER+0)
#define QWP_FRAMEHWND           (QWL_USER+4)

#define GC_NOPATH               (0)
#define GC_STROKEPATH           (1)
#define GC_FILLPATH             (2)
#define GC_AREAFILL             (3)
#define GC_FLUSHPATH            (4)

/*
 * Display flags
 */
#define XlibDisplayIOError      (1L << 0)
#define XlibDisplayClosing      (1L << 1)
#define XlibDisplayNoXkb        (1L << 2)
#define XlibDisplayPrivSync     (1L << 3)
#define XlibDisplayProcConni    (1L << 4) /* in _XProcessInternalConnection */
#define XlibDisplayReadEvents   (1L << 5) /* in _XReadEvents */
#define XlibDisplayReply        (1L << 5) /* in _XReply */
#define XlibDisplayWriting      (1L << 6) /* in _XFlushInt, _XSend */

/* For _XSnprintf */
#define HAS_SNPRINTF
#define LIBX11

struct Xlib_Font_st;
struct Xlib_Pixmap_st;

typedef enum {
        PMATM_NULL, PMATM_FONT, PMATM_BITMAP
}       PMAtmType;

typedef struct {
        PMAtmType type;
        union {
                struct Xlib_Font_st *font;
                struct Xlib_Pixmap_st *pixmap;
        } data;
}       PMAtoms;

typedef struct {
        USHORT  cb;
        GC currentGC;
        HDC hdc;
        HPS hps;
        PMAtoms *pmatoms;
        void *reserved;
        XWindowAttributes winattrib;
        XEvent  *lastexpose, *lastconfigure;
        unsigned int prevkeycode, prevkeystate;
        Pixmap background_pixmap;       /* background or None or ParentRelative */
        unsigned long background_pixel; /* background pixel */
        Cursor cursor;
        Bool delete_window_notify;
        char *wm_name, *wm_iconname, *wm_class, *wm_locale;
        XSizeHints *sizehints;
        XWMHints *hints;
		Window wm_client_leader;
}       WinAttribData;

typedef struct Xlib_Pixmap_st {         /* First 5 elements same as WinAttribData */
        USHORT  cb;
        GC currentGC;
        HDC hdc;
        HPS hps;
        PMAtoms *pmatoms;
        struct Xlib_Pixmap_st **pixatoms;
        HBITMAP hbm;
        int width, height;
        Colormap colormap;
} Xlib_Pixmap;

typedef struct {
        XExtData *ext_data;     /* hook for extension to hang data */
        HPS gid;                /* Presentation space handle */
        HRGN cliprgn;           /* clipmask region */
        XGCValues values;       /* shadow structure of values */
        WinAttribData *winattrib;
        Xlib_Pixmap *pixmap;
        int path;
        POINTL cp;
} Xlib_GC;

typedef struct Xlib_Font_st {
        FATTRS fattrs;
        SIZEF  sizef;
        int    psmode;
        int    descender;
        struct Xlib_Pixmap_st **pixatoms;
} Xlib_Font;

typedef struct {
        HWND    hwndParent;
        ULONG   flStyle;
        PSZ     pszTitle;
        LONG    x;
        LONG    y;
        LONG    cx;
        LONG    cy;
        WinAttribData *winattrib;
        ULONG   frameStyle;
} Xlib_CreateWindow;

typedef struct {
        HWND    hwnd;
        HWND    hwndInsertBehind;
        LONG    x;
        LONG    y;
        LONG    cx;
        LONG    cy;
        ULONG   fl;
} Xlib_SetWindowPos;

typedef struct {
        Display*        display;
        Window          w;
        Atom            property, type;
        int             format, mode;
        unsigned char*  data;
        int             nelements;
} Xlib_ChangeProperty;

typedef struct {
        Display*        display;
        Window          w;
        Atom            property;
        long            long_offset, long_length;
        Bool            delete;
        Atom            req_type, *actual_type_return;
        int*            actual_format_return;
        unsigned long   *nitems_return, *bytes_after_return;
        unsigned char** prop_return;
} Xlib_GetWinProperty;

typedef struct {
        Display*        display;
        Window          w, p;
        int             x, y;
} Xlib_ReparentWindow;

typedef struct _xeventqueue {
        XEvent event;
        long qserial_num;
        struct _xeventqueue *next;
} Xlib_EventQueue;

typedef struct {
        int pixels, points;
        int avgwidth;
        int hres, vres;
} Xlib_FontHints;

#include "X11pmhk.h"

#define PMXLIB_DEFAULT_ICON     0x2000

HAB mainhab;
HMQ mainhmq;
HWND mainhwnd; /* Object instance window handle */
HWND hwndDesktop;
HATOMTBL pmatomtbl;
pthread_t pmthread, mainthread;
Display *maindisplay;
int xinitialized, auto_repeat;

Xlib_EventQueue *EventQueue;
/*Xlib_Grab *Grab;*/
Xlib_Grab *(*Xlib_NewGrab)(void);
void (*Xlib_RemoveGrab)(int);
void (*Xlib_RemoveGrabAny)(int);
Xlib_Grab *(*Xlib_FindGrab)(int);
PFN Xlib_InputQueueHook;

int pmout[2];

pthread_mutex_t evmutex;

int wndcount, UM_FLUSH;
Xlib_GC *gctouched;

char** atomNames;
Atom* atomValues;

USHORT GXtoMixMode[16];
USHORT LineStyletoLineType[3];
USHORT CapStyletoLineEnd[4];
USHORT JoinStyletoLineJoin[3];

GC GCList[1025];

int RestoreGCValues(HPS, XGCValues *, XGCValues *);
XWindowAttributes *GetWinAttrib(Drawable, HPS *);
int GetDrawableHeight(Drawable, GC, HPS *, int);

int RenderFontName(FONTMETRICS *, char *, Xlib_FontHints *, Xlib_Font *);
int PatternMatch(char *, int, char *, int);
int FontFileCountDashes(char *, int);
FONTMETRICS *Xlib_LoadFont(char *, Xlib_Font *);
XFontProp *Xlib_NewFontProp(HPS, FONTMETRICS *, int *n_properties);
XCharStruct *Xlib_NewCharBounds(HPS, FONTMETRICS *, XCharStruct *min, XCharStruct *max);

#ifdef OS2I18N
void Xlib_InitOS2I18N(void);
int Xlib_XlatUCS_2(char *tgt, int tgt_size, void *src, int src_size);
int Xlib_XlatISO8859_1(char *tgt, int tgt_size, char *src, int src_size);
#endif

LONG Xlib_AllocFontAtom(Xlib_Pixmap *client, Xlib_Font *font);
LONG Xlib_AllocPixmapAtom(Xlib_Pixmap *client, Xlib_Pixmap *pixmap);
void Xlib_FreePMAtom(Xlib_Pixmap *client, LONG atom);
void Xlib_FreeAllAtoms(Xlib_Pixmap *client);
void Xlib_FreeFontAtom(Xlib_Font *font);
void Xlib_FreePixmapAtom(Xlib_Pixmap *pixmap);
void Xlib_MonitorResource(XID *resource);
void Xlib_UnmonitorResource(XID *resource);
void Xlib_InvalidateResource(XID resource);

void Xlib_SetGC(HPS hps, Xlib_GC *xgc);

XExtData *new_xextdata(void);
int free_xextdata(XExtData *);

Screen *new_screen(Display *);
int free_screen(Screen *);

Visual *new_visual(void);
int free_visual(Visual *);

XEvent *Xlib_NewEvent(void);
void Xlib_RemoveEvent(XEvent *ev);

Status Xlib_SendEvent(Display *display, Window w, Bool propagate,
                  long event_mask, XEvent *event_send, Bool send_event);

/*BOOL EXPENTRY InputQueueHook (HAB hab, PQMSG pQmsg, USHORT fs);*/

void Xlib_crash(int signal);

int _XFreeExtData (XExtData*);

char *__XOS2RedirRoot(char *fname);
int _XGetHostname(char* buf, int maxlen);
void Xlib_GetDrawableInfo(Drawable d, GC gc, HPS *hps, int pathtype, long *width, long *height);

extern int _XTextHeight(
#if NeedFunctionPrototypes
    XFontStruct*        /* font_struct */,
    _Xconst char*       /* string */,
    int                 /* count */
#endif
);

extern int _XTextHeight16(
#if NeedFunctionPrototypes
    XFontStruct*        /* font_struct */,
    _Xconst XChar2b*    /* string */,
    int                 /* count */
#endif
);

void * pm_thread(void * arg);

#define x11_console_notice(info) fprintf(stdout,"%s\n",info)
#define Xmalloc(size) malloc(size)
#define Xcalloc(a,size) calloc((a),(size))
#define Xfree(ptr) free(ptr)
#define Xrealloc(ptr,size) realloc((ptr),(size))

XrmQuark _XrmInternalStringToQuark(register _Xconst char *name, register int len,
        register unsigned long sig, Bool permstring);

#define min(a,b) (((a) < (b)) ? (a) : (b))
#define max(a,b) (((a) > (b)) ? (a) : (b))

#ifdef XTHREADS
#define LockDisplay(display) pthread_mutex_lock(&_Xglobal_lock)
#define UnlockDisplay(display) pthread_mutex_unlock(&_Xglobal_lock)
#define _XUnlockMutex(mutex) pthread_mutex_unlock(&((pthread_mutex_t)mutex))
#define _XLockMutex(mutex) pthread_mutex_lock(&((pthread_mutex_t)mutex))
#define _XCreateMutex(mutex) _pthread_mutex_init(&((pthread_mutex_t)mutex), NULL)
#define _XFreeMutex(mutes) _pthread_mutex_destroy(&((pthread_mutex_t)mutex))
#else
#define LockDisplay(display)
#define UnlockDisplay(display)
#define _XUnlockMutex(mutex)
#define _XLockMutex(mutex)
#define _XCreateMutex(mutex)
#define _XFreeMutex(mutes)
#endif

#define CI_NONEXISTCHAR(cs) (((cs)->width == 0) && \
                             (((cs)->rbearing|(cs)->lbearing| \
                               (cs)->ascent|(cs)->descent) == 0))

/*
 * CI_GET_CHAR_INFO_1D - return the charinfo struct for the indicated 8bit
 * character.  If the character is in the column and exists, then return the
 * appropriate metrics (note that fonts with common per-character metrics will
 * return min_bounds).  If none of these hold true, try again with the default
 * char.
 */
#define CI_GET_CHAR_INFO_1D(fs,col,def,cs) \
{ \
    cs = def; \
    if (col >= fs->min_char_or_byte2 && col <= fs->max_char_or_byte2) { \
        if (fs->per_char == NULL) { \
            cs = &fs->min_bounds; \
        } else { \
            cs = &fs->per_char[(col - fs->min_char_or_byte2)]; \
            if (CI_NONEXISTCHAR(cs)) cs = def; \
        } \
    } \
}

#define CI_GET_DEFAULT_INFO_1D(fs,cs) \
  CI_GET_CHAR_INFO_1D (fs, fs->default_char, NULL, cs)



/*
 * CI_GET_CHAR_INFO_2D - return the charinfo struct for the indicated row and
 * column.  This is used for fonts that have more than row zero.
 */
#define CI_GET_CHAR_INFO_2D(fs,row,col,def,cs) \
{ \
    cs = def; \
    if (row >= fs->min_byte1 && row <= fs->max_byte1 && \
        col >= fs->min_char_or_byte2 && col <= fs->max_char_or_byte2) { \
        if (fs->per_char == NULL) { \
            cs = &fs->min_bounds; \
        } else { \
            cs = &fs->per_char[((row - fs->min_byte1) * \
                                (fs->max_char_or_byte2 - \
                                 fs->min_char_or_byte2 + 1)) + \
                               (col - fs->min_char_or_byte2)]; \
            if (CI_NONEXISTCHAR(cs)) cs = def; \
        } \
    } \
}

#define CI_GET_DEFAULT_INFO_2D(fs,cs) \
{ \
    unsigned int r = (fs->default_char >> 8); \
    unsigned int c = (fs->default_char & 0xff); \
    CI_GET_CHAR_INFO_2D (fs, r, c, NULL, cs); \
}

extern char *_XAllocScratch(
#if NeedFunctionPrototypes
    Display*            /* dpy */,
    unsigned long       /* nbytes */
#endif
);
extern char *_XAllocTemp(
#if NeedFunctionPrototypes
    Display*            /* dpy */,
    unsigned long       /* nbytes */
#endif
);
extern void _XFreeTemp(
#if NeedFunctionPrototypes
    Display*            /* dpy */,
    char*               /* buf */,
    unsigned long       /* nbytes */
#endif
);

#define SyncHandle() \
        if (dpy->synchandler) (*dpy->synchandler)(dpy)

extern int _XError(
#if NeedFunctionPrototypes
    Display*    /* dpy */,
    xError*     /* rep */
#endif
);
extern int _XIOError(
#if NeedFunctionPrototypes
    Display*    /* dpy */
#endif
);
extern int (*_XIOErrorFunction)(
#if NeedNestedPrototypes
    Display*    /* dpy */
#endif
);
extern int (*_XErrorFunction)(
#if NeedNestedPrototypes
    Display*            /* dpy */,
    XErrorEvent*        /* error_event */
#endif
);

/* internal connections for IMs */

typedef void (*_XInternalConnectionProc)(
#if NeedFunctionPrototypes
    Display*                    /* dpy */,
    int                         /* fd */,
    XPointer                    /* call_data */
#endif
);


extern Status _XRegisterInternalConnection(
#if NeedFunctionPrototypes
    Display*                    /* dpy */,
    int                         /* fd */,
    _XInternalConnectionProc    /* callback */,
    XPointer                    /* call_data */
#endif
);

extern void _XUnregisterInternalConnection(
#if NeedFunctionPrototypes
    Display*                    /* dpy */,
    int                         /* fd */
#endif
);

/* Display structure has pointers to these */

struct _XConnectionInfo {       /* info from _XRegisterInternalConnection */
    int fd;
    _XInternalConnectionProc read_callback;
    XPointer call_data;
    XPointer *watch_data;       /* set/used by XConnectionWatchProc */
    struct _XConnectionInfo *next;
};

struct _XConnWatchInfo {        /* info from XAddConnectionWatch */
    XConnectionWatchProc fn;
    XPointer client_data;
    struct _XConnWatchInfo *next;
};

#ifdef DEBUG

volatile struct Xlib_DebugInfo_st {
        char    *filename;
        int     linenumb;
        char    *procname,*procinfo;
} Xlib_DebugInfo[1024];
volatile int Xlib_DebugOffset;

int Xlib_DebugEnter(char*,int,char*,char*);

#define DBUG_ENTER(a)                                           \
        int DebugLevel = Xlib_DebugEnter(__FILE__,__LINE__,(a),"");
#define DBUG_POINT(a) {                                         \
                Xlib_DebugInfo[DebugLevel].linenumb = __LINE__; \
                Xlib_DebugInfo[DebugLevel].procinfo = a;        \
        }
#define DBUG_LEAVE {                                            \
                Xlib_DebugInfo[DebugLevel].linenumb = __LINE__; \
                Xlib_DebugOffset = --DebugLevel;                \
        }
#define DBUG_RETURN(a) {                                        \
                DBUG_LEAVE;                                     \
                return (a);                                     \
        }
#define DBUG_VOID_RETURN {                                      \
                DBUG_LEAVE;                                     \
                return;                                         \
        }
#else
#define DBUG_ENTER(a)
#define DBUG_POINT(a)
#define DBUG_RETURN(a) return (a)
#define DBUG_VOID_RETURN return
#endif


#endif
