
/*
 * This allocates PM atoms for font cacheing & stipples
 */

#include "Xlib_private.h"

#define PMATOM_LIMIT 1024

LONG Xlib_AllocFontAtom(Xlib_Pixmap *client, Xlib_Font *font)
{
	DBUG_ENTER("Xlib_AllocFontAtom")
	Xlib_Pixmap **pixatom;
	PMAtoms *pmatom;
	LONG atom = 0;
	if (!client || !font) DBUG_RETURN(0);
	if (!(pmatom = client->pmatoms)) 
	if (!(pmatom = client->pmatoms = calloc(PMATOM_LIMIT, sizeof(PMAtoms)))) DBUG_RETURN(0);
	if (!(pixatom = font->pixatoms)) 
	if (!(pixatom = font->pixatoms = calloc(PMATOM_LIMIT, sizeof(void *)))) DBUG_RETURN(0);

	while (atom < PMATOM_LIMIT-1) {
		pmatom++; pixatom++; atom++;
		if (pmatom->type != PMATM_NULL || *pixatom) {
			if (pmatom->type == PMATM_FONT && *pixatom == client &&
			    pmatom->data.font == font) DBUG_RETURN(atom);
			continue;
		}
		*pixatom = client;
		pmatom->type = PMATM_FONT;
		pmatom->data.font = font;
		GpiCreateLogFont(client->hps, NULL, atom, &font->fattrs);
		DBUG_RETURN(atom)
	}
	DBUG_RETURN(0);
}

LONG Xlib_AllocPixmapAtom(Xlib_Pixmap *client, Xlib_Pixmap *pixmap)
{
	DBUG_ENTER("Xlib_AllocPixmapAtom")
	Xlib_Pixmap **pixatom;
	PMAtoms *pmatom;
	LONG atom = 0;
	if (!client || !pixmap) DBUG_RETURN(0);

#ifdef DEBUG_VERBOSE
	fprintf(stderr,"Xlib_AllocPixmapAtom(%p,%p): pmatoms=%p, pixatoms=%p\n",
		client, pixmap, client->pmatoms, pixmap->pixatoms );
#endif


	if (!(pmatom = client->pmatoms))
	if (!(pmatom = client->pmatoms = calloc(PMATOM_LIMIT, sizeof(PMAtoms)))) DBUG_RETURN(0);
	if (!(pixatom = pixmap->pixatoms)) {
	if (!(pixatom = pixmap->pixatoms = calloc(PMATOM_LIMIT, sizeof(void *)))) DBUG_RETURN(0);

#ifdef DEBUG_VERBOSE
	fprintf(stderr,"Xlib_AllocPixmapAtom(%p,%p): pmatom=%p, pixatom=%p\n",
		client, pixmap, pmatom, pixatom );
#endif
}
	while (atom < PMATOM_LIMIT-1) {
#ifdef DEBUG_VERBOSE
		char dbug_st[128];
#endif
		pmatom++; pixatom++; atom++;
#ifdef DEBUG_VERBOSE
		sprintf(dbug_st,"client=%p, pixmap=%p, atom=%ld, pmatom=%p, pixatom=%p",client,pixmap,atom,pmatom,pixatom);
		DBUG_POINT(dbug_st);
#endif
		if (pmatom->type != PMATM_NULL || *pixatom) {
			if (pmatom->type == PMATM_BITMAP && *pixatom == client &&
			    pmatom->data.pixmap == pixmap) DBUG_RETURN(atom);
			continue;
		}
		*pixatom = client;
		pmatom->type = PMATM_BITMAP;
		pmatom->data.pixmap = pixmap;
		GpiSetBitmapId(client->hps, pixmap->hbm, atom);
		DBUG_RETURN(atom)
	}
	DBUG_RETURN(0);
}

static void Xlib_FreeSpecificAtom(HPS hps, PMAtoms *pmatom, LONG atom)
{
	DBUG_ENTER("Xlib_FreeSpecificAtom")
	switch (pmatom->type) {
	case PMATM_NULL:
		/* Nothing to do here */
		break;
	case PMATM_FONT:
		if (!pmatom->data.font || !pmatom->data.font->pixatoms) break;
		pmatom->data.font->pixatoms[atom] = NULL;
		if (GpiQueryCharSet(hps) == atom)
			GpiSetCharSet(hps, LCID_DEFAULT);
		GpiDeleteSetId(hps, atom);
		break;
	case PMATM_BITMAP:
		if (!pmatom->data.pixmap || !pmatom->data.pixmap->pixatoms) break;
		pmatom->data.pixmap->pixatoms[atom] = NULL;
		if (GpiQueryPatternSet(hps) == atom)
			GpiSetPatternSet(hps, LCID_DEFAULT);
		GpiDeleteSetId(hps, atom);
		break;
	}
	pmatom->type = PMATM_NULL;
	DBUG_VOID_RETURN;	
}

void Xlib_FreePMAtom(Xlib_Pixmap *client, LONG atom)
{
	DBUG_ENTER("Xlib_FreePMAtom")
	if (!client || atom < 1 || atom > PMATOM_LIMIT-1 || !client->pmatoms) DBUG_VOID_RETURN;
	Xlib_FreeSpecificAtom(client->hps, &client->pmatoms[atom], atom);
	DBUG_VOID_RETURN;
}

void Xlib_FreeAllAtoms(Xlib_Pixmap *client)
{
	DBUG_ENTER("Xlib_FreeAllAtoms")
	PMAtoms *pmatom;
	LONG atom = 0;
	if (!client || !(pmatom=client->pmatoms)) DBUG_VOID_RETURN;
#ifdef DBUG_VERBOSE
	fprintf(stderr,"Xlib_FreeAllAtoms: client=%p\n",client);
#endif
	while (atom < PMATOM_LIMIT-1) {
		pmatom++; atom++;
		Xlib_FreeSpecificAtom(client->hps, pmatom, atom);
	}
	free(client->pmatoms); client->pmatoms = NULL;
	DBUG_VOID_RETURN;
}

void Xlib_FreeFontAtom(Xlib_Font *font)
{
	DBUG_ENTER("Xlib_FreeFontAtom")
	Xlib_Pixmap **pixatom;
	LONG atom = 0;
	if (!font || !(pixatom = font->pixatoms)) DBUG_VOID_RETURN;
#ifdef DBUG_VERBOSE
	fprintf(stderr,"Xlib_FreeFontAtom: font=%p\n",font);
#endif
	while (atom < PMATOM_LIMIT-1) {
		Xlib_Pixmap *client = *(++pixatom); atom++;
		if (!client || !client->pmatoms) continue;
		Xlib_FreeSpecificAtom(client->hps, &client->pmatoms[atom], atom);
	}
	free(font->pixatoms); font->pixatoms = NULL;
	DBUG_VOID_RETURN;
}

void Xlib_FreePixmapAtom(Xlib_Pixmap *pixmap)
{
	DBUG_ENTER("Xlib_FreePixmapAtom")
	Xlib_Pixmap **pixatom;
	LONG atom = 0;
	if (!pixmap || !(pixatom = pixmap->pixatoms)) DBUG_VOID_RETURN;
#ifdef DBUG_VERBOSE
	fprintf(stderr,"Xlib_FreePixmapAtom: pixmap=%p\n",pixmap);
#endif
	while (atom < PMATOM_LIMIT-1) {
		Xlib_Pixmap *client = *(++pixatom); atom++;
		if (!client || !client->pmatoms) continue;
		Xlib_FreeSpecificAtom(client->hps, &client->pmatoms[atom], atom);
	}
	free(pixmap->pixatoms); pixmap->pixatoms = NULL;
	DBUG_VOID_RETURN;
}

static XID **res_list = NULL;
static int res_listsize = 0, res_listused = 0;

/*
 * The following is primitive, but what the heck!
 */

void Xlib_MonitorResource(XID *resource)
{
	DBUG_ENTER("Xlib_MonitorResource")
	XID **res;
	if (!(res = res_list))
	if (!(res = res_list = calloc(res_listsize = 512, sizeof(XID *))))
		DBUG_VOID_RETURN;
	if (res_listused==res_listsize) {
		res = calloc(res_listsize * 2, sizeof(XID *));
		memcpy(res, res_list, res_listsize * sizeof(XID *));
		res_listsize *= 2;
		free(res_list); res_list = res;
	}
	while (*res) {
		if (*res == resource) DBUG_VOID_RETURN;
		res++;
	}
	*res = resource;
	res_listused++;
	DBUG_VOID_RETURN;
}

void Xlib_UnmonitorResource(XID *resource)
{
	DBUG_ENTER("Xlib_UnmonitorResource")
	XID **res = res_list;
	int res_count = 0;
	if (!res || !res_listused) DBUG_VOID_RETURN;
	while (res_count < res_listused) {
		if (*res == resource) {
			*res = NULL;
			res_listused--;
			DBUG_VOID_RETURN;
		}
		if (*res) res_count++;
		res++;
	}
	DBUG_VOID_RETURN;
}

void Xlib_InvalidateResource(XID resource)
{
	DBUG_ENTER("Xlib_InvalidateResource")
	XID **res = res_list;
	int res_count = 0;
	if (!res || !res_listused || !resource) DBUG_VOID_RETURN;
	while (res_count < res_listused) {
		if (*res && **res == resource) {
			**res = (XID)0;
			*res = NULL;
			res_listused--;
		}
		if (*res) res_count++;
		res++;
	}
	DBUG_VOID_RETURN;
}
