
#include "Xlib_private.h"
#include <netdb.h>

HAB pmctls_hab;

Colormap Xlib_CreateDefaultColormap(Display *dpy);

Screen *new_screen(Display *display)
{
	DBUG_ENTER("new_screen")
	Screen *tmpscreen;
	XGCValues values;
	HPS hps;
	HDC hdc;
	LONG res[2];

	DBUG_POINT("calloc");
        tmpscreen = calloc(1,sizeof(Screen));
	if (!tmpscreen) {
		fprintf(stderr,"new_screen: malloc failed!");
		abort();
	} else
	DBUG_POINT("1");

        /* Fill in the screen structure */
        tmpscreen->display = display;
        tmpscreen->root = hwndDesktop;
        tmpscreen->height = WinQuerySysValue(hwndDesktop,SV_CYSCREEN);
        tmpscreen->width = WinQuerySysValue(hwndDesktop,SV_CXSCREEN);

	hps = WinGetScreenPS(hwndDesktop);
	hdc = GpiQueryDevice(hps);
	DevQueryCaps(hdc, CAPS_HORIZONTAL_FONT_RES, 2, res);
	WinReleasePS(hps);

	tmpscreen->mwidth = (tmpscreen->width * 3048) / (125 * res[0] - 3000);
	tmpscreen->mheight = (tmpscreen->height * 3048) / (125 * res[1] - 3000);

        /* Not too sure about depths */
        tmpscreen->ndepths = 1;
	DBUG_POINT("Xmalloc");
        tmpscreen->depths = (Depth *)Xcalloc(1,sizeof(Depth));
	if (!tmpscreen->depths) {
		printf("new_screen: Xmalloc failed!\n");
		abort();
	}
        tmpscreen->root_depth = 24;
	tmpscreen->depths->depth = 24;
	tmpscreen->depths->nvisuals = 1;
	DBUG_POINT("Xmalloc");
	tmpscreen->depths->visuals = (Visual *)Xcalloc(1,sizeof(Visual));
	tmpscreen->depths->visuals->ext_data = NULL;
	tmpscreen->depths->visuals->visualid = (VisualID)mainhab;
	tmpscreen->depths->visuals->class = TrueColor;
	tmpscreen->depths->visuals->red_mask =
	tmpscreen->depths->visuals->green_mask =
	tmpscreen->depths->visuals->blue_mask = 0xff00;
	tmpscreen->depths->visuals->bits_per_rgb = 8;
	tmpscreen->depths->visuals->map_entries = 0;

	tmpscreen->root_visual = tmpscreen->depths->visuals;

        /* Get the colormap of the root window (HWND_DESKTOP) */
        tmpscreen->cmap = Xlib_CreateDefaultColormap(display);

	values.background = tmpscreen->white_pixel = 0x00ffffffL;
	values.foreground = tmpscreen->black_pixel = 0x00000000L;
	
	tmpscreen->default_gc = XCreateGC(display, tmpscreen->root, 
			GCForeground | GCBackground, &values);

        DBUG_RETURN(tmpscreen);
}

int free_screen(Screen* screen)
{
	DBUG_ENTER("free_screen")
	if (screen) free(screen);
	DBUG_RETURN(True);
}

XExtData *new_xextdata(void)
{
	DBUG_ENTER("new_xextdata")
	XExtData *tmpxextdata;

        tmpxextdata = malloc(sizeof(XExtData));

        DBUG_RETURN(tmpxextdata);
}

int free_xextdata(XExtData *xextdata)
{
	DBUG_ENTER("free_xextdata")
	if (xextdata) free(xextdata);
	DBUG_RETURN(True);
}

Visual *new_visual(void)
{
	DBUG_ENTER("new_visual")
	Visual *tmpvisual;
	
	tmpvisual = malloc(sizeof(Visual));

	DBUG_RETURN(tmpvisual);
}

int free_visual(Visual *visual)
{
	DBUG_ENTER("free_visual")
	if (visual) free(visual);
	DBUG_RETURN(True);
}

int XNoOp(Display* display)
{
	pthread_yield();
	return TRUE;
}

int XBell(Display* display, int percent)
{
	if (percent<=50)
		WinAlarm(hwndDesktop, WA_NOTE);
	else
	if (percent<=75)
		WinAlarm(hwndDesktop, WA_WARNING);
	else
		WinAlarm(hwndDesktop, WA_ERROR);
	return TRUE;
}

int XAutoRepeatOff(Display* display)
{
	auto_repeat = 0;
	return TRUE;
}

int XAutoRepeatOn(Display* display)
{
	auto_repeat = 1;
	return TRUE;
}

char *XDisplayName(_Xconst char* display)
{
    char *d;
    if ( display != (char *)NULL && *display != '\0' )
	return( (char*) display );
    if ( (d = getenv( "DISPLAY" )) != (char *)NULL )
	return( d );
    return( "" );
}

char *__XOS2RedirRoot(char *fname)
{
    /* This adds a further redirection by allowing the ProjectRoot
     * to be prepended by the content of the envvar X11ROOT.
     * This is for the purpose to move the whole X11 stuff to a different
     * disk drive.
     * The feature was added despite various environment variables
     * because not all file opens respect them.
     */
    static char redirname[300]; /* enough for long filenames */
    char *root;

    /* if name does not start with /, assume it is not root-based */
    if (fname==0 || !(fname[0]=='/' || fname[0]=='\\'))
	return fname;

    root = (char*)getenv("X11ROOT");
    if (root==0 || 
	((fname[1]==':') && (isalpha((int)fname[0]))) ||
        (strlen(fname)+strlen(root)+2) > 300)
	return fname;
    sprintf(redirname,"%s%s",root,fname);
    return redirname;
}

char *__XOS2RedirRoot1(char *format, char *arg1, char *arg2, char *arg3)
{
    /* this first constructs a name from a format and up to three
     * components, then adds a path
     */
    char buf[300];
    sprintf(buf,format,arg1,arg2,arg3);
    return __XOS2RedirRoot(buf);
}

int _XGetHostname(char* buf, int maxlen)
{
    int len;
#ifdef NEED_UTSNAME
    struct utsname name;
    if (maxlen <= 0 || buf == NULL)
	return 0;
    uname (&name);
    len = strlen (name.nodename);
    if (len >= maxlen) len = maxlen - 1;
    strncpy (buf, name.nodename, len);
    buf[len] = '\0';
#else
    if (maxlen <= 0 || buf == NULL)
	return 0;
    buf[0] = '\0';
    (void) gethostname (buf, maxlen);
    buf [maxlen - 1] = '\0';
    len = strlen(buf);
#endif /* NEED_UTSNAME */
    return len;
}

long XMaxRequestSize(dpy)
    Display *dpy;
{
    DBUG_ENTER("XMaxRequestSize")
    long result = dpy->max_request_size;
    DBUG_RETURN(result);
}

long XExtendedMaxRequestSize(Display *display)
{
   DBUG_ENTER("XExtendedMaxRequestSize");
   DBUG_RETURN(0);
}

char *XResourceManagerString(dpy)
    Display *dpy;
{
    DBUG_ENTER("XResourceManagerString")
    char *result = dpy->xdefaults;
    DBUG_RETURN(result);
}

unsigned long XDisplayMotionBufferSize(dpy)
    Display *dpy;
{
    DBUG_ENTER("XDisplayMotionBufferSize")
    unsigned long result = dpy->motion_buffer;
    DBUG_RETURN(result);
}

int XDisplayKeycodes(dpy, min_keycode_return, max_keycode_return)
    Display *dpy;
    int *min_keycode_return, *max_keycode_return;
{
    DBUG_ENTER("XDisplayKeycodes")
    *min_keycode_return = dpy->min_keycode;
    *max_keycode_return = dpy->max_keycode;
    DBUG_RETURN(1);
}

VisualID XVisualIDFromVisual(visual)
    Visual *visual;
{
    DBUG_ENTER("XVisualIDFromVisual")
    VisualID result = visual->visualid;
    DBUG_RETURN(result);
}

#if 0
long XExtendedMaxRequestSize(dpy)
    Display *dpy;
{
    return dpy->bigreq_size;
}
#endif

char *XScreenResourceString(screen)
	Screen *screen;
{
    DBUG_ENTER("XScreenResourceString")
    Atom prop_name;
    Atom actual_type;
    int actual_format;
    unsigned long nitems;
    unsigned long leftover;
    char *val = NULL;

    prop_name = XInternAtom(screen->display, "SCREEN_RESOURCES", True);
    if (prop_name &&
	XGetWindowProperty(screen->display, screen->root, prop_name,
			   0L, 100000000L, False,
			   XA_STRING, &actual_type, &actual_format,
			   &nitems, &leftover,
			   (unsigned char **) &val) == Success) {
	if ((actual_type == XA_STRING) && (actual_format == 8))
	    DBUG_RETURN(val);
	if (val)
	    Xfree(val);
    }
    DBUG_RETURN((char *)NULL);
}

/*
 * Given a visual id, find the visual structure for this id on this display.
 */
Visual *_XVIDtoVisual (dpy, id)
	Display *dpy;
	VisualID id;
{
	DBUG_ENTER("_XVIDtoVisual")
	register int i, j, k;
	register Screen *sp;
	register Depth *dp;
	register Visual *vp;
	for (i = 0; i < dpy->nscreens; i++) {
		sp = &dpy->screens[i];
		for (j = 0; j < sp->ndepths; j++) {
			dp = &sp->depths[j];
			/* if nvisuals == 0 then visuals will be NULL */
			for (k = 0; k < dp->nvisuals; k++) {
				vp = &dp->visuals[k];
				if (vp->visualid == id) DBUG_RETURN(vp);
			}
		}
	}
	DBUG_RETURN(NULL);
}

int _XFreeExtData (XExtData* extension)
{
	DBUG_ENTER("_XFreeExtData")
	XExtData *temp;
	while (extension) {
		if (extension->free_private) 
		    (*extension->free_private)(extension);
		else Xfree ((char *)extension->private_data);
		temp = extension->next;
		Xfree ((char *)extension);
		extension = temp;
	}
	DBUG_RETURN(0);
}

XGetKeyboardControl (dpy, state)
    register Display *dpy;
    register XKeyboardState *state;
    {

    state->key_click_percent = 0;
    state->bell_percent = 50;
    state->bell_pitch = 770;
    state->bell_duration = 200;
    state->led_mask = 0;
    state->global_auto_repeat = auto_repeat;
    SyncHandle();
    return 1;
    }

