#include "Xlib.h"
#include "Xlib_private.h"
#include "GetReq.h"


/*

Copyright 1986, 1998  The Open Group

All Rights Reserved.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.

*/


/* 
 * Arguments
 * 
 *  display	Specifies the connection to the X server. 
 *  src_w		Specifies the source window or None. 
 *  dest_w		Specifies the destination window or None. 
 *  src_x
 *  src_y
 *  src_width
 *  src_height	Specify a rectangle in the source window. 
 *  dest_x
 *  dest_y		Specify the x and y coordinates within the destination window. 
 * 
 * 
 * Description
 * 
 * If dest_w is None, XWarpPointer() moves the pointer by the offsets (dest_x, dest_y) relative to the current position of the
 * pointer. If dest_w is a window, XWarpPointer() moves the pointer to the offsets (dest_x, dest_y) relative to the origin of dest_w.
 * However, if src_w is a window, the move only takes place if the window src_w contains the pointer and if the specified rectangle of
 * src_w contains the pointer. 
 * 
 * The src_x and src_y coordinates are relative to the origin of src_w. If src_height is zero, it is replaced with the current height of
 * src_w minus src_y. If src_width is zero, it is replaced with the current width of src_w minus src_x. 
 * 
 * There is seldom any reason for calling this function. The pointer should normally be left to the user. If you do use this function,
 * however, it generates events just as if the user had instantaneously moved the pointer from one position to another. Note that you
 * cannot use XWarpPointer() to move the pointer outside the confine_to window of an active pointer grab. An attempt to do so
 * will only move the pointer as far as the closest edge of the confine_to window. 
 * 
 * XWarpPointer() can generate a BadWindow error. 
 * 
 * Diagnostics
 * 
 *  BadWindow    A value for a Window argument does not name a defined Window.
 */


int XWarpPointer(register Display *dpy, Window src_win, Window dest_win, int src_x, int src_y, unsigned int src_width, unsigned int src_height, int dest_x, int dest_y)
{       
    register xWarpPointerReq *req;

    DBUG_ENTER("XWarpPointer");
    LockDisplay(dpy);
    GetReq(WarpPointer, req);
    req->srcWid = src_win;
    req->dstWid = dest_win;
    req->srcX = src_x;
    req->srcY = src_y;
    req->srcWidth = src_width;
    req->srcHeight = src_height;
    req->dstX = dest_x;
    req->dstY = dest_y;
    UnlockDisplay(dpy);
    SyncHandle();
    DBUG_RETURN(1);
}

