#include "Xlib.h"
#include "Xlib_private.h"
#include "GetReq.h"

/* 
 * Arguments
 * 
 *  display	Specifies the connection to the X server. 
 *  colormap	Specifies the colormap. 
 * 
 * 
 * Description
 * 
 * The XUninstallColormap() function removes the specified colormap from the required list for its screen. As a result, the
 * specified colormap might be uninstalled, and the X server might implicitly install or uninstall additional colormaps. Which
 * colormaps get installed or uninstalled is server-dependent except that the required list must remain installed. 
 * 
 * If the specified colormap becomes uninstalled, the X server generates a ColormapNotify event on each window that has that
 * colormap. In addition, for every other colormap that is installed or uninstalled as a result of a call to XUninstallColormap(), the
 * X server generates a ColormapNotify event on each window that has that colormap. 
 * 
 * XUninstallColormap() can generate a BadColor error. 
 * 
 * 
 * Diagnostics
 * 
 *  BadColor	A value for a Colormap argument does not name a defined Colormap. 
 */


/*

Copyright 1986, 1998  The Open Group

All Rights Reserved.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.

*/

int XUninstallColormap(register Display *dpy, Colormap cmap)
{
    register xResourceReq *req;

    DBUG_ENTER("XUninstallColormap");
    LockDisplay(dpy);
    GetResReq(UninstallColormap, cmap, req);
    UnlockDisplay(dpy);
    SyncHandle();
    DBUG_RETURN(1);
}
