/* $XConsortium: TrCoords.c,v 11.15 94/04/17 20:21:20 rws Exp $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#define NEED_REPLIES
#include "Xlib_private.h"

Bool XTranslateCoordinates(dpy, src_win, dest_win, src_x, src_y, 
		      dst_x, dst_y, child)
     register Display *dpy;
     Window src_win, dest_win;
     int src_x, src_y;
     int *dst_x, *dst_y;
     Window *child;
{       
	DBUG_ENTER("XTranslateCoordinates")
	SWP src_swp, dest_swp;
	POINTL ptl;
	
	if (!WinQueryWindowPos((HWND)src_win, &src_swp) ||
	    !WinQueryWindowPos((HWND)dest_win, &dest_swp))
	{
		SyncHandle();
		DBUG_RETURN(False);
	}
	ptl.x = src_x; ptl.y = src_swp.cy - src_y;
	WinMapWindowPoints((HWND)src_win, (HWND)dest_win, &ptl, 1);
	*child = (Window) WinWindowFromPoint((HWND)dest_win, &ptl, TRUE);
	*dst_x = ptl.x;
	*dst_y = dest_swp.cy - ptl.y;
	SyncHandle();
	DBUG_RETURN(True);
}

