
#include <alloca.h>
#include "Xlib_private.h"

int Xlib_SetFont(Pixmap, Font);

static int Xlib_DrawText(Drawable d, GC gc, int x, int y,
	char* string, int length, ULONG flOptions, int *return_x)
{
	DBUG_ENTER("Xlib_DrawText")
	HPS hps;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_NOPATH);
	POINTL ptl, aptl[TXTBOX_COUNT];
	RECTL rectl;
	if (!viewheight || !string || !length || !hps) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	/*if (xgc->pixmap && xgc->values.font)
		Xlib_SetFont((Pixmap)xgc->pixmap, xgc->values.font);
	else
	if (xgc->winattrib && xgc->values.font)
		Xlib_SetFont((Pixmap)xgc->winattrib, xgc->values.font);*/
	if (GpiQueryTextBox(hps, length, (char *)string, TXTBOX_COUNT, aptl)) {
		ptl.x = x; ptl.y = viewheight - y;
		rectl.xLeft = ptl.x+ aptl[TXTBOX_TOPLEFT].x;
		rectl.yTop = ptl.y + aptl[TXTBOX_TOPRIGHT].y;
		rectl.xRight=ptl.x + aptl[TXTBOX_BOTTOMRIGHT].x;
		rectl.yBottom=ptl.y+ aptl[TXTBOX_BOTTOMLEFT].y;
		aptl[TXTBOX_CONCAT].x += ptl.x;
		aptl[TXTBOX_CONCAT].y += ptl.y;
		ptl.y++;
		GpiCharStringPosAt(hps, &ptl, &rectl, flOptions, length, string, NULL);
		GpiMove(hps,&aptl[TXTBOX_CONCAT]);
		if (return_x) *return_x = aptl[TXTBOX_CONCAT].x;
		DBUG_RETURN(True);
	}
	DBUG_RETURN(True);
}

int XDrawString(Display* display, Drawable d, GC gc, int x, int y,
		_Xconst char* string, int length)
{
	DBUG_ENTER("XDrawString")
	int result;
#ifdef OS2I18N
	int tmplen = (length+1)*2;
	char *str = alloca(tmplen);
	length = Xlib_XlatISO8859_1(str, tmplen, (char *)string, length);
#else
	char *str = (char *)string;
#endif
	result = Xlib_DrawText(d, gc, x, y, str, length, CHS_CLIP, NULL);
	DBUG_RETURN(result);
}

int XDrawImageString(Display* display, Drawable d, GC gc, int x, int y,
		_Xconst char* string, int length)
{
	DBUG_ENTER("XDrawImageString")
	int result;
#ifdef OS2I18N
	int tmplen = (length+1)*2;
	char *str = alloca(tmplen);
	length = Xlib_XlatISO8859_1(str, tmplen, (char *)string, length);
#else
	char *str = (char *)string;
#endif
	result = Xlib_DrawText(d, gc, x, y, str, length, CHS_CLIP | CHS_OPAQUE, NULL);
	DBUG_RETURN(result);
}

int XDrawText(Display* display, Drawable d, GC gc, int x, int y,
		XTextItem* items, int nitems)
{
	DBUG_ENTER("XDrawText")
	Pixmap pixmap = None;
	HPS hps;
	int result = 0, cx = x;
	if (GetDrawableHeight(d, gc, &hps, GC_NOPATH)) {
		Xlib_GC *xgc = (Xlib_GC *)gc;
		Xlib_SetGC(hps, xgc);
		if (xgc->pixmap) pixmap = (Pixmap)xgc->pixmap; else
		if (xgc->winattrib) pixmap = (Pixmap)xgc->winattrib;
	}
	while (nitems && items) {
#ifdef OS2I18N
		int tmplen = (items->nchars+1)*2;
		char *str = alloca(tmplen);
		int length = Xlib_XlatISO8859_1(str, tmplen, (char *)items->chars, items->nchars);
#else
		char *str = (char *)items->chars;
		int length = items->nchars;
#endif
		if (items->font != None && pixmap) {
			Xlib_SetFont(pixmap, items->font);
		}
		cx += items->delta;
		result = Xlib_DrawText(d, gc, cx, y, str, length, CHS_CLIP, &cx);
		items++; nitems--;
	}
	DBUG_RETURN(result);
}


#ifdef OS2I18N

int XDrawString16(Display* display, Drawable d, GC gc, int x, int y,
		_Xconst XChar2b* string, int length)
{
	DBUG_ENTER("XDrawString16")
	int result;
	int tmplen = (length+1)*2;
	char *str = alloca(tmplen);
	length = Xlib_XlatUCS_2(str, tmplen, (void *)string, length);
	result = Xlib_DrawText(d, gc, x, y, str, length, CHS_CLIP, NULL);
	DBUG_RETURN(result);
}

int XDrawImageString16(Display* display, Drawable d, GC gc, int x, int y,
		_Xconst XChar2b* string, int length)
{
	DBUG_ENTER("XDrawImageString16")
	int result;
	int tmplen = (length+1)*2;
	char *str = alloca(tmplen);
	length = Xlib_XlatUCS_2(str, tmplen, (void *)string, length);
	result = Xlib_DrawText(d, gc, x, y, str, length, CHS_CLIP | CHS_OPAQUE, NULL);
	DBUG_RETURN(result);
}

int XDrawText16(Display* display, Drawable d, GC gc, int x, int y, 
		XTextItem16* items, int nitems)
{
	DBUG_ENTER("XDrawText16")
	Pixmap pixmap = None;
	HPS hps;
	int result = 0, cx = x;
	if (GetDrawableHeight(d, gc, &hps, GC_NOPATH)) {
		Xlib_GC *xgc = (Xlib_GC *)gc;
		Xlib_SetGC(hps, xgc);
		if (xgc->pixmap) pixmap = (Pixmap)xgc->pixmap; else
		if (xgc->winattrib) pixmap = (Pixmap)xgc->winattrib;
	}
	while (nitems && items) {
		int tmplen = (items->nchars+1)*2;
		char *str = alloca(tmplen);
		int length = Xlib_XlatUCS_2(str, tmplen, (void *)items->chars, items->nchars);
		if (items->font != None && pixmap) {
			Xlib_SetFont(pixmap, items->font);
		}
		cx += items->delta;
		result = Xlib_DrawText(d, gc, cx, y, str, length, CHS_CLIP, &cx);
		items++; nitems--;
	}
	DBUG_RETURN(result);
}

#endif /* OS2I18N */
