#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#define STR(def)# def

#define STUBMSG	"Xlib: function \"%s()\" not implemented!\n"

#ifdef DEBUG

volatile struct Xlib_DebugInfo_st {
	char 	*filename;
	int	linenumb;
	char	*procname,*procinfo;
} Xlib_DebugInfo[1024];
volatile int Xlib_DebugOffset;

int Xlib_DebugEnter(char*,int,char*,char*);

#define DBUG_ENTER(a)						\
	int DebugLevel = Xlib_DebugEnter(__FILE__,__LINE__,(a),"")
#define DBUG_POINT(a) {						\
		Xlib_DebugInfo[DebugLevel].linenumb = __LINE__;	\
		Xlib_DebugInfo[DebugLevel].procinfo = a;	\
	}
#define DBUG_LEAVE {						\
		Xlib_DebugInfo[DebugLevel].linenumb = __LINE__;	\
		Xlib_DebugOffset = --DebugLevel;		\
	}
#define DBUG_RETURN(a) {					\
		DBUG_LEAVE; 					\
		return (a);					\
	}
#define DBUG_VOID_RETURN {					\
		DBUG_LEAVE; 					\
		return;						\
	}
#else
#define DBUG_ENTER(a) int DebugLevel
#define	DBUG_POINT(a)
#define DBUG_RETURN(a) return (a)
#define DBUG_VOID_RETURN return
#endif


#define STUB(func) 				\
int func (void) 				\
{						\
	static int firsttime = 0;		\
	if (!(firsttime++))			\
	fprintf(stderr,STUBMSG,STR(func));	\
	_setsyserrno(EINVAL);			\
	return 0;				\
}

#ifndef OS2I18N
STUB(XDrawImageString16)
STUB(XDrawString16)
STUB(XDrawText16)
#endif


STUB(XCreateGlyphCursor)
STUB(XGetSelectionOwner)
STUB(XListFontsWithInfo)
STUB(XGetFontPath)
STUB(XListProperties)
STUB(XListHosts)
STUB(XInitThreads)
STUB(XXAddExtension)
STUB(XReconfigureWMWindow)
STUB(XGetWMProtocols)
STUB(XSetWMColormapWindows)
STUB(XAddHost)
STUB(XAddHosts)
STUB(XAddToSaveSet)
STUB(XChangeKeyboardControl)
STUB(XChangeKeyboardMapping)
STUB(XChangePointerControl)
STUB(XChangeSaveSet)
STUB(XCheckMaskEvent)
STUB(XCheckTypedEvent)
STUB(XCheckTypedWindowEvent)
STUB(XConvertSelection)
STUB(XDeleteProperty)
STUB(XDestroySubwindows)
STUB(XDisableAccessControl)
STUB(XEnableAccessControl)
/*STUB(XFreeFontInfo)*/
/*STUB(XFreeFontPath)*/
STUB(XGetErrorDatabaseText)
STUB(XGetErrorText)
STUB(XGetPointerControl)
STUB(XGetPointerMapping)
STUB(XInstallColormap)
STUB(XKillClient)
STUB(XMaskEvent)
STUB(XQueryKeymap)
STUB(XQueryTextExtents)
STUB(XQueryTextExtents16)
STUB(XRemoveFromSaveSet)
STUB(XRemoveHost)
STUB(XRemoveHosts)
STUB(XSetAccessControl)
/* STUB(XSetClipMask)*/
/* STUB(XSetClipOrigin) */
STUB(XSetCloseDownMode)
STUB(XSetDashes)
STUB(XSetFontPath)
STUB(XSetModifierMapping)
STUB(XSetPlaneMask)
STUB(XSetPointerMapping)
STUB(XSetSelectionOwner)
STUB(XSetState)
STUB(XSetTSOrigin)
STUB(XSetTile)
STUB(XSetWindowBorderPixmap)
/*STUB(XUninstallColormap)*/
/*STUB(XWarpPointer)*/

/* MORE STUBS! */
STUB(XkbSelectEventDetails)
STUB(XcmsTekHVCQueryMinV)
STUB(_XimUnregisterFilter)
STUB(_XUnknownNativeEvent)
STUB(_X11TransBytesReadable)
STUB(XcmsTekHVCQueryMaxV)
STUB(_XimXTransGetMyAddr)
STUB(XcmsCIELuvQueryMaxLC)
STUB(_XimDecodeICATTRIBUTE)
STUB(_XimDecodeIMATTRIBUTE)
STUB(_XimProtoWireToEvent)
STUB(_XimXTransSetOption)
STUB(XcmsTekHVCQueryMaxVC)
STUB(_XimEncodeICATTRIBUTE)
STUB(_XimXTransGetPeerAddr)
STUB(_XimEncodeIMATTRIBUTE)
STUB(_XimXTransGetHostname)
STUB(_XimProtoEventToWire)
STUB(_X11TransRead)
STUB(XkbGetKeyVirtualModMap)
STUB(_XimRegisterIMInstantiateCallback)
STUB(XkbChangeMap)
STUB(XauFileName)
STUB(_XimRegisterTriggerKeysCallback)
STUB(_XimXTransFreeConnInfo)
STUB(XauReadAuth)
STUB(XkbGetState)
STUB(XkbGetNames)
STUB(XkbSetNames)
STUB(_XimGetWindowEventmask)
STUB(XkbLockGroup)
STUB(XkbDeviceBell)
STUB(_Ximctstombs)
STUB(_XReadEvents)
STUB(_X11TransClose)
STUB(_Ximctstowcs)
STUB(XkbLatchGroup)
STUB(_XlcEucLoader)
STUB(_X11TransReadv)
STUB(_XimICOfXICID)
STUB(_X11TransConnectDisplay)
STUB(_X11TransConvertAddress)
STUB(_X11TransCloseForCloning)
STUB(_XimTransRead)
STUB(_XimTransConf)
STUB(_X11TransOpenCLTSClient)
STUB(_X11TransWrite)
STUB(_X11TransSocketTCPFuncs)
STUB(_X11TransOpenCOTSClient)
STUB(XkbGetKeySyms)
STUB(XkbGetDeviceInfoChanges)
STUB(_XEventToWire)
STUB(_X11TransSocketINETFuncs)
STUB(_XimExtension)
STUB(_XimProcError)
STUB(_XWireToEvent)
STUB(XkbChangeNames)
STUB(_XimCbDispatch)
STUB(_XFlushGCCache)
STUB(_XimTransCallDispatcher)
STUB(XkbGetGeometry)
STUB(XkbChangeEnabledControls)
STUB(XkbSetGeometry)
STUB(_XGetAsyncData)
STUB(XcmsQueryBlack)
STUB(_XimThaiFilter)
STUB(_XimXTransBytesReadable)
STUB(XcmsAllocColor)
STUB(_XlcSjisLoader)
STUB(_XimForwardEventCallback)
STUB(XkbGetControls)
STUB(XauDisposeAuth)
STUB(XkbSetControls)
STUB(_XimTransFlush)
STUB(XcmsQueryWhite)
STUB(_XcmsCIELabQueryMaxLCRGB)
STUB(XcmsQueryColor)
STUB(_XEventsQueued)
STUB(_XimSetEventMaskCallback)
STUB(XcmsStoreColor)
STUB(_XimFreeTransIntrCallback)
STUB(XkbSetServerInternalMods)
STUB(_XimRegProtoIntrCallback)
STUB(_XDefaultError)
STUB(_XimTransWrite)
STUB(_XimRegisterServerFilter)
STUB(XkbGetKeyTypes)
STUB(XkbGetAutoResetControls)
STUB(XkbSetAutoResetControls)
STUB(_XimProtoMbLookupString)
STUB(_XcmsTekHVCQueryMaxVCRGB)
STUB(_XimXTransRead)
STUB(_XInitKeysymDB)
STUB(_XimFreeProtoIntrCallback)
STUB(_XimTransFilterWaitEvent)
STUB(XkbGetDeviceButtonActions)
STUB(_XimProtoWcLookupString)
STUB(XkbSetDeviceButtonActions)
STUB(_XimXTransOpenCLTSClient)
STUB(_XimXTransOpenCOTSClient)
STUB(_XcmsCIELuvQueryMaxLCRGB)
STUB(_XimXTransSocketTCPFuncs)
STUB(XcmsClientWhitePointOfCCC)
STUB(XcmsScreenWhitePointOfCCC)
STUB(_XimXTransCloseForCloning)
STUB(_X11TransConnect)
STUB(_X11TransIsLocal)
STUB(_XDeq)
STUB(_XEnq)
STUB(XkbGetNamedDeviceIndicator)
STUB(_XimXTransSocketINETFuncs)
STUB(XkbSetNamedDeviceIndicator)
STUB(_X11TransWritev)
STUB(XkbGetDetectableAutoRepeat)
STUB(XkbSetDetectableAutoRepeat)
STUB(XcmsCIELabClipL)
STUB(XcmsCIELabClipab)
STUB(XcmsCIELabWhiteShiftColors)
STUB(_XProcessWindowAttributes)
STUB(XkbGetCompatMap)
STUB(XkbSetCompatMap)
STUB(XcmsTekHVCClipC)
STUB(XkbGetDeviceInfo)
STUB(XkbSetDeviceInfo)
STUB(_XFreeAtomTable)
STUB(XcmsTekHVCWhiteShiftColors)
STUB(XcmsCIELuvClipL)
STUB(XkbGetMapChanges)
STUB(XcmsCIELuvWhiteShiftColors)
STUB(_XUpdateGCCache)
STUB(XcmsVisualOfCCC)
STUB(_XcmsGetElement)
STUB(_XConnectDisplay)
STUB(_XimThaiCreateIC)
STUB(XkbLockModifiers)
STUB(XcmsTekHVCClipV)
STUB(XkbGetKeyActions)
STUB(XGetRGBColormaps)
STUB(XkbSelectEvents)
STUB(XkbGetUpdatedMap)
STUB(_XimSyncCallback)
STUB(_XimUnRegisterIMInstantiateCallback)
STUB(XSetRGBColormaps)
STUB(_XRead)
STUB(XcmsLookupColor)
STUB(XcmsDisplayOfCCC)
STUB(XcmsTekHVCClipVC)
STUB(XkbLatchModifiers)
STUB(XcmsCIELabClipLab)
STUB(_XSend)
STUB(XGetWMSizeHints)
STUB(_XimXTransClose)
STUB(XcmsCIELuvClipuv)
STUB(_XimDispatchInit)
STUB(_XimUnregisterServerFilter)
STUB(XcmsStoreColors)
STUB(XcmsAddColorSpace)
STUB(_XimForwardEvent)
STUB(XcmsTekHVCQueryMaxVSamples)
STUB(_X11TransGetMyAddr)
STUB(_XimErrorCallback)
STUB(_XGetAsyncReply)
STUB(_XcmsGetProperty)
STUB(_XDefaultIOError)
STUB(_XScreenOfWindow)
STUB(_XimXTransWrite)
STUB(_XimXTransReadv)
STUB(XcmsCIELuvClipLuv)
STUB(XGetWMNormalHints)
STUB(_XDeqAsyncHandler)
STUB(_X11TransGetConnectionNumber)
STUB(_X11TransSetOption)
STUB(_XUpdateAtomCache)
STUB(_XimXTransWritev)
STUB(_XimProtoCreateIC)
STUB(XkbListComponents)
STUB(_XimXTransConnect)
STUB(XSetAuthorization)
STUB(_XimXTransIsLocal)
STUB(_XimTriggerNotify)
STUB(XkbGetVirtualMods)
STUB(XkbForceDeviceBell)
STUB(_XimRespSyncReply)
STUB(_XimProcSyncReply)
STUB(XcmsAddFunctionSet)
STUB(XkbGetIndicatorMap)
STUB(_XimCommitCallback)
STUB(XkbDeviceBellEvent)
STUB(XkbGetKeyBehaviors)
STUB(XkbSetIndicatorMap)
STUB(_XkbInitReadBuffer)
STUB(_XimRegisterFilter)
STUB(_XimTransInternalConnection)
STUB(_XimFreeCommitInfo)
STUB(_XSendClientPrefix)
STUB(_XimTransRegisterDispatcher)
STUB(XcmsFormatOfPrefix)
STUB(XcmsPrefixOfFormat)
STUB(XkbGetKeyExplicitComponents)
STUB(_XDefaultWireError)
STUB(_XFlush)
STUB(_XError)
STUB(_XimGetAttributeID)
STUB(_X11TransGetPeerAddr)
STUB(_XUnknownWireEvent)
STUB(_XEatData)
STUB(_XReply)
STUB(_XAllocID)
STUB(_XimSync)
STUB(_X11TransDisconnect)
STUB(_XimXTransGetConnectionNumber)
STUB(XkbSetMap)
STUB(_X11TransGetHostname)
STUB(_XimXConf)
STUB(_XReadPad)
STUB(_XimError)
STUB(_XIOError)
STUB(XkbChangeDeviceInfo)
STUB(XkbGetDeviceLedInfo)
STUB(_XcmsConvertColorsWithWhitePt)
STUB(XcmsAllocNamedColor)
STUB(_X11TransFreeConnInfo)
STUB(XkbSetDebuggingFlags)
STUB(XauGetBestAuthByAddr)
STUB(_XimResetIMInstantiateCallback)
STUB(XkbGetKeyboardByName)
STUB(_XAllocIDs)
STUB(XGetStandardColormap)
STUB(XkbGetKeyModifierMap)
STUB(XcmsCIELabQueryMaxC)
STUB(XkbGetAutoRepeatRate)
STUB(XSetStandardColormap)
STUB(XkbSetAutoRepeatRate)
STUB(XkbSetIgnoreLockMods)
STUB(_XAsyncErrorHandler)
STUB(XkbGetNamedGeometry)
STUB(XcmsCIELabQueryMinL)
STUB(_XDisconnectDisplay)
STUB(XkbGetIndicatorState)
STUB(XcmsCIELabQueryMaxL)
STUB(_XimMakeICAttrIDList)
STUB(XcmsTekHVCQueryMaxC)
STUB(XcmsCIELuvQueryMaxC)
STUB(_XimMakeIMAttrIDList)
STUB(_XimLocalSetICValues)
STUB(_XSetLastRequestRead)
STUB(XcmsCIELuvQueryMinL)
STUB(XcmsCIELabQueryMaxLC)
STUB(_XimXTransDisconnect)
STUB(XcmsScreenNumberOfCCC)
STUB(XcmsCIELuvQueryMaxL)
STUB(_XimReregisterFilter)
