
#include "Xlib_private.h"

int Xlib_SetStipple(Pixmap pixmap, Pixmap stipple)
{
	DBUG_ENTER("Xlib_SetStipple")
	LONG atom = LCID_DEFAULT;
	if (!pixmap) DBUG_RETURN(0);
	if (stipple) {
		atom = Xlib_AllocPixmapAtom((Xlib_Pixmap *)pixmap, (Xlib_Pixmap *)stipple);
		if (!atom) {
			x11_console_notice("Out of free GPI atoms!\n");
			/* Perhaps need some LRU disposal schema */
			DBUG_RETURN(0);
		}
	}
	GpiSetPatternSet(((Xlib_Pixmap *)pixmap)->hps, atom);
	DBUG_RETURN(1);
}

int XSetStipple(Display* dpy, GC gc, Pixmap stipple)
{
	DBUG_ENTER("XSetStipple")
	Xlib_GC *xgc = (Xlib_GC *)gc;
	HPS hps = NULLHANDLE;
	int result = 0;
	if (!xgc) DBUG_RETURN(0);
	if ((xgc->values.stipple = stipple)) 
		Xlib_MonitorResource((XID *)&xgc->values.stipple);
	if (GetDrawableHeight(0, gc, &hps, GC_NOPATH)) {
		if (xgc->pixmap)
			result = Xlib_SetStipple((Pixmap)xgc->pixmap, stipple);
		else
		if (xgc->winattrib)
			result = Xlib_SetStipple((Pixmap)xgc->winattrib, stipple);
	}
	SyncHandle();
	DBUG_RETURN(result);
}
