
#include "Xlib_private.h"

int Xlib_SetFont(Pixmap pixmap, Font font)
{
	DBUG_ENTER("Xlib_SetFont")
	LONG atom = LCID_DEFAULT;
	if (!pixmap) DBUG_RETURN(0);
	if (font) {
		atom = Xlib_AllocFontAtom((Xlib_Pixmap *)pixmap, (Xlib_Font *)font);
		if (!atom) {
			x11_console_notice("Out of free GPI atoms!\n");
			/* Perhaps need some LRU disposal schema */
			DBUG_RETURN(0);
		}
	}
	GpiSetCharSet(((Xlib_Pixmap *)pixmap)->hps, atom);
	if (font && ((Xlib_Font *)font)->psmode)
	GpiSetCharBox(((Xlib_Pixmap *)pixmap)->hps, &((Xlib_Font *)font)->sizef);
	DBUG_RETURN(1);
}

int XSetFont(Display* dpy, GC gc, Font font)
{
	DBUG_ENTER("XSetFont")
	Xlib_GC *xgc = (Xlib_GC *)gc;
	HPS hps = NULLHANDLE;
	int result = 0;
	if (!xgc) DBUG_RETURN(0);
	if ((xgc->values.font = font))
		Xlib_MonitorResource((XID *)&xgc->values.font);
	if (GetDrawableHeight(0, gc, &hps, GC_NOPATH)) {
		if (xgc->pixmap)
			result = Xlib_SetFont((Pixmap)xgc->pixmap, font);
		else
		if (xgc->winattrib)
			result = Xlib_SetFont((Pixmap)xgc->winattrib, font);
	}
	SyncHandle();
	DBUG_RETURN(result);
}
