/* $XConsortium: SetCRects.c /main/12 1996/10/22 14:21:48 kaleb $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#include "Xlib_private.h"
#include <alloca.h>

/* can only call when display is locked. */
void _XSetClipRectangles (dpy, gc, clip_x_origin, clip_y_origin, rectangles, n,
                    ordering)
    register Display *dpy;
    GC gc;
    int clip_x_origin, clip_y_origin;
    XRectangle *rectangles;
    int n;
    int ordering;
{
    DBUG_ENTER("_XSetClipRectangles")
    Xlib_GC *xgc = (Xlib_GC *)gc;
    HDC hdc = GpiQueryDevice(xgc->gid);
    HWND wnd = WinWindowFromDC(hdc);
    HPS hps;
    int viewheight = GetDrawableHeight(wnd, gc, &hps, GC_NOPATH);
    HRGN hrgn;
    RECTL *rectl,*cp;
    int i;

    cp = rectl = alloca(sizeof(RECTL) * n);

    for (i=0; i<n; i++,cp++,rectangles++) {
	cp->xRight = (cp->xLeft = rectangles->x) + rectangles->width;
	cp->yBottom = (cp->yTop = viewheight - rectangles->y) - rectangles->height;
    }

    hrgn = GpiCreateRegion(hps, n, rectl);
    GpiSetClipRegion(hps, hrgn, NULL);
    if (xgc->cliprgn) GpiDestroyRegion(hps,xgc->cliprgn);
    xgc->cliprgn = hrgn;
    DBUG_VOID_RETURN;
}

int XSetClipRectangles (dpy, gc, clip_x_origin, clip_y_origin, rectangles, n,
                    ordering)
    register Display *dpy;
    GC gc;
    int clip_x_origin, clip_y_origin;
    XRectangle *rectangles;
    int n;
    int ordering;
{
    DBUG_ENTER("XSetClipRectangles")
    LockDisplay(dpy);
    _XSetClipRectangles (dpy, gc, clip_x_origin, clip_y_origin, rectangles, n,
                    ordering);
    UnlockDisplay(dpy);
    SyncHandle();
    DBUG_RETURN(1);
}
    
