#include <X11/Xlib.h>
#include "Xlib_private.h"

/* Can't configure the Lockup as far as I know so these functions don't do anything */

int XGetScreenSaver(display, timeout_return, interval_return, prefer_blanking_return, 
                  allow_exposures_return)
      Display *display;
      int *timeout_return, *interval_return;
      int *prefer_blanking_return;
      int *allow_exposures_return;
{
   DBUG_ENTER("XGetScreenSaver");
   *timeout_return = 300;
   *interval_return = 10;
   *prefer_blanking_return = DefaultBlanking;
   *allow_exposures_return = DontAllowExposures;
   DBUG_RETURN(True);
}

int XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures)
      Display *display;
      int timeout, interval;
      int prefer_blanking; 
      int allow_exposures;
{
   DBUG_ENTER("XSetScreenSaver");
   DBUG_RETURN(True);
}

int XActivateScreenSaver(Display *display)
{
   DBUG_ENTER("XActivateScreenSaver");
   WinLockupSystem(mainhab);
   DBUG_RETURN(True);
}

/* Reset may only work in screensaver mode - Brian */
int XResetScreenSaver(Display *display)
{
   DBUG_ENTER("XResetScreenSaver");
   WinUnlockSystem(mainhab, "");
   DBUG_RETURN(True);
}

int XForceScreenSaver(Display *display, int mode)
{
   DBUG_ENTER("XForceScreenSaver");
   switch(mode) 
   {
   case ScreenSaverActive:
      XActivateScreenSaver(display);
      break;
   case ScreenSaverReset:
      XResetScreenSaver(display);
     break;
   }
   DBUG_RETURN(True);
}

