
#include "Xlib_private.h"

int SizeClient(HWND hwnd, int width, int height) 
{
	DBUG_ENTER("SizeClient")
	Xlib_SetWindowPos SizeParams = { hwnd, NULLHANDLE,
		0, 0, width, height, SWP_SIZE
	};
	int result = (int)WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0);
	DBUG_RETURN(result);
}

int XResizeWindow(Display* display, Window w, unsigned int width,unsigned int height)
{
	DBUG_ENTER("XResizeWindow")
	XWindowAttributes *winattrib = GetWinAttrib(w,NULL);
	HWND winframe = WinQueryWindowULong((HWND)w, QWP_FRAMEHWND);
	HWND winparent = WinQueryWindow(winframe, QW_PARENT);
	Xlib_SetWindowPos SizeParams = { winframe, NULLHANDLE,
		0, 0, width, height, SWP_MOVE | SWP_SIZE
	};
	SWP swp, parent;
	
	if (!winframe || !winattrib ||
	    !WinQueryWindowPos(winframe, &swp) ||
	    !WinQueryWindowPos(winparent, &parent)) DBUG_RETURN(False);
	if (winframe != (HWND)w) {
		SizeClient((HWND)w, width, height);
		SizeParams.cx += 2 * winattrib->border_width;
		SizeParams.cy += 2 * winattrib->border_width + 
			WinQuerySysValue(hwndDesktop,SV_CYTITLEBAR);
		SizeParams.y = parent.cy - winattrib->y - height - winattrib->border_width;
	} else
	SizeParams.y = parent.cy - winattrib->y - height;
	SizeParams.x = swp.x;
	if (WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0)) {
		winattrib->width = width;
		winattrib->height = height;
		DBUG_RETURN(True);
	} else
		DBUG_RETURN(False);
}

int XMoveWindow(Display* display, Window w, int x, int y)
{
	DBUG_ENTER("XMoveWindow")
	XWindowAttributes *winattrib = GetWinAttrib(w,NULL);
	HWND winframe = WinQueryWindowULong((HWND)w, QWP_FRAMEHWND);
	HWND winparent = WinQueryWindow(winframe, QW_PARENT);
	Xlib_SetWindowPos SizeParams = { winframe, NULLHANDLE,
		x, 0, 0, 0, SWP_MOVE
	};
	SWP swp, parent;

	if (!winframe || !winattrib ||
	    !WinQueryWindowPos(winframe, &swp) ||
	    !WinQueryWindowPos(winparent, &parent)) DBUG_RETURN(False);
	if ( winframe != (HWND)w) {
		SizeParams.x -= winattrib->border_width;
		SizeParams.y = parent.cy - y - swp.cy - winattrib->border_width;
	} else
	SizeParams.y = parent.cy - y - swp.cy;
	if (WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0)) {
		winattrib->x = x;
		winattrib->y = y;
		DBUG_RETURN(True);
	} else
		DBUG_RETURN(False);
}

int XMoveResizeWindow(Display* display, Window w, int x, int y, unsigned int width, unsigned int height)
{
	DBUG_ENTER("XMoveResizeWindow")
	XWindowAttributes *winattrib = GetWinAttrib(w,NULL);
	HWND winframe = WinQueryWindowULong((HWND)w, QWP_FRAMEHWND);
	HWND winparent = WinQueryWindow(winframe, QW_PARENT);
	Xlib_SetWindowPos SizeParams = { winframe, NULLHANDLE,
		x, 0, width, height, SWP_MOVE | SWP_SIZE
	};
	SWP swp, parent;

	if (!winframe || !winattrib ||
	    !WinQueryWindowPos(winframe, &swp) ||
	    !WinQueryWindowPos(winparent, &parent)) DBUG_RETURN(False);
	if (winframe != (HWND)w) {
		SizeClient((HWND)w, width, height);
		SizeParams.cx += 2 * winattrib->border_width;
		SizeParams.cy += 2 * winattrib->border_width + 
			WinQuerySysValue(hwndDesktop,SV_CYTITLEBAR);
		SizeParams.x -= winattrib->border_width;
		SizeParams.y = parent.cy - y - height - winattrib->border_width;
	} else
	SizeParams.y = parent.cy - y - height;
	if (WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0)) {
		winattrib->x = x;
		winattrib->y = y;
		winattrib->width = width;
		winattrib->height = height;
		DBUG_RETURN(True);
	} else
		DBUG_RETURN(False);
}

int XMapWindow(Display* display, Window w)
{
	DBUG_ENTER("XMapWindow")
	XWindowAttributes *winattrib = GetWinAttrib(w,NULL);
	HWND winframe = WinQueryWindowULong((HWND)w, QWP_FRAMEHWND);
	Xlib_SetWindowPos SizeParams = { winframe, NULLHANDLE,
		0, 0, 0, 0, SWP_SHOW
	};
	int result;
	if (!winframe || !winattrib) DBUG_RETURN(False);
	winattrib->map_state = IsUnmapped;
	if (winframe != (HWND)w) SizeParams.fl |= SWP_ACTIVATE;
	result = (int)WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0);
	DBUG_RETURN(result);
}

int XMapSubwindows(Display *display, Window w)
{
	DBUG_ENTER("XMapSubwindows")
	HENUM henum;
	HWND child;
	henum = WinBeginEnumWindows((HWND)w);
	while((child = WinGetNextWindow(henum)) != NULLHANDLE)
		XMapWindow(display, (Window)child);
	DBUG_RETURN(WinEndEnumWindows(henum));
}

int XUnmapWindow(Display* display, Window w)
{
	DBUG_ENTER("XUnmapWindow")
	XWindowAttributes *winattrib = GetWinAttrib(w,NULL);
	HWND winframe = WinQueryWindowULong((HWND)w, QWP_FRAMEHWND);
	Xlib_SetWindowPos SizeParams = { winframe, NULLHANDLE,
		0, 0, 0, 0, SWP_HIDE
	};
	int result;
	if (!winframe || !winattrib) DBUG_RETURN(False);
	winattrib->map_state = IsUnmapped;
	result = (int)WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0);
	DBUG_RETURN(result);
}

Status XWithdrawWindow(Display* display, Window w, int screen_number)
{
	DBUG_ENTER("XWithdrawWindow")
	XWindowAttributes *winattrib = GetWinAttrib(w,NULL);
	HWND winframe = WinQueryWindowULong((HWND)w, QWP_FRAMEHWND);
	Xlib_SetWindowPos SizeParams = { winframe, NULLHANDLE,
		0, 0, 0, 0, SWP_HIDE
	};
	int result;
	if (!winframe || !winattrib) DBUG_RETURN(False);
	winattrib->map_state = IsUnmapped;
	if (winframe != (HWND)w) SizeParams.fl |= SWP_DEACTIVATE;
	result = (int)WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0);
	DBUG_RETURN(result);
}

int XUnmapSubwindows(Display *display, Window w)
{
	DBUG_ENTER("XUnmapSubwindows")
	HENUM henum;
	HWND child;
	henum = WinBeginEnumWindows((HWND)w);
	while((child = WinGetNextWindow(henum)) != NULLHANDLE)
		XUnmapWindow(display, (Window)child);
	DBUG_RETURN(WinEndEnumWindows(henum));
}

int XMapRaised(Display* display, Window w)
{
	DBUG_ENTER("XMapRaised")
	XWindowAttributes *winattrib = GetWinAttrib(w,NULL);
	HWND winframe = WinQueryWindowULong((HWND)w, QWP_FRAMEHWND);
	Xlib_SetWindowPos SizeParams = { winframe, HWND_TOP,
		0, 0, 0, 0, SWP_SHOW | SWP_ZORDER
	};
	if (!winframe || !winattrib) DBUG_RETURN(False);
	winattrib->map_state = IsUnmapped;
	{
		int result = (int)WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0);
		DBUG_RETURN(result);
	}
}

int XRaiseWindow(Display* display, Window w)
{
	DBUG_ENTER("XRaiseWindow")
	HWND winframe = WinQueryWindowULong((HWND)w, QWP_FRAMEHWND);
	Xlib_SetWindowPos SizeParams = { winframe, HWND_TOP,
		0, 0, 0, 0, SWP_ZORDER
	};
	if (winframe && WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0))
		DBUG_RETURN(True);
	
	DBUG_RETURN(False);
}

int XLowerWindow(Display* display, Window w)
{
	DBUG_ENTER("XLowerWindow")
	HWND winframe = WinQueryWindowULong((HWND)w, QWP_FRAMEHWND);
	Xlib_SetWindowPos SizeParams = { winframe, HWND_BOTTOM,
		0, 0, 0, 0, SWP_ZORDER
	};
	if (winframe && WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0))
		DBUG_RETURN(True);
	
	DBUG_RETURN(False);
}

int XCirculateSubwindows(Display *display, Window w, int direction)
{
	DBUG_ENTER("XCirculateSubwindows")
	/* todo: determine windows which are completely exposed
	   and remove them from the list */
	HENUM henum;
	HWND child;
	henum = WinBeginEnumWindows((HWND)w);
	if(direction == LowerHighest)
	{
		if((child = WinGetNextWindow(henum)) != NULLHANDLE)
		XRaiseWindow(display, w);
	}
	else if(direction == RaiseLowest)
	{
		while((child = WinGetNextWindow(henum)) != NULLHANDLE) { } 
		if(child)
			XLowerWindow(display, w);
	}
	DBUG_RETURN(WinEndEnumWindows(henum));
}

int XCirculateSubwindowsDown(Display *display, Window w)
{
	DBUG_ENTER("XCirculateSubwindowsDown")
	int result = XCirculateSubwindows(display, w, LowerHighest);
	DBUG_RETURN(result);
}

int XCirculateSubwindowsUp(Display *display, Window w)
{
	DBUG_ENTER("XCirculateSubwindowsUp")
	int result = XCirculateSubwindows(display, w, RaiseLowest);
	DBUG_RETURN(result);
}

Status XIconifyWindow(Display *display, Window w, int screen_number)
{
   DBUG_ENTER("XIconifyWindow")
	Xlib_SetWindowPos SizeParams = { WinQueryWindowULong((HWND)w, QWP_FRAMEHWND), NULLHANDLE,
		0, 0, 0, 0, SWP_MINIMIZE };
   if (!SizeParams.hwnd)
      DBUG_RETURN(False);
   WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0);
   DBUG_RETURN(True);
}

int XReparentWindow(display, w, parent, x, y)
      Display *display;
      Window w;
      Window parent;
      int x, y;
{
   DBUG_ENTER("XReparentWindow")
   WinSetParent(w, parent, FALSE);
   XMoveWindow(display, w, x, y);
   DBUG_RETURN(True);
}

int XRestackWindows(display, windows, nwindows)
      Display *display;
      Window windows[];
      int nwindows;
{
   DBUG_ENTER("XRestackWindows")
	Xlib_SetWindowPos SizeParams = { NULLHANDLE, HWND_BOTTOM,
		0, 0, 0, 0, SWP_ZORDER };
   int i;
   for(i=nwindows;i>0;i--)
      {
        SizeParams.hwnd = WinQueryWindowULong((HWND)windows[i], QWP_FRAMEHWND);
        if (SizeParams.hwnd) 
           WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0);
      }
   DBUG_RETURN(True);
}
