/* $XConsortium: ReconfWin.c /main/9 1996/10/22 14:21:21 kaleb $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#include "Xlib_private.h"

#define AllMaskBits (CWX|CWY|CWWidth|CWHeight|\
		     CWBorderWidth|CWSibling|CWStackMode)

int SizeClient(HWND, int, int);

int XConfigureWindow(dpy, w, mask, changes)
    register Display *dpy;
    Window w;
    unsigned int mask;
    XWindowChanges *changes;
{
	DBUG_ENTER("XConfigureWindow")
	XWindowAttributes *winattrib = GetWinAttrib(w,NULL);
	HWND winframe = WinQueryWindowULong((HWND)w, QWP_FRAMEHWND);
	HWND winparent = WinQueryWindow(winframe, QW_PARENT);
	Xlib_SetWindowPos SizeParams = { winframe, NULLHANDLE,
		0, 0, 0, 0, 0
	};
	SWP swp, parent;
	if (!winattrib || !winframe || !(mask & AllMaskBits) ||
	    !WinQueryWindowPos(winframe, &swp) ||
	    !WinQueryWindowPos(winparent, &parent)) return 0;

	SizeParams.x = swp.x; SizeParams.y = swp.y;
	SizeParams.cx = swp.cx; SizeParams.cy = swp.cy;
	if (winframe != (HWND)w) {
		if (mask & CWBorderWidth) 
			winattrib->border_width = changes->border_width;
		if (mask & CWWidth)
			SizeParams.cx = changes->width;
		if (mask & CWHeight)
			SizeParams.cy = changes->height;
		if (mask &(CWWidth | CWHeight))
			SizeClient((HWND)w, SizeParams.cx, SizeParams.cy);
		if (mask &(CWWidth | CWBorderWidth)) {
			SizeParams.cx += 2 * winattrib->border_width;
			SizeParams.fl |= SWP_SIZE;
		}
		if (mask &(CWHeight | CWBorderWidth)) {
			SizeParams.y = parent.cy - winattrib->y - SizeParams.cy - winattrib->border_width;
			SizeParams.cy += 2 * winattrib->border_width +
				WinQuerySysValue(hwndDesktop, SV_CYTITLEBAR);
			SizeParams.fl |= SWP_MOVE | SWP_SIZE;
		}
		if (mask & CWX) {
			SizeParams.x = changes->x - winattrib->border_width;
			SizeParams.fl |= SWP_MOVE;
		}
		if (mask & CWY) {
			SizeParams.y = parent.cy - changes->y - SizeParams.cy - winattrib->border_width;
			SizeParams.fl |= SWP_MOVE;
		}
	} else {
		if (mask & CWWidth) {
			SizeParams.cx = changes->width;
			SizeParams.fl |= SWP_SIZE;
		}
		if (mask & CWHeight) {
			SizeParams.cy = changes->height;
			SizeParams.y = parent.cy - winattrib->y - SizeParams.cy;
			SizeParams.fl |= SWP_SIZE | SWP_MOVE;
		}
		if (mask & CWX) {
			SizeParams.x = changes->x;
			SizeParams.fl |= SWP_MOVE;
		}
		if (mask & CWY) {
			SizeParams.y = parent.cy - changes->y - SizeParams.cy;
			SizeParams.fl |= SWP_MOVE;
		}
	}

        if (SizeParams.fl && WinSendMsg(mainhwnd, UM_SetWindowPos, (MPARAM)&SizeParams, 0)) {
		SyncHandle();
		DBUG_RETURN(1);
	}
	DBUG_RETURN(0);
}
