#include "Xlib.h"
#include "Xlib_private.h"
#include "GetReq.h"

/*

Copyright 1986, 1998  The Open Group

All Rights Reserved.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.

*/

/* 
 * Arguments
 * 
 *  display            Specifies the connection to the X server. 
 *  cursor             Specifies the cursor. 
 *  foreground_color   Specifies the RGB values for the foreground of the source. 
 *  background_color   Specifies the RGB values for the background of the source. 
 * 
 * 
 * Description
 * 
 * The XRecolorCursor() function changes the color of the specified cursor, and if the cursor is being displayed on a screen, the
 * change is visible immediately. The pixel members of the XColor structures are ignored; only the RGB values are used. 
 * 
 * XRecolorCursor() can generate a BadCursor error. 
 * 
 */


int XRecolorCursor(register Display *dpy, Cursor cursor, XColor *foreground, XColor *background)
{       
    register xRecolorCursorReq *req;

    DBUG_ENTER("XRecolorCursor");
    LockDisplay(dpy);
    GetReq(RecolorCursor, req);
    req->cursor = cursor;
    req->foreRed = foreground->red;
    req->foreGreen = foreground->green;
    req->foreBlue = foreground->blue;
    req->backRed = background->red;
    req->backGreen = background->green;
    req->backBlue = background->blue;
    UnlockDisplay(dpy);
    SyncHandle();
    DBUG_RETURN(1);
}

