
#include "Xlib_private.h"

extern HAB pmctls_hab;


Bool XQueryPointer(Display* display, Window w, Window* root_return, Window* child_return, 
		int* root_x_return, int* root_y_return, int* win_x_return, int* win_y_return,
		unsigned int* mask_return)
{
	DBUG_ENTER("XQueryPointer")
	POINTL ptl;
	Window child;
	XWindowAttributes *attrib;

	WinQueryPointerPos(hwndDesktop, &ptl);
	child = (Window) WinWindowFromPoint(hwndDesktop, &ptl, TRUE);
	if (!(attrib = GetWinAttrib(child,NULL)) ||
	   DisplayOfScreen(attrib->screen) != display) child = (Window)hwndDesktop;
	if (root_x_return) *root_x_return = ptl.x;
	if (root_y_return) *root_y_return = WinQuerySysValue(hwndDesktop,SV_CYSCREEN) - ptl.y;
	if (root_return) *root_return = WinQueryDesktopWindow(mainhab, NULLHANDLE);
	if (child_return) *child_return = child;
	if (child && (win_x_return || win_y_return)) {
		RECTL rectl;
		WinQueryWindowRect(child, &rectl);
		WinMapWindowPoints(hwndDesktop, child, &ptl, 1);
		if (win_x_return) *win_x_return = ptl.x;
		if (win_y_return) *win_y_return = rectl.yTop - rectl.yBottom - ptl.y;
	}
	*mask_return = 0;
	if (WinGetKeyState(hwndDesktop,VK_CAPSLOCK) & 0x0001) *mask_return |= LockMask;
	if (WinGetKeyState(hwndDesktop,VK_SHIFT) & 0x8000) *mask_return |= ShiftMask;
	if (WinGetKeyState(hwndDesktop,VK_CTRL) & 0x8000) *mask_return |= ControlMask;
	if (WinGetKeyState(hwndDesktop,VK_ALT) & 0x8000) *mask_return |= Mod2Mask;
	if (WinGetKeyState(hwndDesktop, VK_BUTTON1)&0x8000) *mask_return |= Button1Mask;
	if (WinGetKeyState(hwndDesktop, VK_BUTTON2)&0x8000) *mask_return |= Button2Mask;
	if (WinGetKeyState(hwndDesktop, VK_BUTTON3)&0x8000) *mask_return |= Button3Mask;
	
	DBUG_RETURN(True);
}
