
#include "Xlib_private.h"

#define UM_UNMAP (WM_USER+10)
#define UM_MAP (WM_USER+11)

MRESULT EXPENTRY xpmframeproc(HWND, ULONG, MPARAM, MPARAM);

int Xlib_PMWM_Handler0(HWND* hWnd, ULONG* msg, MPARAM* mp1, MPARAM* mp2)
{
	if (msg && mp1) switch(*msg) {
	case UM_SetWindowPos:
	{
		SWP oldswp;
		HWND parent;
		Xlib_SetWindowPos *args = PVOIDFROMMP(*mp1);
		if (!args) break;

		parent = WinQueryWindow( args->hwnd, QW_PARENT );
		WinQueryWindowPos( args->hwnd, &oldswp );

		if (parent == hwndDesktop) {
			int cyscreen = WinQuerySysValue(hwndDesktop, SV_CYSCREEN);
			int y, cy;
			if (args->fl & SWP_MOVE) y = args->y; else y = oldswp.y;
			if (args->fl & SWP_SIZE) cy = args->cy; else cy = oldswp.cy;
			if (cy > cyscreen) {
				args->cy = cyscreen;
				if (!(args->fl & SWP_SIZE)) {
					args->cx = oldswp.cx;
					args->fl |= SWP_SIZE;
				}
			}
			if (y + cy > cyscreen) {
				args->y = cyscreen - cy;
				if (!(args->fl & SWP_MOVE)) {
					args->x = oldswp.x;
					args->fl |= SWP_MOVE;
				}
			}
		}

		if (args->fl & SWP_MOVE && args->x == oldswp.x && args->y == oldswp.y)
			args->fl &= ~SWP_MOVE;
		if (args->fl & SWP_SIZE && args->cx == oldswp.cx && args->cy == oldswp.cy)
			args->fl &= ~SWP_SIZE;

		break;
	}
	default:
		break;
	}
	return 0;
}

int Xlib_PMWM_Handler1(HWND* hWnd, ULONG* msg, MPARAM* mp1, MPARAM* mp2)
{
    if(msg && mp1) switch(*msg) {
    case UM_ChangeProperty:
        {
            Xlib_ChangeProperty *args = PVOIDFROMMP(mp1);
            WinAttribData *attrib = WinQueryWindowPtr(args->w, QWP_WINATTRIB);

           if (args->property == XA_WM_ICON_NAME && args->type == XA_STRING) {
                HPOINTER tmpicon;
                HWND hwndframe = WinQueryWindowULong((HWND)args->w, QWP_FRAMEHWND);

                if(hwndframe && attrib->wm_iconname)
                {
                    char *newname = malloc(strlen(attrib->wm_iconname)+5);

                    strcpy(newname, attrib->wm_iconname);
                    strcat(newname, ".ico");
                    /* May need to search a path of some sort */
                    if(tmpicon = WinLoadFileIcon(newname, FALSE))
                        WinSendMsg(hwndframe, WM_SETICON, (MPARAM)tmpicon, 0);
                    free(newname);
                }
            }
        }
        break;
    }
    return 0;
}
