
#define INCL_DOSPROCESS
#include "Xlib_private.h"
#include <netdb.h>

extern PID mypid;
HMODULE module;
unsigned int _XmaxKeyCode, _XminKeyCode;
KeySym *_XkeyMap;

extern Bool _XWireToEvent();
extern Status _XUnknownNativeEvent();
extern Bool _XUnknownWireEvent();
extern Bool OsInitColors();

void Xlib_InitAtoms(Display*);
void Xlib_buildmark(char*, int);
Bool XkbUseExtension(Display*,int*,int*);
void _XInitKeyMapping(void);
void Xlib_InitOS2I18N(void);

void pthread_setfuncs(void *mutex, void *event);


#ifndef BUFSIZE
#define BUFSIZE 2048
#endif

static ScreenFormat ScreenFmtTmpl[] = {
	{NULL, 24, 32, 4},
	{NULL, 16, 16, 2},
	{NULL, 8,  8, 1},
	{NULL, 1,  1, 1}
};

/* XFreeDisplayStructure frees all the storage associated with a 
 * Display.  It is used by XOpenDisplay if it runs out of memory,
 * and also by XCloseDisplay.   It needs to check whether all pointers
 * are non-NULL before dereferencing them, since it may be called
 * by XOpenDisplay before the Display structure is fully formed.
 * XOpenDisplay must be sure to initialize all the pointers to NULL
 * before the first possible call on this.
 */

void _XFreeDisplayStructure(dpy)
	register Display *dpy;
{
	DBUG_ENTER("_XFreeDisplayStructure")
	while (dpy->ext_procs) {
	    _XExtension *ext = dpy->ext_procs;
	    dpy->ext_procs = ext->next;
	    if (ext->name)
		Xfree (ext->name);
	    Xfree ((char *)ext);
	}
	if (dpy->im_filters)
	   (*dpy->free_funcs->im_filters)(dpy);
	if (dpy->cms.clientCmaps)
	   (*dpy->free_funcs->clientCmaps)(dpy);
	if (dpy->cms.defaultCCCs)
	   (*dpy->free_funcs->defaultCCCs)(dpy);
	if (dpy->cms.perVisualIntensityMaps)
	   (*dpy->free_funcs->intensityMaps)(dpy);
	if (dpy->atoms)
	    (*dpy->free_funcs->atoms)(dpy);
	if (dpy->modifiermap)
	   (*dpy->free_funcs->modifiermap)(dpy->modifiermap);
	if (dpy->key_bindings)
	   (*dpy->free_funcs->key_bindings)(dpy);
	if (dpy->context_db)
	   (*dpy->free_funcs->context_db)(dpy);
	if (dpy->xkb_info)
	   (*dpy->free_funcs->xkb)(dpy);

	if (dpy->screens) {
	    register int i;

            for (i = 0; i < dpy->nscreens; i++) {
		Screen *sp = &dpy->screens[i];

		if (sp->depths) {
		   register int j;

		   for (j = 0; j < sp->ndepths; j++) {
			Depth *dp = &sp->depths[j];

			if (dp->visuals) {
			   register int k;

			   for (k = 0; k < dp->nvisuals; k++)
			     _XFreeExtData (dp->visuals[k].ext_data);
			   Xfree ((char *) dp->visuals);
			   }
			}

		   Xfree ((char *) sp->depths);
		   }

		_XFreeExtData (sp->ext_data);
		}

	    Xfree ((char *)dpy->screens);
	    }
	
	if (dpy->pixmap_format) {
	    register int i;

	    for (i = 0; i < dpy->nformats; i++)
	      _XFreeExtData (dpy->pixmap_format[i].ext_data);
            Xfree ((char *)dpy->pixmap_format);
	    }

	if (dpy->display_name)
	   Xfree (dpy->display_name);
	if (dpy->vendor)
	   Xfree (dpy->vendor);

        if (dpy->private12)
	   Xfree (dpy->private12);
	if (dpy->keysyms && dpy->keysyms != _XkeyMap)
	   Xfree ((char *) dpy->keysyms);
	if (dpy->xdefaults)
	   Xfree (dpy->xdefaults);
	if (dpy->error_vec)
	    Xfree ((char *)dpy->error_vec);

	_XFreeExtData (dpy->ext_data);
	if (dpy->free_funcs)
	    Xfree ((char *)dpy->free_funcs);
 	if (dpy->scratch_buffer)
 	    Xfree (dpy->scratch_buffer);
	/*FreeDisplayLock(dpy);*/

	/*if (dpy->qfree) {
	    register _XQEvent *qelt = dpy->qfree;

	    while (qelt) {
		register _XQEvent *qnxt = qelt->next;
		Xfree ((char *) qelt);
		qelt = qnxt;
	    }
	}*/

	while (dpy->im_fd_info) {
	    struct _XConnectionInfo *conni = dpy->im_fd_info;
	    dpy->im_fd_info = conni->next;
	    if (conni->watch_data)
		Xfree (conni->watch_data);
	    Xfree (conni);
	}
	if (dpy->conn_watchers) {
	    struct _XConnWatchInfo *watcher = dpy->conn_watchers;
	    dpy->conn_watchers = watcher->next;
	    Xfree (watcher);
	}
	if (dpy->filedes)
	    Xfree (dpy->filedes);

	Xfree ((char *)dpy);
	DBUG_VOID_RETURN;
}

Display *new_display(_Xconst char *displayname)
{
	DBUG_ENTER("new_display")
	Display *tmpdisplay = malloc(sizeof(Display));
	char hostname[256];
	int i;
	extern XID _XAllocID();
	extern void _XAllocIDs();

	memset(tmpdisplay, 0, sizeof(Display));

	tmpdisplay->fd = pmout[0];

	if (!displayname) {
		gethostname(hostname,255);
		strcat(hostname,":0");
	}

	tmpdisplay->proto_major_version = X_PROTOCOL;
	tmpdisplay->proto_minor_version = X_PROTOCOL_REVISION;
	tmpdisplay->vendor = strdup("Everblue");
	tmpdisplay->release = 0;

	tmpdisplay->ext_data = NULL;
	
	tmpdisplay->display_name = strdup(displayname?displayname:hostname);
	tmpdisplay->qlen = 0;

	tmpdisplay->nformats = sizeof(ScreenFmtTmpl) / sizeof(ScreenFormat);
	tmpdisplay->pixmap_format = (ScreenFormat *)Xmalloc(sizeof(ScreenFmtTmpl));
	memcpy(tmpdisplay->pixmap_format, ScreenFmtTmpl, sizeof(ScreenFmtTmpl));		

	tmpdisplay->event_vec[0] = _XUnknownWireEvent;
	tmpdisplay->event_vec[1] = _XUnknownWireEvent;
	tmpdisplay->wire_vec[0]  = _XUnknownNativeEvent;
	tmpdisplay->wire_vec[1]  = _XUnknownNativeEvent;
	for (i = KeyPress; i < LASTEvent; i++) {
	    tmpdisplay->event_vec[i] 	= _XWireToEvent;
	    tmpdisplay->wire_vec[i] 	= NULL;
	}
	for (i = LASTEvent; i < 128; i++) {
	    tmpdisplay->event_vec[i] 	= _XUnknownWireEvent;
	    tmpdisplay->wire_vec[i] 	= _XUnknownNativeEvent;
	}
	tmpdisplay->next_event_serial_num = 1;

	tmpdisplay->private8 = X_PROTOCOL;
	tmpdisplay->resource_alloc = _XAllocID;
	tmpdisplay->idlist_alloc = _XAllocIDs;

	_XInitKeyMapping();
	tmpdisplay->min_keycode = _XminKeyCode;
	tmpdisplay->max_keycode = _XmaxKeyCode;
	tmpdisplay->keysyms = _XkeyMap;
	tmpdisplay->keysyms_per_keycode = 4;
	tmpdisplay->mode_switch = Mod1Mask;

	tmpdisplay->nscreens = 1;
	tmpdisplay->default_screen = 0;
	tmpdisplay->screens = new_screen(tmpdisplay);

	tmpdisplay->bitmap_bit_order = LSBFirst;
	tmpdisplay->byte_order = LSBFirst;

	tmpdisplay->bigreq_size = 1L<<24;
	tmpdisplay->max_request_size = BUFSIZE;
	tmpdisplay->private13 = tmpdisplay->private12 = Xcalloc(1, BUFSIZE);
	tmpdisplay->private14 = tmpdisplay->private12 + BUFSIZE;

	tmpdisplay->free_funcs = (_XFreeFuncRec *)Xcalloc(1, sizeof(_XFreeFuncRec));

	DBUG_RETURN(tmpdisplay);
}
	
int oldapptype;

int XCloseDisplay(Display* dpy)
{
	DBUG_ENTER("XCloseDisplay")
	register _XExtension *ext;
	register int i;

	if (!(dpy->flags & XlibDisplayClosing))
	{
		dpy->flags |= XlibDisplayClosing;
		for (i = 0; i < dpy->nscreens; i++) {
			register Screen *sp = &dpy->screens[i];
			XFreeGC (dpy, sp->default_gc);
		}
		if (dpy->cursor_font != None) {
			XUnloadFont (dpy, dpy->cursor_font);
		}
		XSync(dpy, 1);  /* throw away pending events, catch errors */
		/* call out to any extensions interested */
		for (ext = dpy->ext_procs; ext; ext = ext->next) {
			if (ext->close_display)
			(*ext->close_display)(dpy, &ext->codes);
		}
		/* if the closes generated more protocol, sync them up */
		if (dpy->request != dpy->last_request_read)
			XSync(dpy, 1);
	}

	if (xinitialized && dpy == maindisplay) {
		APIRET rc;
		PPIB pib = NULL;

		WinPostMsg(mainhwnd, WM_QUIT, 0, 0);

		while (xinitialized) _sleep2(10);

		/* now to reverse what XOpenDisplay does... */

		close(pmout[1]); close(pmout[0]);

		WinDestroyMsgQueue(mainhmq);
		WinTerminate(mainhab);

		(ULONG) mainthread = (ULONG) maindisplay = 
		(ULONG) mainhmq = (ULONG) mainhab = (ULONG) mainhwnd = 0L;

		pthread_mutex_destroy(&evmutex);
		_XFreeMutex(_Xglobal_lock);

		if (oldapptype != 3) {
			pthread_setfuncs((void *)NULL, (void *)NULL);

			rc = DosGetInfoBlocks(NULL,&pib);
			pib->pib_ultype = oldapptype;
		}

		/*x11_console_notice("X closed.");*/
	
		/*free_display(display);*/
	
	}
	_XFreeDisplayStructure(dpy);
	DBUG_RETURN(0);
}


Display *XOpenDisplay(_Xconst char *display)
{
	DBUG_ENTER("XOpenDisplay")
	int res;
	char *display_name;
	Display *result = NULL;

	if (display == NULL || *display == '\0') {
		display_name = strdup(getenv("DISPLAY"));
		/* Absolute fallback force local since we really
		 * don't have a display anyway. ;)
		 */
		if(display == NULL || *display == '\0')
			display_name = "localhost:0.0";
	}
	else {
		/* Display is non-NULL, copy the pointer */
		display_name = strdup((char *)display);
	}

/*
 * Set the default error handlers.  This allows the global variables to
 * default to NULL for use with shared libraries.
 */
	if (_XErrorFunction == NULL) (void) XSetErrorHandler (NULL);
	if (_XIOErrorFunction == NULL) (void) XSetIOErrorHandler (NULL);

	if (!xinitialized) {
		APIRET rc;
		PPIB pib = NULL;

		/* Make this a PM app */
		rc = DosGetInfoBlocks(NULL,&pib);
		oldapptype = pib->pib_ultype;
		pib->pib_ultype = 3;
		mypid = pib->pib_ulpid;

		pthread_setfuncs((void *)WinRequestMutexSem, (void *)WinWaitEventSem);

		DosQueryModuleHandle("X11.DLL", &module);

		memset(GCList, 0, sizeof(GCList));

		pthread_init();

#ifdef OS2I18N
		Xlib_InitOS2I18N();
#endif

		pthread_mutex_init(&evmutex, NULL);
		
		_XCreateMutex(_Xglobal_lock);
	
		mainhab = WinInitialize(0);
		mainhmq = WinCreateMsgQueue(mainhab, 0);
		pmatomtbl = WinQuerySystemAtomTable();

		hwndDesktop = WinQueryDesktopWindow(mainhab, NULLHANDLE);

		pipe(pmout);

		mainthread = pthread_self();
		res = pthread_create(&pmthread, NULL, pm_thread, NULL);
	}

	if (!maindisplay) {
		char buildmark[80];
		maindisplay = new_display(display_name);

		while (!xinitialized) _sleep2(10);

		Xlib_InitAtoms(maindisplay);

		Xlib_buildmark(buildmark,sizeof(buildmark));
		fprintf(stderr,"PM-Xlib built %s,\n",buildmark);

		result = maindisplay;
	} else
		result = new_display(display_name);

	/*
	 * call into synchronization routine so that all programs can be
	 * forced synchronous
	 */
	(void) XSynchronize(result, _Xdebug);

	if (result == maindisplay) {
		extern Display *_XHeadOfDisplayList;
		OsInitColors();
		_XHeadOfDisplayList = result;
	}

	XkbUseExtension(result, NULL, NULL);

	/*
		XEvent new;
		extern int serial;
		new.xany.serial = serial++;
		new.xany.display = result;
		new.xany.window = None;
		new.xany.send_event = True;
		new.type = MappingNotify;
		new.xmapping.request = MappingModifier;
		XRefreshKeyboardMapping(&new);
	*/

	DBUG_RETURN(result);
}