/* $XConsortium: ModMap.c /main/15 1996/10/22 14:20:24 kaleb $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#define NEED_REPLIES
#include "Xlib_private.h"
#include "x11pmvk.h"

XModifierKeymap *
XGetModifierMapping(dpy)
     register Display *dpy;
{       
    DBUG_ENTER("XGetModifierMapping")
    XModifierKeymap *res, *rc;

    res = XNewModifiermap(8);
    if (!res) DBUG_RETURN(NULL);

    DBUG_POINT("ShiftMapIndex");
    if ((rc = XInsertModifiermapEntry(res, 0xaa, ShiftMapIndex))) res=rc;
    if ((rc = XInsertModifiermapEntry(res, 0xb6, ShiftMapIndex))) res=rc;
    DBUG_POINT("LockMapIndex");
    if ((rc = XInsertModifiermapEntry(res, 0xba, LockMapIndex))) res=rc;
    DBUG_POINT("ControlMapIndex");
    if ((rc = XInsertModifiermapEntry(res, 0x9d, ControlMapIndex))) res=rc;
    if ((rc = XInsertModifiermapEntry(res, 0xdb, ControlMapIndex))) res=rc;
    DBUG_POINT("Mod1MapIndex");
    if ((rc = XInsertModifiermapEntry(res, 0x11, Mod1MapIndex))) res=rc;
    DBUG_POINT("Mod2MapIndex");
    if ((rc = XInsertModifiermapEntry(res, 0xb8, Mod2MapIndex))) res=rc;
    if ((rc = XInsertModifiermapEntry(res, 0xde, Mod2MapIndex))) res=rc;

    DBUG_POINT("SyncHandle()");
    SyncHandle();
    DBUG_RETURN(res);
}

/*
 *	Returns:
 *	0	Success
 *	1	Busy - one or more old or new modifiers are down
 *	2	Failed - one or more new modifiers unacceptable
 */
#if 0
int
XSetModifierMapping(dpy, modifier_map)
    register Display *dpy;
    register XModifierKeymap *modifier_map;
{
    register xSetModifierMappingReq *req;
    xSetModifierMappingReply rep;
    int         mapSize = modifier_map->max_keypermod << 3;	/* 8 modifiers */

    LockDisplay(dpy);
    GetReqExtra(SetModifierMapping, mapSize, req);

    req->numKeyPerModifier = modifier_map->max_keypermod;

    memcpy((char *) NEXTPTR(req,xSetModifierMappingReq),
	   (char *) modifier_map->modifiermap,
	   mapSize);

    (void) _XReply(dpy, (xReply *) & rep,
	(SIZEOF(xSetModifierMappingReply) - SIZEOF(xReply)) >> 2, xTrue);
    UnlockDisplay(dpy);
    SyncHandle();
    return (rep.success);
}
#endif

XModifierKeymap *
XNewModifiermap(keyspermodifier)
    int keyspermodifier;
{
    DBUG_ENTER("XNewModifiermap")
    XModifierKeymap *res = (XModifierKeymap *) Xmalloc((sizeof (XModifierKeymap)));
    if (res) {
	res->max_keypermod = keyspermodifier;
	res->modifiermap = (keyspermodifier > 0 ?
			    (KeyCode *) Xmalloc((unsigned) (8 * keyspermodifier))
			    : (KeyCode *) NULL);
	if (keyspermodifier && (res->modifiermap == NULL)) {
	    Xfree((char *) res);
	    DBUG_RETURN((XModifierKeymap *) NULL);
	}
    }
    DBUG_RETURN(res);
}


int XFreeModifiermap(map)
    XModifierKeymap *map;
{
    DBUG_ENTER("XFreeModifiermap")
    if (map) {
	if (map->modifiermap)
	    Xfree((char *) map->modifiermap);
	Xfree((char *) map);
    }
    DBUG_RETURN(1);
}

#if NeedFunctionPrototypes
XModifierKeymap *
XInsertModifiermapEntry(XModifierKeymap *map,
#if NeedWidePrototypes
			unsigned int keycode,
#else
			KeyCode keycode,
#endif
			int modifier)
#else
XModifierKeymap *
XInsertModifiermapEntry(map, keycode, modifier)
    XModifierKeymap *map;
    KeyCode keycode;
    int modifier;
#endif
{
    DBUG_ENTER("XInsertModifiermapEntry")
    XModifierKeymap *newmap;
    int i,
	row = modifier * map->max_keypermod,
	newrow,
	lastrow;

    for (i=0; i<map->max_keypermod; i++) {
        if (map->modifiermap[ row+i ] == keycode)
	    DBUG_RETURN(map); /* already in the map */
        if (map->modifiermap[ row+i ] == 0) {
            map->modifiermap[ row+i ] = keycode;
	    DBUG_RETURN(map); /* we added it without stretching the map */
	}
    }   

    /* stretch the map */
    if ((newmap = XNewModifiermap(map->max_keypermod+1)) == NULL)
	DBUG_RETURN((XModifierKeymap *) NULL);
    newrow = row = 0;
    lastrow = newmap->max_keypermod * 8;
    while (newrow < lastrow) {
	for (i=0; i<map->max_keypermod; i++)
	    newmap->modifiermap[ newrow+i ] = map->modifiermap[ row+i ];
	newmap->modifiermap[ newrow+i ] = 0;
	row += map->max_keypermod;
	newrow += newmap->max_keypermod;
    }
    (void) XFreeModifiermap(map);
    newrow = newmap->max_keypermod * modifier + newmap->max_keypermod - 1;
    newmap->modifiermap[ newrow ] = keycode;
    DBUG_RETURN(newmap);
}

#if NeedFunctionPrototypes
XModifierKeymap *
XDeleteModifiermapEntry(XModifierKeymap *map,
#if NeedWidePrototypes
			unsigned int keycode,
#else
			KeyCode keycode,
#endif
			int modifier)
#else
XModifierKeymap *
XDeleteModifiermapEntry(map, keycode, modifier)
    XModifierKeymap *map;
    KeyCode keycode;
    int modifier;
#endif
{
    DBUG_ENTER("XDeleteModifiermapEntry")
    int i,
	row = modifier * map->max_keypermod;

    for (i=0; i<map->max_keypermod; i++) {
        if (map->modifiermap[ row+i ] == keycode)
            map->modifiermap[ row+i ] = 0;
    }
    /* should we shrink the map?? */
    DBUG_RETURN(map);
}
