/* $XConsortium: LookupCol.c,v 11.23 94/04/17 20:20:10 rws Exp $ */
/*

Copyright (c) 1985  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#define NEED_REPLIES
#include <stdio.h>
#include "Xlib_private.h"
#include "Xcmsint.h"
#include <alloca.h>

extern void _XcmsRGB_to_XColor();
extern void _XUnresolveColor();
extern int _XcmsResolveColorString();
extern char *rgbPath;

Bool OsLookupColor(int, char *, unsigned, 
	unsigned short *, unsigned short *, unsigned short *);

#if NeedFunctionPrototypes
Status XLookupColor (
	register Display *dpy,
        Colormap cmap,
	_Xconst char *spec,
	XColor *def,
	XColor *scr)
#else
Status XLookupColor (dpy, cmap, spec, def, scr)
	register Display *dpy;
        Colormap cmap;
	char *spec;
	XColor *def, *scr;
#endif
{
	DBUG_ENTER("XLookupColor")
	register int n;
	unsigned short red, green, blue;
	XcmsCCC ccc;
	XcmsColor cmsColor_exact;

	/*
	 * Let's Attempt to use Xcms and i18n approach to Parse Color
	 */
	/* copy string to allow overwrite by _XcmsResolveColorString() */
	if ((ccc = XcmsCCCOfColormap(dpy, cmap)) != (XcmsCCC)NULL) {
	    if (_XcmsResolveColorString(ccc, &spec,
		    &cmsColor_exact, XcmsRGBFormat) >= XcmsSuccess) {
		_XcmsRGB_to_XColor(&cmsColor_exact, def, 1);
		memcpy((char *)scr, (char *)def, sizeof(XColor));
		_XUnresolveColor(ccc, scr);
		DBUG_RETURN(1);
	    }
	    /*
	     * Otherwise we failed; or spec was changed with yet another
	     * name.  Thus pass name to the X Server.
	     */
	}


	/*
	 * Xcms and i18n methods failed, so lets pass it to the server
	 * for parsing.
	 */

	n = strlen (spec);
	if (!OsLookupColor(0,(char *)spec,n,&red,&green,&blue)) {
	    SyncHandle();
	    DBUG_RETURN(0);
	}
	
	def->red   = red;
	def->green = green;
	def->blue  = blue;

	/* NEED TO ADD GAMMA CORRECTION HERE */	

	scr->red   = red;
	scr->green = green;
	scr->blue  = blue;

	SyncHandle();
	DBUG_RETURN(1);
}

#define HASHSIZE 511

typedef struct _dbEntry * dbEntryPtr;
typedef struct _dbEntry {
  dbEntryPtr     link;
  unsigned short red;
  unsigned short green;
  unsigned short blue;
  char           name[1];	/* some compilers complain if [0] */
} dbEntry;


extern void _XcmsCopyISOLatin1Lowered();

static dbEntryPtr hashTab[HASHSIZE];


static dbEntryPtr
lookup(name, len, create)
     char *name;
     int  len;
     Bool create;
{
  DBUG_ENTER("lookup")
  unsigned int h = 0, g;
  dbEntryPtr   entry, *prev = NULL;
  char         *str = name;

  if (!(name = (char*)alloca(len +1))) DBUG_RETURN(NULL);
  _XcmsCopyISOLatin1Lowered(name, str, len);
  
  name[len] = '\0';

  for(str = name; *str; str++) {
    h = (h << 4) + *str;
    if ((g = h) & 0xf0000000) h ^= (g >> 24);
    h &= g;
  }
  h %= HASHSIZE;

  if (( entry = hashTab[h] ))
    {
      for( ; entry; prev = (dbEntryPtr*)entry, entry = entry->link )
	if (! strcmp(name, entry->name) ) break;
    }
  else
    prev = &(hashTab[h]);

  if (!entry && create && (entry = (dbEntryPtr)malloc(sizeof(dbEntry) +len)))
    {
      *prev = entry;
      entry->link = NULL;
      strcpy( entry->name, name );
    }

  /*DEALLOCATE_LOCAL(name);*/

  DBUG_RETURN(entry);
}


Bool
OsInitColors()
{
  DBUG_ENTER("OsInitColors")
  FILE       *rgb;
  char       *path;
  char       line[BUFSIZ];
  char       name[BUFSIZ];
  int        red, green, blue, lineno = 0;
  dbEntryPtr entry;

  static Bool was_here = FALSE;

  if (!was_here)
    {
#ifndef __EMX__
      path = (char*)ALLOCATE_LOCAL(strlen(rgbPath) +5);
      strcpy(path, rgbPath);
      strcat(path, ".txt");
#else
      char *tmp = (char*)__XOS2RedirRoot(rgbPath);
      path = (char*)alloca(strlen(tmp) +5);
      strcpy(path, tmp);
      strcat(path, ".txt");
#endif
      if (!(rgb = fopen(path, "r")))
        {
	   fprintf(stderr, "Couldn't open RGB_DB '%s'\n", rgbPath );
	   fprintf(stderr, "Xlated path '%s'\n", path );
	   /*DEALLOCATE_LOCAL(path);*/
	   DBUG_RETURN(FALSE);
	}

      while(fgets(line, sizeof(line), rgb))
	{
	  lineno++;
#ifndef __EMX__
	  if (sscanf(line,"%d %d %d %[^\n]\n", &red, &green, &blue, name) == 4)
#else
	  if (sscanf(line,"%d %d %d %[^\n\r]\n", &red, &green, &blue, name) == 4)
#endif
	    {
	      if (red >= 0   && red <= 0xff &&
		  green >= 0 && green <= 0xff &&
		  blue >= 0  && blue <= 0xff)
		{
		  if ((entry = lookup(name, strlen(name), TRUE)))
		    {
		      entry->red   = (red * 65535)   / 255;
		      entry->green = (green * 65535) / 255;
		      entry->blue  = (blue  * 65535) / 255;
		    }
		}
	      else
		fprintf(stderr,"Value out of range: %s:%d\n", path, lineno);
	    }
	  else if (*line && *line != '#' && *line != '!')
	    fprintf(stderr,"Syntax Error: %s:%d\n", path, lineno);
	}
      
      fclose(rgb);
      /*DEALLOCATE_LOCAL(path);*/

      was_here = TRUE;
    }

  DBUG_RETURN(TRUE);
}

Bool
OsLookupColor(screen, name, len, pred, pgreen, pblue)
    int		   screen;
    char	   *name;
    unsigned	   len;
    unsigned short *pred, *pgreen, *pblue;

{
  DBUG_ENTER("OsLookupColor")
  dbEntryPtr entry;

  if ((entry = lookup(name, len, FALSE)))
    {
      *pred   = entry->red;
      *pgreen = entry->green;
      *pblue  = entry->blue;
      DBUG_RETURN(TRUE);
    }

  DBUG_RETURN(FALSE);
}
