#include "Xlib_private.h"

/* I originally was going to use WinSetCapture() for capturing
 mouse input, but since I needed to grab other info from the
 system input queue I decided to implement it the same way.
 Brian Smith
 */

#include "x11pmvk.h"

Xlib_Grab *__GrabNull(void)
{
	return NULL;
}

void __GrabVoid(void)
{
	return;
}

Xlib_Grab *(*Xlib_NewGrab)(void) = __GrabNull;
void (*Xlib_RemoveGrab)(int) = __GrabVoid;
void (*Xlib_RemoveGrabAny)(int) = __GrabVoid;
Xlib_Grab *(*Xlib_FindGrab)(int) = __GrabNull;
PFN Xlib_InputQueueHook = NULL;

int XGrabPointer(
    Display*		display,
    Window		grab_window,
    Bool		owner_events,
    unsigned int	event_mask,
    int			pointer_mode,
    int			keyboard_mode,
    Window		confine_to,
    Cursor		cursor,
    Time		time
)
{
    DBUG_ENTER("XGrabPointer")
    Xlib_Grab *new;
    
    /* I think we can safely ignore the Time paramater since
     according to the documentation it is for network synchronization
     problems which should not be an issue here - Brian Smith */

    new = Xlib_FindGrab(GrabPointer);
    if (new && new->window != grab_window) 
        DBUG_RETURN(AlreadyGrabbed);

    new = Xlib_NewGrab();
    if (!new) DBUG_RETURN(False);

    new->type = GrabPointer;
    new->window = grab_window;
    new->owner_events = owner_events;
    new->event_mask = event_mask;
    new->pointer_mode = pointer_mode;
    new->keyboard_mode = keyboard_mode;
    new->cursor = cursor;
    new->time = time;

    if(cursor != None)
        XDefineCursor(display, grab_window, cursor);
    DBUG_RETURN(True);
}

int XUngrabPointer(Display*    	display,   Time	time)
{
    DBUG_ENTER("XUngrabPointer")
    Xlib_Grab *current;

    current = Xlib_FindGrab(GrabPointer);
    if (!current) DBUG_RETURN(False);
    XUndefineCursor(display, current->window);
    Xlib_RemoveGrab(GrabPointer);

    DBUG_RETURN(True);
}

int XAllowEvents(Display *display, int event_mode, Time time)
{
    DBUG_ENTER("XAllowEvents")
    Xlib_Grab *current;
    
    switch(event_mode) {
    case AsyncPointer:
        Xlib_RemoveGrabAny(GrabPointer);
        break;
    case SyncPointer:
        if((current = Xlib_FindGrab(GrabPointer))!=NULL)
            current->special = SyncPointer;
        break;
    case AsyncKeyboard:
        Xlib_RemoveGrabAny(GrabKeyboard);
        break;
    case SyncKeyboard:
        if((current = Xlib_FindGrab(GrabKeyboard))!=NULL)
            current->special = SyncKeyboard;
        break;
    case AsyncBoth:
        Xlib_RemoveGrabAny(GrabKeyboard);
        Xlib_RemoveGrabAny(GrabPointer);
        break;
    case SyncBoth:
        if((current = Xlib_FindGrab(GrabKeyboard))!=NULL)
            current->special = SyncKeyboard;
        if((current = Xlib_FindGrab(GrabPointer))!=NULL)
            current->special = SyncPointer;
        break;
    }
    DBUG_RETURN(True);
}

int XGrabButton(
    Display*		display,
    unsigned int	button,
    unsigned int	modifiers,
    Window		grab_window,
    Bool		owner_events,
    unsigned int	event_mask,
    int			pointer_mode,
    int			keyboard_mode,
    Window		confine_to,
    Cursor		cursor
)
{
    DBUG_ENTER("XGrabButton")
    Xlib_Grab *new;

    new = Xlib_FindGrab(GrabKey);
    if (new && new->window != grab_window)
        DBUG_RETURN(AlreadyGrabbed);
    
    new = Xlib_NewGrab();
    if (!new) DBUG_RETURN(False);

    new->type = GrabKey;
    new->button = button;
    new->modifiers = modifiers;
    new->window = grab_window;
    new->owner_events = owner_events;
    new->pointer_mode = pointer_mode;
    new->keyboard_mode = keyboard_mode;
    
    DBUG_RETURN(True);
}

int XUngrabButton(
    Display*		display,
    unsigned int	button,
    unsigned int	modifiers,
    Window		grab_window
)
{
    DBUG_ENTER("XUngrabButton")
    Xlib_RemoveGrab(GrabButton);
    DBUG_RETURN(True);
}

int XGrabKey(
    Display*		display,
    int			keycode,
    unsigned int	modifiers,
    Window		grab_window,
    Bool		owner_events,
    int			pointer_mode,
    int			keyboard_mode
)
{
    DBUG_ENTER("XGrabKey")
    Xlib_Grab *new;

    new = Xlib_FindGrab(GrabKey);
    if (new && new->window != grab_window)
        DBUG_RETURN(AlreadyGrabbed);
        
    new = Xlib_NewGrab();
    if (!new) DBUG_RETURN(False);

    new->type = GrabKey;
    new->keycode = keycode;
    new->modifiers = modifiers;
    new->window = grab_window;
    new->owner_events = owner_events;
    new->pointer_mode = pointer_mode;
    new->keyboard_mode = keyboard_mode;
    
    DBUG_RETURN(True);
}

int XUngrabKey(
    Display*		display,
    int			keycode,
    unsigned int	modifiers,
    Window		grab_window
)
{
    DBUG_ENTER("XUngrabKey")
    Xlib_RemoveGrab(GrabKey);
    DBUG_RETURN(True);
}

int XGrabKeyboard(
    Display*		display,
    Window		grab_window,
    Bool		owner_events,
    int			pointer_mode,
    int			keyboard_mode,
    Time		time
)
{
    DBUG_ENTER("XGrabKeyboard")
    Xlib_Grab *new;

    new = Xlib_FindGrab(GrabKeyboard);
    if (new && new->window != grab_window)
        DBUG_RETURN(AlreadyGrabbed);
        
    new = Xlib_NewGrab();
    if (!new) DBUG_RETURN(False);

    new->type = GrabKeyboard;
    new->window = grab_window;
    new->owner_events = owner_events;
    new->pointer_mode = pointer_mode;
    new->keyboard_mode = keyboard_mode;
    new->time = time;

    DBUG_RETURN(True);
}

int XUngrabKeyboard(Display*   	display,  Time 	time)
{
    DBUG_ENTER("XUngrabKeyboard")
    Xlib_RemoveGrab(GrabKeyboard);
    DBUG_RETURN(True);
}

int XGrabServer(
    Display*		display
)
{
    DBUG_ENTER("XGrabServer")
    Xlib_Grab *new;

    if(Xlib_FindGrab(GrabServer))
        DBUG_RETURN(AlreadyGrabbed);

    new = Xlib_NewGrab();
    if (!new) DBUG_RETURN(False);

    new->type = GrabServer;
    DBUG_RETURN(True);
}


int XUngrabServer(Display*      	display)
{
    DBUG_ENTER("XUngrabServer")
    Xlib_RemoveGrabAny(GrabServer);
    DBUG_RETURN(True);
}

int XChangeActivePointerGrab(Display *display, unsigned int event_mask, Cursor cursor, Time time)
{
    DBUG_ENTER("XChangeActivePointerGrab")
    Xlib_Grab *current = Xlib_FindGrab(GrabPointer);
    
    if(current)
    {
        current->event_mask = event_mask;
        current->cursor = cursor;
        current->time = time;
        if(cursor != None)
            XDefineCursor(display, current->window, cursor);
        DBUG_RETURN(True);
    }
    DBUG_RETURN(False);
}
