/****************************************************************************************
*Arguments
*
* display     Specifies the connection to the X server. 
* w           Specifies the window. 
* start
* stop 
*             Specify the time interval in which the events are returned from the motion history buffer. You can pass a
*             timestamp or CurrentTime. 
* nevents_return 
*             Returns the number of events from the motion history buffer. 
*
*
*Description
*
*The XGetMotionEvents() function returns all events in the motion history buffer that fall between the specified start and stop
*times, inclusive, and that have coordinates that lie within the specified window (including its borders) at its present placement. If the
*server does not support motion history, if the start time is later than the stop time, or if the start time is in the future, no events are
*returned; XGetMotionEvents() returns NULL. If the stop time is in the future, it is equivalent to specifying CurrentTime . The
*return type for this function is a structure defined as follows: 
*
*
*typedef struct {
*        Time time;
*        short x, y;
*} XTimeCoord;
*
*The time member is set to the time, in milliseconds. The x and y members are set to the coordinates of the pointer and are reported
*relative to the origin of the specified window. To free the data returned from this call, use XFree(). 
*
*XGetMotionEvents() can generate a BadWindow error. 
*
*Diagnostics
*
* BadWindow     A value for a Window argument does not name a defined Window.
****************************************************************************************/

#include "Xlib.h"
#include "Xlib_private.h" 

XTimeCoord *XGetMotionEvents(Display *display, Window w, Time start, Time stop, int *nevents_return)
{
	/* This one will return always NULL since the "Everblue"-server does
	 * not support motion history (yet) . */

        DBUG_ENTER("XGetMotionEvents");
        #ifdef DEBUG
           fprintf(stderr, "XGetMotionEvents: motion history not supported/implemented\n");
        #endif
	DBUG_RETURN(NULL);
}
