/* $XConsortium: GetImage.c,v 11.30 95/06/07 20:39:54 gildea Exp $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#define NEED_REPLIES
#include "Xlib_private.h"
#include <X11/Xutil.h>		/* for XDestroyImage */

#define ROUNDUP(nbytes, pad) (((((nbytes) - 1) + (pad)) / (pad)) * (pad))

int _XSetImage(XImage*, register XImage*, register int, register int);
Visual *_XVIDtoVisual (Display*, VisualID);
int _XGetScanlinePad(Display*, int);

static unsigned int Ones(mask)                /* HACKMEM 169 */
    unsigned long mask;
{
    register unsigned long y;

    y = (mask >> 1) &033333333333;
    y = mask - y - ((y >>1) & 033333333333);
    return ((unsigned int) (((y + (y >> 3)) & 030707070707) % 077));
}

XImage *XGetImage (dpy, d, x, y, width, height, plane_mask, format)
     register Display *dpy;
     Drawable d;
     int x, y;
     unsigned int width, height;
     unsigned long plane_mask;
     int format;	/* either XYPixmap or ZPixmap */
{
	DBUG_ENTER("XGetImage")
	char *data;
	XImage *image = NULL;
	DEVOPENSTRUC dop = { 0L, "DISPLAY", NULL, 0L, 0L, 0L, 0L, 0L, 0L };
	BITMAPINFOHEADER2 bmih;
	SIZEL sizl = {0, 0};
	HDC ihdc = DevOpenDC(mainhab, OD_MEMORY, "*", 5L, (PDEVOPENDATA)&dop, NULLHANDLE);
	HPS ihps = GpiCreatePS(mainhab, ihdc, &sizl, PU_PELS | GPIT_MICRO | GPIA_ASSOC ), dhps;
	int dheight = GetDrawableHeight(d, 0, &dhps, GC_FLUSHPATH);
	POINTL aptl[] = { {0, 0}, {width, height}, {x,dheight-y} };
	HBITMAP ihbm;

	if (!dheight || !ihps) DBUG_RETURN(NULL);

	LockDisplay(dpy);

	memset(&bmih, 0, sizeof(BITMAPINFOHEADER2));
	bmih.cbFix = sizeof(BITMAPINFOHEADER2);
	bmih.cx = width; bmih.cy = height;
	bmih.cPlanes = 1; bmih.cBitCount = 24;
	ihbm = GpiCreateBitmap(ihps, &bmih, 0L, NULL, NULL);

	GpiSetBitmap(ihps, ihbm);
	GpiCreateLogColorTable(ihps, 0, LCOLF_RGB, 0, 0, NULL );

	data = malloc((((bmih.cBitCount * bmih.cx)+31)/32) * 4 * bmih.cy);
	if (data) {
		GpiBitBlt(ihps,dhps,3,aptl,ROP_SRCCOPY,BBO_IGNORE);
		GpiQueryBitmapBits(ihps, 0L, height, data, (PBITMAPINFO2)&bmih);

	        if (format == XYPixmap)
		   image = XCreateImage(dpy, _XVIDtoVisual(dpy, 0),
			  Ones (plane_mask &
				(((unsigned long)0xFFFFFFFF) >> (32 - bmih.cBitCount))),
			  format, 0, data, width, height, dpy->bitmap_pad, 0);
		else /* format == ZPixmap */
	           image = XCreateImage (dpy, _XVIDtoVisual(dpy, 0),
			 bmih.cBitCount, ZPixmap, 0, data, width, height,
			  _XGetScanlinePad(dpy, (int) bmih.cBitCount), 0);
	}
	if (!image)
	    Xfree(data);
	if (!ihbm)
		GpiDeleteBitmap(ihbm);
	if (!ihps)
		GpiDestroyPS(ihps);
	if (!ihdc)
		DevCloseDC(ihdc);
	UnlockDisplay(dpy);
	SyncHandle();
	DBUG_RETURN(image);
}

XImage *XGetSubImage(dpy, d, x, y, width, height, plane_mask, format,
		     dest_image, dest_x, dest_y)
     register Display *dpy;
     Drawable d;
     int x, y;
     unsigned int width, height;
     unsigned long plane_mask;
     int format;	/* either XYPixmap or ZPixmap */
     XImage *dest_image;
     int dest_x, dest_y;
{
	DBUG_ENTER("XGetSubImage")
	XImage *temp_image;
	temp_image = XGetImage(dpy, d, x, y, width, height, 
				plane_mask, format);
	if (!temp_image)
	    DBUG_RETURN((XImage *)NULL);
	_XSetImage(temp_image, dest_image, dest_x, dest_y);
	XDestroyImage(temp_image);
	DBUG_RETURN(dest_image);
}	
