#include "Xlib.h"
#include "Xlib_private.h" 

/*

Copyright 1986, 1998  The Open Group

All Rights Reserved.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.

*/



/*
 * Arguments
 * 
 *  display            Specifies the connection to the X server. 
 *  w                  Specifies the window. 
 *  icon_name_return   Returns the window's icon name, which is a null-terminated string. 
 * 
 * 
 * Description
 * 
 * The XGetIconName() function returns the name to be displayed in the specified window's icon. If it succeeds, it returns a
 * nonzero status; otherwise, if no icon name has been set for the window, it returns zero. If you never assigned a name to the
 * window, XGetIconName() sets icon_name_return to NULL. If the data returned by the server is in the Latin Portable Character
 * Encoding, then the returned string is in the Host Portable Character Encoding. Otherwise, the result is implementation
 * dependent. When finished with it, a client must free the icon name string using XFree(). 
 * 
 * XGetIconName() can generate a BadWindow error. 
 * 
 * 
 * Diagnostics
 * 
 *  BadWindow        A value for a Window argument does not name a defined Window. 
 * 
 */


Status XGetIconName (register Display *dpy, Window w, char **icon_name)
{
    Atom actual_type;
    int actual_format;
    unsigned long nitems;
    unsigned long leftover;
    unsigned char *data = NULL;

    DBUG_ENTER("XGetIconName");
    if (XGetWindowProperty(dpy, w, XA_WM_ICON_NAME, 0L, (long)BUFSIZ, False,
        XA_STRING, 
	&actual_type,
	&actual_format, &nitems, &leftover, &data) != Success) {
        *icon_name = NULL;
	DBUG_RETURN(0);
	}
    if ( (actual_type == XA_STRING) &&  (actual_format == 8) ) {

	/* The data returned by XGetWindowProperty is guarranteed to
	contain one extra byte that is null terminated to make retrieveing
	string properties easy. */

	*icon_name = (char*)data;
	DBUG_RETURN(1);
	}
    if (data) Xfree ((char *)data);
    *icon_name = NULL;
    DBUG_RETURN(0);
}
