/* $XConsortium: GetColor.c,v 11.29 94/04/17 20:19:30 rws Exp $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#define NEED_REPLIES
#include <stdio.h>
#include "Xlib_private.h"
#include "Xcmsint.h"

extern void _XcmsRGB_to_XColor();
extern Bool OsLookupColor(int, char *, unsigned, 
	unsigned short *, unsigned short *, unsigned short *);
extern Status _XcmsResolveColorString (XcmsCCC, _Xconst char **, XcmsColor *, XcmsColorFormat);

#if NeedFunctionPrototypes
Status XAllocNamedColor(
register Display *dpy,
Colormap cmap,
_Xconst char *colorname, /* STRING8 */
XColor *hard_def, /* RETURN */
XColor *exact_def) /* RETURN */
#else
Status XAllocNamedColor(dpy, cmap, colorname, hard_def, exact_def)
register Display *dpy;
Colormap cmap;
char *colorname; /* STRING8 */
XColor *hard_def; /* RETURN */
XColor *exact_def; /* RETURN */
#endif
{
    DBUG_ENTER("XAllocNamedColor")
    long n;
    unsigned short red, green, blue;
    XcmsCCC ccc;
    XcmsColor cmsColor_exact;
    Status ret;

    /*
     * Let's Attempt to use Xcms and i18n approach to Parse Color
     */
    /* copy string to allow overwrite by _XcmsResolveColorString() */
    if ((ccc = XcmsCCCOfColormap(dpy, cmap)) != (XcmsCCC)NULL) {
	if (_XcmsResolveColorString(ccc, &colorname, &cmsColor_exact,
		XcmsRGBFormat) >= XcmsSuccess) {
	    _XcmsRGB_to_XColor(&cmsColor_exact, exact_def, 1);
	    memcpy((char *)hard_def, (char *)exact_def, sizeof(XColor));
	    ret = XAllocColor(dpy, cmap, hard_def);
	    exact_def->pixel = hard_def->pixel;
	    DBUG_RETURN(ret);
	}
	/*
	 * Otherwise we failed; or colorname was changed with yet another
	 * name.  Thus pass name to the X Server.
	 */
    }

    /*
     * Xcms and i18n approach failed.
     */
	n = strlen (colorname);
	if (!OsLookupColor(0,(char *)colorname,n,&red,&green,&blue)) {
	    SyncHandle();
	    DBUG_RETURN(0);
	}
	
	exact_def->red   = red;
	exact_def->green = green;
	exact_def->blue  = blue;

	/* NEED TO ADD GAMMA CORRECTION HERE */	
	/*exact_def->pixel = hard_def->pixel = 
		GpiQueryColorIndex(     */

	hard_def->red   = (red &= 0xff00);
	hard_def->green = (green &= 0xff00);
	hard_def->blue  = (blue &= 0xff00);

	exact_def->pixel = hard_def->pixel = 
	((unsigned long)red << 8)|((unsigned long)green)|((unsigned long)blue >> 8);

	/*printf("Color '%s' -> (%d,%d,%d) = #%06x\n",colorname,red >> 8,green >> 8,blue >> 8,exact_def->pixel);*/

	SyncHandle();
	DBUG_RETURN(1);
}
