/* The Everblue Project 1999 */

#include "Xlib_private.h"

Status XGetGeometry(display, d, root_return, x_return, y_return, width_return,
                      height_return, border_width_return, depth_return)
Display *display;
Drawable d;
Window *root_return;
int *x_return, *y_return;
unsigned int *width_return, *height_return;
unsigned int *border_width_return;
unsigned int *depth_return;
{
    GC gc = XCreateGC(display, d, 0, NULL);
    HPS hps = 0;
    DBUG_ENTER("XGetGeometry");

    if(gc)
        hps = (HPS)((Xlib_GC *)gc)->gid;
    else
        DBUG_RETURN(False);

    if((HWND)d == hwndDesktop || ((Xlib_GC *)gc)->pixmap) {
        *x_return = *y_return = *border_width_return = 0;
    } else if(((Xlib_GC *)gc)->winattrib) {
        *border_width_return = ((Xlib_GC *)gc)->winattrib->winattrib.border_width;
        *x_return = ((Xlib_GC *)gc)->cp.x;
        *y_return = ((Xlib_GC *)gc)->cp.y;
    } else {
        return BadDrawable;
    }

    *root_return = (Window)hwndDesktop;
    Xlib_GetDrawableInfo(d, gc, &hps, GC_NOPATH, (long *)width_return, (long *)height_return);
    *depth_return = DefaultScreenOfDisplay(display)->root_depth;
    XFreeGC(display, gc);
    DBUG_RETURN(True);
}