#include "Xlib.h"
#include "Xlib_private.h"

/*

Copyright 1986, 1998  The Open Group

All Rights Reserved.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.

*/


/* Arguments
 * 
 *  names		Specifies the list of font names. 
 *  free_info	Specifies the font information. 
 *  actual_count	Specifies the actual number of font names. 
 * 
 * 
 * Description
 * 
 * The XFreeFontInfo() function frees a font structure or an array of font structures, and optionally an array of font names. If
 * NULL is passed for names, no font names are freed. If a font structure for an open font (returned by XLoadQueryFont()) is
 * passed, the structure is freed but the font is not closed; use XUnloadFont() to close the font. 
 */

int XFreeFontInfo (char **names, XFontStruct *info, int actualCount)
{
	register int i;

	DBUG_ENTER("XFreeFontInfo");
	if (names) {
		Xfree (names[0]-1);
		for (i = 1; i < actualCount; i++) {
			Xfree (names[i]);
		}
		Xfree((char *) names);
	}
	if (info) {
		for (i = 0; i < actualCount; i++) {
			if (info[i].per_char)
				Xfree ((char *) info[i].per_char);
			if (info[i].properties)
				Xfree ((char *) info[i].properties);
			}
		Xfree((char *) info);
	}
	DBUG_RETURN(1);
}

