/* $XConsortium: FontInfo.c /main/16 1996/10/22 14:18:39 kaleb $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#define NEED_REPLIES
#include "Xlib_private.h"

extern struct {
	char *alias, *fontname;
} FontAlias[];

#if NeedFunctionPrototypes
char **XListFontsWithInfo(
register Display *dpy,
_Xconst char *pattern,  /* null-terminated */
int maxNames,
int *actualCount,	/* RETURN */
XFontStruct **info)	/* RETURN */
#else
char **XListFontsWithInfo(dpy, pattern, maxNames, actualCount, info)
register Display *dpy;
char *pattern;  /* null-terminated */
int maxNames;
int *actualCount;	/* RETURN */
XFontStruct **info;	/* RETURN */
#endif
{       
	DBUG_ENTER("XListFontsWithInfo")
	char **names, **name, **next;
	names = name = XListFonts(dpy, pattern, maxNames, actualCount);
	if (names && actualcount && info) {
		int i = 0;
		XFontStruct *pinfo;
		*info = pinfo = malloc(*actualCount * sizeof(XFontStruct));
		next = name+1;
		while (i<*actualCount) {
			XFontStruct *font_struct = XLoadQueryFont(dpy, *name++);
			
		}
	}
	DBUG_RETURN(names);
}


int XFreeFontInfo (names, info, actualCount)
char **names;
XFontStruct *info;
int actualCount;
{
	DBUG_ENTER("XFreeFontInfo")
	register int i;
	if (names) {
		Xfree (names[0]-1);
		for (i = 1; i < actualCount; i++) {
			Xfree (names[i]);
		}
		Xfree((char *) names);
	}
	if (info) {
		for (i = 0; i < actualCount; i++) {
			if (info[i].per_char)
				Xfree ((char *) info[i].per_char);
			if (info[i].properties)
				Xfree ((char *) info[i].properties);
			}
		Xfree((char *) info);
	}
	DBUG_RETURN(1);
}
