/* $XConsortium: FSWrap.c /main/14 1996/09/28 16:33:40 rws $ */

/*
 * Copyright 1991 by the Open Software Foundation
 * Copyright 1993 by the TOSHIBA Corp.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name Open Software Foundation
 * not be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Open Software
 * Foundation makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *
 * OPEN SOFTWARE FOUNDATION DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL OPEN SOFTWARE FOUNDATIONN BE
 * LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 *		 M. Collins		OSF  
 *
 *		 Katsuhisa Yano		TOSHIBA Corp.
 */				

/*

Copyright (c) 1991  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

*/

/* $XFree86: xc/lib/X11/FSWrap.c,v 1.1.1.3.2.2 1998/05/18 14:08:38 dawes Exp $ */

#include "Xlib_private.h"
#include "Xlcint.h"
#include <ctype.h>
#include <X11/Xos.h>


#define	MAXLIST	256

char **
_XParseBaseFontNameList(str, num)
    char           *str;
    int            *num;
{
    DBUG_ENTER("_XParseBaseFontNameList")
    char           *plist[MAXLIST];
    char          **list;
    char           *ptr;

    *num = 0;
    if (!str || !*str) {
	DBUG_RETURN((char **)NULL);
    }
    while (*str && isspace(*str))
	str++;
    if (!*str)
	DBUG_RETURN((char **)NULL);

    if (!(ptr = Xmalloc((unsigned)strlen(str) + 1))) {
	DBUG_RETURN((char **)NULL);
    }
    strcpy(ptr, str);

    while (*num < sizeof(plist) / sizeof(plist[0])) {
	char	*back;

	plist[*num] = ptr;
	if ((ptr = strchr(ptr, ','))) {
	    back = ptr;
	} else {
	    back = plist[*num] + strlen(plist[*num]);
	}
	while (isspace(*(back - 1)))
	    back--;
	*back = '\0';
	(*num)++;
	if (!ptr)
	    break;
	ptr++;
	while (*ptr && isspace(*ptr))
	    ptr++;
	if (!*ptr)
	    break;
    }
    if (!(list = (char **) Xmalloc((unsigned)sizeof(char *) * (*num + 1)))) {
	Xfree(ptr);
	DBUG_RETURN((char **)NULL);
    }
    memcpy((char *)list, (char *)plist, sizeof(char *) * (*num));
    *(list + *num) = NULL;

    DBUG_RETURN(list);
}

static char **
copy_string_list(string_list, list_count)
    char **string_list;
    int list_count;
{
    DBUG_ENTER("copy_string_list")
    char **string_list_ret, **list_src, **list_dst, *dst;
    int length, count;

    if (string_list == NULL)
	DBUG_RETURN((char **) NULL);

    string_list_ret = (char **) Xmalloc(sizeof(char *) * list_count);
    if (string_list_ret == NULL)
	DBUG_RETURN((char **) NULL);

    list_src = string_list;
    count = list_count;
    for (length = 0; count-- > 0; list_src++)
	length += strlen(*list_src) + 1;

    dst = (char *) Xmalloc(length);
    if (dst == NULL) {
	Xfree(string_list_ret);
	DBUG_RETURN((char **) NULL);
    }

    list_src = string_list;
    count = list_count;
    list_dst = string_list_ret;
    for ( ;  count-- > 0; list_src++) {
	strcpy(dst, *list_src);
	*list_dst++ = dst;
	dst += strlen(dst) + 1;
    }

    DBUG_RETURN(string_list_ret);
}

#if NeedFunctionPrototypes
XFontSet
XCreateFontSet (
    Display        *dpy,
    _Xconst char   *base_font_name_list,
    char         ***missing_charset_list,
    int            *missing_charset_count,
    char          **def_string)
#else
XFontSet
XCreateFontSet (dpy, base_font_name_list, missing_charset_list,
	        missing_charset_count, def_string)
    Display        *dpy;
    char           *base_font_name_list;
    char         ***missing_charset_list;
    int            *missing_charset_count;
    char          **def_string;
#endif
{
    DBUG_ENTER("XCreateFontSet")
    XOM om;
    XOC oc;
    XOMCharSetList *list;

    *missing_charset_list = NULL;
    *missing_charset_count = 0;

    om = XOpenOM(dpy, NULL, NULL, NULL);
    if (om == NULL) {
#ifdef DEBUG
	fprintf(stderr,"XCreateFontSet: XOpenOM failed!\n");
#endif
	DBUG_RETURN((XFontSet) NULL);
    }
    if ((oc = XCreateOC(om, XNBaseFontName, base_font_name_list, NULL))) {
	list = &oc->core.missing_list;
	oc->core.om_automatic = True;
    } else {
	list = &om->core.required_charset;
#ifdef DEBUG
	fprintf(stderr,"XCreateFontSet: XCreateOC failed!\n");
#endif
    }
    
    *missing_charset_list = copy_string_list(list->charset_list,
					     list->charset_count);
    *missing_charset_count = list->charset_count;

    if (list->charset_list && *missing_charset_list == NULL) {
#ifdef DEBUG
	fprintf(stderr,"XCreateFontSet: charset list missing!\n");
#endif
	oc = NULL;
    }

    if (oc && def_string) {
	*def_string = oc->core.default_string;
	if (!*def_string)
	    *def_string = "";
    }
    
    if (oc == NULL)
	XCloseOM(om);

    DBUG_RETURN((XFontSet) oc);
}

int
XFontsOfFontSet(font_set, font_struct_list, font_name_list)
    XFontSet        font_set;
    XFontStruct  ***font_struct_list;
    char         ***font_name_list;
{
    DBUG_ENTER("XFontsOfFontSet")
    int result;
    *font_name_list   = font_set->core.font_info.font_name_list;
    *font_struct_list = font_set->core.font_info.font_struct_list;
    result = font_set->core.font_info.num_font;
    DBUG_RETURN(result);
}

char *
XBaseFontNameListOfFontSet(font_set)
    XFontSet        font_set;
{
    DBUG_ENTER("XBaseFontNameListOfFontSet")
    char *result = font_set->core.base_name_list;
    DBUG_RETURN(result);
}

char *
XLocaleOfFontSet(font_set)
    XFontSet        font_set;
{
    DBUG_ENTER("XLocaleOfFontSet")
    char *result = font_set->core.om->core.lcd->core->name;
    DBUG_RETURN(result);
}

extern Bool XContextDependentDrawing(font_set)
    XFontSet        font_set;
{
    DBUG_ENTER("XContextDependentDrawing")
    Bool result = font_set->core.om->core.context_dependent;
    DBUG_RETURN(result);
}

Bool
XDirectionalDependentDrawing(font_set)
    XFontSet        font_set;
{
    DBUG_ENTER("XDirectionalDependentDrawing")
    Bool result = font_set->core.om->core.directional_dependent;
    DBUG_RETURN(result);
}

Bool
XContextualDrawing(font_set)
    XFontSet        font_set;
{
    DBUG_ENTER("XContextualDrawing")
    Bool result = font_set->core.om->core.contextual_drawing;
    DBUG_RETURN(result);
}

XFontSetExtents *
XExtentsOfFontSet(font_set)
    XFontSet        font_set;
{
    DBUG_ENTER("XExtentsOfFontSet")
    XFontSetExtents *result = &font_set->core.font_set_extents;
    DBUG_RETURN(result);
}

void
XFreeFontSet(dpy, font_set)
    Display        *dpy;
    XFontSet        font_set;
{
    DBUG_ENTER("XFreeFontSet")
    XCloseOM(font_set->core.om);
    DBUG_VOID_RETURN;
}
