
#include <alloca.h>
#include "Xlib_private.h"

int XFillPolygon(Display* display, Drawable d, GC gc, XPoint* points, int npoints, int shape, int mode)
{
	DBUG_ENTER("XFillPolygon")
	HPS hps;
	POLYGON poly;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_NOPATH);
	int i;
	if (!viewheight || !points || ((poly.ulPoints = npoints)<2) || 
		!(poly.aPointl = alloca(sizeof(POINTL) * npoints))) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	for (i=0; i<npoints; i++) {
		poly.aPointl[i].x = points[i].x;
                poly.aPointl[i].y = viewheight - points[i].y;
        }
	GpiMove(hps, &poly.aPointl[npoints-1]);
	viewheight = GetDrawableHeight(d, gc, &hps, GC_AREAFILL);
        GpiPolyLine(hps, poly.ulPoints, poly.aPointl);
        XFlushGC(display, gc);
	DBUG_RETURN(True);
}

int XFillArc(Display* display, Drawable d, GC gc, int x, int y,
	     unsigned int width, unsigned int height, int angle1, int angle2)
{
	DBUG_ENTER("XFillArc")
	HPS hps;
	POINTL lPtCenter, lStartPt, lEndPt;
	ARCPARAMS arcparms;
	FIXED fxStartAngle, fxSweepAngle;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int reverse = 0;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_NOPATH);
	if (!viewheight) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	arcparms.lR = arcparms.lS = 0L;
	lPtCenter.x = x + (arcparms.lP = width / 2L);
	lPtCenter.y = viewheight - y - (arcparms.lQ = height / 2L) - 1;
	if (angle2 < 0) {
		angle1 -= (angle2 = -angle2);
		reverse = 1;
	};	
	while (angle1 < 0) angle1 += 23040;
	/*fxStartAngle = MAKEFIXED(angle1 / 64,(angle1 % 64)<<10);
	 *fxSweepAngle = MAKEFIXED(angle2 / 64,(angle2 % 64)<<10);*/
	fxStartAngle = MAKEFIXED(angle1,0)/64;
	fxSweepAngle = MAKEFIXED(angle2,0)/64;
	GpiSetLineType(hps, LINETYPE_INVISIBLE);
	GpiMove(hps, &lPtCenter);
	GpiSetArcParams(hps, (PARCPARAMS)&arcparms);
	GpiPartialArc(hps, &lPtCenter, MAKEFIXED(1,0), fxStartAngle, MAKEFIXED(0,0));
	GpiQueryCurrentPosition(hps, (PPOINTL)&lStartPt);
	GpiSetLineType(hps, LineStyletoLineType[((Xlib_GC *)gc)->values.line_style]);
	viewheight = GetDrawableHeight(d, gc, &hps, GC_AREAFILL);
	GpiPartialArc(hps, &lPtCenter, MAKEFIXED(1,0), fxStartAngle, fxSweepAngle);
	GpiQueryCurrentPosition(hps, (PPOINTL)&lEndPt);
	if (((Xlib_GC *)gc)->values.arc_mode == ArcPieSlice)
		GpiLine(hps, &lPtCenter);
	GpiLine(hps, &lStartPt);
	XFlushGC(display, gc);
	if (reverse)
	GpiMove(hps, (PPOINTL)&lStartPt);
	GpiMove(hps, (PPOINTL)&lEndPt);
	DBUG_RETURN(False);
}

int XFillArcs(Display* display, Drawable d, GC gc, XArc* arcs, int narcs)
{
	DBUG_ENTER("XFillArcs")
	HPS hps;
	POINTL lPtCenter, lStartPt;
	ARCPARAMS arcparms;
	FIXED fxStartAngle, fxSweepAngle;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int reverse = 0;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_NOPATH);
	if (!viewheight || !narcs || !arcs) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	while (narcs--) {
		int angle1 = arcs->angle1, angle2 = arcs->angle2;
		arcparms.lR = arcparms.lS = 0L;
		lPtCenter.x = arcs->x + (arcparms.lP = arcs->width / 2L);
		lPtCenter.y = viewheight - arcs->y - (arcparms.lQ = arcs->height / 2L) - 1;
		if (angle2 < 0) {
			angle1 -= (angle2 = -angle2);
			reverse = 1;
		};	
		while (angle1 < 0) angle1 += 23040;
		/*fxStartAngle = MAKEFIXED(angle1 / 64,(angle1 % 64)<<10);
		 *fxSweepAngle = MAKEFIXED(angle2 / 64,(angle2 % 64)<<10);*/
		fxStartAngle = MAKEFIXED(angle1,0)/64;
		fxSweepAngle = MAKEFIXED(angle2,0)/64;
		GpiSetLineType(hps, LINETYPE_INVISIBLE);
		GpiMove(hps, &lPtCenter);
		GpiSetArcParams(hps, (PARCPARAMS)&arcparms);
		GpiPartialArc(hps, &lPtCenter, MAKEFIXED(1,0), fxStartAngle, MAKEFIXED(0,0));
		GpiQueryCurrentPosition(hps, (PPOINTL)&lStartPt);
		GpiSetLineType(hps, LineStyletoLineType[((Xlib_GC *)gc)->values.line_style]);
		viewheight = GetDrawableHeight(d, gc, &hps, GC_AREAFILL);
		GpiPartialArc(hps, &lPtCenter, MAKEFIXED(1,0), fxStartAngle, fxSweepAngle);
		if (((Xlib_GC *)gc)->values.arc_mode == ArcPieSlice)
			GpiLine(hps, &lPtCenter);
		GpiLine(hps, &lStartPt);
		XFlushGC(display, gc);
		arcs++;
	}
	DBUG_RETURN(True);
}

int XDrawArc(Display* display, Drawable d, GC gc, int x, int y,
	     unsigned int width, unsigned int height, int angle1, int angle2)
{
	DBUG_ENTER("XDrawArc")
	HPS hps;
	POINTL lPtCenter, lStartPt, lEndPt;
	ARCPARAMS arcparms;
	FIXED fxStartAngle, fxSweepAngle;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int reverse = 0;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_STROKEPATH);
	if (!viewheight) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	arcparms.lR = arcparms.lS = 0L;
	lPtCenter.x = x + (arcparms.lP = width / 2L);
	lPtCenter.y = viewheight - y - (arcparms.lQ = height / 2L) - 1;
	if (angle2 < 0) {
		angle1 -= (angle2 = -angle2);
		reverse = 1;
	};	
	while (angle1 < 0) angle1 += 23040;
	/*fxStartAngle = MAKEFIXED(angle1 / 64,(angle1 % 64)<<10);
	 *fxSweepAngle = MAKEFIXED(angle2 / 64,(angle2 % 64)<<10);*/
	fxStartAngle = MAKEFIXED(angle1,0)/64;
	fxSweepAngle = MAKEFIXED(angle2,0)/64;
	GpiSetLineType(hps, LINETYPE_INVISIBLE);
	GpiMove(hps, &lPtCenter);
	GpiSetArcParams(hps, (PARCPARAMS)&arcparms);
	GpiPartialArc(hps, &lPtCenter, MAKEFIXED(1,0), fxStartAngle, MAKEFIXED(0,0));
	GpiQueryCurrentPosition(hps, (PPOINTL)&lStartPt);
	GpiSetLineType(hps, LineStyletoLineType[((Xlib_GC *)gc)->values.line_style]);
	GpiPartialArc(hps, &lPtCenter, MAKEFIXED(1,0), fxStartAngle, fxSweepAngle);
	GpiQueryCurrentPosition(hps, (PPOINTL)&lEndPt);
	if (reverse)
	GpiMove(hps, (PPOINTL)&lStartPt);
	GpiMove(hps, (PPOINTL)&lEndPt);
	DBUG_RETURN(True);
}


int XDrawArcs(Display* display, Drawable d, GC gc, XArc* arcs, int narcs)
{
	DBUG_ENTER("XDrawArcs")
	HPS hps;
	POINTL lPtCenter, lStartPt;
	ARCPARAMS arcparms;
	FIXED fxStartAngle, fxSweepAngle;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int reverse = 0;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_STROKEPATH);
	if (!viewheight || !narcs || !arcs) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	while (narcs--) {
		int angle1 = arcs->angle1, angle2 = arcs->angle2;
		arcparms.lR = arcparms.lS = 0L;
		lPtCenter.x = arcs->x + (arcparms.lP = arcs->width / 2L);
		lPtCenter.y = viewheight - arcs->y - (arcparms.lQ = arcs->height / 2L) - 1;
		if (angle2 < 0) {
			angle1 -= (angle2 = -angle2);
			reverse = 1;
		};	
		while (angle1 < 0) angle1 += 23040;
		/*fxStartAngle = MAKEFIXED(angle1 / 64,(angle1 % 64)<<10);
		 *fxSweepAngle = MAKEFIXED(angle2 / 64,(angle2 % 64)<<10);*/
		fxStartAngle = MAKEFIXED(angle1,0)/64;
		fxSweepAngle = MAKEFIXED(angle2,0)/64;
		GpiSetLineType(hps, LINETYPE_INVISIBLE);
		GpiMove(hps, &lPtCenter);
		GpiSetArcParams(hps, (PARCPARAMS)&arcparms);
		GpiPartialArc(hps, &lPtCenter, MAKEFIXED(1,0), fxStartAngle, MAKEFIXED(0,0));
		GpiQueryCurrentPosition(hps, (PPOINTL)&lStartPt);
		GpiSetLineType(hps, LineStyletoLineType[((Xlib_GC *)gc)->values.line_style]);
		GpiPartialArc(hps, &lPtCenter, MAKEFIXED(1,0), fxStartAngle, fxSweepAngle);
		arcs++;
	}
	DBUG_RETURN(True);		
}
