
#include "Xlib_private.h"
#include <alloca.h>

int XSetLineAttributes(Display* display, GC gc, unsigned int line_width,
	int line_style, int cap_style, int join_style)
{
	DBUG_ENTER("XSetLineAttributes")
	HPS hps;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	if (!xgc) DBUG_RETURN(False);
	xgc->values.join_style = join_style;
	xgc->values.cap_style = cap_style;
	xgc->values.line_style = line_style;
	xgc->values.line_width = line_width;
	if (GetDrawableHeight(0, gc, &hps, GC_NOPATH)) {
		GpiSetLineJoin(hps, JoinStyletoLineJoin[join_style]);
		GpiSetLineEnd(hps, CapStyletoLineEnd[cap_style]);
		GpiSetLineType(hps, LineStyletoLineType[line_style]);
		GpiSetLineWidthGeom(hps, line_width);
	}
	DBUG_RETURN(True);
}

int XSetFunction (dpy, gc, function)
register Display *dpy;
GC gc;
int function;
{
	DBUG_ENTER("XSetFunction")
	HPS hps;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	if (!xgc) DBUG_RETURN(False);
	LockDisplay(dpy);
	if (xgc->values.function != function) {
		xgc->values.function = function;
		if (GetDrawableHeight(0, gc, &hps, GC_NOPATH)) {
			GpiSetMix(hps, GXtoMixMode[function]);
			GpiSetBackMix(hps, GXtoMixMode[function]);
		}
	}
	UnlockDisplay(dpy);
	SyncHandle();
	DBUG_RETURN(1);
}

int XDrawLine(Display* display, Drawable d, GC gc, int x1, int y1, int x2, int y2)
{
	DBUG_ENTER("XDrawLine")
	HPS hps;
	POINTL ptl;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_STROKEPATH);
	if (!viewheight) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	ptl.x = x1; ptl.y = viewheight - y1;
	GpiMove(hps, &ptl);
	ptl.x = x2; ptl.y = viewheight - y2;
	GpiLine(hps, &ptl);
	DBUG_RETURN(True);
}

int XDrawLines(Display* display, Drawable d, GC gc, XPoint* points, int npoints, int mode)
{
	DBUG_ENTER("XDrawLines")
	HPS hps;
	POINTL *pptl;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int i = 1;
	int viewheight;
	if (!npoints || !points || !(pptl = alloca(sizeof(POINTL) * npoints)) ||
	    !(viewheight = GetDrawableHeight(d, gc, &hps, GC_STROKEPATH))) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	for (i = 0; i<npoints; i++) {
		pptl[i].x = points[i].x;
		pptl[i].y = viewheight - points[i].y;
	}
	GpiMove(hps, pptl);
	GpiPolyLine(hps, npoints, pptl);
	DBUG_RETURN(True);
}

int XDrawSegments(Display* display, Drawable d, GC gc, XSegment* segments, int nsegments)
{
	DBUG_ENTER("XDrawSegments")
	HPS hps;
	POINTL ptl;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int i = 0;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_STROKEPATH);
	if (!viewheight || !nsegments || !segments) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	while (i < nsegments) {
		ptl.x = segments->x1; ptl.y = viewheight - segments->y1;
		GpiMove(hps, &ptl);
		ptl.x = segments->x2; ptl.y = viewheight - segments->y2;
		GpiLine(hps, &ptl);
		i++; segments++;
	}
	DBUG_RETURN(True);
}

int XDrawRectangle(Display* display, Drawable d, GC gc, int x, int y, 
		unsigned int width, unsigned int height)
{
	DBUG_ENTER("XDrawRectangle")
	HPS hps;
	POINTL ptl;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_STROKEPATH);
	if (!viewheight) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	ptl.x = x; 
	ptl.y = viewheight - y;
	GpiMove(hps, &ptl);
	ptl.x += width; 
	ptl.y -= height;
	GpiBox(hps, DRO_OUTLINE, &ptl, 0, 0);
	DBUG_RETURN(True);
}

int XDrawRectangles(Display* display, Drawable d, GC gc, XRectangle* rectangles, int nrectangles)
{
	DBUG_ENTER("XDrawRectangles")
	HPS hps;
	POINTL ptl;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int i = 0;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_STROKEPATH);
	if (!viewheight || !nrectangles || !rectangles) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	while (i < nrectangles) {
		ptl.x = rectangles->x; 
		ptl.y = viewheight - rectangles->y;
		GpiMove(hps, &ptl);
		ptl.x += rectangles->width; 
		ptl.y -= rectangles->height;
		GpiBox(hps, DRO_OUTLINE, &ptl, 0, 0);
		i++; rectangles++;
	}
	DBUG_RETURN(True);
}

int XDrawPoint(Display* display, Drawable d, GC gc, int x, int y)
{
	DBUG_ENTER("XDrawPoint")
	HPS hps;
	POINTL ptl;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_NOPATH);
	if (!viewheight) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	ptl.x = x; ptl.y = viewheight - y;
	GpiSetPel(hps, &ptl);
	DBUG_RETURN(True);
}

int XDrawPoints(Display* display, Drawable d, GC gc, XPoint* points, int npoints, int mode)
{
	DBUG_ENTER("XDrawPoints")
	HPS hps;
	POINTL ptl;
	Xlib_GC *xgc = (Xlib_GC *)gc;
	int i = 0;
	int viewheight = GetDrawableHeight(d, gc, &hps, GC_NOPATH);
	if (!viewheight || !npoints || !points) DBUG_RETURN(False);
	Xlib_SetGC(hps, xgc);
	while (i < npoints) {
		ptl.x = points->x; 
		ptl.y = viewheight - points->y;
		GpiSetPel(hps, &ptl);
		i++; points++;
	}
	DBUG_RETURN(True);
}
