
#include "Xlib_private.h"

Colormap Xlib_CreateDefaultColormap(Display *dpy);

Window XCreateWindow(
    Display*            display,
    Window              parent,
    int                 x,
    int                 y,
    unsigned int        width,
    unsigned int        height,
    unsigned int        border_width,
    int                 depth,
    unsigned int        class,
    Visual*             visual,
    unsigned long       valuemask,
    XSetWindowAttributes*       attributes
)
{
        DBUG_ENTER("XCreateWindow")
		XID newwind;
		XWindowAttributes *parentattrib = GetWinAttrib(parent, NULL);
		WinAttribData *winattribdata = calloc(1,sizeof(WinAttribData));
		Xlib_CreateWindow CreateParams = { (HWND)parent, 0, "Xlib/PM",
		x, y, width, height, winattribdata,
		FCF_MINMAX | FCF_SYSMENU | FCF_TITLEBAR | FCF_TASKLIST
		};

        if (!display) DBUG_RETURN(False);
		winattribdata->cb = sizeof(WinAttribData);
		winattribdata->winattrib.x = x;
        winattribdata->winattrib.y = y;
        winattribdata->winattrib.width = width;
        winattribdata->winattrib.height = height;
        CreateParams.x = CreateParams.y =
        winattribdata->winattrib.border_width = WinQuerySysValue(hwndDesktop, SV_CXSIZEBORDER);
        winattribdata->winattrib.screen = DefaultScreenOfDisplay(display);
        winattribdata->winattrib.win_gravity = NorthWestGravity;
        winattribdata->winattrib.backing_store = NotUseful;
        winattribdata->background_pixmap = None;
		winattribdata->background_pixel = 0xffffff;

		if (attributes && valuemask)
		{
			if ((valuemask & CWColormap) != 0)
				winattribdata->winattrib.colormap = attributes->colormap;
			else
				winattribdata->winattrib.colormap = Xlib_CreateDefaultColormap(display);

			if ((valuemask & CWOverrideRedirect) != 0)
				winattribdata->winattrib.override_redirect = attributes->override_redirect;
			if ((valuemask & CWSaveUnder) != 0)
				winattribdata->winattrib.save_under = attributes->save_under;
			if ((valuemask & CWEventMask) != 0)
				winattribdata->winattrib.your_event_mask = attributes->event_mask;
			if ((valuemask & CWDontPropagate) != 0)
				winattribdata->winattrib.do_not_propagate_mask = attributes->do_not_propagate_mask;
			if ((valuemask & CWBackPixel) != 0 )
				winattribdata->background_pixel = attributes->background_pixel;
			if ((valuemask & CWBackPixmap) != 0 )
			{
				winattribdata->background_pixmap = attributes->background_pixmap;
				Xlib_MonitorResource((XID *)&winattribdata->background_pixmap);
			}
			if ((valuemask & CWWinGravity) != 0 )
				winattribdata->winattrib.win_gravity = attributes->win_gravity;
			if ((valuemask & CWCursor) != 0)
				winattribdata->cursor = attributes->cursor;
		}

		if (parentattrib)
		{
			if (parentattrib->your_event_mask & SubstructureNotifyMask)
				winattribdata->winattrib.your_event_mask |= StructureNotifyMask;
		}

		if (winattribdata->winattrib.save_under) CreateParams.flStyle |= WS_SAVEBITS;
		if (!border_width || winattribdata->background_pixmap == ParentRelative)
			winattribdata->winattrib.border_width = 0;
		else
			CreateParams.frameStyle |= FCF_SIZEBORDER;

		(ULONG) newwind =
			WinSendMsg(mainhwnd, UM_CreateWindow, (MPARAM)&CreateParams,
                (MPARAM)(parent==hwndDesktop?1:0));

		if (newwind)
		{
                SIZEL sizl = {0,0};
				winattribdata->hps = GpiCreatePS(mainhab, winattribdata->hdc, &sizl,
												 PU_PELS | GPIT_MICRO | GPIA_ASSOC );
				GpiCreateLogColorTable(winattribdata->hps, 0, LCOLF_RGB, 0, 0, NULL );
				XMoveResizeWindow(display, newwind, x, y, width, height);
                if (parent == hwndDesktop && (valuemask & CWBorderPixel) != 0 ) {
					RGB2 rgb2 = { attributes->border_pixel & 0xff,
					(attributes->border_pixel >> 8) & 0xff,
					(attributes->border_pixel >> 16) & 0xff, 0 };
					WinSetPresParam(WinQueryWindow(newwind, QW_PARENT),
									PP_BORDERCOLOR,sizeof(rgb2),&rgb2);
				}
		}

        /*if (winattribdata->background_pixmap == ParentRelative)
                printf("ParentRelative window %x (parent %x)\n", newwind, parent);

        printf("Window created (parent %x), handle %x\n", parent, newwind);*/
		DBUG_RETURN(newwind);
}

Window XCreateSimpleWindow(
    Display*            display,
    Window              parent,
    int                 x,
    int                 y,
    unsigned int        width,
    unsigned int        height,
    unsigned int        border_width,
    unsigned long       border,
    unsigned long       background
)
{
   DBUG_ENTER("XCreateSimpleWindow")
        XID newwind;
        XWindowAttributes *parentattrib = GetWinAttrib(parent, NULL);
        WinAttribData *winattribdata = calloc(1,sizeof(WinAttribData));
        Xlib_CreateWindow CreateParams = { (HWND)parent, 0, "Xlib/PM",
                x, y, width, height, winattribdata,
                FCF_MINMAX | FCF_SYSMENU | FCF_TITLEBAR | FCF_TASKLIST
        };

        if (!display) DBUG_RETURN(False);
        winattribdata->cb = sizeof(WinAttribData);
        winattribdata->winattrib.x = x;
        winattribdata->winattrib.y = y;
        winattribdata->winattrib.width = width;
        winattribdata->winattrib.height = height;
        CreateParams.x = CreateParams.y =
        winattribdata->winattrib.border_width = WinQuerySysValue(hwndDesktop, SV_CXSIZEBORDER);
        winattribdata->winattrib.screen = DefaultScreenOfDisplay(display);
        winattribdata->winattrib.win_gravity = NorthWestGravity;
        winattribdata->winattrib.backing_store = NotUseful;
        winattribdata->background_pixmap = None;
        winattribdata->background_pixel = background;

        if (parentattrib) {
                if (parentattrib->your_event_mask & SubstructureNotifyMask)
                        winattribdata->winattrib.your_event_mask |= StructureNotifyMask;
        }

        if (!border_width || winattribdata->background_pixmap == ParentRelative)
                winattribdata->winattrib.border_width = 0;
        else
                CreateParams.frameStyle |= FCF_SIZEBORDER;

        (ULONG) newwind =
        WinSendMsg(mainhwnd, UM_CreateWindow, (MPARAM)&CreateParams,
                (MPARAM)(parent==hwndDesktop?1:0));

        if (newwind) {
                SIZEL sizl = {0,0};
                RGB2 rgb2 = { border & 0xff,
                              (border >> 8) & 0xff,
                              (border >> 16) & 0xff, 0 };
                winattribdata->hps = GpiCreatePS(mainhab, winattribdata->hdc, &sizl,
                                PU_PELS | GPIT_MICRO | GPIA_ASSOC );
                GpiCreateLogColorTable(winattribdata->hps, 0, LCOLF_RGB, 0, 0, NULL );
                XMoveResizeWindow(display, newwind, x, y, width, height);
                WinSetPresParam(WinQueryWindow(newwind, QW_PARENT),
                        PP_BORDERCOLOR,sizeof(rgb2),&rgb2);
        }

        /*if (winattribdata->background_pixmap == ParentRelative)
                printf("ParentRelative window %x (parent %x)\n", newwind, parent);

        printf("Window created (parent %x), handle %x\n", parent, newwind);*/
        DBUG_RETURN(newwind);
}

void _XPurgeGC(Display* display, GC gc);

int XDestroyWindow(Display *display, Window window)
{
        DBUG_ENTER("XDestroyWindow")
        WinAttribData *winattrib = WinQueryWindowPtr(window,QWP_WINATTRIB);
        HWND winframe = WinQueryWindowULong(window, QWP_FRAMEHWND);
        if (winattrib && winframe) {
                Xlib_GC *xgc = (Xlib_GC *)winattrib->currentGC;
                _XPurgeGC(display, winattrib->currentGC);
                if (xgc->winattrib == winattrib) {
                        xgc->winattrib = NULL;
                        (HPS)xgc->gid = WinGetScreenPS(hwndDesktop);
                }
                winattrib->currentGC = (GC)0L;
                Xlib_FreeAllAtoms((Xlib_Pixmap *)winattrib);
                Xlib_UnmonitorResource((XID *)&winattrib->background_pixmap);
                WinSendMsg(mainhwnd, UM_DestroyWindow, (MPARAM)winframe, 0);
        }
        DBUG_RETURN(True);
}

