
#include "Xlib_private.h"

int Xlib_SetFont(Pixmap, Font);
int Xlib_SetStipple(Pixmap, Pixmap);

GC XCreateGC(Display* display, Drawable d, unsigned long valuemask, XGCValues* values)
{
        DBUG_ENTER("XCreateGC")
        WinAttribData *attrib = WinQueryWindowPtr(d, QWP_WINATTRIB);
        Xlib_GC *xgc;
        Pixmap atom_pixmap = None;
        int i;

        if (!(xgc = calloc(1,sizeof(Xlib_GC))))
                DBUG_RETURN((GC)0L);

        if (attrib) {
                (HPS)xgc->gid = attrib->hps;
                xgc->winattrib = attrib;
                atom_pixmap = (Pixmap)attrib;
        } else
        if ((HWND)d == hwndDesktop)
            (HPS)xgc->gid = WinGetScreenPS(hwndDesktop);
        else
        if (d) {
                xgc->pixmap = (Xlib_Pixmap *)d;
                (HPS)xgc->gid = xgc->pixmap->hps;
                atom_pixmap = (Pixmap)d;
        } else {
                free(xgc);
                DBUG_RETURN((GC)0L);
        }

        xgc->values.function = GXcopy;
        xgc->values.plane_mask = (unsigned long)0xffffffffL;
        xgc->values.foreground = 0;
        xgc->values.background = 0x00FFFFFF;
        xgc->values.line_width = 1;
        xgc->values.line_style = LineSolid;
        xgc->values.cap_style = CapButt;
        xgc->values.join_style = JoinMiter;
        xgc->values.fill_style = FillSolid;
        xgc->values.fill_rule = EvenOddRule;
        xgc->values.arc_mode = ArcPieSlice;
        xgc->values.subwindow_mode = ClipByChildren;
        xgc->values.graphics_exposures = TRUE;

        /*GpiSetPattern(hps, PATSYM_SOLID);*/

        if (values && valuemask) {
                if (valuemask & GCFunction) xgc->values.function = values->function;
                if (valuemask & GCForeground) xgc->values.foreground = values->foreground;
                if (valuemask & GCBackground) xgc->values.background = values->background;
                if (valuemask & GCLineWidth) xgc->values.line_width = values->line_width;
                if (valuemask & GCLineStyle) xgc->values.line_style = values->line_style;
                if (valuemask & GCCapStyle)  xgc->values.cap_style  = values->cap_style;
                if (valuemask & GCJoinStyle) xgc->values.join_style = values->join_style;
                if (valuemask & GCFillStyle) xgc->values.fill_style = values->fill_style;
                if (valuemask & GCFillRule)  xgc->values.fill_rule  = values->fill_rule;
                if (valuemask & GCFont)      xgc->values.font       = values->font;
                if (valuemask & GCArcMode)   xgc->values.arc_mode   = values->arc_mode;
                if (valuemask & GCStipple)   xgc->values.stipple    = values->stipple;
        }

        if (xgc->values.font) {
                Xlib_MonitorResource((XID *)&xgc->values.font);
                if (atom_pixmap) Xlib_SetFont(atom_pixmap, xgc->values.font);
        }
        if (xgc->values.stipple) {
                Xlib_MonitorResource((XID *)&xgc->values.stipple);
                if (atom_pixmap) Xlib_SetStipple(atom_pixmap, xgc->values.stipple);
        }

        for (i=0; (i<1024) && GCList[i]; i++);
        GCList[i] = (GC) xgc;

        DBUG_RETURN((GC) xgc);
}


int XFlush(Display* display)
{
        DBUG_ENTER("XFlush")
        int i;
        for (i=0; i<1024; i++) XFlushGC(display, GCList[i]);
        DBUG_RETURN(True);
}

void _XPurgeGC(Display* display, GC gc)
{
        DBUG_ENTER("_XPurgeGC")
        Xlib_GC *xgc = (Xlib_GC *)gc;
        if (xgc && xgc->path != GC_NOPATH) {
                GpiEndPath((HPS)xgc->gid);
                xgc->path = GC_NOPATH;
        }
        DBUG_VOID_RETURN;
}

void XFlushGC(Display* display, GC gc)
{
        DBUG_ENTER("XFlushGC")
        Xlib_GC *xgc = (Xlib_GC *)gc;
        if (!xgc) DBUG_VOID_RETURN;
        switch (xgc->path) {
        case GC_FILLPATH:
                GpiEndPath((HPS)xgc->gid);
                GpiFillPath((HPS)xgc->gid, 1L, xgc->values.fill_rule == WindingRule ?
                        FPATH_WINDING : FPATH_ALTERNATE );
                break;
        case GC_STROKEPATH:
                GpiEndPath((HPS)xgc->gid);
                GpiStrokePath((HPS)xgc->gid, 1L, 0);
                break;
        case GC_AREAFILL:
                GpiEndArea((HPS)xgc->gid);
                break;
        }
        xgc->path = GC_NOPATH;
        DBUG_VOID_RETURN;
}

int XFreeGC(Display* dpy, GC gc)
{
        DBUG_ENTER("XFreeGC")
        Xlib_GC *xgc = (Xlib_GC *)gc;
        _XExtension *ext;
        int i;
        if (!gc) DBUG_RETURN(False);
        LockDisplay(dpy);
        /* call out to any extensions interested */
        for (ext = dpy->ext_procs; ext; ext = ext->next)
                if (ext->free_GC) (*ext->free_GC)(dpy, gc, &ext->codes);
        XFlushGC(dpy, gc);
        for (i=0; (i<1024) && GCList[i] != gc; i++);
        GCList[i] = (GC)0L;
        if (xgc->winattrib && xgc->winattrib->currentGC==gc)
                xgc->winattrib->currentGC = (GC)0L;
        if (xgc->pixmap && xgc->pixmap->currentGC==gc)
                xgc->pixmap->currentGC = (GC)0L;
        UnlockDisplay(dpy);
        SyncHandle();
        _XFreeExtData(gc->ext_data);
        Xlib_UnmonitorResource((XID *)&xgc->values.font);
        Xlib_UnmonitorResource((XID *)&xgc->values.stipple);
        Xfree((char *) gc);
        DBUG_RETURN(1);
}

int XSetForeground(Display* display, GC gc, unsigned long foreground)
{
        DBUG_ENTER("XSetForeground")
        HPS hps;
        Xlib_GC *xgc = (Xlib_GC *)gc;
        if (!xgc) DBUG_RETURN(False);
        xgc->values.foreground = foreground;
        if (!GetDrawableHeight(0, gc, &hps, GC_NOPATH)) return FALSE;
        GpiSetColor(hps, foreground);
        DBUG_RETURN(True);
}

int XSetBackground(Display* display, GC gc, unsigned long background)
{
        DBUG_ENTER("XSetBackground")
        HPS hps;
        Xlib_GC *xgc = (Xlib_GC *)gc;
        if (!xgc) DBUG_RETURN(False);
        xgc->values.background = background;
        if (!GetDrawableHeight(0, gc, &hps, GC_NOPATH)) return FALSE;
        GpiSetBackColor(hps, background);
        DBUG_RETURN(True);
}

int XClearWindow(Display* display, Window w)
{
        DBUG_ENTER("XClearWindow")
        WinAttribData *attrib = WinQueryWindowPtr(w, QWP_WINATTRIB);
        RECTL rectl;
        if (attrib) {
                if (attrib->currentGC) _XPurgeGC(display, attrib->currentGC);
                rectl.xLeft = 0; rectl.yBottom = 0;
                rectl.xRight = attrib->winattrib.width;
                rectl.yTop = attrib->winattrib.height;
                WinFillRect(attrib->hps, &rectl, attrib->background_pixel);
                DBUG_RETURN(True);
        }
        DBUG_RETURN(False);
}

int XClearArea(Display* display, Window w, int x, int y,
                unsigned int width, unsigned int height, Bool exposures)
{
        DBUG_ENTER("XClearArea")
        WinAttribData *attrib = WinQueryWindowPtr(w, QWP_WINATTRIB);
        RECTL rectl;
        if (attrib) {
                if (attrib->currentGC) XFlushGC(display, attrib->currentGC);
                if (!width) width = attrib->winattrib.width - x;
                if (!height) height = attrib->winattrib.height - y;
                rectl.xLeft = x;
                rectl.xRight = x + width;
                rectl.yTop = attrib->winattrib.height - y;
                rectl.yBottom = rectl.yTop - height;
                WinFillRect(attrib->hps, &rectl, attrib->background_pixel);
                DBUG_RETURN(True);
        }
        DBUG_RETURN(False);
}

int XFillRectangle(Display* display, Drawable d, GC gc, int x, int y,
                unsigned int width, unsigned int height)
{
        DBUG_ENTER("XFillRectangle")
        HPS hps;
        POINTL ptl;
        Xlib_GC *xgc = (Xlib_GC *)gc;
        int rc;
        int viewheight = GetDrawableHeight(d, gc, &hps, GC_NOPATH);
        if (!viewheight) DBUG_RETURN(False);
        Xlib_SetGC(hps, xgc);
        ptl.x = x; ptl.y = viewheight - y;
        rc = GpiMove(hps, &ptl);
        ptl.x += width; ptl.y -= height;
        rc |= GpiBox(hps, DRO_FILL, &ptl, 0, 0);
        if(rc == GPI_OK)
                DBUG_RETURN(True);
        DBUG_RETURN(False);
}

int XFillRectangles(Display* display, Drawable d, GC gc, XRectangle* rectangles, int nrectangles)
{
        DBUG_ENTER("XFillRectangles")
        HPS hps;
        POINTL ptl;
        Xlib_GC *xgc = (Xlib_GC *)gc;
        int rc = 0;
        int i = 0, viewheight = GetDrawableHeight(d, gc, &hps, GC_NOPATH);
        if (!viewheight || !nrectangles || !rectangles) DBUG_RETURN(False);
        Xlib_SetGC(hps, xgc);
/*      GpiCreateLogColorTable(hps, LCOL_RESET, LCOLF_RGB, 0, 0, NULL); */
        while (i < nrectangles) {
                ptl.x = rectangles->x; ptl.y = viewheight - rectangles->y;
                rc |= GpiMove(hps, &ptl);
                ptl.x += rectangles->width; ptl.y -= rectangles->height;
                rc |= GpiBox(hps, DRO_FILL, &ptl, 0, 0);
                i++; rectangles++;
        }
        if(rc == GPI_OK)
                DBUG_RETURN(True);
        DBUG_RETURN(False);
}


