/* $XConsortium: CrPixmap.c,v 11.8 94/04/17 20:19:01 rws Exp $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#include "Xlib_private.h"

void Xlib_InitPixmap(HPS hps, int width, int height, int depth)
{
	DBUG_ENTER("Xlib_InitPixmap")
	struct {
		BITMAPINFO2 bmi;
		RGB2 palette[256];
	} inf;
	
	memset(&inf, 0, sizeof(inf));	
	inf.bmi.cbFix = sizeof(BITMAPINFO2);
	inf.bmi.cx = width; inf.bmi.cy = height;
	inf.bmi.cPlanes = 1; inf.bmi.cBitCount = depth;
	inf.bmi.cbImage = ((width * depth + 7)>>3)*height;
	inf.bmi.ulColorEncoding = BCE_RGB;
	inf.bmi.argbColor[0].bBlue = 0xff;
	inf.bmi.argbColor[0].bGreen = 0xff;
	inf.bmi.argbColor[0].bRed = 0xff;
	if (depth <= 8)
		inf.bmi.cclrUsed = inf.bmi.cclrImportant = 1<<depth;
	else
		inf.bmi.ulColorEncoding = 0;
	GpiSetBitmapBits(hps, 0, 0, NULL, &inf.bmi);
	DBUG_VOID_RETURN;
}

Pixmap XCreatePixmap (dpy, d, width, height, depth)
    Display *dpy;
    Drawable d;
    unsigned int width, height, depth;
{
    DBUG_ENTER("XCreatePixmap")
    DEVOPENSTRUC dop = { 0L, "DISPLAY", NULL, 0L, 0L, 0L, 0L, 0L, 0L };
    BITMAPINFOHEADER2 bmih;
    SIZEL sizl = {0, 0};
    Xlib_Pixmap *pixmap;

    if (!(pixmap = calloc(1,sizeof(Xlib_Pixmap)))) DBUG_RETURN((Pixmap)0);
    if (!depth) depth = 24;

    pixmap->width = width; pixmap->height = height;
    pixmap->hdc = DevOpenDC(mainhab, OD_MEMORY, "*", 5L, (PDEVOPENDATA)&dop, NULLHANDLE);

    pixmap->hps = GpiCreatePS(mainhab, pixmap->hdc, &sizl, PU_PELS | GPIT_MICRO | GPIA_ASSOC );

    memset(&bmih, 0, sizeof(BITMAPINFOHEADER2));
    bmih.cbFix = sizeof(BITMAPINFOHEADER2);
    bmih.cx = width; bmih.cy = height;
    bmih.cPlanes = bmih.cBitCount = depth;
    bmih.cbImage = (width * height * depth + 7)>>3;
    
    pixmap->hbm = GpiCreateBitmap(pixmap->hps, &bmih, 0L, NULL, NULL);

    pixmap->colormap = None;

    GpiSetBitmap(pixmap->hps, pixmap->hbm);

    if (depth>8)
	GpiCreateLogColorTable(pixmap->hps, LCOL_PURECOLOR, LCOLF_RGB, 0, 0, NULL );

    Xlib_InitPixmap(pixmap->hps, width, height, depth);

#ifdef DEBUG_VERBOSE
    fprintf(stderr,"XCreatePixmap: width=%d, height=%d, depth=%d, pixmap=%p,\n",width,height,depth,pixmap);
#endif

    DBUG_RETURN((Pixmap)pixmap);
}

void _XPurgeGC(Display* display, GC gc);

int XFreePixmap(Display* display, Pixmap _pixmap)
{
	DBUG_ENTER("XFreePixmap")
	Xlib_Pixmap *pixmap = (Xlib_Pixmap *)_pixmap;
	Xlib_GC *xgc;
	int i;
	if (!pixmap) DBUG_RETURN(False);
	_XPurgeGC(display, pixmap->currentGC);
	if (pixmap->currentGC  && (xgc=(Xlib_GC *)pixmap->currentGC)->pixmap == pixmap) {
		xgc->pixmap = (Pixmap)0L;
		(HPS)xgc->gid = WinGetScreenPS(hwndDesktop);
	}
	pixmap->currentGC = (GC)0L;
	Xlib_FreePixmapAtom(pixmap);
	Xlib_FreeAllAtoms(pixmap);
	Xlib_InvalidateResource((XID)_pixmap);
	/* We must disassociate the bitmap from the presentation space
	 * before deleting it.
	 */
	GpiSetBitmap(pixmap->hps, NULLHANDLE);
	GpiDeleteBitmap(pixmap->hbm);
	GpiDestroyPS(pixmap->hps);
	DevCloseDC(pixmap->hdc);
	free(pixmap);
	DBUG_RETURN(True);
}
