/* $XConsortium: CopyArea.c /main/5 1996/10/22 14:16:57 kaleb $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#include "Xlib_private.h"

extern USHORT GXtoROPMode[16];

XCopyArea(dpy, src_drawable, dst_drawable, gc,
	  src_x, src_y, width, height,
	  dst_x, dst_y)
     register Display *dpy;
     Drawable src_drawable, dst_drawable;
     GC gc;
     int src_x, src_y;
     unsigned int width, height;
     int dst_x, dst_y;

{
	DBUG_ENTER("XCopyArea")
	HPS src_hps, dst_hps;
	int src_viewheight = GetDrawableHeight(src_drawable, gc, &src_hps, GC_NOPATH);
	int dst_viewheight = GetDrawableHeight(dst_drawable, gc, &dst_hps, GC_NOPATH);
	Xlib_GC *xgc = (Xlib_GC *)gc;
    int rc;
	POINTL aptl[3] = {
		dst_x, dst_viewheight - dst_y - height,
		dst_x + width, dst_viewheight - dst_y,
		src_x, src_viewheight - src_y - height
	};

	if (!src_viewheight || !dst_viewheight || !gc) DBUG_RETURN(False);
	
	LockDisplay(dpy);

	rc = GpiBitBlt(dst_hps, src_hps, 3, aptl, GXtoROPMode[xgc->values.function], 0);

	UnlockDisplay(dpy);
	SyncHandle();

	if(rc != GPI_OK)
		DBUG_RETURN(False);
	DBUG_RETURN(True);
}

