
/* $XConsortium: StNColor.c /main/20 1996/10/22 14:23:13 kaleb $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#include <stdio.h>
#include "Xlib_private.h"
#include "Xcmsint.h"

extern void _XcmsCopyCmapRecAndFree();
extern void _XcmsDeleteCmapRec();
extern void _XcmsAddCmapRec();
extern void _XcmsRGB_to_XColor();
extern Status _XcmsResolveColorString (XcmsCCC ccc, _Xconst char **color_string, XcmsColor *pColor_exact_return, XcmsColorFormat result_format);


#define COLORMAP_RGB 0
#define COLORMAP_PAL 1

typedef struct {
	HPS	prevhps;
	LONG	maptype;
	LONG	count;
	HPAL    hpal, oldpal;
	USHORT *allocbmp;
	ULONG  *Colors;
} Xlib_Colormap;

void Xlib_SetColormap(HPS hps, Xlib_Colormap *cmap)
{
	DBUG_ENTER("Xlib_SetColormap")
		cmap->prevhps = hps;
	if(cmap->count && !cmap->oldpal)
		cmap->oldpal = GpiSelectPalette(hps, cmap->hpal);
	else if(cmap->count && cmap->oldpal)
		GpiSelectPalette(hps, cmap->hpal);
	else if (!cmap->count && cmap->oldpal)
		GpiSelectPalette(hps, cmap->oldpal);
	DBUG_VOID_RETURN;
}

void Xlib_ApplyColormap(Drawable d, Colormap colormap)
{
	DBUG_ENTER("Xlib_ApplyColormap")
		HPS hps;
	ULONG pc;

	if (GetDrawableHeight(d, 0, &hps, GC_NOPATH))
	{
		Xlib_SetColormap(hps, (Xlib_Colormap *)colormap);
		if(WinIsWindow(mainhab, d))
			WinRealizePalette(d, hps, &pc);
	}

	DBUG_VOID_RETURN;
}

Colormap Xlib_DupColormap(Display *dpy, Colormap colormap)
{
	DBUG_ENTER("Xlib_DupColormap")
	Xlib_Colormap *result = malloc(sizeof(Xlib_Colormap));
	memcpy(result,(void *)colormap,sizeof(Xlib_Colormap));
	result->Colors = malloc(sizeof(ULONG)*result->count);
	memcpy(result->Colors, ((Xlib_Colormap *)colormap)->Colors, sizeof(ULONG)*result->count);
	result->oldpal = result->prevhps = NULLHANDLE;
	DBUG_RETURN((Colormap)result);
}

Colormap Xlib_CreateDefaultColormap(Display *dpy)
{
	DBUG_ENTER("Xlib_CreateDefaultColormap")
		Xlib_Colormap *result = malloc(sizeof(Xlib_Colormap));
	HPS hps = WinGetScreenPS(hwndDesktop);
	ULONG *array = NULL;
	int t;

	result->hpal = GpiQueryPalette(hps);
	if(!result->hpal || (result->count = GpiQueryPaletteInfo(result->hpal, NULLHANDLE, 0L, 0L, 0L, array)) < 1)
	{
		/* If we don't have a palette get the logical color table and create a palette with it */
		ULONG aul[16];
		result->count = GpiQueryLogColorTable(hps, 0L, 0L, 16L, aul);
		result->Colors = malloc(sizeof(ULONG)*result->count);
		memcpy(result->Colors, aul, sizeof(LONG)*result->count);
		result->hpal = GpiCreatePalette(mainhab, LCOL_PURECOLOR, LCOLF_CONSECRGB,result->count, result->Colors);
	}
	else
	{
		result->Colors = malloc(sizeof(ULONG)*result->count);
		memcpy(result->Colors, array, sizeof(ULONG)*result->count);
	}
	result->allocbmp = malloc(result->count*sizeof(USHORT));
	for(t=0;t<result->count;t++)
		result->allocbmp[t] = 1;
	WinReleasePS(hps);
	DBUG_RETURN((Colormap)result);
}

Colormap Xlib_CreateColormap(Display* dpy, Window w, Visual* visual, int alloc)
{
	DBUG_ENTER("Xlib_CreateColormap")
		Xlib_Colormap *result;
	result = calloc(1, sizeof(Xlib_Colormap));
	if (!alloc || !visual->map_entries) {
		result->maptype = (!visual->map_entries)?0:1;
		result->count = 0;
		result->Colors = NULL;
		result->allocbmp = NULL;
	} else if (alloc == AllocAll){
		result->Colors = calloc(1, sizeof(ULONG)*visual->map_entries);
		result->allocbmp = calloc(1, sizeof(USHORT)*visual->map_entries);
		result->count = visual->map_entries;
		result->maptype = 1;
	} else {
		result->Colors = calloc(1, sizeof(ULONG)*alloc);
		result->allocbmp = calloc(1, sizeof(USHORT)*alloc);
		result->count = alloc;
		result->maptype = 1;
	}
	result->hpal = result->oldpal = result->prevhps = 0;;
	if(result->count > 0)
		result->hpal = GpiCreatePalette(mainhab, LCOL_PURECOLOR, LCOLF_CONSECRGB,result->count, result->Colors);
	DBUG_RETURN((Colormap)result);
}

void Xlib_FreeColormap(Xlib_Colormap *colormap)
{
	DBUG_ENTER("Xlib_FreeColormap")
		if(colormap->hpal)
			GpiDeletePalette(colormap->hpal);
	if(colormap->Colors)
		free(colormap->Colors);
	free(colormap);
	DBUG_VOID_RETURN;
}

Colormap XCopyColormapAndFree(Display* dpy, Colormap colormap)
{
	DBUG_ENTER("XCopyColormapAndFree")
		Colormap result = Xlib_DupColormap(dpy, colormap);
	Xlib_FreeColormap((Xlib_Colormap *)colormap);
	SyncHandle();
	_XcmsCopyCmapRecAndFree(dpy, colormap, result);
	DBUG_RETURN(result);
}

Colormap XCreateColormap(Display* dpy, Window w, Visual* visual, int alloc)
{
	DBUG_ENTER("XCreateColormap")
		Colormap result = Xlib_CreateColormap(dpy,w,visual,alloc);
	SyncHandle();
	_XcmsAddCmapRec(dpy, result, w, visual);
	DBUG_RETURN(result);
}

Status XAllocColor(Display *display, Colormap colormap, XColor *screen_in_out)
{
	DBUG_ENTER("XAllocColor")
		HPS hps = WinGetScreenPS(hwndDesktop);
	LONG newcol = GpiQueryNearestColor(hps, 0L, (PC_RESERVED*16777216) + (screen_in_out->red*65536) + (screen_in_out->green*256) + screen_in_out->blue);
	if(newcol < 0)
		screen_in_out->pixel = ((screen_in_out->red*65536) + (screen_in_out->green*256) + screen_in_out->blue) >> 8;
	else
	{
		screen_in_out->blue = (newcol & 0xFF);
		screen_in_out->green = ((newcol >> 8) & 0xFF);
		screen_in_out->red =  ((newcol >> 16) & 0xFF);
		screen_in_out->pixel = newcol;
	}
	WinReleasePS(hps);
	DBUG_RETURN(True);
}

Status XStoreColor(Display* display, Colormap colormap, XColor* screen_in)
{
	DBUG_ENTER("XStoreColor")
		Xlib_Colormap *cmap = (Xlib_Colormap *)colormap;
	int index;
	int blue = 0, red = 0, green = 0;
	if(!cmap)
		DBUG_RETURN(True);

	index = screen_in->pixel;
	if(index >= cmap->count)
		DBUG_RETURN(False);

	if(cmap->allocbmp[index] == 1)
	{
		blue = (cmap->Colors[index] & 0xFF);
		green = ((cmap->Colors[index] >> 8) & 0xFF);
		red =  ((cmap->Colors[index] >> 16) & 0xFF);
	}

	if(screen_in->flags & DoRed)
		red = screen_in->red;
	if(screen_in->flags & DoGreen)
		green = screen_in->green;
	if(screen_in->flags & DoBlue)
		blue = screen_in->blue;

	cmap->Colors[index] = ((red*65536) + (green*256) + blue) >> 8;
	cmap->allocbmp[index] = 1;
	if(GpiSetPaletteEntries(cmap->hpal, LCOLF_CONSECRGB, index, 1, &cmap->Colors[index]) == FALSE)
		DBUG_RETURN(False);
	DBUG_RETURN(True);
}

Status XAllocColorCells(Display* display, Colormap colormap, Bool contig,
						unsigned long* plane_masks_return, unsigned int nplanes,
						unsigned long* pixels_return, unsigned int npixels)
{
	DBUG_ENTER("XAllocColorCells")
		Xlib_Colormap *cmap = (Xlib_Colormap *)colormap;
	int t, x=0;

	if(!cmap)
		DBUG_RETURN(BadColor);
	if(nplanes < 0 || npixels < 1)
		DBUG_RETURN(BadValue);
	if(!contig)
	{
		for(t=0;t<cmap->count;t++) {
			if(!cmap->allocbmp[t]) {
				pixels_return[x] = t;
				x++;
				if(x == npixels)
					break;
			}
			DBUG_RETURN(False);
		}
	} else {
		for(t=0;t<cmap->count;t++) {
			if(t+npixels < cmap->count) {
				int z, failed = 0;;
				for(z=0;z<npixels;z++)
					if(cmap->allocbmp[z+t])
						failed = 1;
				if(failed == 0) {
					for(z=0;z<npixels;z++)
						pixels_return[z] = z+t;
				} else {
					DBUG_RETURN(False);
				}
			}
		}
	}
	/* Not sure about planes yet */

	DBUG_RETURN(True);
}

Status XAllocColorPlanes(Display* display, Colormap colormap, Bool contig,
						 unsigned long* pixels_return, int ncolors, int nreds, int ngreens, int nblues,
						 unsigned long* rmask_return, unsigned long* gmask_return, unsigned long* bmask_return)
{
	DBUG_ENTER("XAllocColorPlanes")
		/* Still working on the plane code... check back soon ;) Brian */
		DBUG_RETURN(True);
}

int XFreeColormap(Display* dpy, Colormap colormap)
{
	DBUG_ENTER("XFreeColormap")
		Xlib_FreeColormap((Xlib_Colormap *)colormap);
	SyncHandle();
	_XcmsDeleteCmapRec(dpy, colormap);
	DBUG_RETURN(1);
}

int XFreeColors(Display* display, Colormap colormap,
				unsigned long* pixels, int npixels, unsigned long planes)
{
	DBUG_ENTER("XFreeColors")
		Xlib_Colormap *cmap = (Xlib_Colormap *)colormap;
	int t;

	if(!cmap)
		DBUG_RETURN(BadColor);
	/* I am making an untested assumption that if you try to allocate
	 a color that is already in the palette it will not use a new
	 palette entry - Brian */
	for(t=0;t<npixels;t++) {
		if(pixels[t] < cmap->count) {
			cmap->Colors[pixels[t]] = 0L;
			cmap->allocbmp[pixels[t]] = 0;
		}
	}
	DBUG_RETURN(True);
}


int XSetWindowColormap(Display* dpy, Window w, Colormap colormap)
{
	DBUG_ENTER("XSetWindowColormap")
		XSetWindowAttributes attrib;
	attrib.colormap = colormap;
	XChangeWindowAttributes(dpy, w, CWColormap, &attrib);
	DBUG_RETURN(1);
}

int XStoreColors(Display* display, Colormap colormap, XColor* color, int ncolors)
{
	DBUG_ENTER("XStoreColors")
		int t;
	for(t=0;t<ncolors;t++)
		XStoreColor(display, colormap, &color[t]);
	DBUG_RETURN(True);
}


int XStoreNamedColor(Display* dpy, Colormap cmap,
					 _Xconst char* name, unsigned long pixel, int flags)
{
	XcmsCCC ccc;
	XcmsColor cmsColor_exact;
	XColor scr_def;

	/*
	 * Let's Attempt to use Xcms approach to Parse Color
	 */
	if ((ccc = XcmsCCCOfColormap(dpy, cmap)) != (XcmsCCC)NULL) {
		if (_XcmsResolveColorString(ccc, &name, &cmsColor_exact,
									XcmsRGBFormat) >= XcmsSuccess) {
			_XcmsRGB_to_XColor(&cmsColor_exact, &scr_def, 1);
			scr_def.pixel = pixel;
			scr_def.flags = flags;
			return XStoreColor(dpy, cmap, &scr_def);
		}
	}

	return 0;
}

Colormap *XListInstalledColormaps(Display* display, Window w, int* num_return)
{
	DBUG_ENTER("XListInstalledColormaps")
		WinAttribData *attrib = WinQueryWindowPtr(w, QWP_WINATTRIB);

	if(attrib && attrib->winattrib.colormap) {
		*num_return = 1;
		/* We may need to make a copy but I don't think so */
		DBUG_RETURN((Colormap)&attrib->winattrib.colormap);
	}
	*num_return = 0;
	DBUG_RETURN(False);
}

int XInstallColormap(Display* display, Colormap colormap);
int XUninstallColormap(Display* display, Colormap colormap);

