/* $XConsortium: ChGC.c /main/7 1996/10/22 14:15:58 kaleb $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#include "Xlib_private.h"

#define ValidGCValuesBits (GCFunction | GCPlaneMask | GCForeground | \
			   GCBackground | GCLineWidth | GCLineStyle | \
			   GCCapStyle | GCJoinStyle | GCFillStyle | \
			   GCFillRule | GCTile | GCStipple | \
			   GCTileStipXOrigin | GCTileStipYOrigin | \
			   GCFont | GCSubwindowMode | GCGraphicsExposures | \
			   GCClipXOrigin | GCClipYOrigin | GCDashOffset | \
			   GCArcMode)

int XChangeGC (dpy, gc, valuemask, values)
    register Display *dpy;
    GC gc;
    unsigned long valuemask;
    XGCValues *values;
{
    DBUG_ENTER("XChangeGC")
    LockDisplay(dpy);

    if (valuemask & ~ValidGCValuesBits || !gc) DBUG_RETURN(False);

    if (valuemask & GCFunction) {
	((Xlib_GC *)gc)->values.function = values->function;
    }

    if (valuemask & GCPlaneMask)
      /*values->plane_mask = -1*/;

    if (valuemask & GCForeground) {
	((Xlib_GC *)gc)->values.foreground = values->foreground;
    }

    if (valuemask & GCBackground) {
	((Xlib_GC *)gc)->values.background = values->background;
    }

    if (valuemask & GCLineWidth) {
	((Xlib_GC *)gc)->values.line_width = values->line_width;
    }

    if (valuemask & GCLineStyle) {
	((Xlib_GC *)gc)->values.line_style = values->line_style;
    }

    if (valuemask & GCCapStyle) {
	((Xlib_GC *)gc)->values.cap_style = values->cap_style;
    }

    if (valuemask & GCJoinStyle) {
	((Xlib_GC *)gc)->values.join_style = values->join_style;
    }

    if (valuemask & GCFillStyle)
      ((Xlib_GC *)gc)->values.fill_style = values->fill_style;

    if (valuemask & GCFillRule)
      ((Xlib_GC *)gc)->values.fill_rule = values->fill_rule;

    if (valuemask & GCTile)
      ((Xlib_GC *)gc)->values.tile = values->tile;

    if (valuemask & GCStipple)
      XSetStipple(dpy, gc, values->stipple);

    if (valuemask & GCTileStipXOrigin)
      ((Xlib_GC *)gc)->values.ts_x_origin = values->ts_x_origin;

    if (valuemask & GCTileStipYOrigin)
      ((Xlib_GC *)gc)->values.ts_y_origin = values->ts_y_origin;

    if (valuemask & GCFont)
      XSetFont(dpy, gc, values->font);

    if (valuemask & GCSubwindowMode)
      /*values->subwindow_mode = ClipByChildren*/;

    if (valuemask & GCGraphicsExposures)
      /*values->graphics_exposures = True*/;

    if (valuemask & GCClipXOrigin)
      ((Xlib_GC *)gc)->values.clip_x_origin = values->clip_x_origin;

    if (valuemask & GCClipYOrigin)
      ((Xlib_GC *)gc)->values.clip_y_origin = values->dash_offset;

    if (valuemask & GCDashOffset)
      ((Xlib_GC *)gc)->values.dash_offset = values->dash_offset;

    if (valuemask & GCArcMode)
      ((Xlib_GC *)gc)->values.arc_mode = values->arc_mode;

    UnlockDisplay(dpy);
    SyncHandle();
    DBUG_RETURN(1);
}

