/* $XConsortium: ChWAttrs.c /main/6 1996/10/22 14:16:19 kaleb $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#include "Xlib_private.h"

#define AllMaskBits (CWBackPixmap|CWBackPixel|CWBorderPixmap|\
		     CWBorderPixel|CWBitGravity|CWWinGravity|\
		     CWBackingStore|CWBackingPlanes|CWBackingPixel|\
		     CWOverrideRedirect|CWSaveUnder|CWEventMask|\
                     CWDontPropagate|CWColormap|CWCursor)

void Xlib_ApplyColormap(Drawable d, Colormap colormap);

int XChangeWindowAttributes (dpy, w, valuemask, attributes)
    register Display *dpy;
    Window w;
    unsigned long valuemask;
    XSetWindowAttributes *attributes;
{
    DBUG_ENTER("XChangeWindowAttributes")
    WinAttribData *attrib = WinQueryWindowPtr(w, QWP_WINATTRIB);

    if (valuemask & ~AllMaskBits || !attrib || !attributes) DBUG_RETURN(False);
    LockDisplay(dpy);

    if (valuemask & CWEventMask)
	attrib->winattrib.your_event_mask = attributes->event_mask;
    if (valuemask & CWDontPropagate)
	attrib->winattrib.do_not_propagate_mask = attributes->do_not_propagate_mask;
    if (valuemask & CWBackPixel)
	attrib->background_pixel = attributes->background_pixel;
    if (valuemask & CWBackPixmap)
	attrib->background_pixmap = attributes->background_pixmap;
    if (valuemask & CWWinGravity)
	attrib->winattrib.win_gravity = attributes->win_gravity;
    if (valuemask & CWColormap) {
	attrib->winattrib.colormap = attributes->colormap;
        Xlib_ApplyColormap(w, attributes->colormap);
    }
    if (valuemask & CWCursor) {
	POINTL ptl;
	HWND hwnd;
	attrib->cursor = attributes->cursor;
	WinQueryPointerPos(hwndDesktop, &ptl);
	hwnd = WinWindowFromPoint(hwndDesktop, &ptl, TRUE);
	if ((HWND)w == hwnd) WinSetPointer(hwndDesktop, attributes->cursor);
    }

    UnlockDisplay(dpy);
    SyncHandle();
    DBUG_RETURN(1);
}

int XSetWindowBackground(dpy, w, pixel)
    register Display *dpy;
    Window w;
    unsigned long pixel;
{
    DBUG_ENTER("XSetWindowBackground")
    XSetWindowAttributes attrib;
    attrib.background_pixel = pixel;

    XChangeWindowAttributes(dpy, w, CWBackPixel, &attrib);

    DBUG_RETURN(1);
}

int XSetWindowBackgroundPixmap(display, w, background_pixmap)
      Display *display;
      Window w;
      Pixmap background_pixmap;
{
    DBUG_ENTER("XSetWindowBackgroundPixmap")
    XSetWindowAttributes attrib;
    attrib.background_pixmap = background_pixmap;

    XChangeWindowAttributes(display, w, CWBackPixmap, &attrib);

    DBUG_RETURN(1);
}