/* $TOG: lcWrap.c /main/25 1997/06/02 17:28:04 kaleb $ */
/*

Copyright (c) 1991  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

*/
/*
 * Copyright 1991 by the Open Software Foundation
 * Copyright 1993 by the TOSHIBA Corp.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of Open Software Foundation and TOSHIBA
 * not be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Open Software
 * Foundation and TOSHIBA make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *
 * OPEN SOFTWARE FOUNDATION AND TOSHIBA DISCLAIM ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL OPEN SOFTWARE FOUNDATIONN OR TOSHIBA BE
 * LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 *		 M. Collins		OSF  
 *
 *		 Katsuhisa Yano		TOSHIBA Corp.
 */				
/* $XFree86: xc/lib/X11/lcWrap.c,v 3.1.4.4 1998/10/04 13:36:25 hohndel Exp $ */

#include "Xlib_private.h"
#include "Xlcint.h"
#include <X11/Xlocale.h>
#include <X11/Xos.h>
#ifdef WIN32
#undef close
#endif
#include <X11/Xutil.h>

#ifdef __STDC__
#define Const const
#else
#define Const /**/
#endif

#ifdef X_NOT_STDC_ENV
extern char *getenv();
#endif

extern void _XlcInitLoader(
#if NeedFunctionPrototypes
    void
#endif
);

#ifdef XTHREADS
LockInfoPtr _Xi18n_lock;
#endif

#if NeedFunctionPrototypes
char *
XSetLocaleModifiers(
    _Xconst char   *modifiers
)
#else
char *
XSetLocaleModifiers(modifiers)
    char        *modifiers;
#endif
{
    DBUG_ENTER("XSetLocaleModifiers")
    XLCd lcd = _XlcCurrentLC();
    char *user_mods;

    if (!lcd)
	DBUG_RETURN((char *) NULL);
    if (!modifiers) {
	char *result = lcd->core->modifiers;
	DBUG_RETURN(result);
    }
    user_mods = getenv("XMODIFIERS");
    modifiers = (*lcd->methods->map_modifiers) (lcd,
						user_mods, (char *)modifiers);
    if (modifiers) {
	if (lcd->core->modifiers)
	    Xfree(lcd->core->modifiers);
	lcd->core->modifiers = (char *)modifiers;
    }
    DBUG_RETURN((char *)modifiers);
}

Bool
XSupportsLocale()
{
    DBUG_ENTER("XSupportsLocale")
    Bool result = _XlcCurrentLC() != (XLCd)NULL;
    DBUG_RETURN(result);
}

Bool _XlcValidModSyntax(mods, valid_mods)
    char *mods;
    char **valid_mods;
{
    DBUG_ENTER("_XlcValidModSyntax")
    int i;
    char **ptr;

    while (mods && (*mods == '@')) {
	mods++;
	if (*mods == '@')
	    break;
	for (ptr = valid_mods; *ptr; ptr++) {
	    i = strlen(*ptr);
	    if (strncmp(mods, *ptr, i) || ((mods[i] != '=')
#ifdef WIN32
					   && (mods[i] != '#')
#endif
					   ))
		continue;
	    mods = strchr(mods+i+1, '@');
	    break;
	}
    }
    DBUG_RETURN(!mods || !*mods);
}

static Const char *im_valid[] = {"im", (char *)NULL};

/*ARGSUSED*/
char *
_XlcDefaultMapModifiers (lcd, user_mods, prog_mods)
    XLCd lcd;
    char *user_mods;
    char *prog_mods;
{
    DBUG_ENTER("_XlcDefaultMapModifiers")
    int i;
    char *mods;

    if (!_XlcValidModSyntax(prog_mods, (char **)im_valid))
	DBUG_RETURN((char *)NULL);
    if (!_XlcValidModSyntax(user_mods, (char **)im_valid))
	DBUG_RETURN((char *)NULL);
    i = strlen(prog_mods) + 1;
    if (user_mods)
	i += strlen(user_mods);
    mods = Xmalloc(i);
    if (mods) {
	strcpy(mods, prog_mods);
	if (user_mods)
	    strcat(mods, user_mods);
#ifdef WIN32
	{
	    char *s;
	    for (s = mods; s = strchr(s, '@'); s++) {
		for (s++; *s && *s != '='; s++) {
		    if (*s == '#') {
			*s = '=';
			break;
		    }
		}
	    }
	}
#endif
    }
    DBUG_RETURN(mods);
}

typedef struct _XLCdListRec {
    struct _XLCdListRec *next;
    XLCd lcd;
    int ref_count;
} XLCdListRec, *XLCdList;

static XLCdList lcd_list = NULL;

typedef struct _XlcLoaderListRec {
    struct _XlcLoaderListRec *next;
    XLCdLoadProc proc;
} XlcLoaderListRec, *XlcLoaderList;

static XlcLoaderList loader_list = NULL;

void
_XlcRemoveLoader(proc)
    XLCdLoadProc proc;
{
    DBUG_ENTER("_XlcRemoveLoader")
    XlcLoaderList loader, prev;

    if (loader_list == NULL)
	DBUG_VOID_RETURN;

    prev = loader = loader_list;
    if (loader->proc == proc) {
	loader_list = loader->next;
	Xfree(loader);
	DBUG_VOID_RETURN;
    }

    while ((loader = loader->next)) {
	if (loader->proc == proc) {
	    prev->next = loader->next;
	    Xfree(loader);
	    DBUG_VOID_RETURN;
	}
	prev = loader;
    }

    DBUG_VOID_RETURN;
}

Bool
_XlcAddLoader(proc, position)
    XLCdLoadProc proc;
    XlcPosition position;
{
    DBUG_ENTER("_XlcAddLoader")
    XlcLoaderList loader, last;

    _XlcRemoveLoader(proc);		/* remove old loader, if exist */

    loader = (XlcLoaderList) Xmalloc(sizeof(XlcLoaderListRec));
    if (loader == NULL)
	DBUG_RETURN(False);

    loader->proc = proc;

    if (loader_list == NULL)
	position = XlcHead;

    if (position == XlcHead) {
	loader->next = loader_list;
	loader_list = loader;
    } else {
	last = loader_list;
	while (last->next)
	    last = last->next;
	
	loader->next = NULL;
	last->next = loader;
    }

    DBUG_RETURN(True);
}

XLCd
_XOpenLC(name)
    _Xconst char *name;
{
    DBUG_ENTER("_XOpenLC")
    XLCd lcd = NULL;
    XlcLoaderList loader;
    XLCdList cur;
#if !defined(X_NOT_STDC_ENV) && !defined(X_LOCALE)
    char siname[256];
    char *_XlcMapOSLocaleName();
#endif
    int num;

    if (name == NULL) {
	name = setlocale (LC_CTYPE, (char *)NULL);
#if !defined(X_NOT_STDC_ENV) && !defined(X_LOCALE)
	name = _XlcMapOSLocaleName (name, siname); 
#endif
    }

    _XLockMutex(_Xi18n_lock);

    /*
     * search for needed lcd, if found return it
     */
    for (cur = lcd_list; cur; cur = cur->next) {
	if (!strcmp (cur->lcd->core->name, name)) {
	    lcd = cur->lcd;
	    cur->ref_count++;
	    goto found;
	}
    }

    if (!loader_list)
	_XlcInitLoader();

    /*
     * not there, so try to get and add to list
     */
    for (loader = loader_list, num = 0; loader; loader = loader->next, num++) {
	lcd = (*loader->proc)(name);
	if (lcd) {
	    cur = (XLCdList) Xmalloc (sizeof(XLCdListRec));
	    if (cur) {
		cur->lcd = lcd;
		cur->ref_count = 1;
		cur->next = lcd_list;
		lcd_list = cur;
	    } else {
#if defined(DEBUG) && defined(VERBOSE)
		fprintf(stderr,"_XOpenLC: Xmalloc failed!\n");
#endif
		(*lcd->methods->close)(lcd);
		lcd = (XLCd) NULL;
	    }
	    break;
	}
    }

#if defined(DEBUG) && defined(VERBOSE)
    if (!lcd) {
	fprintf(stderr,"_XOpenLC: Out of %d loaders, none worked!\n",num);
    }
#endif
found:
    _XUnlockMutex(_Xi18n_lock);
    DBUG_RETURN(lcd);
}

void
_XCloseLC(lcd)
    XLCd lcd;
{
    DBUG_ENTER("_XCloseLC")
    XLCdList cur, *prev;

    for (prev = &lcd_list; (cur = *prev); prev = &cur->next) {
	if (cur->lcd == lcd) {
	    if (--cur->ref_count < 1) {
		(*lcd->methods->close)(lcd);
		*prev = cur->next;
		Xfree(cur);
	    }
	    break;
	}
    }
    DBUG_VOID_RETURN;
}

/*
 * Get the XLCd for the current locale
 */

XLCd
_XlcCurrentLC()
{
    DBUG_ENTER("_XlcCurrentLC")
    XLCd lcd;
    static XLCd last_lcd = NULL;

    lcd = _XOpenLC((char *) NULL);

    if (last_lcd)
	_XCloseLC(last_lcd);
    
    last_lcd = lcd;

    DBUG_RETURN(lcd);
}

XrmMethods
_XrmInitParseInfo(state)
    XPointer *state;
{
    DBUG_ENTER("_XrmInitParseInfo")
    XLCd lcd = _XOpenLC((char *) NULL);
    XrmMethods result;
    
    if (lcd == (XLCd) NULL)
	DBUG_RETURN((XrmMethods) NULL);
    
    result = (*lcd->methods->init_parse_info)(lcd, state);
    DBUG_RETURN(result);
}

int
XmbTextPropertyToTextList(dpy, text_prop, list_ret, count_ret)
    Display *dpy;
    XTextProperty *text_prop;
    char ***list_ret;
    int *count_ret;
{
    DBUG_ENTER("XmbTextPropertyToTextList")
    XLCd lcd = _XlcCurrentLC();
    int result;
    
    if (lcd == NULL)
	DBUG_RETURN(XLocaleNotSupported);

    result = (*lcd->methods->mb_text_prop_to_list)(lcd, dpy, text_prop, list_ret,
						 count_ret);
    DBUG_RETURN(result);
}

int
XwcTextPropertyToTextList(dpy, text_prop, list_ret, count_ret)
    Display *dpy;
    XTextProperty *text_prop;
    wchar_t ***list_ret;
    int *count_ret;
{
    DBUG_ENTER("XwcTextPropertyToTextList")
    XLCd lcd = _XlcCurrentLC();
    int result;
    
    if (lcd == NULL)
	DBUG_RETURN(XLocaleNotSupported);

    result = (*lcd->methods->wc_text_prop_to_list)(lcd, dpy, text_prop, list_ret,
						 count_ret);
    DBUG_RETURN(result);
}

int
XmbTextListToTextProperty(dpy, list, count, style, text_prop)
    Display *dpy;
    char **list;
    int count;
    XICCEncodingStyle style;
    XTextProperty *text_prop;
{
    DBUG_ENTER("XmbTextListToTextProperty")
    XLCd lcd = _XlcCurrentLC();
    int result;
    
    if (lcd == NULL)
	return XLocaleNotSupported;

    result = (*lcd->methods->mb_text_list_to_prop)(lcd, dpy, list, count, style,
						 text_prop);
    DBUG_RETURN(result);
}

int
XwcTextListToTextProperty(dpy, list, count, style, text_prop)
    Display *dpy;
    wchar_t **list;
    int count;
    XICCEncodingStyle style;
    XTextProperty *text_prop;
{
    DBUG_ENTER("XwcTextListToTextProperty")
    XLCd lcd = _XlcCurrentLC();
    int result;
    
    if (lcd == NULL)
	return XLocaleNotSupported;

    result = (*lcd->methods->wc_text_list_to_prop)(lcd, dpy, list, count, style,
						 text_prop);
    DBUG_RETURN(result);
}

void
XwcFreeStringList(list)
    wchar_t **list;
{
    DBUG_ENTER("XwcFreeStringList")
    XLCd lcd = _XlcCurrentLC();
    
    if (lcd == NULL)
	DBUG_VOID_RETURN;

    (*lcd->methods->wc_free_string_list)(lcd, list);
    DBUG_VOID_RETURN;
}

char *
XDefaultString()
{
    DBUG_ENTER("XDefaultString")
    XLCd lcd = _XlcCurrentLC();
    char *result;
    
    if (lcd == NULL)
	DBUG_RETURN((char *) NULL);
    
    result = (*lcd->methods->default_string)(lcd);
    DBUG_RETURN(result);
}

void
_XlcCopyFromArg(src, dst, size)
    char *src;
    register char *dst;
    register int size;
{
    DBUG_ENTER("_XlcCopyFromArg")
    if (size == sizeof(long))
	*((long *) dst) = (long) src;
#ifdef LONG64
    else if (size == sizeof(int))
	*((int *) dst) = (int)(long) src;
#endif
    else if (size == sizeof(short))
	*((short *) dst) = (short)(long) src;
    else if (size == sizeof(char))
	*((char *) dst) = (char)(long) src;
    else if (size == sizeof(XPointer))
	*((XPointer *) dst) = (XPointer) src;
    else if (size > sizeof(XPointer))
	memcpy(dst, (char *) src, size);
    else
	memcpy(dst, (char *) &src, size);
    DBUG_VOID_RETURN;
}

void
_XlcCopyToArg(src, dst, size)
    register char *src;
    register char **dst;
    register int size;
{
    DBUG_ENTER("_XlcCopyToArg")
    if (size == sizeof(long))
	*((long *) *dst) = *((long *) src);
    else if (size == sizeof(short))
	*((short *) *dst) = *((short *) src);
    else if (size == sizeof(char))
	*((char *) *dst) = *((char *) src);
    else if (size == sizeof(XPointer))
	*((XPointer *) *dst) = *((XPointer *) src);
    else
	memcpy(*dst, src, size);
    DBUG_VOID_RETURN;
}

void
_XlcCountVaList(var, count_ret)
    va_list var;
    int *count_ret;
{
    DBUG_ENTER("_XlcCountVaList")
    register int count;

    for (count = 0; va_arg(var, char *); count++)
	va_arg(var, XPointer);
    
    *count_ret = count;
    DBUG_VOID_RETURN;
}

void
_XlcVaToArgList(var, count, args_ret)
    va_list var;
    register int count;
    XlcArgList *args_ret;
{
    DBUG_ENTER("_XlcVaToArgList")
    register XlcArgList args;

    *args_ret = args = (XlcArgList) Xmalloc(sizeof(XlcArg) * count);
    if (args == (XlcArgList) NULL)
	DBUG_VOID_RETURN;
    
    for ( ; count-- > 0; args++) {
	args->name = va_arg(var, char *);
	args->value = va_arg(var, XPointer);
    }
    DBUG_VOID_RETURN;
}

void
_XlcCompileResourceList(resources, num_resources)
    register XlcResourceList resources;
    register int num_resources;
{
    DBUG_ENTER("_XlcCompileResourceList")
    for ( ; num_resources-- > 0; resources++)
	resources->xrm_name = XrmPermStringToQuark(resources->name);
    DBUG_VOID_RETURN;
}

char *
_XlcGetValues(base, resources, num_resources, args, num_args, mask)
    XPointer base;
    XlcResourceList resources;
    int num_resources;
    XlcArgList args;
    int num_args;
    unsigned long mask;
{
    DBUG_ENTER("_XlcGetValues")
    XlcResourceList res;
    XrmQuark xrm_name;
    int count;

    for ( ; num_args-- > 0; args++) {
	res = resources;
	count = num_resources;
	xrm_name = XrmPermStringToQuark(args->name);

	for ( ; count-- > 0; res++) {
	    if (xrm_name == res->xrm_name && (mask & res->mask)) {
		    _XlcCopyToArg(base + res->offset, &args->value, res->size);
		break;
	    }
	}

	if (count < 0)
	    DBUG_RETURN(args->name);
    }

    DBUG_RETURN(NULL);
}

char *
_XlcSetValues(base, resources, num_resources, args, num_args, mask)
    XPointer base;
    XlcResourceList resources;
    int num_resources;
    XlcArgList args;
    int num_args;
    unsigned long mask;
{
    DBUG_ENTER("_XlcSetValues")
    XlcResourceList res;
    XrmQuark xrm_name;
    int count;

    for ( ; num_args-- > 0; args++) {
	res = resources;
	count = num_resources;
	xrm_name = XrmPermStringToQuark(args->name);

	for ( ; count-- > 0; res++) {
	    if (xrm_name == res->xrm_name && (mask & res->mask)) {
		_XlcCopyFromArg(args->value, base + res->offset, res->size);
		break;
	    }
	}

	if (count < 0)
	    DBUG_RETURN(args->name);
    }

    DBUG_RETURN(NULL);
}
