/* $XConsortium: lcPubWrap.c,v 1.3 94/01/20 18:07:08 rws Exp $ */
/*
 * Copyright 1992, 1993 by TOSHIBA Corp.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of TOSHIBA not be used in advertising
 * or publicity pertaining to distribution of the software without specific,
 * written prior permission. TOSHIBA make no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * TOSHIBA DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * TOSHIBA BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Author: Katsuhisa Yano	TOSHIBA Corp.
 *			   	mopi@osa.ilab.toshiba.co.jp
 */
/* $XFree86: xc/lib/X11/lcPubWrap.c,v 1.1.1.1.12.1 1998/01/25 06:11:08 dawes Exp $ */

#include "Xlib_private.h"
#include "XlcPubI.h"

#if NeedVarargsPrototypes
char *
_XGetLCValues(XLCd lcd, ...)
#else
char *
_XGetLCValues(lcd, va_alist)
    XLCd lcd;
    va_dcl
#endif
{
    DBUG_ENTER("_XGetLCValues")
    va_list var;
    XlcArgList args;
    char *ret;
    int num_args;
    XLCdPublicMethodsPart *methods = XLC_PUBLIC_METHODS(lcd);

    Va_start(var, lcd);
    _XlcCountVaList(var, &num_args);
    va_end(var);

    Va_start(var, lcd);
    _XlcVaToArgList(var, num_args, &args);
    va_end(var);

    if (args == (XlcArgList) NULL)
	DBUG_RETURN((char *) NULL);
    
    ret = (*methods->get_values)(lcd, args, num_args);

    Xfree(args);

    DBUG_RETURN(ret);
}

void
_XlcDestroyLC(lcd)
    XLCd lcd;
{
    DBUG_ENTER("_XlcDestroyLC")
    XLCdPublicMethods methods = (XLCdPublicMethods) lcd->methods;

    (*methods->pub.destroy)(lcd);
    DBUG_VOID_RETURN;
}

XLCd
_XlcCreateLC(name, methods)
    _Xconst char *name;
    XLCdMethods methods;
{
    DBUG_ENTER("_XlcCreateLC")
    XLCdPublicMethods pub_methods = (XLCdPublicMethods) methods;
    XLCd lcd;

    lcd = (*pub_methods->pub.create)(name, methods);
    if (lcd == NULL) {
#if defined(DEBUG) && defined(VERBOSE)
	fprintf(stderr, "_XlcCreateLC: pub.create method failed!\n");
#endif
	DBUG_RETURN((XLCd) NULL);
    }

    if (lcd->core->name == NULL) {
	lcd->core->name = (char*) Xmalloc(strlen(name) + 1);
	if (lcd->core->name == NULL) {
#if defined(DEBUG) && defined(VERBOSE)
	    fprintf(stderr, "_XlcCreateLC: malloc failed!\n");
#endif
	    goto err;
}
	strcpy(lcd->core->name, name);
    }
    
    if (lcd->methods == NULL)
	lcd->methods = methods;

    if ((*pub_methods->pub.initialize)(lcd) == False) {
#if defined(DEBUG) && defined(VERBOSE)
	fprintf(stderr, "_XlcCreateLC: pub.initialize method failed!\n");
#endif
	goto err;
}
    
    DBUG_RETURN(lcd);

err:
    _XlcDestroyLC(lcd);

    DBUG_RETURN((XLCd) NULL);
}
