/* $XConsortium: lcConv.c /main/8 1996/09/28 16:37:28 rws $ */
/*
 * Copyright 1992, 1993 by TOSHIBA Corp.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of TOSHIBA not be used in advertising
 * or publicity pertaining to distribution of the software without specific,
 * written prior permission. TOSHIBA make no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * TOSHIBA DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * TOSHIBA BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Author: Katsuhisa Yano	TOSHIBA Corp.
 *			   	mopi@osa.ilab.toshiba.co.jp
 */

#include "Xlib_private.h"
#include "XlcPubI.h"
#include <stdio.h>

typedef XlcConv (*XlcConverter)();

typedef struct _XlcConverterListRec {
    XLCd from_lcd;
    char *from;
    XrmQuark from_type;
    XLCd to_lcd;
    char *to;
    XrmQuark to_type;
    XlcConverter converter;
    struct _XlcConverterListRec *next;
} XlcConverterListRec, *XlcConverterList;

static XlcConverterList conv_list = NULL;

static void
close_converter(conv)
    XlcConv conv;
{
    DBUG_ENTER("close_converter")
    (*conv->methods->close)(conv);
    DBUG_VOID_RETURN;
}

static XlcConv
get_converter(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    XrmQuark from_type;
    XLCd to_lcd;
    XrmQuark to_type;
{
    DBUG_ENTER("get_converter")
    register XlcConverterList list, prev = NULL;

    for (list = conv_list; list; list = list->next) {
	if (list->from_lcd == from_lcd && list->to_lcd == to_lcd 
	    && list->from_type == from_type && list->to_type == to_type) {
	    XlcConv result;

	    if (prev && prev != conv_list) {	/* XXX */
		prev->next = list->next;
		list->next = conv_list;
		conv_list = list;
	    }

	    result = (*list->converter)(from_lcd, list->from, to_lcd, list->to);
	    DBUG_RETURN(result);
	}

	prev = list;
    }
    
    DBUG_RETURN((XlcConv) NULL);
}

Bool
_XlcSetConverter(from_lcd, from, to_lcd, to, converter)
    XLCd from_lcd;
    char *from;
    XLCd to_lcd;
    char *to;
    XlcOpenConverterProc converter;
{
    DBUG_ENTER("_XlcSetConverter")
    register XlcConverterList list;
    register XrmQuark from_type, to_type;

    from_type = XrmStringToQuark(from);
    to_type = XrmStringToQuark(to);

    for (list = conv_list; list; list = list->next) {
	if (list->from_lcd == from_lcd && list->to_lcd == to_lcd 
	    && list->from_type == from_type && list->to_type == to_type) {

	    list->converter = converter;
	    DBUG_RETURN(True);
	}
    }

    list = (XlcConverterList) Xmalloc(sizeof(XlcConverterListRec));
    if (list == NULL)
	DBUG_RETURN(False);
    
    list->from_lcd = from_lcd;
    list->from = from;
    list->from_type = from_type;
    list->to_lcd = to_lcd;
    list->to = to;
    list->to_type = to_type;
    list->converter = converter;
    list->next = conv_list;
    conv_list = list;

    DBUG_RETURN(True);
}

typedef struct _ConvRec {
    XlcConv from_conv;
    XlcConv to_conv;
} ConvRec, *Conv;

static int
indirect_convert(lc_conv, from, from_left, to, to_left, args, num_args)
    XlcConv lc_conv;
    XPointer *from;
    int *from_left;
    XPointer *to;
    int *to_left;
    XPointer *args;
    int num_args;
{
    DBUG_ENTER("indirect_convert")
    Conv conv = (Conv) lc_conv->state;
    XlcConv from_conv = conv->from_conv;
    XlcConv to_conv = conv->to_conv;
    XlcCharSet charset;
    char buf[BUFSIZ], *cs;
    XPointer tmp_args[1];
    int cs_left, ret, length, unconv_num = 0;

    if (from == NULL || *from == NULL) {
	if (from_conv->methods->reset)
	    (*from_conv->methods->reset)(from_conv);

	if (to_conv->methods->reset)
	    (*to_conv->methods->reset)(to_conv);

	DBUG_RETURN(0);
    }

    while (*from_left > 0) {
	cs = buf;
	cs_left = BUFSIZ;
	tmp_args[0] = (XPointer) &charset;

	ret = (*from_conv->methods->convert)(from_conv, from, from_left, &cs,
					     &cs_left, tmp_args, 1);
	if (ret < 0)
	    break;

	length = cs_left = cs - buf;
	cs = buf;

	tmp_args[0] = (XPointer) charset;

	ret = (*to_conv->methods->convert)(to_conv, &cs, &cs_left, to, to_left,
					   tmp_args, 1);
	if (ret < 0) {
	    unconv_num += length / charset->char_size;
	    continue;
	}
	
	if (*to_left < 1)
	    break;
    }

    DBUG_RETURN(unconv_num);
}

static void
close_indirect_converter(lc_conv)
    XlcConv lc_conv;
{
    DBUG_ENTER("close_indirect_converter")
    Conv conv = (Conv) lc_conv->state;

    if (conv) {
	if (conv->from_conv)
	    close_converter(conv->from_conv);
	if (conv->to_conv)
	    close_converter(conv->to_conv);

	Xfree((char *) conv);
    }

    Xfree((char *) lc_conv);
    DBUG_VOID_RETURN;
}

static void
reset_indirect_converter(lc_conv)
    XlcConv lc_conv;
{
    DBUG_ENTER("reset_indirect_converter")
    Conv conv = (Conv) lc_conv->state;

    if (conv) {
	if (conv->from_conv && conv->from_conv->methods->reset)
	    (*conv->from_conv->methods->reset)(conv->from_conv);
	if (conv->to_conv && conv->to_conv->methods->reset)
	    (*conv->to_conv->methods->reset)(conv->to_conv);
    }
    DBUG_VOID_RETURN;
}

static XlcConvMethodsRec conv_methods = {
    close_indirect_converter,
    indirect_convert,
    reset_indirect_converter
} ;

static XlcConv
open_indirect_converter(from_lcd, from, to_lcd, to)
    XLCd from_lcd;
    char *from;
    XLCd to_lcd;
    char *to;
{
    DBUG_ENTER("open_indirect_converter")
    XlcConv lc_conv, from_conv, to_conv;
    Conv conv;
    XrmQuark from_type, to_type;
    static XrmQuark QChar, QCharSet, QCTCharSet = (XrmQuark) 0;

    if (QCTCharSet == (XrmQuark) 0) {
	QCTCharSet = XrmStringToQuark(XlcNCTCharSet);
	QCharSet = XrmStringToQuark(XlcNCharSet);
	QChar = XrmStringToQuark(XlcNChar);
    }

    from_type = XrmStringToQuark(from);
    to_type = XrmStringToQuark(to);

    if (from_type == QCharSet || from_type == QChar || to_type == QCharSet ||
	to_type == QChar)
	DBUG_RETURN((XlcConv) NULL);

    lc_conv = (XlcConv) Xmalloc(sizeof(XlcConvRec));
    if (lc_conv == NULL)
	DBUG_RETURN((XlcConv) NULL);
    
    lc_conv->methods = &conv_methods;

    lc_conv->state = (XPointer) Xcalloc(1, sizeof(ConvRec));
    if (lc_conv->state == NULL)
	goto err;
    
    conv = (Conv) lc_conv->state;

    from_conv = get_converter(from_lcd, from_type, from_lcd, QCTCharSet);
    if (from_conv == NULL)
	from_conv = get_converter(from_lcd, from_type, from_lcd, QCharSet);
    if (from_conv == NULL)
	from_conv = get_converter((XLCd)NULL, from_type, (XLCd)NULL, QCharSet);
    if (from_conv == NULL)
	from_conv = get_converter(from_lcd, from_type, from_lcd, QChar);
    if (from_conv == NULL)
	goto err;
    conv->from_conv = from_conv;

    to_conv = get_converter(to_lcd, QCTCharSet, to_lcd, to_type);
    if (to_conv == NULL)
	to_conv = get_converter(to_lcd, QCharSet, to_lcd, to_type);
    if (to_conv == NULL)
	to_conv = get_converter((XLCd) NULL, QCharSet, (XLCd) NULL, to_type);
    if (to_conv == NULL)
	goto err;
    conv->to_conv = to_conv;

    DBUG_RETURN(lc_conv);

err:
    close_indirect_converter(lc_conv);

    DBUG_RETURN((XlcConv) NULL);
}

XlcConv
_XlcOpenConverter(from_lcd, from, to_lcd, to)
    XLCd from_lcd;
    char *from;
    XLCd to_lcd;
    char *to;
{
    DBUG_ENTER("_XlcOpenConverter")
    XlcConv conv;
    XrmQuark from_type, to_type;

    from_type = XrmStringToQuark(from);
    to_type = XrmStringToQuark(to);

    if (!(conv = get_converter(from_lcd, from_type, to_lcd, to_type)))
	conv = open_indirect_converter(from_lcd, from, to_lcd, to);

    DBUG_RETURN(conv);
}

void
_XlcCloseConverter(conv)
    XlcConv conv;
{
    DBUG_ENTER("_XlcCloseConverter")
    close_converter(conv);
    DBUG_VOID_RETURN;
}

int
_XlcConvert(conv, from, from_left, to, to_left, args, num_args)
    XlcConv conv;
    XPointer *from;
    int *from_left;
    XPointer *to;
    int *to_left;
    XPointer *args;
    int num_args;
{
    DBUG_ENTER("_XlcConvert")
    int result = (*conv->methods->convert)(conv, from, from_left, to, to_left, args,
				     num_args);
    DBUG_RETURN(result);
}

void
_XlcResetConverter(conv)
    XlcConv conv;
{
    DBUG_ENTER("_XlcResetConverter")
    if (conv->methods->reset)
	(*conv->methods->reset)(conv);
    DBUG_VOID_RETURN;
}
