/* $XConsortium: XKBGAlloc.c /main/7 1996/02/02 14:38:24 kaleb $ */
/* $XFree86: xc/lib/X11/XKBGAlloc.c,v 3.2 1996/10/13 11:17:25 dawes Exp $ */
/************************************************************
Copyright (c) 1993 by Silicon Graphics Computer Systems, Inc.

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of Silicon Graphics not be 
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
Silicon Graphics makes no representation about the suitability 
of this software for any purpose. It is provided "as is"
without any express or implied warranty.

SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#define	NEED_EVENTS
#define	NEED_REPLIES

#ifndef XKB_IN_SERVER

#include <stdio.h>
#include "Xlib_private.h"
#include "XKBlibint.h"
#include <X11/extensions/XKBgeom.h>
#include <X11/extensions/XKBproto.h>

#else 

#include <stdio.h>
#include "X.h"
#include "Xproto.h"
#include "misc.h"
#include "inputstr.h"
#include "XKBsrv.h"
#include "XKBgeom.h"

#endif /* XKB_IN_SERVER */

#ifdef X_NOT_POSIX
#define Size_t unsigned int
#else
#define Size_t size_t
#endif

/***====================================================================***/

static void 
#if NeedFunctionPrototypes
_XkbFreeGeomLeafElems(	Bool			freeAll,
			int			first,
			int 			count,
			unsigned short *	num_inout,
			unsigned short *	sz_inout,
			char **			elems,
			unsigned int		elem_sz)
#else
_XkbFreeGeomLeafElems(freeAll,first,count,num_inout,sz_inout,elems,elem_sz)
    Bool		freeAll;
    int			first;
    int			count;
    unsigned short *	num_inout;
    unsigned short *	sz_inout;
    char **		elems;
    unsigned int	elem_sz;
#endif
{
    DBUG_ENTER("_XkbFreeGeomLeafElems")
    if ((freeAll)||(*elems==NULL)) {
	*num_inout= *sz_inout= 0;
	if (*elems!=NULL) {
	    _XkbFree(*elems);
	    *elems= NULL;
	}	
	DBUG_VOID_RETURN;
    }

    if ((first>=(*num_inout))||(first<0)||(count<1))
	DBUG_VOID_RETURN;

    if (first+count>=(*num_inout)) { 
	/* truncating the array is easy */
	(*num_inout)= first;
    }
    else {
	char *	ptr;
	int 	extra;
	ptr= *elems;
	extra= ((*num_inout)-(first+count))*elem_sz;
	if (extra>0)
	    memmove(&ptr[first*elem_sz],&ptr[(first+count)*elem_sz],extra);
	(*num_inout)-= count;
    }
    DBUG_VOID_RETURN;
}

typedef void (*ContentsClearFunc)(
#if NeedFunctionPrototypes
		char *		/* priv */
#endif
);

static void 
#if NeedFunctionPrototypes
_XkbFreeGeomNonLeafElems(	Bool			freeAll,
				int			first,
				int 			count,
				unsigned short *	num_inout,
				unsigned short *	sz_inout,
				char **			elems,
				unsigned int		elem_sz,
				ContentsClearFunc	freeFunc)
#else
_XkbFreeGeomNonLeafElems(freeAll,first,count,num_inout,sz_inout,elems,elem_sz,
								 freeFunc)
    Bool		freeAll;
    int			first;
    int			count;
    unsigned short *	num_inout;
    unsigned short *	sz_inout;
    char **		elems;
    unsigned int	elem_sz;
    ContentsClearFunc	freeFunc;
#endif
{
    DBUG_ENTER("_XkbFreeGeomNonLeafElems")
    register int i;
    register char *ptr;

    if (freeAll) {
	first= 0;
	count= (*num_inout);
    }
    else if ((first>=(*num_inout))||(first<0)||(count<1)) {
	DBUG_VOID_RETURN;
    } else if (first+count>(*num_inout))
	count= (*num_inout)-first;
    if (*elems==NULL)
	DBUG_VOID_RETURN;

    if (freeFunc) {
	ptr= *elems;
	ptr+= first*elem_sz;
	for (i=0;i<count;i++) {
	    (*freeFunc)(ptr);
	    ptr+= elem_sz;
	}
    }
    if (freeAll) {
	(*num_inout)= (*sz_inout)= 0;
	if (*elems) {
	    _XkbFree(*elems);
	    *elems= NULL;
	}
    }
    else if (first+count>=(*num_inout))
	*num_inout= first;
    else {
	i= ((*num_inout)-(first+count))*elem_sz;
	ptr= *elems;
	memmove(&ptr[first*elem_sz],&ptr[(first+count)*elem_sz],i);
	(*num_inout)-= count;
    }
    DBUG_VOID_RETURN;
}

/***====================================================================***/

static void
#if NeedFunctionPrototypes
_XkbClearProperty(char *prop_in)
#else
_XkbClearProperty(prop_in)
    char *	prop_in;
#endif
{
    DBUG_ENTER("_XkbClearProperty")
    XkbPropertyPtr	prop= (XkbPropertyPtr)prop_in;

    if (prop->name) {
	_XkbFree(prop->name);
	prop->name= NULL;
    }
    if (prop->value) {
	_XkbFree(prop->value);
	prop->value= NULL;
    }
    DBUG_VOID_RETURN;
}

void
#if NeedFunctionPrototypes
XkbFreeGeomProperties(	XkbGeometryPtr	geom,
			int		first,
			int		count,
			Bool		freeAll)
#else
XkbFreeGeomProperties(geom,first,count,freeAll)
    XkbGeometryPtr	geom;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomProperties")
    _XkbFreeGeomNonLeafElems(freeAll,first,count,
				&geom->num_properties,&geom->sz_properties,
				(char **)&geom->properties,
				sizeof(XkbPropertyRec),_XkbClearProperty);
    DBUG_VOID_RETURN;
}

/***====================================================================***/

void
#if NeedFunctionPrototypes
XkbFreeGeomKeyAliases(	XkbGeometryPtr	geom,
			int		first,
			int		count,
			Bool		freeAll)
#else
XkbFreeGeomKeyAliases(geom,first,count,freeAll)
    XkbGeometryPtr	geom;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{	
    DBUG_ENTER("XkbFreeGeomKeyAliases")
    _XkbFreeGeomLeafElems(freeAll,first,count,
				&geom->num_key_aliases,&geom->sz_key_aliases,
				(char **)&geom->key_aliases,
				sizeof(XkbKeyAliasRec));
    DBUG_VOID_RETURN;
}

/***====================================================================***/

static void
#if NeedFunctionPrototypes
_XkbClearColor(char *color_in)
#else
_XkbClearColor(color_in)
    char *	color_in;
#endif
{
    DBUG_ENTER("_XkbClearColor")
    XkbColorPtr	color= (XkbColorPtr)color_in;

    if (color->spec)
	_XkbFree(color->spec);
    DBUG_VOID_RETURN;
}

void
#if NeedFunctionPrototypes
XkbFreeGeomColors(XkbGeometryPtr geom,int first,int count,Bool freeAll)
#else
XkbFreeGeomColors(geom,first,count,freeAll)
    XkbGeometryPtr	geom;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomColors")
    _XkbFreeGeomNonLeafElems(freeAll,first,count,
				&geom->num_colors,&geom->sz_colors,
				(char **)&geom->colors,
				sizeof(XkbColorRec),_XkbClearColor);
    DBUG_VOID_RETURN;
}

/***====================================================================***/

void
#if NeedFunctionPrototypes
XkbFreeGeomPoints(XkbOutlinePtr outline,int first,int count,Bool freeAll)
#else
XkbFreeGeomPoints(outline,first,count,freeAll)
    XkbOutlinePtr	outline;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomPoints")
    _XkbFreeGeomLeafElems(freeAll,first,count,
				&outline->num_points,&outline->sz_points,
				(char **)&outline->points,
				sizeof(XkbPointRec));
    DBUG_VOID_RETURN;
}

/***====================================================================***/

static void
#if NeedFunctionPrototypes
_XkbClearOutline(char *outline_in)
#else
_XkbClearOutline(outline_in)
    char *	outline_in;
#endif
{
    DBUG_ENTER("_XkbClearOutline")
    XkbOutlinePtr	outline= (XkbOutlinePtr)outline_in;

    if (outline->points!=NULL)
	XkbFreeGeomPoints(outline,0,outline->num_points,True);
    DBUG_VOID_RETURN;
}

void
#if NeedFunctionPrototypes
XkbFreeGeomOutlines(XkbShapePtr	shape,int first,int count,Bool freeAll)
#else
XkbFreeGeomOutlines(shape,first,count,freeAll)
    XkbShapePtr		shape;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomOutlines")
    _XkbFreeGeomNonLeafElems(freeAll,first,count,
				&shape->num_outlines,&shape->sz_outlines,
				(char **)&shape->outlines,
				sizeof(XkbOutlineRec),_XkbClearOutline);
	
    DBUG_VOID_RETURN;
}

/***====================================================================***/

static void
#if NeedFunctionPrototypes
_XkbClearShape(char *shape_in)
#else
_XkbClearShape(shape_in)
    char *	shape_in;
#endif
{
    DBUG_ENTER("_XkbClearShape")
    XkbShapePtr	shape= (XkbShapePtr)shape_in;

    if (shape->outlines)
	XkbFreeGeomOutlines(shape,0,shape->num_outlines,True);
    DBUG_VOID_RETURN;
}

void
#if NeedFunctionPrototypes
XkbFreeGeomShapes(XkbGeometryPtr geom,int first,int count,Bool freeAll)
#else
XkbFreeGeomShapes(geom,first,count,freeAll)
    XkbGeometryPtr	geom;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomShapes")
    _XkbFreeGeomNonLeafElems(freeAll,first,count,
				&geom->num_shapes,&geom->sz_shapes,
				(char **)&geom->shapes,
				sizeof(XkbShapeRec),_XkbClearShape);
    DBUG_VOID_RETURN;
}

/***====================================================================***/

void 
#if NeedFunctionPrototypes
XkbFreeGeomOverlayKeys(XkbOverlayRowPtr row,int first,int count,Bool freeAll)
#else
XkbFreeGeomOverlayKeys(row,first,count,freeAll)
    XkbOverlayRowPtr	row;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomOverlayKeys")
    _XkbFreeGeomLeafElems(freeAll,first,count,
				&row->num_keys,&row->sz_keys,
				(char **)&row->keys,
				sizeof(XkbOverlayKeyRec));
    DBUG_VOID_RETURN;
}

/***====================================================================***/

static void
#if NeedFunctionPrototypes
_XkbClearOverlayRow(char *row_in)
#else
_XkbClearOverlayRow(row_in)
    char *	row_in;
#endif
{
    DBUG_ENTER("_XkbClearOverlayRow")
    XkbOverlayRowPtr	row= (XkbOverlayRowPtr)row_in;

    if (row->keys!=NULL)
	XkbFreeGeomOverlayKeys(row,0,row->num_keys,True);
    DBUG_VOID_RETURN;
}

void
#if NeedFunctionPrototypes
XkbFreeGeomOverlayRows(XkbOverlayPtr overlay,int first,int count,Bool freeAll)
#else
XkbFreeGeomOverlayRows(overlay,first,count,freeAll)
    XkbOverlayPtr	overlay;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomOverlayRows")
    _XkbFreeGeomNonLeafElems(freeAll,first,count,
				&overlay->num_rows,&overlay->sz_rows,
				(char **)&overlay->rows,
				sizeof(XkbOverlayRowRec),_XkbClearOverlayRow);
    DBUG_VOID_RETURN;
}

/***====================================================================***/

static void
#if NeedFunctionPrototypes
_XkbClearOverlay(char *overlay_in)
#else
_XkbClearOverlay(overlay_in)
    char *	overlay_in;
#endif
{
    DBUG_ENTER("_XkbClearOverlay")
    XkbOverlayPtr	overlay= (XkbOverlayPtr)overlay_in;

    if (overlay->rows!=NULL)
	XkbFreeGeomOverlayRows(overlay,0,overlay->num_rows,True);
    DBUG_VOID_RETURN;
}

void
#if NeedFunctionPrototypes
XkbFreeGeomOverlays(XkbSectionPtr section,int first,int	count,Bool freeAll)
#else
XkbFreeGeomOverlays(section,first,count,freeAll)
    XkbSectionPtr	section;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomOverlays")
    _XkbFreeGeomNonLeafElems(freeAll,first,count,
				&section->num_overlays,&section->sz_overlays,
				(char **)&section->overlays,
				sizeof(XkbOverlayRec),_XkbClearOverlay);
    DBUG_VOID_RETURN;
}

/***====================================================================***/

void
#if NeedFunctionPrototypes
XkbFreeGeomKeys(XkbRowPtr row,int first,int count,Bool freeAll)
#else
XkbFreeGeomKeys(row,first,count,freeAll)
    XkbRowPtr		row;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomKeys")
    _XkbFreeGeomLeafElems(freeAll,first,count,
				&row->num_keys,&row->sz_keys,
				(char **)&row->keys,
				sizeof(XkbKeyRec));
    DBUG_VOID_RETURN;
}

/***====================================================================***/

static void
#if NeedFunctionPrototypes
_XkbClearRow(char *row_in)
#else
_XkbClearRow(row_in)
    char *	row_in;
#endif
{
    DBUG_ENTER("_XkbClearRow")
    XkbRowPtr	row= (XkbRowPtr)row_in;

    if (row->keys!=NULL)
	XkbFreeGeomKeys(row,0,row->num_keys,True);
    DBUG_VOID_RETURN;
}

void
#if NeedFunctionPrototypes
XkbFreeGeomRows(XkbSectionPtr section,int first,int count,Bool freeAll)
#else
XkbFreeGeomRows(section,first,count,freeAll)
    XkbSectionPtr	section;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomRows")
    _XkbFreeGeomNonLeafElems(freeAll,first,count,
				&section->num_rows,&section->sz_rows,
				(char **)&section->rows,
				sizeof(XkbRowRec),_XkbClearRow);
    DBUG_VOID_RETURN;
}

/***====================================================================***/

static void
#if NeedFunctionPrototypes
_XkbClearSection(char *section_in)
#else
_XkbClearSection(section_in)
    char *	section_in;
#endif
{
    DBUG_ENTER("_XkbClearSection")
    XkbSectionPtr	section= (XkbSectionPtr)section_in;

    if (section->rows!=NULL)
	XkbFreeGeomRows(section,0,section->num_rows,True);
    if (section->doodads!=NULL) {
	XkbFreeGeomDoodads(section->doodads,section->num_doodads,True);
	section->doodads= NULL;
    }
    DBUG_VOID_RETURN;
}

void
#if NeedFunctionPrototypes
XkbFreeGeomSections(XkbGeometryPtr geom,int first,int count,Bool freeAll)
#else
XkbFreeGeomSections(geom,first,count,freeAll)
    XkbGeometryPtr	geom;
    int			first;
    int			count;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomSections")
    _XkbFreeGeomNonLeafElems(freeAll,first,count,
				&geom->num_sections,&geom->sz_sections,
				(char **)&geom->sections,
				sizeof(XkbSectionRec),_XkbClearSection);
    DBUG_VOID_RETURN;
}

/***====================================================================***/

static void
#if NeedFunctionPrototypes
_XkbClearDoodad(char *doodad_in)
#else
_XkbClearDoodad(doodad_in)
    char *	doodad_in;
#endif
{
    DBUG_ENTER("_XkbClearDoodad")
    XkbDoodadPtr	doodad= (XkbDoodadPtr)doodad_in;

    switch (doodad->any.type) {
   	case XkbTextDoodad: 
	    {
		if (doodad->text.text!=NULL) {
		    _XkbFree(doodad->text.text);
		    doodad->text.text= NULL;
		}
		if (doodad->text.font!=NULL) {
		    _XkbFree(doodad->text.font);
		    doodad->text.font= NULL;
		}
	    }
	    break;
   	case XkbLogoDoodad: 
	    {
		if (doodad->logo.logo_name!=NULL) {
		    _XkbFree(doodad->logo.logo_name);
		    doodad->logo.logo_name= NULL;
		}
	    }
	    break;
    }
    DBUG_VOID_RETURN;
}

void
#if NeedFunctionPrototypes
XkbFreeGeomDoodads(XkbDoodadPtr doodads,int nDoodads,Bool freeAll)
#else
XkbFreeGeomDoodads(doodads,nDoodads,freeAll)
    XkbDoodadPtr	doodads;
    int			nDoodads;
    Bool		freeAll;
#endif
{
    DBUG_ENTER("XkbFreeGeomDoodads")
    register int 		i;
    register XkbDoodadPtr	doodad;

    if (doodads) {
	for (i=0,doodad= doodads;i<nDoodads;i++,doodad++) {
	    _XkbClearDoodad((char *)doodad);
	}
	if (freeAll)
	    _XkbFree(doodads);
    }
    DBUG_VOID_RETURN;
}

void
#if NeedFunctionPrototypes
XkbFreeGeometry(XkbGeometryPtr geom,unsigned which,Bool freeMap)
#else
XkbFreeGeometry(geom,which,freeMap)
    XkbGeometryPtr	geom;
    unsigned		which;
    Bool		freeMap;
#endif
{
    DBUG_ENTER("XkbFreeGeometry")
    if (geom==NULL)
	DBUG_VOID_RETURN;
    if (freeMap)
	which= XkbGeomAllMask;
    if ((which&XkbGeomPropertiesMask)&&(geom->properties!=NULL))
	XkbFreeGeomProperties(geom,0,geom->num_properties,True);
    if ((which&XkbGeomColorsMask)&&(geom->colors!=NULL))
	XkbFreeGeomColors(geom,0,geom->num_colors,True);
    if ((which&XkbGeomShapesMask)&&(geom->shapes!=NULL))
	XkbFreeGeomShapes(geom,0,geom->num_shapes,True);
    if ((which&XkbGeomSectionsMask)&&(geom->sections!=NULL))
	XkbFreeGeomSections(geom,0,geom->num_sections,True);
    if ((which&XkbGeomDoodadsMask)&&(geom->doodads!= NULL)) {
	XkbFreeGeomDoodads(geom->doodads,geom->num_doodads,True);
	geom->doodads= NULL;
	geom->num_doodads= geom->sz_doodads= 0;
    }
    if ((which&XkbGeomKeyAliasesMask)&&(geom->key_aliases!=NULL))
	XkbFreeGeomKeyAliases(geom,0,geom->num_key_aliases,True);
    if (freeMap) {
	if (geom->label_font!=NULL) {
	    _XkbFree(geom->label_font);
	    geom->label_font= NULL;
	}
	_XkbFree(geom);
    }
    DBUG_VOID_RETURN;
}

/***====================================================================***/

static Status
#if NeedFunctionPrototypes
_XkbGeomAlloc(	XPointer *		old,
		unsigned short *	num,
		unsigned short *	total,
		int			num_new,
		Size_t			sz_elem)
#else
_XkbGeomAlloc(old,num,total,num_new,sz_elem)
    XPointer *		old;
    unsigned short *	num;
    unsigned short *	total;
    int			num_new;
    Size_t		sz_elem;
#endif
{
    DBUG_ENTER("_XkbGeomAlloc")
    if (num_new<1)
	DBUG_RETURN(Success);
    if ((*old)==NULL)
	*num= *total= 0;

    if ((*num)+num_new<=(*total))
	DBUG_RETURN(Success);

    *total= (*num)+num_new;
    if ((*old)!=NULL)
	 (*old)= (XPointer)_XkbRealloc((*old),(*total)*sz_elem);
    else (*old)= (XPointer)_XkbCalloc((*total),sz_elem);
    if ((*old)==NULL) {
	*total= *num= 0;
	DBUG_RETURN(BadAlloc);
    }

    if (*num>0) {
	char *tmp= (char *)(*old);
	bzero(&tmp[sz_elem*(*num)],(num_new*sz_elem));
    }
    DBUG_RETURN(Success);
}

#define	_XkbAllocProps(g,n) _XkbGeomAlloc((XPointer *)&(g)->properties,\
				&(g)->num_properties,&(g)->sz_properties,\
				(n),sizeof(XkbPropertyRec))
#define	_XkbAllocColors(g,n) _XkbGeomAlloc((XPointer *)&(g)->colors,\
				&(g)->num_colors,&(g)->sz_colors,\
				(n),sizeof(XkbColorRec))
#define	_XkbAllocShapes(g,n) _XkbGeomAlloc((XPointer *)&(g)->shapes,\
				&(g)->num_shapes,&(g)->sz_shapes,\
				(n),sizeof(XkbShapeRec))
#define	_XkbAllocSections(g,n) _XkbGeomAlloc((XPointer *)&(g)->sections,\
				&(g)->num_sections,&(g)->sz_sections,\
				(n),sizeof(XkbSectionRec))
#define	_XkbAllocDoodads(g,n) _XkbGeomAlloc((XPointer *)&(g)->doodads,\
				&(g)->num_doodads,&(g)->sz_doodads,\
				(n),sizeof(XkbDoodadRec))
#define	_XkbAllocKeyAliases(g,n) _XkbGeomAlloc((XPointer *)&(g)->key_aliases,\
				&(g)->num_key_aliases,&(g)->sz_key_aliases,\
				(n),sizeof(XkbKeyAliasRec))

#define	_XkbAllocOutlines(s,n) _XkbGeomAlloc((XPointer *)&(s)->outlines,\
				&(s)->num_outlines,&(s)->sz_outlines,\
				(n),sizeof(XkbOutlineRec))
#define	_XkbAllocRows(s,n) _XkbGeomAlloc((XPointer *)&(s)->rows,\
				&(s)->num_rows,&(s)->sz_rows,\
				(n),sizeof(XkbRowRec))
#define	_XkbAllocPoints(o,n) _XkbGeomAlloc((XPointer *)&(o)->points,\
				&(o)->num_points,&(o)->sz_points,\
				(n),sizeof(XkbPointRec))
#define	_XkbAllocKeys(r,n) _XkbGeomAlloc((XPointer *)&(r)->keys,\
				&(r)->num_keys,&(r)->sz_keys,\
				(n),sizeof(XkbKeyRec))
#define	_XkbAllocOverlays(s,n) _XkbGeomAlloc((XPointer *)&(s)->overlays,\
				&(s)->num_overlays,&(s)->sz_overlays,\
				(n),sizeof(XkbOverlayRec))
#define	_XkbAllocOverlayRows(o,n) _XkbGeomAlloc((XPointer *)&(o)->rows,\
				&(o)->num_rows,&(o)->sz_rows,\
				(n),sizeof(XkbOverlayRowRec))
#define	_XkbAllocOverlayKeys(r,n) _XkbGeomAlloc((XPointer *)&(r)->keys,\
				&(r)->num_keys,&(r)->sz_keys,\
				(n),sizeof(XkbOverlayKeyRec))
    
Status
#if NeedFunctionPrototypes
XkbAllocGeomProps(XkbGeometryPtr geom,int nProps)
#else
XkbAllocGeomProps(geom,nProps)
    XkbGeometryPtr	geom;
    int			nProps;
#endif
{
    DBUG_ENTER("XkbAllocGeomProps")
    Status result = _XkbAllocProps(geom,nProps);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomColors(XkbGeometryPtr geom,int nColors)
#else
XkbAllocGeomColors(geom,nColors)
    XkbGeometryPtr	geom;
    int			nColors;
#endif
{
    DBUG_ENTER("XkbAllocGeomColors")
    Status result = _XkbAllocColors(geom,nColors);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomKeyAliases(XkbGeometryPtr geom,int nKeyAliases)
#else
XkbAllocGeomKeyAliases(geom,nKeyAliases)
    XkbGeometryPtr	geom;
    int			nKeyAliases;
#endif
{
    DBUG_ENTER("XkbAllocGeomKeyAliases")
    Status result = _XkbAllocKeyAliases(geom,nKeyAliases);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomShapes(XkbGeometryPtr geom,int nShapes)
#else
XkbAllocGeomShapes(geom,nShapes)
    XkbGeometryPtr	geom;
    int			nShapes;
#endif
{
    DBUG_ENTER("XkbAllocGeomShapes")
    Status result = _XkbAllocShapes(geom,nShapes);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomSections(XkbGeometryPtr geom,int nSections)
#else
XkbAllocGeomSections(geom,nSections)
    XkbGeometryPtr	geom;
    int			nSections;
#endif
{
    DBUG_ENTER("XkbAllocGeomSections")
    Status result = _XkbAllocSections(geom,nSections);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomOverlays(XkbSectionPtr section,int nOverlays)
#else
XkbAllocGeomOverlays(section,nOverlays)
    XkbSectionPtr	section;
    int			nOverlays;
#endif
{
    DBUG_ENTER("XkbAllocGeomOverlays")
    Status result = _XkbAllocOverlays(section,nOverlays);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomOverlayRows(XkbOverlayPtr overlay,int nRows)
#else
XkbAllocGeomOverlayRows(overlay,nRows)
    XkbOverlayPtr	overlay;
    int			nRows;
#endif
{
    DBUG_ENTER("XkbAllocGeomOverlayRows")
    Status result = _XkbAllocOverlayRows(overlay,nRows);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomOverlayKeys(XkbOverlayRowPtr row,int nKeys)
#else
XkbAllocGeomOverlayKeys(row,nKeys)
    XkbOverlayRowPtr	row;
    int			nKeys;
#endif
{
    DBUG_ENTER("XkbAllocGeomOverlayKeys")
    Status result = _XkbAllocOverlayKeys(row,nKeys);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomDoodads(XkbGeometryPtr geom,int nDoodads)
#else
XkbAllocGeomDoodads(geom,nDoodads)
    XkbGeometryPtr	geom;
    int			nDoodads;
#endif
{
    DBUG_ENTER("XkbAllocGeomDoodads")
    Status result = _XkbAllocDoodads(geom,nDoodads);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomSectionDoodads(XkbSectionPtr section,int nDoodads)
#else
XkbAllocGeomSectionDoodads(section,nDoodads)
    XkbSectionPtr	section;
    int			nDoodads;
#endif
{
    DBUG_ENTER("XkbAllocGeomSectionDoodads")
    Status result = _XkbAllocDoodads(section,nDoodads);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomOutlines(XkbShapePtr shape,int nOL)
#else
XkbAllocGeomOutlines(shape,nOL)
    XkbShapePtr		shape;
    int			nOL;
#endif
{
    DBUG_ENTER("XkbAllocGeomOutlines")
    Status result = _XkbAllocOutlines(shape,nOL);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomRows(XkbSectionPtr section,int nRows)
#else
XkbAllocGeomRows(section,nRows)
    XkbSectionPtr	section;
    int			nRows;
#endif
{
    DBUG_ENTER("XkbAllocGeomRows")
    Status result = _XkbAllocRows(section,nRows);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomPoints(XkbOutlinePtr ol,int nPts)
#else
XkbAllocGeomPoints(ol,nPts)
    XkbOutlinePtr	ol;
    int			nPts;
#endif
{
    DBUG_ENTER("XkbAllocGeomPoints")
    Status result = _XkbAllocPoints(ol,nPts);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeomKeys(XkbRowPtr row,int nKeys)
#else
XkbAllocGeomKeys(row,nKeys)
    XkbRowPtr		row;
    int			nKeys;
#endif
{
    DBUG_ENTER("XkbAllocGeomKeys")
    Status result = _XkbAllocKeys(row,nKeys);
    DBUG_RETURN(result);
}

Status
#if NeedFunctionPrototypes
XkbAllocGeometry(XkbDescPtr xkb,XkbGeometrySizesPtr sizes)
#else
XkbAllocGeometry(xkb,sizes)
    XkbDescPtr		xkb;
    XkbGeometrySizesPtr	sizes;
#endif
{
    DBUG_ENTER("XkbAllocGeometry")
    XkbGeometryPtr	geom;
    Status		rtrn;

    if (xkb->geom==NULL) {
	xkb->geom= _XkbTypedCalloc(1,XkbGeometryRec);
	if (!xkb->geom)
	    DBUG_RETURN(BadAlloc);
    }
    geom= xkb->geom;
    if ((sizes->which&XkbGeomPropertiesMask)&&
	((rtrn=_XkbAllocProps(geom,sizes->num_properties))!=Success)) {
	goto BAIL;
    }
    if ((sizes->which&XkbGeomColorsMask)&&
	((rtrn=_XkbAllocColors(geom,sizes->num_colors))!=Success)) {
	goto BAIL;
    }
    if ((sizes->which&XkbGeomShapesMask)&&
	((rtrn=_XkbAllocShapes(geom,sizes->num_shapes))!=Success)) {
	goto BAIL;
    }
    if ((sizes->which&XkbGeomSectionsMask)&&
	((rtrn=_XkbAllocSections(geom,sizes->num_sections))!=Success)) {
	goto BAIL;
    }
    if ((sizes->which&XkbGeomDoodadsMask)&&
	((rtrn=_XkbAllocDoodads(geom,sizes->num_doodads))!=Success)) {
	goto BAIL;
    }
    if ((sizes->which&XkbGeomKeyAliasesMask)&&
	((rtrn=_XkbAllocKeyAliases(geom,sizes->num_key_aliases))!=Success)) {
	goto BAIL;
    }
    DBUG_RETURN(Success);
BAIL:
    XkbFreeGeometry(geom,XkbGeomAllMask,True);
    xkb->geom= NULL;
    DBUG_RETURN(rtrn);
}

/***====================================================================***/

XkbPropertyPtr
#if NeedFunctionPrototypes
XkbAddGeomProperty(XkbGeometryPtr geom,char *name,char *value)
#else
XkbAddGeomProperty(geom,name,value)
    XkbGeometryPtr	geom;
    char *		name;
    char *		value;
#endif
{
    DBUG_ENTER("XkbAddGeomProperty")
    register int i;
    register XkbPropertyPtr prop;

    if ((!geom)||(!name)||(!value))
	DBUG_RETURN(NULL);
    for (i=0,prop=geom->properties;i<geom->num_properties;i++,prop++) {
	if ((prop->name)&&(strcmp(name,prop->name)==0)) {
	    if (prop->value)
		_XkbFree(prop->value);
	    prop->value= (char *)_XkbAlloc(strlen(value)+1);
	    if (prop->value)
		strcpy(prop->value,value);
	    DBUG_RETURN(prop);
	}    
    }
    if ((geom->num_properties>=geom->sz_properties)&&
					(_XkbAllocProps(geom,1)!=Success)) {
	DBUG_RETURN(NULL);
    }
    prop= &geom->properties[geom->num_properties];
    prop->name= (char *)_XkbAlloc(strlen(name)+1);
    if (!name)
	DBUG_RETURN(NULL);
    strcpy(prop->name,name);
    prop->value= (char *)_XkbAlloc(strlen(value)+1);
    if (!value) {
	_XkbFree(prop->name);
	prop->name= NULL;
	DBUG_RETURN(NULL);
    }
    strcpy(prop->value,value);
    geom->num_properties++;
    DBUG_RETURN(prop);
}

XkbKeyAliasPtr
#if NeedFunctionPrototypes
XkbAddGeomKeyAlias(XkbGeometryPtr geom,char *aliasStr,char *realStr)
#else
XkbAddGeomKeyAlias(geom,aliasStr,realStr)
    XkbGeometryPtr	geom;
    char *		aliasStr;
    char *		realStr;
#endif
{
    DBUG_ENTER("XkbAddGeomKeyAlias")
    register int i;
    register XkbKeyAliasPtr alias;

    if ((!geom)||(!aliasStr)||(!realStr)||(!aliasStr[0])||(!realStr[0]))
	DBUG_RETURN(NULL);
    for (i=0,alias=geom->key_aliases;i<geom->num_key_aliases;i++,alias++) {
	if (strncmp(alias->alias,aliasStr,XkbKeyNameLength)==0) {
	    bzero(alias->real,XkbKeyNameLength);
	    strncpy(alias->real,realStr,XkbKeyNameLength);
	    DBUG_RETURN(alias);
	}
    }
    if ((geom->num_key_aliases>=geom->sz_key_aliases)&&
				(_XkbAllocKeyAliases(geom,1)!=Success)) {
	DBUG_RETURN(NULL);
    }
    alias= &geom->key_aliases[geom->num_key_aliases];
    bzero(alias,sizeof(XkbKeyAliasRec));
    strncpy(alias->alias,aliasStr,XkbKeyNameLength);
    strncpy(alias->real,realStr,XkbKeyNameLength);
    geom->num_key_aliases++;
    DBUG_RETURN(alias);
}

XkbColorPtr
#if NeedFunctionPrototypes
XkbAddGeomColor(XkbGeometryPtr geom,char *spec,unsigned int pixel)
#else
XkbAddGeomColor(geom,spec,pixel)
    XkbGeometryPtr	geom;
    char *		spec;
    unsigned int	pixel;
#endif
{
    DBUG_ENTER("XkbAddGeomColor")
    register int i;
    register XkbColorPtr color;

    if ((!geom)||(!spec))
	DBUG_RETURN(NULL);
    for (i=0,color=geom->colors;i<geom->num_colors;i++,color++) {
	if ((color->spec)&&(strcmp(color->spec,spec)==0)) {
	    color->pixel= pixel;
	    DBUG_RETURN(color);
	}
    }
    if ((geom->num_colors>=geom->sz_colors)&&
					(_XkbAllocColors(geom,1)!=Success)) {
	DBUG_RETURN(NULL);
    }
    color= &geom->colors[geom->num_colors];
    color->pixel= pixel;
    color->spec= (char *)_XkbAlloc(strlen(spec)+1);
    if (!color->spec)
	DBUG_RETURN(NULL);
    strcpy(color->spec,spec);
    geom->num_colors++;
    DBUG_RETURN(color);
}

XkbOutlinePtr
#if NeedFunctionPrototypes
XkbAddGeomOutline(XkbShapePtr shape,int sz_points)
#else
XkbAddGeomOutline(shape,sz_points)
    XkbShapePtr		shape;
    int			sz_points;
#endif
{
    DBUG_ENTER("XkbAddGeomOutline")
    XkbOutlinePtr	outline;

    if ((!shape)||(sz_points<0))
	DBUG_RETURN(NULL);
    if ((shape->num_outlines>=shape->sz_outlines)&&
					(_XkbAllocOutlines(shape,1)!=Success)) {
	DBUG_RETURN(NULL);
    }
    outline= &shape->outlines[shape->num_outlines];
    bzero(outline,sizeof(XkbOutlineRec));
    if ((sz_points>0)&&(_XkbAllocPoints(outline,sz_points)!=Success))
	DBUG_RETURN(NULL);
    shape->num_outlines++;
    DBUG_RETURN(outline);
}

XkbShapePtr
#if NeedFunctionPrototypes
XkbAddGeomShape(XkbGeometryPtr geom,Atom name,int sz_outlines)
#else
XkbAddGeomShape(geom,name,sz_outlines)
    XkbGeometryPtr	geom;
    Atom		name;
    int			sz_outlines;
#endif
{
    DBUG_ENTER("XkbAddGeomShape")
    XkbShapePtr	shape;
    register int	i;

    if ((!geom)||(!name)||(sz_outlines<0))
	DBUG_RETURN(NULL);
    if (geom->num_shapes>0) {
	for (shape=geom->shapes,i=0;i<geom->num_shapes;i++,shape++) {
	    if (name==shape->name)
		DBUG_RETURN(shape);
	}
    }
    if ((geom->num_shapes>=geom->sz_shapes)&&
					(_XkbAllocShapes(geom,1)!=Success))
	DBUG_RETURN(NULL);
    shape= &geom->shapes[geom->num_shapes];
    bzero(shape,sizeof(XkbShapeRec));
    if ((sz_outlines>0)&&(_XkbAllocOutlines(shape,sz_outlines)!=Success))
	DBUG_RETURN(NULL);
    shape->name= name;
    shape->primary= shape->approx= NULL;
    geom->num_shapes++;
    DBUG_RETURN(shape);
}

XkbKeyPtr
#if NeedFunctionPrototypes
XkbAddGeomKey(XkbRowPtr row)
#else
XkbAddGeomKey(row)
    XkbRowPtr		row;
#endif
{
    DBUG_ENTER("XkbAddGeomKey")
    XkbKeyPtr	key;
    if (!row)
	DBUG_RETURN(NULL);
    if ((row->num_keys>=row->sz_keys)&&(_XkbAllocKeys(row,1)!=Success))
	DBUG_RETURN(NULL);
    key= &row->keys[row->num_keys++];
    bzero(key,sizeof(XkbKeyRec));
    DBUG_RETURN(key);
}

XkbRowPtr
#if NeedFunctionPrototypes
XkbAddGeomRow(XkbSectionPtr section,int sz_keys)
#else
XkbAddGeomRow(section,sz_keys)
    XkbSectionPtr	section;
    int			sz_keys;
#endif
{
    DBUG_ENTER("XkbAddGeomRow")
    XkbRowPtr	row;

    if ((!section)||(sz_keys<0))
	DBUG_RETURN(NULL);
    if ((section->num_rows>=section->sz_rows)&&
    					(_XkbAllocRows(section,1)!=Success))
	DBUG_RETURN(NULL);
    row= &section->rows[section->num_rows];
    bzero(row,sizeof(XkbRowRec));
    if ((sz_keys>0)&&(_XkbAllocKeys(row,sz_keys)!=Success))
	DBUG_RETURN(NULL);
    section->num_rows++;
    DBUG_RETURN(row);
}

XkbSectionPtr
#if NeedFunctionPrototypes
XkbAddGeomSection(	XkbGeometryPtr	geom,
			Atom		name,
			int		sz_rows,
			int		sz_doodads,
			int		sz_over)
#else
XkbAddGeomSection(geom,name,sz_rows,sz_doodads,sz_over)
    XkbGeometryPtr	geom;
    Atom		name;
    int			sz_rows;
    int			sz_doodads;
    int			sz_over;
#endif
{
    DBUG_ENTER("XkbAddGeomSection")
    register int	i;
    XkbSectionPtr	section;

    if ((!geom)||(name==None)||(sz_rows<0))
	DBUG_RETURN(NULL);
    for (i=0,section=geom->sections;i<geom->num_sections;i++,section++) {
	if (section->name!=name)
	    continue;
	if (((sz_rows>0)&&(_XkbAllocRows(section,sz_rows)!=Success))||
	    ((sz_doodads>0)&&(_XkbAllocDoodads(section,sz_doodads)!=Success))||
	    ((sz_over>0)&&(_XkbAllocOverlays(section,sz_over)!=Success)))
	    DBUG_RETURN(NULL);
	DBUG_RETURN(section);
    }
    if ((geom->num_sections>=geom->sz_sections)&&
					(_XkbAllocSections(geom,1)!=Success))
	DBUG_RETURN(NULL);
    section= &geom->sections[geom->num_sections];
    if ((sz_rows>0)&&(_XkbAllocRows(section,sz_rows)!=Success))
	DBUG_RETURN(NULL);
    if ((sz_doodads>0)&&(_XkbAllocDoodads(section,sz_doodads)!=Success)) {
	if (section->rows) {
	    _XkbFree(section->rows);
	    section->rows= NULL;
	    section->sz_rows= section->num_rows= 0;
	}
	DBUG_RETURN(NULL);
    }
    section->name= name;
    geom->num_sections++;
    DBUG_RETURN(section);
}

XkbDoodadPtr
#if NeedFunctionPrototypes
XkbAddGeomDoodad(XkbGeometryPtr geom,XkbSectionPtr section,Atom name)
#else
XkbAddGeomDoodad(geom,section,name)
    XkbGeometryPtr	geom;
    XkbSectionPtr	section;
    Atom		name;
#endif
{
    DBUG_ENTER("XkbAddGeomDoodad")
    XkbDoodadPtr	old,doodad;
    register int	i,nDoodads;

    if ((!geom)||(name==None))
	DBUG_RETURN(NULL);
    if ((section!=NULL)&&(section->num_doodads>0)) {
	old= section->doodads;
	nDoodads= section->num_doodads;
    }
    else {
	old= geom->doodads;
	nDoodads= geom->num_doodads;
    }
    for (i=0,doodad=old;i<nDoodads;i++,doodad++) {
	if (doodad->any.name==name)
	    DBUG_RETURN(doodad);
    }
    if (section) {
	if ((section->num_doodads>=geom->sz_doodads)&&
	    (_XkbAllocDoodads(section,1)!=Success)) {
	    DBUG_RETURN(NULL);
	}
	doodad= &section->doodads[section->num_doodads++];
    }
    else {
	if ((geom->num_doodads>=geom->sz_doodads)&&
					(_XkbAllocDoodads(geom,1)!=Success))
	    DBUG_RETURN(NULL);
	doodad= &geom->doodads[geom->num_doodads++];
    }
    bzero(doodad,sizeof(XkbDoodadRec));
    doodad->any.name= name;
    DBUG_RETURN(doodad);
}

XkbOverlayKeyPtr
#if NeedFunctionPrototypes
XkbAddGeomOverlayKey(	XkbOverlayPtr		overlay,
			XkbOverlayRowPtr 	row,
			char *			over,
			char *			under)
#else
XkbAddGeomOverlayKey(overlay,row,over,under)
    XkbOverlayPtr	overlay;
    XkbOverlayRowPtr	row;
    char *		over;
    char *		under;
#endif
{
    DBUG_ENTER("XkbAddGeomOverlayKey")
    register int	i;
    XkbOverlayKeyPtr key;
    XkbSectionPtr	section;
    XkbRowPtr	row_under;
    Bool		found;

    if ((!overlay)||(!row)||(!over)||(!under))
	DBUG_RETURN(NULL);
    section= overlay->section_under;
    if (row->row_under>=section->num_rows)
	DBUG_RETURN(NULL);
    row_under= &section->rows[row->row_under];
    for (i=0,found=False;i<row_under->num_keys;i++) {
	if (strncmp(under,row_under->keys[i].name.name,XkbKeyNameLength)==0) {
	    found= True;
	    break;
	}
    }
    if (!found)
   	DBUG_RETURN(NULL); 
    if ((row->num_keys>=row->sz_keys)&&(_XkbAllocOverlayKeys(row,1)!=Success))
	DBUG_RETURN(NULL);
    key= &row->keys[row->num_keys];
    strncpy(key->under.name,under,XkbKeyNameLength);
    strncpy(key->over.name,over,XkbKeyNameLength);
    row->num_keys++;
    DBUG_RETURN(key);
}

XkbOverlayRowPtr
#if NeedFunctionPrototypes
XkbAddGeomOverlayRow(XkbOverlayPtr overlay,int row_under,int sz_keys)
#else
XkbAddGeomOverlayRow(overlay,row_under,sz_keys)
    XkbOverlayPtr	overlay;
    int 		row_under;
    int			sz_keys;
#endif
{
    DBUG_ENTER("XkbAddGeomOverlayRow")
    register int		i;
    XkbOverlayRowPtr	row;

    if ((!overlay)||(sz_keys<0))
	DBUG_RETURN(NULL);
    if (row_under>=overlay->section_under->num_rows)
	DBUG_RETURN(NULL);
    for (i=0;i<overlay->num_rows;i++) {
	if (overlay->rows[i].row_under==row_under) {
	    row= &overlay->rows[i];
	    if ((row->sz_keys<sz_keys)&&
				(_XkbAllocOverlayKeys(row,sz_keys)!=Success)) {
		DBUG_RETURN(NULL);
	    }
	    DBUG_RETURN(&overlay->rows[i]);
	}
    }
    if ((overlay->num_rows>=overlay->sz_rows)&&
				(_XkbAllocOverlayRows(overlay,1)!=Success))
	DBUG_RETURN(NULL);
    row= &overlay->rows[overlay->num_rows];
    bzero(row,sizeof(XkbOverlayRowRec));
    if ((sz_keys>0)&&(_XkbAllocOverlayKeys(row,sz_keys)!=Success))
	DBUG_RETURN(NULL);
    row->row_under= row_under;
    overlay->num_rows++;
    DBUG_RETURN(row);
}

XkbOverlayPtr
#if NeedFunctionPrototypes
XkbAddGeomOverlay(XkbSectionPtr section,Atom name,int sz_rows)
#else
XkbAddGeomOverlay(section,name,sz_rows)
    XkbSectionPtr	section;
    Atom		name;
    int			sz_rows;
#endif
{
    DBUG_ENTER("XkbAddGeomOverlay")
    register int	i;
    XkbOverlayPtr	overlay;

    if ((!section)||(name==None)||(sz_rows==0))
	DBUG_RETURN(NULL);

    for (i=0,overlay=section->overlays;i<section->num_overlays;i++,overlay++) {
	if (overlay->name==name) {
	    if ((sz_rows>0)&&(_XkbAllocOverlayRows(overlay,sz_rows)!=Success))
		DBUG_RETURN(NULL);
	    DBUG_RETURN(overlay);
	}
    }
    if ((section->num_overlays>=section->sz_overlays)&&
				(_XkbAllocOverlays(section,1)!=Success))
	DBUG_RETURN(NULL);
    overlay= &section->overlays[section->num_overlays];
    if ((sz_rows>0)&&(_XkbAllocOverlayRows(overlay,sz_rows)!=Success))
	DBUG_RETURN(NULL);
    overlay->name= name;
    overlay->section_under= section;
    section->num_overlays++;
    DBUG_RETURN(overlay);
}
