/* rexx */
/* Trace TDF file list utility */
/* R.J.Moore 4th May 1996 */
/* version 1.2 */
/*         1.1 fix MODNAME to specify dll in tdf */
/*         1.2 prepare for group and type support in DTRACE */
/*         1.3 suppress null group/type specification */
/*             suppress redundant major code overrides */
/*         1.4 fix push ecs error                      */
/*         1.5 long name support + new merlin rpn commands    */
/*         1.6 @SDD4 RPN command addiions                     */
/*         1.7 Major and Minor in hex and decimal             */
say ';TDFLST: TRACE .TDF file list utility version 1.7'
say ';Author: Richard Moore - 27th July 1998'
say ';Copyright (C) 1995,1996 IBM UK Ltd.'
say ''

!.=''
arg !.0tdffile d .

if d='DEBUG' then !.0dbg=(0=0)
else !.0dbg=(0=1)

if !.0tdffile='' then do
   say 'TDFLST tdf_file'
   exit 4
end  /* Do */

if right(!.0tdffile,4)='.TDF' then !.0tdffile=!.0tdffile|| '.TDF'

!.0tdfopen=0=1
signal on halt name haltexit

!.0rxcc=rxfuncadd('SysFileTree','REXXUTIL','SysFileTree')
call SysFileTree !.0tdffile,'x','F'
if x.0=0 then do
   say 'File' !.0tdffile 'not found'
   if !.0rxcc=0 then call rxfuncdrop 'SysFileTree'
   exit 4
end  /* Do */
if !.0rxcc=0 then call rxfuncdrop 'SysFileTree'

call initvars

x=tdfhdr()
if x<>0 then signal haltexit

do i=1 to !.0tdf_keywd_count
   x=tdfkwds(i)
   if x<>0 then signal haltexit
end /* do */

x=prtkwds(i)
if x<>0 then signal haltexit

say ";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
say " "

!.0offset=!.0tdf_data_offset
do i=1 to !.0tdf_trec_count
   x=tdfrecord(i)
   if x<>0 then signal haltexit
end /* do */


haltexit: if !.0tdfopen then x=lineout(!.0tdffile) /* close tfffile */

exit 0

tdfhdr: procedure expose !.

/* deal with tdf header */

!.0tdf_signature=getbyte(0,3)
if !.0tdf_signature<>'TDF' then do
   say 'Invalid TDF file'
   return 1
end /* do */

!.0tdf_data_lengtth=c2d(getdword(8))
!.0tdf_trec_count=c2d(getdword(12))
!.0tdf_data_offset=c2d(getdword(16))
!.0tdf_local_data_count=c2d(getdword(20))
!.0tdf_max_reclen=c2d(getdword(24))
!.0tdf_major_code=c2d(getword(28))
!.0tdf_mod_name=strip(getbyte(30,256),'t','0'x)
!.0tdf_keywd_count=c2d(getword(286))
!.0tdf_tdf_id=c2d(getword(288))

!.0offset=324

if !.0dbg then do
   say 'len 0x'd2x(!.0tdf_data_lengtth)
   say 'trec 0x'd2x(!.0tdf_trec_count)
   say 'doff 0x'd2x(!.0tdf_data_offset)
   say 'dcnt 0x'd2x(!.0tdf_local_data_count)
   say 'kwd cnt 0x'd2x(!.0tdf_keywd_count)
end /* do */

/*parse var !.0tdffile name '.'  .*/
/*parse var !.0tdf_mod_name name '.'  . */
parse var !.0tdf_mod_name name '.' ext . /* long name support */
if ext='DLL' then say "name="name
else say "name="!.0tdf_mod_name
say "major=0x"d2x(!.0tdf_major_code) ';' !.0tdf_major_code
say "logmax="!.0tdf_max_reclen
say "id="!.0tdf_tdf_id
say "vars="!.0tdf_local_data_count
say " "
!.xmajor=right(d2x(!.0tdf_major_code),4,'0')

return 0

tdfkwds: procedure expose !.
 
/* deal with the key words (goups and types) */
arg i

keyword=strip(getbyte(!.0offset,9),'t','0'x)
!.0offset=!.0offset+9
keytype=getbyte(!.0offset)
!.0offset=!.0offset+1
keyid=c2d(getword(!.0offset))
!.0offset=!.0offset+2

if !.0dbg then do
   say 'keyword' keyword
   say 'keytype' c2x(keytype)
   say 'keyid' d2x(keyid)  
end /* do */

if keytype='01'x then do
   !.0group.keyid=keyword
   k=!.0groups
   k=k+1
   !.0grplst.k=keyid
   !.0groups=k
end /* do */
else if keytype='02'x then do 
   !.0type.keyid=keyword
   k=!.0types 
   k=k+1
   !.0typlst.k=keyid
   !.0types=k
end /* do */
else do 
   say 'Invalid keytype'
   return 1
end /* do */

return 0

prtkwds: procedure expose !.
 
/* print out the key words (goups and types) */

if !.0groups<>0 then do
   k=!.0grplst.1
   do i=1 to !.0groups
      k=!.0grplst.i
      say 'groupdef='!.0group.k','k
   end /* do */
end
say " "

if !.0types<>0 then do
   k=!.0typlst.1
   do i=1 to !.0types
      k=!.0typlst.i
      say 'typedef='!.0type.k','k
   end /* do */
end /* do */
say " "
return 0


tdfrecord: procedure expose !.
 
/* deal with the minor tp record */
arg i

tp_length=c2d(getword(!.0offset))
!.0offset=!.0offset+2

tp_type_id=getword(!.0offset)
!.0offset=!.0offset+2

tp_group_id=c2d(getword(!.0offset))
!.0offset=!.0offset+2

tp_segment=c2x(getdword(!.0offset))
!.0offset=!.0offset+4

tp_offset=c2x(getdword(!.0offset))
!.0offset=!.0offset+4

tp_minor=c2x(getword(!.0offset))
!.0offset=!.0offset+2

tp_major=c2x(getword(!.0offset))
!.0offset=!.0offset+2

tp_cmdlen=c2d(getword(!.0offset))
!.0offset=!.0offset+2

tp_opcode=c2x(getbyte(!.0offset))
!.0offset=!.0offset+2

if !.0dbg then do
   say 'cmd len 0x'd2x(tp_cmdlen)
   say 'rec len 0x'd2x(tp_length)
   say 'type id 0x'c2x(tp_type_id)
   say 'group id 0x'd2x(tp_group_id)
end /* do */


say "minor=0x"tp_minor ';' x2d(tp_minor)
if tp_major<> !.xmajor then say "major=0x"tp_major
group=!.0group.tp_group_id
if group<>'' then say "group="group
type=''
if tp_type_id <>'0000'x then do 
   do i=0 to 15
      mask=d2c(2**i,2)
      seltype=c2d(bitand(tp_type_id,mask))
      if seltype<>0 then do
         if !.0dbg then say 'selected type 0x'd2x(seltype)
         if type='' then type=!.0type.seltype
         else type=type'+'!.0type.seltype
      end /* do */
   end /* do */
end /* do */

if type <>'' then say "type="type
say "object=0x"tp_segment
say "offset=0x"tp_offset
say "opcode=0x"tp_opcode


do i=1 to tp_cmdlen
   cmd=c2d(getbyte(!.0offset))
   !.0offset=!.0offset+1
   if !.0dbg then say 'rpn cmd 0x'd2x(cmd)
   instr=!.0instr.cmd
   oplen=!.0oplen.cmd
   select
      when oplen=0 then say instr
      when oplen=1 then do
         op=c2x(getbyte(!.0offset))
         say instr",0x"op
         !.0offset=!.0offset+1
         i=i+1
      end /* do */
      when oplen=2 then do
         op=c2x(getword(!.0offset))
         say instr",0x"op
         !.0offset=!.0offset+2
         i=i+2
      end /* do */
      when oplen=4 then do
         op=c2x(getdword(!.0offset))
         say instr",0x"op
         !.0offset=!.0offset+4
         i=i+4
      end /* do */
   otherwise
   say 'Invalid RPN command' d2x(cmd)
   return 1
   end  /* select */
end /* do */

say " "
say ";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
say " "

return 0     

initvars: procedure expose !.
   !.0groups=0
   !.0types=0

   !.0instr.0="push eax"        
   !.0instr.1="push ecx"        
   !.0instr.2="push edx"        
   !.0instr.3="push ebx"        
   !.0instr.4="push esp"        
   !.0instr.5="push ebp"        
   !.0instr.6="push esi"        
   !.0instr.7="push edi"        
   !.0instr.8="push es"         
   !.0instr.9="push cs"         
   !.0instr.10="push ss"        
   !.0instr.11="push ds"        
   !.0instr.12="push eflags"    
   !.0instr.13="push eip"
   !.0instr.14="push fs"
   !.0instr.15="push gs"
   !.0instr.16="push w"
   !.0instr.17="push oxs"
   !.0instr.18="push wis"
   !.0instr.19="push sis"
   !.0instr.20="log wn"
   !.0instr.21="log mrs"
   !.0instr.22="add"
   !.0instr.23="nop w17"
   !.0instr.24="nop w18"
   !.0instr.25="log ars"
   !.0instr.26="push d"
   !.0instr.27="push oxf"
   !.0instr.28="push fif"
   !.0instr.29="cnvrt fxs"
   !.0instr.30="cnvrt sxf"
   !.0instr.31="cnvrt dxs"
   !.0instr.32="cnvrt sxd"
   !.0instr.33="log dn"
   !.0instr.34="log mrf"
   !.0instr.35="log arf"
   !.0instr.36="sub"
   !.0instr.37="mul"
   !.0instr.38="pop n"
   !.0instr.39="move v"
   !.0instr.40="push v"
   !.0instr.41="inc v"
   !.0instr.42="move vii"
   !.0instr.43="push vii"
   !.0instr.44="inc vii"
   !.0instr.45="jmp n"
   !.0instr.46="jmp zn"
   !.0instr.47="jmp nn"
   !.0instr.48="jmp pn"
   !.0instr.49="abort"
   !.0instr.50="or v"
   !.0instr.51="remove"
   !.0instr.52="sysdump"
   !.0instr.53="and"
   !.0instr.54="or"
   !.0instr.55="xor"
   !.0instr.56="not"
   !.0instr.57="exit"
   !.0instr.58="procdump"
   !.0instr.59="setminw"
   !.0instr.60="setmajw"
   !.0instr.61="setmin"
   !.0instr.62="setmaj"
   !.0instr.63="xchg"           /*@sdd4*/
   !.0instr.64="call kdb"       /*@sdd4*/
   !.0instr.65="call dd"        /*@sdd4*/
   !.0instr.66="call dbg"       /*@sdd4*/
   !.0instr.67="dup n"          /*@sdd4*/
   !.0instr.68="dup"            /*@sdd4*/
   !.0instr.69="enter bif"      /*@sdd4*/
   !.0instr.70="enter wif"      /*@sdd4*/
   !.0instr.71="enter dif"      /*@sdd4*/
   !.0instr.72="enter bis"      /*@sdd4*/
   !.0instr.73="enter wis"      /*@sdd4*/
   !.0instr.74="enter dis"      /*@sdd4*/
   !.0instr.75="push bif"       /*@sdd4*/
   !.0instr.76="push bis"       /*@sdd4*/
   !.0instr.77="push dis"       /*@sdd4*/
   !.0instr.78="push wif"       /*@sdd4*/
   !.0instr.79="push tsc"       /*@sdd4*/
   !.0instr.80="push tid"       /*@sdd4*/
   !.0instr.81="push pid"       /*@sdd4*/
   !.0instr.82="push procid"    /*@sdd4*/
   !.0instr.83="push slot"      /*@sdd4*/
   !.0instr.84="push pTCB"      /*@sdd4*/
   !.0instr.85="push pPTDA"     /*@sdd4*/
   !.0instr.86="push pPCB"      /*@sdd4*/
   !.0instr.87="suspend"        /*@sdd4*/
   !.0instr.88="resume"         /*@sdd4*/
   !.0instr.89="rol n"          /*@sdd4*/
   !.0instr.90="ror n"          /*@sdd4*/
   !.0instr.91="shl n"          /*@sdd4*/
   !.0instr.92="shr n"          /*@sdd4*/
   !.0instr.93="rol"            /*@sdd4*/
   !.0instr.94="ror"            /*@sdd4*/
   !.0instr.95="shl"            /*@sdd4*/
   !.0instr.96="shr"            /*@sdd4*/
   !.0instr.97="vfa"            /*@sdd4*/
   !.0instr.98="vsa"            /*@sdd4*/
   !.0instr.99="push keax"      /*@sdd4*/
   !.0instr.100="push kecx"     /*@sdd4*/
   !.0instr.101="push kedx"     /*@sdd4*/
   !.0instr.102="push kebx"     /*@sdd4*/
   !.0instr.103="push kesp"     /*@sdd4*/
   !.0instr.104="push kebp"     /*@sdd4*/
   !.0instr.105="push kesi"     /*@sdd4*/
   !.0instr.106="push kedi"     /*@sdd4*/
   !.0instr.107="push kes"      /*@sdd4*/
   !.0instr.108="push kcs"      /*@sdd4*/
   !.0instr.109="pushk ss"      /*@sdd4*/
   !.0instr.110="pushk ds"      /*@sdd4*/
   !.0instr.111="pushk eflags"  /*@sdd4*/
   !.0instr.112="pushk eip"     /*@sdd4*/
   !.0instr.113="pushk fs"      /*@sdd4*/
   !.0instr.114="pushk gs"      /*@sdd4*/
   !.0instr.115="enter eax"     /*@sdd4*/
   !.0instr.116="enter ebx"     /*@sdd4*/
   !.0instr.117="enter ecx"     /*@sdd4*/
   !.0instr.118="enter edx"     /*@sdd4*/
   !.0instr.119="enter esi"     /*@sdd4*/
   !.0instr.120="enter edi"     /*@sdd4*/
   !.0instr.121="enter ebp"     /*@sdd4*/
   !.0instr.122="enter ds"      /*@sdd4*/
   !.0instr.123="enter es"      /*@sdd4*/
   !.0instr.124="enter fs"      /*@sdd4*/
   !.0instr.125="enter gs"      /*@sdd4*/
   !.0instr.126="push cr0"      /*@sdd4*/
   !.0instr.127="push cr2"      /*@sdd4*/
   !.0instr.128="push cr3"      /*@sdd4*/
   !.0instr.129="push cr4"      /*@sdd4*/
   !.0instr.130="push dr0"      /*@sdd4*/
   !.0instr.131="push dr1"      /*@sdd4*/
   !.0instr.132="push dr2"      /*@sdd4*/
   !.0instr.133="push dr3"      /*@sdd4*/
   !.0instr.134="push dr6"      /*@sdd4*/
   !.0instr.135="push dr7"      /*@sdd4*/
   !.0instr.136="push tr"       /*@sdd4*/
   !.0instr.137="push ldtr"     /*@sdd4*/
   !.0instr.138="push gdtr"     /*@sdd4*/
   !.0instr.139="push idtr"     /*@sdd4*/
   !.0instr.140="push msr"      /*@sdd4*/
   !.0instr.141="push pmc"      /*@sdd4*/
   !.0instr.142="push cpuid"    /*@sdd4*/

   
   !.0oplen.0=0
   !.0oplen.1=0
   !.0oplen.2=0
   !.0oplen.3=0
   !.0oplen.4=0
   !.0oplen.5=0
   !.0oplen.6=0
   !.0oplen.7=0
   !.0oplen.8=0
   !.0oplen.9=0
   !.0oplen.10=0
   !.0oplen.11=0
   !.0oplen.12=0
   !.0oplen.13=0
   !.0oplen.14=0
   !.0oplen.15=0
   !.0oplen.16=2
   !.0oplen.17=1
   !.0oplen.18=0
   !.0oplen.19=0
   !.0oplen.20=1
   !.0oplen.21=0
   !.0oplen.22=0
   !.0oplen.23=0
   !.0oplen.24=0
   !.0oplen.25=0
   !.0oplen.26=4
   !.0oplen.27=4
   !.0oplen.28=0
   !.0oplen.29=0
   !.0oplen.30=0
   !.0oplen.31=0
   !.0oplen.32=0
   !.0oplen.33=1
   !.0oplen.34=0
   !.0oplen.35=0
   !.0oplen.36=0
   !.0oplen.37=0
   !.0oplen.38=1
   !.0oplen.39=2
   !.0oplen.40=2
   !.0oplen.41=2
   !.0oplen.42=0
   !.0oplen.43=0
   !.0oplen.44=0
   !.0oplen.45=2
   !.0oplen.46=2
   !.0oplen.47=2
   !.0oplen.48=2
   !.0oplen.49=0
   !.0oplen.50=2
   !.0oplen.51=0
   !.0oplen.52=0
   !.0oplen.53=0
   !.0oplen.54=0
   !.0oplen.55=0
   !.0oplen.56=0
   !.0oplen.57=0
   !.0oplen.58=0
   !.0oplen.59=2
   !.0oplen.60=2
   !.0oplen.61=0
   !.0oplen.62=0
   !.0oplen.63=0


return

x=getbyte(!.0tdf.i.0offset)
do while x<>'0'x
   !.0tdf.i.0fmt=!.0tdf.i.0fmt || x
   !.0tdf.i.0offset=!.0tdf.i.0offset+1
   x=getbyte(!.0tdf.i.0offset)
end /* do */

return 0     


getbyte: procedure expose !.
/* read one or more bytes from the .tff file from given offset */

parse arg offset,length
if length='' then length=1
return charin(!.0tdffile,offset+1,length)

getword: procedure expose !.
/* read a word from the .tff file from given offset */

parse arg offset
x=charin(!.0tdffile,offset+1,2)
return translate('12',x,'21')

getdword: procedure expose !.
/* read a double word from the .tff file from given offset */

parse arg offset
x=charin(!.0tdffile,offset+1,4)
return translate('1234',x,'4321')
