/**************************************************************************/
/*                                                                        */
/*              IBM OS/2(tm) Directory and Security Services (DSS)        */
/*                            Version 5.0                                 */
/*                   (C) Copyright IBM Corp. 1995                         */
/*                  Licensed Materials - Property of IBM                  */
/*                                                                        */
/**************************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  HPFS386.H                                  *
 *                                                                  *
 *  This file contains information about the HPFS386 APIs.          *
 *                                                                  *
 *      Function prototypes.                                        *
 *                                                                  *
 *      Data structure templates.                                   *
 *                                                                  *
 *      Definition of special values.                               *
 *                                                                  *
 *                                                                  *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *         file depends on values defined in NETCONS.H.             *
 *                                                                  *
 ********************************************************************/




#ifdef  ANY_32_BIT
#pragma pack(1)
#endif

/****************************************************************
 *                                                              *
 *                     Function prototypes                      *
 *                                                              *
 ****************************************************************/

#ifdef ANY_32_BIT

APIRET APIENTRY
  HPFS386GETINFO(char *                   pszReserved,
                 char *                   pszInfo,
                 unsigned long            Level,
                 char *                   pbBuffer,
                 unsigned long            cbBuffer,
                 unsigned long *          pcbAvail);

APIRET APIENTRY
  HPFS386CALLOUTREGISTER(void *            pBuf,
                         unsigned long     ulBufLen,
                         unsigned long     ulLevel);

APIRET APIENTRY
  HPFS386CALLOUTDEREGISTER(void *          pBuf,
                           unsigned long   ulBufLen,
                           unsigned long   ulLevel);

#else

extern API_FUNCTION
  HPFS386GetInfo16(char LSFAR *             pszReserved,
                   char LSFAR *             pszInfo,
                   unsigned short           Level,
                   char LSFAR *             pbBuffer,
                   unsigned short           cbBuffer,
                   unsigned short LSFAR *   pcbAvail);


#endif


/****************************************************************
 *                                                              *
 *                 Special values and constants                 *
 *                                                              *
 ****************************************************************/


/****************************************************************
 *                                                              *
 *                   Data structure templates                   *
 *                                                              *
 ****************************************************************/

struct hpfs386_info_0   {
      unsigned long hi0_status;
};    /* hpfs386_info_0 */

/** Bitmap values for hi0_status **/
#define  HPFS386_NotRunning      0x00000000
#define  HPFS386_Running         0x00000001
#define  HPFS386_LocallySecure   0x00000002


/** Volume information **/

struct hpfs386_info_1 {
    unsigned long hi1_Len;              /* length of structure */
    unsigned char hi1_MajorVer;         /* Volume's version */
    unsigned char hi1_MinorVer;
    unsigned char hi1_pad1[2];
    unsigned long hi1_DrvFlag;          /* SPB flags */
    unsigned long hi1_VolFlag;          /* VOL flags */
    unsigned char hi1_Unit;             /* unit number */
    unsigned char hi1_Drive;            /* drive number */
    unsigned char hi1_LazyFlag;         /* lazy writing flag */
    unsigned char hi1_LazyPri;          /* lazy writing priority */
    unsigned long hi1_BufferIdle;       /* BufferIdle value for drive */
    unsigned long hi1_Maxage;           /* Maxage value for drive */
    unsigned long hi1_SpareDB;          /* count of Spare DBs left on volume */
    unsigned long hi1_Sectors;          /* # of sectors on volume */
    unsigned long hi1_Space;            /* space remaining (in sectors) */
    unsigned char hi1_Label[11];        /* volume label */
    unsigned char hi1_LabelLen;         /* length of volume label */
    unsigned long hi1_BootID;           /* volume serial number */
    unsigned long hi1_AltSPB;           /* alternate spare block sector */
    unsigned long hi1_HFUsed;           /* # of hotfixes in effect */
    unsigned long hi1_HFMax;            /* max # of hotfixes available */
    unsigned long hi1_DDCapabilities;   /* device driver capabilities flag */
    unsigned long hi1_Contig;           /* contiguity factor (in KBytes) */
                                        /*  single sector allocation if == 1 */
    unsigned long hi1_Reserved[3];      /* must be passed in as zero */
};      /* hpfs386_info_1 */


/** System information **/

struct hpfs386_info_2 {
    unsigned long hi2_CacheReads[2];    /* # of cache reads */
    unsigned long hi2_DiskReads[2];     /* # of synchronous disk reads */
    unsigned long hi2_LazyWrites[2];    /* # of lazy writes */
    unsigned long hi2_DiskWrites[2];    /* # of synchronous disk writes */
    unsigned long hi2_HotFixes;         /* # of hotfixes done */
    unsigned short hi2_ReadHits;        /* Read Cache Hit % */
    unsigned short hi2_WriteHits;       /* Write Cache Hit % */
};      /* hpfs386_info_2 */





struct hpfs386_callout_register_0 {
   unsigned char *   hcr0_szDDName;
#ifndef  MASM
   void *            hcr0_Callout;
#else
   unsigned long     hcr0_Callout;
#endif
   unsigned long     hcr0_fEventFlags;
   unsigned long *   hcr0_pulVersion;
}; /* hpfs386_callout_register_0 */

/** Bitmap values for hcr0_fEventFlags **/
#define  HPFS386_FSEVENT_ACCESSCONTROL    0x00000001

struct hpfs386_callout_deregister_0 {
   unsigned char *   hcd0_szDDName;
}; /* hpfs386_callout_deregister_0 */


#ifdef   ANY_32_BIT

#pragma pack()
#endif

