/**************************************************************************/
/*                                                                        */
/*              IBM OS/2(tm) Directory and Security Services (DSS)        */
/*                            Version 5.0                                 */
/*                   (C) Copyright IBM Corp. 1995                         */
/*                  Licensed Materials - Property of IBM                  */
/*                                                                        */
/**************************************************************************/

/*
 *
 *      dsserr.h - DSS error definitions
 *
 */



#define BASE_COMMON            0
#define BASE_APPLY           100

/*------------------------------------------------------------------------
**
** Common Error Codes
**
**------------------------------------------------------------------------
*/
#define DSS_Success           (BASE_COMMON)        // Success

#define DSS_ParamIsNULL       (BASE_COMMON + 1)    // Required parameter is NULL
// information message        (BASE_COMMON + 2)
#define DSS_InvalidSyntax     (BASE_COMMON + 3)    // Invalid command line syntax.
#define DSS_PathNotFound      (BASE_COMMON + 4)    // Path not found.
#define DSS_AccessDenied      (BASE_COMMON + 5)    // Access denied.
#define DSS_RegistryNotFound  (BASE_COMMON + 6)    // Unable to contact registry.
// unused                     (BASE_COMMON + 7)
#define DSS_NotEnoughMemory   (BASE_COMMON + 8)    // Unable to allocate memory.

/*------------------------------------------------------------------------
**
** ACL Apply Error Codes
**
**------------------------------------------------------------------------
*/
#define DSS_ApplyExecuteDenied            (BASE_APPLY)       // Permission to execute the apply rpc is denied.
#define DSS_ApplyInvalidParm_max_errors   (BASE_APPLY + 1)   // max_errors must be greater than zero.
#define DSS_ApplyContainerInvalid         (BASE_APPLY + 2)   // pszContainer must be in the form of "x:<path>".
#define DSS_ApplyContainerNotDirectory    (BASE_APPLY + 3)   // pszContainer must point to a directory.
#define DSS_ApplyDriveNotLocalOrFixed     (BASE_APPLY + 4)   // Apply is not supported on redirected drives or removale media.
#define DSS_ApplyEmptyManipList           (BASE_APPLY + 5)   // The manipulate command list must contain at least one entry.
#define DSS_ApplyInvalidACL               (BASE_APPLY + 6)   // The ACL must contain at least one entry that provides control permission.
#define DSS_ApplyInvalidACLType           (BASE_APPLY + 7)   // sec_acl_type is not valid.
#define DSS_ApplyInvalidPermBits          (BASE_APPLY + 8)   // Invalid permission bits specified.
#define DSS_ApplyInvalidACLEntryType      (BASE_APPLY + 9)   // Unsupported ACL entry type.
#define DSS_ApplyInvalidActionCode        (BASE_APPLY + 10)  // Invalid action code.
#define DSS_ApplyIDNotFound               (BASE_APPLY + 11)  // ID not found in registry.
#define DSS_ApplyForeignIDFormat          (BASE_APPLY + 12)  // Foreign ID cell and name are not in the same format.
#define DSS_ApplyMultipleTarget           (BASE_APPLY + 13)  // Target specified multiple times...
#define DSS_ApplyErrorBufferFull          (BASE_APPLY + 14)  // An error occurred and the error buffer is full.
#define DSS_ApplyInterrupted              (BASE_APPLY + 15)  // Apply operation aborted.
#define DSS_ApplyIUnexpectedError         (BASE_APPLY + 16)  // Unexpected error.
#define DSS_ApplyIACLWrite                (BASE_APPLY + 17)  // Error writing to to ACL database.
#define DSS_ApplyIACLRead                 (BASE_APPLY + 18)  // Error reading from ACL database.
// informational message                  (BASE_APPLY + 19)
// ...
// informational message                  (BASE_APPLY + 27)
#define DSS_ApplyErrorLoggedOnServer      (BASE_APPLY + 28)  // Apply error logged on server.
#define DSS_ApplyInvalidParm_tolerance    (BASE_APPLY + 29)  // Incorrect value specified for tolerance.

