/*************************************************************************
*
* LAST EDIT:   960301
*
* PROLOG...
*
* FILE_ID: dssapply.c
*
* parms    dssapply   <filename.ext>  [ cellname, realmname, servername ]
*            arg[1]   = filename.ext ( response filename.ext )
*
* Note: This file is a DSS sample program for propagating ACL definitions generated via DSS administration.
*       It is based on dssapply (a program used internally to test the APPLY function).
*
*---------------------------------------------------------------------------
*
* END_PROLOG
*
*
* CHANGE_HISTORY
*
*
* END_HISTORY
*
\*************************************************************************/

#define     VER_DATE    "v1.08 - 03/12/96"

#define     DSSAPPLY_NO_NAME_AND_UUID_STRINGS   100
#define     DSSAPPLY_NAME_NOT_USER              101


// OS/2 Toolkit headers
//
#define INCL_DOSFILEMGR
#define INCL_BASE

#include    <os2.h>

// C/C++ headers
//

#include    <stdio.h>
#include    <stdlib.h>
#include    <memory.h>
#include    <stdarg.h>
#include    <string.h>
#include    <assert.h>

// DCE headers
//
#define _DCE_PROTO_
#include    <dce/dce.h>
#include    <dce/id_base.h>
#include    <dce/id_epac.h>
#include    <dce/aclbase.h>

#include    <dce/dbif.h>
#include    <dce/aclif.h>
#include    <dce/binding.h>

#include    <dce/daclif.h>
#include    <dce/pgo.h>
#include    <dce/uuid.h>
#include    <dce/rpc.h>
#include    <dce/rpcexc.h>
#include    <dce/idlbase.h>
#include    <dce/secidmap.h>
//#include    <dce/sec_login.h>

// XPG/4 headers
//
#include    <nl_types.h>
#include    <locale.h>

// LS headers
//
#include    <netcons.h>
#include    <neterr.h>
#include    <errlog.h>
#include    <server.h>

#define     ANY_32_BIT
#include    <access.h>


// LSE headers
//

#include    "apply.h"
#include    "aclmrdef.h"             // acl_mgr_def.h  8.3 format  //



//#include    <netlib32.h>
//#include    <error_log.h>
//#include    <lseaclmg.h>
//#include    <acl_mgr_db.h>
//#include    <acl_mgr.h>
//#include    <sec_cred_internal.h>
//#include    <ctype.h>
//
// apply headers
//
//#include    <apply_msg.h>
//#include    <dsserr.h>

// my includes
//
#define FUNCT_RETURN    56
#define ABORT           55
#define ENTRY_ILLEGAL   9999


// determine_user_group return
#define NAME_IS_USER                100
#define NAME_IS_GROUP               101
#define NAME_NOT_USER_OR_GROUP      200


// local definitions
//
// macro definitions
#define STAT_CHK_PRINTF(st,str) \
    { if(st!=error_status_ok) printf("**%s\n",str); }

// private function definitions
void
init_globals(
    void
) ;

static error_status_t
read_input_file(
    FILE *fin
) ;

void
bld_id_to_repl(
    id_to_replace_t *   itr_p ,
    boolean32           itr_is_user ,
    boolean32           itr_old_local ,
    char *              id_old_name ,
    char *              id_old_uuid ,
    boolean32           itr_new_local ,
    char *              id_new_name ,
    char *              id_new_uuid ,
    error_status_t *    fn_err
) ;

void
bld_sec_acl_entry(
    sec_acl_entry_t *   sae_p,              // where to build it
    long int            perms ,
    sec_acl_entry_type_t   sec_acl_entry_type ,
    char *              sec_id_uuid,        // ptr to uuid, char format
    char *              sec_id_name,        // ptr to name
    char *              sec_rl_id_uuid,     // ptr to realm uuid name
    char *              sec_rl_id_name,     // ptr to realm name
    error_status_t *    fn_err
) ;

void
get_login_PAC(
    sec_id_pac_t *,
    error_status_t *
) ;

void
init_itr(
    id_to_replace_t *  itr_p
) ;

void
init_sec_acl(
    sec_acl_t *         sa_p,
    unsigned32          num_sec_acl_entries ,
    sec_acl_entry_t *   sae_p ,
    error_status_t *    f_stat
) ;

void
init_sec_acl_entries(
    sec_acl_entry_t *   sae_p,
    unsigned32          num ,
    error_status_t *    f_stat
) ;


boolean32
is_server_installed(
    error_status_t *    f_stat
) ;

void
det_sec_acl_entry_type(
    char *                  saet_cptr ,
    sec_acl_entry_type_t *  saet_p,
    error_status_t *        dseat_stat
) ;


unsigned32
parse_perms(
    char *  perms_ptr
) ;


BOOL
connect_to_server(
    handle_t    *pHandle,
    const char  *pszCell,
    const char  *pszRealm,
    const char  *pszServer
) ;

error_status_t
STAT_CHK(
    error_status_t      status_to_check ,
    char *              log_text ,
    unsigned32          action
);


void
parse_apply_err(
    unsigned32          err_code ,
    unsigned char * *   perr_text ,
    error_status_t *    pStatus
) ;

//-------   local defines

#define MAX_ERRORS      1024
#define UUID_NAME_LEN   40

#define CDS_BINDING_LOCATION     "/.:/subsys/realms/root/servers/S1"

//------------------------------------------------------------------------
// var declarations
//------------------------------------------------------------------------

// enum type of call
typedef enum {
    MANIPULATE_APPLY ,
    MANIPULATE_ENTRIES ,
    REPLACE_APPLY
} CALL_TYPE ;

// input file DATA vars
CALL_TYPE           call_type ;

char *              res_glbl_name=NULL ;
char *              cell_name=NULL ;
char *              realm_name=NULL;
char *              server_name=NULL ;

char                sec_mgr_uuid_text[UUID_NAME_LEN] ;

#ifdef              DEBUG
boolean32           debug=TRUE;
#else
boolean32           debug=FALSE;
#endif

boolean32           tolerance= APPLY_TOLERANCE_LOW;
boolean32           recursion=FALSE ;

boolean32           itr_old_local=TRUE ;
boolean32           itr_new_local=TRUE ;

unsigned32          action ;
unsigned32          max_errors=MAX_ERRORS ;
unsigned32          num_errors=0 ;

unsigned32          num_manip_entries=0 ;
unsigned32          manip_entry_num=0 ;

unsigned32          num_sec_acl_entries=0 ;
unsigned32          sec_acl_entry_num=0 ;

unsigned32          sec_acl_entry ;
unsigned32          sec_entry_type ;

error_entry_t *     err_buf_p=NULL ;

uuid_t              sec_mgr_uuid ;      // uuid_from_string(sec_mgr_uuid_text)

sec_id_t            default_realm ;
sec_acl_type_t      sec_acl_type ;

ent_entries_to_manipulate_t *   pEntEntries=NULL ;

sec_acl_list_t      sec_acl_list ;
sec_acl_t           sec_acl ;       // only 1 sec_acl_t in dce1.1
sec_acl_entry_t *   sae_p ;

FILE                *fin ;

// data structures for parsing *.inp file
struct APPLY_TXT {
    char    *txtdata ;
    int     txtix ;
} ;


// the following are the text strings recognized by the parser
// don't change numbering, these are used later by a switch!!
struct APPLY_TXT prmtext[] = {

    {"call_type",           1 },
    {"action",              2 },
    {"tolerance",           3 },
    {"recursion",           4 },
    {"res_global_name",     5 },
    {"sec_mgr_uuid" ,       6 },
    {"sec_acl_type",        7 },

    {"sec_def_realm_name",  8 },
    {"sec_def_realm_uuid",  9 },

    {"num_manip_entries",  10 },
    {"manip_entry_num",    11 },
    {"max_errors",         12 },

    {"cell_name",          15 },
    {"realm_name",         16 },
    {"server_name",        17 },

    {"itr_old_name" ,      20 },
    {"itr_old_uuid" ,      21 },
    {"itr_new_name" ,      22 },
    {"itr_new_uuid" ,      23 },
    {"itr_old_local" ,     24 },
    {"itr_new_local" ,     25 },

    {"num_sec_acl_entries", 30 },
    {"sec_acl_entry_num",  31 },
    {"sec_acl_entry_type", 32 },         // sec_acl_entry_type_t

    {"sec_acl_perms" ,     39 },

    {"sec_acl_id.name" ,   40 },
    {"sec_acl_id.uuid" ,   41 },
    {"sec_acl_rl.name" ,   42 },
    {"sec_acl_rl.uuid" ,   43 },

    {"itr_entry_end" ,     50 },          // for itr
    {"sec_acl_entry_end" , 52 },

    { NULL,                 0 },          // list terminator
} ;


// options for action:
// note that order is important; long strings with valid subsets
// must come first if list is searched linearly
struct APPLY_TXT actext[] = {
    { "rename_user",       ENTRY_RENAME_USER },
    { "rename_group",      ENTRY_RENAME_GROUP },
    { "modify_add_or_create",  ENTRY_MODIFY_ADD_OR_CREATE },
    { "modify_add",        ENTRY_MODIFY_ADD },
    { "delete",            ENTRY_DELETE },
    { "modify_delete",     ENTRY_MODIFY_DELETE },
    { "replace_or_create", ENTRY_REPLACE_OR_CREATE },
    { "replace",           ENTRY_REPLACE },
    { "create",            ENTRY_CREATE },
    { "unsupported",       ENTRY_CREATE | ENTRY_REPLACE },
    { NULL              ,  0 },  // list terminator
} ;


//***********************    main     *****************************
void
main( int argc, char *argv[] )
{
    char *          c_ptr ;
    char            user_in[80] ;
    char            f_name[CCHMAXPATH] ;
    char *          pe_text=NULL ;

    boolean         server_ready ;

    int             j ;

    error_status_t  status = rpc_s_ok ;
    error_status_t  ent_acl_status ;

    unsigned long       ulRC, ulBytes ;

    sec_login_handle_t   login_context;

    handle_t        rpc_handle;

    // initialize pgm
    printf("\nStarting DSSAPPLY: %s\n\n", VER_DATE ) ;


    if( debug ) printf(" argc=%d\n", argc ) ;


    // check command line args
    if( argc < 2 )
    {
        printf("\aSyntax = DSSAPPLY input_filename [cellname, realmname, servername]\n\n") ;
        printf("Input File not found!! \n");
        printf("The Input File is used to specify the data elements supplied to the 2\n") ;
        printf(" apply API functions: \n") ;
        printf("   ent_acl_replace_apply(), and \n");
        printf("   ent_acl_manipulate_apply() \n\n");
        printf("Instructions and examples for creating a DSSAPPLY Input File can be \n") ;
        printf("found in the accompanying file called DSSAPPLY.INP.\n") ;
        exit(1) ;
    }

    // initializations
    init_globals() ;

    // check for any command line args
    if( argc > 4 )      // assume: DSSApply responsefile  cell realm server
    {
        cell_name   = strdup( argv[2] ) ;
        realm_name  = strdup( argv[3] ) ;
        server_name = strdup( argv[4] ) ;

        if( debug )
        {
            printf("\n Command Line Parameters are: \n" ) ;
            printf(" cell = %s\n",   cell_name ) ;
            printf(" realm = %s\n",  realm_name ) ;
            printf(" server = %s\n", server_name ) ;
        }
    }

    // deal with input file
    c_ptr = strcpy( f_name, argv[1] ) ;

    fin = fopen( f_name , "r" ) ;
    if( !fin )
    {
        printf("\n**\aUnable to OPEN %s! Exiting!\n", f_name ) ;
        exit( 1 ) ;
    }

    // get & process input data
    status = read_input_file( fin ) ;

    if( !status )
    {
        // error reading input file
        printf("\n**Errors Reading Input File!!" ) ;
        printf("\n Continue Processing? ( Y/N ): \n" ) ;

        gets( user_in ) ;
        strupr( user_in ) ;
        if( user_in[0] != 'Y' )
            exit(1) ;
    }

    // establish server rpc connection
    server_ready = connect_to_server(
        &rpc_handle,
        cell_name ,
        realm_name ,
        server_name ) ;

    if( !server_ready )
    {
        printf("\n**Unable to connect to server..." ) ;
        printf("\nDo You Wish to Continue?? ( Y/N ) :" ) ;
        _flushall() ;

        gets(user_in) ;
        if( toupper( user_in[0] ) != 'Y' )
            exit(40) ;
    }

    //******   here we go !!  ***********
    num_errors = 0 ;
    ent_acl_status = rpc_s_ok ;

    TRY
    {
        // get current context
        sec_login_get_current_context(
            &login_context,
            &status);

        if( status == error_status_ok )
        {
            rpc_binding_set_auth_info(
                rpc_handle,
                server_name,
                rpc_c_protect_level_pkt_integ,
                rpc_c_authn_dce_secret,
                (rpc_auth_identity_handle_t) login_context,
                rpc_c_authz_dce,
                &status);

            if( status == error_status_ok )
            {

                switch( call_type )
                {
                case MANIPULATE_APPLY :
                    printf("\n  Calling ent_acl_manipulate_apply()..\n" ) ;

                    ent_acl_manipulate_apply(
                        rpc_handle ,
                        res_glbl_name ,
                        sec_acl_type ,
//                      ( ent_entries_to_manipulate_t * ) &ent_entries ,
                        pEntEntries ,
                        tolerance ,
                        recursion ,
                        max_errors ,
                        err_buf_p ,
                        &num_errors ,
                        &ent_acl_status ) ;

                    printf("\n ent_acl_manipulate_apply complete " ) ;

                    break ;

                case REPLACE_APPLY :
                    printf("\n  Calling ent_acl_replace_apply()..\n" ) ;

                    ent_acl_replace_apply(
                        rpc_handle ,
                        res_glbl_name ,
                        sec_acl_type ,
                        &sec_acl_list ,
                        tolerance ,
                        recursion ,
                        max_errors ,
                        err_buf_p ,
                        &num_errors ,
                        &ent_acl_status ) ;

                    printf("\n ent_acl_replace_apply complete" ) ;

                    break;
                }

                printf(" call Done!" ) ;
                printf(" Return Status=%u", ent_acl_status ) ;

                if( ent_acl_status == error_status_ok )
                    printf(" - No Errors!\n" ) ;
                else
                {
                   printf(" *** Error(s)!! ***" ) ;

                   parse_apply_err(
                      ent_acl_status,
                      &pe_text ,
                      &status ) ;

                   if( status == error_status_ok )
                   {
                      if( pe_text )
                          printf( "\n** %s\n", pe_text ) ;
                   }
                   else
                   {
                      printf( "\n**parse_apply_err() Error! Code=%u\n", status ) ;
                      printf( ", Unable to Get Error Text!\n") ;
                   }
                }

                printf("\nNumber of Error Buffer Entries=%d",num_errors ) ;
                if( num_errors > 0 )
                {
                    printf(", Error Display follows..\n" ) ;

                    // display error buffer
                    for ( j=0; j < num_errors; j++ )
                    {
                       printf("\nError Entry #%d: Error Code = %u ( %08lx Hex )",
               j, (err_buf_p+j)->error_code, (err_buf_p+j)->error_code ) ;

                       parse_apply_err(
                          (err_buf_p+j)->error_code,
                          &pe_text ,
                          &status ) ;

                       if( status == error_status_ok )
                       {
                          if( pe_text )
                              printf( "\n** %s", pe_text ) ;
                       }
                       else
                       {
                          printf( "\n**parse_apply_err() Error! Code=%u\n", status ) ;
                          printf( ", Unable to Get Error Text!\n") ;
                       }

                       printf("\nError Object: %s" , (err_buf_p+j)->resource_name);

                       if( (err_buf_p+j)->resource_name )
                          rpc_sm_client_free(
                             (err_buf_p+j)->resource_name,
                             &status ) ;
                    }
                }
                printf( "\n" ) ;

            } // if( binding set info ok )

        } // if current context ok
        else
        {
            printf("\n\a**Unable to Get Login Context! \n" ) ;
        }
    }
    CATCH_ALL
    {
       // Random exception...
       //
       switch(exc_ctx.cur_exception.kind)
       {
       case exc_kind_status_c:
          printf("\nAdditional exceptions status = %u\n", exc_ctx.cur_exception.status.status);
          break;
       case exc_kind_address_c:
          printf("\n**Additional exceptions address = %X\n",
                  exc_ctx.cur_exception.address.address);
          break;
       }
    }
    ENDTRY

    // free up any storage
    if( err_buf_p )
        free( err_buf_p ) ;
    if( pEntEntries )
        free( pEntEntries ) ;
    if( sae_p )
        free( sae_p ) ;

    if( cell_name )
        free( cell_name ) ;
    if( realm_name )
        free( realm_name ) ;
    if( server_name )
        free( server_name ) ;

    printf("\n*** DSSAPPLY Complete!! ***\n" ) ;

} // main()


/**************************************************************************
*
* read_input_file()
*
* this function reads the input file and builds data for the Apply calls
*
\*************************************************************************/
static error_status_t
read_input_file(
    FILE *  fin
)
{
#define FGETS_NUM_TO_READ 160

    char *              read_result ;
    char *              sec_def_rl_name ;
    char *              cptr ;

    char                buf[ FGETS_NUM_TO_READ+1 ] ;
    char                lcb[ FGETS_NUM_TO_READ+1 ] ;
    char                sec_def_rl_idtext[UUID_NAME_LEN] ;

    boolean32           keep_looking ;
    boolean32           sec_acl_t_ok ;
    boolean32           eetm_t_ok ;

    unsigned32          manip_entry_num_old ;
    unsigned32          sec_acl_entry_num_old ;
    unsigned32          size ;

    int                 j, cnt1, cnt2 ;
    int                 ix, ferr_cnt ;

    error_status_t      f_stat ;

    // parms for bld_utr call
    id_to_replace_t     id_to_repl ;
    char *              itr_old_name ;
    char *              itr_old_uuid_text ;
    char *              itr_new_name ;
    char *              itr_new_uuid_text ;

    // parms for bld_sec_acl
    long int            inp_perms ;

    char *              sec_id_name;
    char *              sec_id_uuid_text;
    char *              sec_rl_name;
    char *              sec_rl_uuid_text;

    sec_acl_entry_type_t    sec_acl_entry_type ;

    id_to_replace_t *   itr_p ;

    ent_entry_to_manipulate_t *     eetm_p ;

    struct  APPLY_TXT   *pt ;        // array of primary keywords
    struct  APPLY_TXT   *at ;        // array of action  keywords

    if( debug )
        printf("Read_Input_File():..\n" ) ;

    sec_acl_t_ok = FALSE ;
    eetm_t_ok = FALSE ;
    ferr_cnt = 0 ;

    while( !feof( fin ) )
    {
        for( cnt1=0; cnt1< FGETS_NUM_TO_READ; cnt1++ )
            buf[ cnt1 ] = '\0' ;

//      printf("DB: fgets()\n" ) ;

        read_result = fgets( buf, FGETS_NUM_TO_READ, fin ) ;

        if( !read_result )
        {
            if( feof(fin))
                break ;

            if( ferror( fin ) )
                printf("** Input File Error at #%d!!\n",++ferr_cnt ) ;
            continue ;
        }

        if( strstr( buf, "rem " ) || strstr( buf, "REM " ) )
        {
            printf( "Remark:%s", &buf[3] ) ;  // '\n' should terminate
            continue ;
        }

        // filter comments, etc.
        switch( buf[0] )
        {
            case '*' :
            case '/' :
            case '#' :
            case '%' :
            case ';' :
            case '\n' :
            case '\0' :
            continue ;    // loops back to top of while to get more
                          // break ;
        }

        // kill any '\n'
        for( j=0; j<strlen( buf ); j++ )
            if( buf[j] == '\n' )
                buf[j]  = '\0' ;

        strcpy( lcb, buf ) ;
        strlwr( lcb ) ;
        ix = 0 ;

        // skip any leading white space
        while( buf[ix] == ' ' && buf[ix] != '\0' )
            ix++ ;

        if( buf[ix] == '\0' )
            continue ;

        pt = prmtext ;          // set ptr

        keep_looking = TRUE ;
        // search for primary keywords
        while( ( pt->txtdata != '\0' ) && keep_looking )
        {
            // search for input keyword - note all is in lower case!!
            if( strstr( buf+ix, pt->txtdata ) )
            {
                keep_looking = FALSE ;  // got a match

                // adjust current ptr to parm if applicable
                switch( pt->txtix )
                {
                case 50 :        // these have no parms
                case 52 :
                    break ;

                default :       // process to start of 2nd parm
                    // skip to blank
                    while( buf[ix] != ' ' && buf[ix] != '\0' && buf[ix] != '\n' )
                        ix++ ;
                    // skip to beginning of 2nd token
                    while( buf[ix] == ' '  && buf[ix] != '\0' &&
                           buf[ix] != '\n' )
                        ix++ ;
                    // ix now pts to 2nd token, or eol
                    if( buf[ix] == '\0' || buf[ix] == '\n' )
                        continue ;      // oops!!
                 break ;
                }

                // process data item - note that illegal parms needed for errs
                switch( pt->txtix )
                {
                case 1 :        // apply call type
                    if( !strncmp( lcb+ix, "manip", 5 ) )
                        call_type = MANIPULATE_APPLY ;
                    else if( !strncmp( lcb+ix, "repl", 4 ) )
                        call_type = REPLACE_APPLY ;
                    else
                    {
                        printf("\n**\aUnknown Call TYPE!! Processing Halted..\n");
                        printf("\nBuf=%s\n",buf);
                    }
                    break ;

                case 2 :  // search for action code
                    action = ENTRY_ILLEGAL ;
                    at = actext ;  // set ptr to start of array

                    cptr = lcb+ix ;

                    while( at->txtdata != '\0' )
                    {
                        if( !strncmp( cptr, at->txtdata, strlen(at->txtdata) ) )
                        {
                            action = at->txtix ;  // action enums
                            break ;  // successful exit from while
                        }
                        else
                            at++ ;
                    }
                    if( action == ENTRY_ILLEGAL )
                        printf("\n\a**Action Code NOT Found!!") ;
                    break ;

                case 3 :        // tolerance
                    tolerance = APPLY_TOLERANCE_LOW;
                    if( !strncmp( lcb+ix, "yes", 3 ) )
                        tolerance = APPLY_TOLERANCE_MED;
                    break ;

                case 4 :        // recursion
                    recursion = FALSE ;
                    if( !strncmp( lcb+ix, "yes", 3 ) )
                        recursion = TRUE ;
                    break ;

                case 5 :    // resource global name
                    res_glbl_name = strdup( buf+ix ) ;
                    break ;

                case 6 :    // sec_mgr_uuid
                    strcpy( sec_mgr_uuid_text , buf+ix ) ;
                    break ;

                case 7 :    // sec_acl_type ( obj, def_obj, def_cont )
                    switch( lcb[ix] )
                    {
                        case 'o' :
                            sec_acl_type = sec_acl_type_object ;
                            break ;

                        case 'd' :
                            switch( lcb[ix+4] )
                            {
                                case 'o' :
                            sec_acl_type = sec_acl_type_default_object ;
                                    break ;
                                case 'c' :
                            sec_acl_type = sec_acl_type_default_container ;
                                    break ;
                            }
                            break ;

                        default :  // error case
                            sec_acl_type = sec_acl_type_default_container |
                                           sec_acl_type_default_object ;
                            break ;
                    }
                    break ;

                case 8 : // sec_def_realm_name ( optional )
                    default_realm.name = strdup( buf+ix ) ;
                    break ;

                case 9 : // sec_def_realm_uuid ( optional )
                    uuid_from_string( buf+ix, &default_realm.uuid, &f_stat ) ;
                    STAT_CHK_PRINTF( f_stat,
                        "uuid_from_string(&default_realm.uuid) Error!") ;
                    break ;

                case 10 : // num_manip_entries
                    // get storage for manip_entries
                    sscanf( buf+ix, "%d", &num_manip_entries ) ;

                    // get storage for ent_entries block
                size = sizeof(ent_entries_to_manipulate_t) +
                       sizeof(ent_entry_to_manipulate_t) * (num_manip_entries-1) ;

                pEntEntries = malloc( size ) ;
/***
                    if( pEntEntries == NULL )
    printf( "\n**Unable to malloc() for %d ent_entries!\n",num_manip_entries ) ;
                    else
                    {
**/
                        eetm_t_ok = TRUE ;
//                  }
                    break ;

                case 11 : // manip_entry_num; starts manip data gathering
                    action = ENTRY_ILLEGAL ;
                    itr_old_name      = NULL ;
                    itr_old_uuid_text = NULL ;
                    itr_old_local     = TRUE ;
                    itr_new_name      = NULL ;
                    itr_new_uuid_text = NULL ;
                    itr_new_local     = TRUE ;

                    sec_acl_entry_type = sec_acl_e_type_extended ;
                    sec_id_name      = NULL ;
                    sec_id_uuid_text = NULL ;
                    sec_rl_name      = NULL ;
                    sec_rl_uuid_text = NULL ;
                    inp_perms = 0 ;

                    manip_entry_num_old = manip_entry_num ;
                    sscanf( buf+ix, "%d", &manip_entry_num ) ;
                    if( manip_entry_num > num_manip_entries )
                        manip_entry_num = manip_entry_num_old ;
                    break ;

                case 12 : // max_errors
                    sscanf( buf+ix, "%d", &max_errors ) ;
                    break ;

                case 15 :    // cell name
                    if( cell_name )
                        free( cell_name ) ;
                    cell_name = strdup( buf+ix ) ;
                    break ;

                case 16 :    // realm name
                    realm_name = strdup( buf+ix ) ;
                    break ;

                case 17 :    // server name
                    server_name = strdup( buf+ix ) ;
                    break ;

                case 20 : // itr_old_name
                    itr_old_name = strdup( buf+ix ) ;
                    break ;

                case 21 : // itr_old_uuid
                    itr_old_uuid_text = strdup( buf+ix ) ;
                    break ;

                case 22 : // itr_new_name
                    itr_new_name = strdup( buf+ix ) ;
                    break ;

                case 23 : // itr_new_uuid
                    itr_new_uuid_text = strdup( buf+ix ) ;
                    break ;

                case 24 : // itr_old_local
                    if( !strncmp( lcb+ix, "true", 4 ) )
                        itr_old_local = TRUE ;
                    else if( !strncmp( lcb+ix, "false", 5 ) )
                        itr_old_local = FALSE ;
                    break ;

                case 25 : // itr_new_local
                    if( !strncmp( lcb+ix, "true", 4 ) )
                        itr_new_local = TRUE ;
                    else if( !strncmp( lcb+ix, "false", 5 ) )
                        itr_new_local = FALSE ;
                    break ;

                case 30 : // num_sec_acl_entries - this assumes replace only
                    sscanf( buf+ix, "%d", &num_sec_acl_entries ) ;

                    // get storage block for sec_acl_entry_t block
                    sae_p = (sec_acl_entry_t *)
                        malloc( num_sec_acl_entries * sizeof(sec_acl_entry_t) ) ;
/***
                    if( sae_p == NULL )
    printf( "\n**Unable to malloc() for %d sec_acl_entries!\n",num_sec_acl_entries ) ;
                    else
****/
                    {
                        // initialize sec_acl_list_t, etc.
                        sec_acl_list.num_acls = 1 ;
                        sec_acl_list.sec_acls[0] = &sec_acl ;

                        init_sec_acl(
                            &sec_acl ,
                            num_sec_acl_entries,
                            sae_p,
                            &f_stat ) ;

                        init_sec_acl_entries(
                            sae_p ,
                            num_sec_acl_entries,
                            &f_stat ) ;
                        sec_acl_t_ok = TRUE ;
                    }
                    break ;

                case 31 : // sec_acl_entry_num; starts sec_acl data input
                    sec_acl_entry_type = sec_acl_e_type_extended ;
                    sec_id_name      = NULL ;
                    sec_id_uuid_text = NULL ;
                    sec_rl_name      = NULL ;
                    sec_rl_uuid_text = NULL ;
                    inp_perms = 0 ;

                    sec_acl_entry_num_old = sec_acl_entry_num ;
                    sscanf( buf+ix, "%d", &sec_acl_entry_num ) ;
                    if( sec_acl_entry_num <= num_sec_acl_entries )
                    {
                        action = ENTRY_ILLEGAL ;
                    }
                    else
                        sec_acl_entry_num = sec_acl_entry_num_old ;
                    break ;

                case 32 : // sec_acl_entry_type_t
                    det_sec_acl_entry_type(
                        lcb+ix ,
                        &sec_acl_entry_type ,
                        &f_stat ) ;
                    break ;

                case 39 : // sec_acl_perms
                    inp_perms = parse_perms( lcb+ix ) ;
                    break ;

                case 40 : // sec_acl_id.name
                    sec_id_name = strdup( buf+ix ) ;
                    break ;

                case 41 : // sec_acl_id.uuid
                    sec_id_uuid_text = strdup( buf+ix ) ;
                    break ;

                case 42 : // sec_acl_rl.name
                    sec_rl_name = strdup( buf+ix ) ;
                    break ;

                case 43 : // sec_acl_rl.uuid
                    sec_rl_uuid_text = strdup( buf+ix ) ;
                    break ;

                case 50 : // itr entry_end; build itr structure
                    if( eetm_t_ok )
                    {
     pEntEntries->entries_to_change_list[manip_entry_num-1].action = action ;

                        switch( action )
                        {
                            case ENTRY_RENAME_USER :
        init_itr( &pEntEntries->entries_to_change_list[manip_entry_num-1].target.user ) ;

                            bld_id_to_repl(
        &pEntEntries->entries_to_change_list[manip_entry_num-1].target.user,
                                TRUE ,
                                itr_old_local ,
                                itr_old_name ,
                                itr_old_uuid_text ,
                                itr_new_local ,
                                itr_new_name ,
                                itr_new_uuid_text ,
                                &f_stat ) ;
                            break ;

                            case ENTRY_RENAME_GROUP :
        init_itr( &pEntEntries->entries_to_change_list[manip_entry_num-1].target.group ) ;

                            bld_id_to_repl(
        &pEntEntries->entries_to_change_list[manip_entry_num-1].target.group,
                                FALSE ,
                                itr_old_local ,
                                itr_old_name ,
                                itr_old_uuid_text ,
                                itr_new_local ,
                                itr_new_name ,
                                itr_new_uuid_text ,
                                &f_stat ) ;
                            break ;

                            default :
                                // invalid action for itr build!!
                            break ;
                        }
                    }
                    break ;

                case 52 : // sec_acl_entry_end
                    switch( call_type )
                    {
                        case REPLACE_APPLY :
                            if( sec_acl_t_ok )
                            {
                                bld_sec_acl_entry(
                                    sae_p + ( sec_acl_entry_num-1 ),
                                    inp_perms ,
                                    sec_acl_entry_type ,
                                    sec_id_uuid_text,
                                    sec_id_name,
                                    sec_rl_uuid_text,
                                    sec_rl_name,
                                    &f_stat ) ;

                                STAT_CHK_PRINTF(f_stat,"Error Blding SEC Entry!");
                            }

                            break ;

                        case MANIPULATE_APPLY :
                            if( eetm_t_ok )
                            {
        pEntEntries->entries_to_change_list[manip_entry_num-1].action = action ;

                            init_sec_acl_entries(
        &pEntEntries->entries_to_change_list[manip_entry_num-1].target.sec_acl,
                                1 ,
                                &f_stat ) ;

                            bld_sec_acl_entry(
        &pEntEntries->entries_to_change_list[manip_entry_num-1].target.sec_acl,
                                inp_perms ,
                                sec_acl_entry_type ,
                                sec_id_uuid_text,
                                sec_id_name,
                                sec_rl_uuid_text,
                                sec_rl_name,
                                &f_stat ) ;

                            STAT_CHK_PRINTF(f_stat,"Error Blding SEC Entry!");
                            }

                            break ;

                        default :
                            break ;

                    }
                    break ;

                default :
                printf("\n**Error in read_input_file(): Unknown switch(pt->txtix)=%d!\n",
                                pt->txtix);
                    break ;

                } // switch( pt->txtix )

            }
            else
                pt++ ;

        } // while

    } // while !eof()

    fclose( fin ) ;

    printf("\nFile Read Successful Completion!\n" ) ;

    // allocate error buffer
    err_buf_p = (error_entry_t *) malloc( max_errors * sizeof(error_entry_t) ) ;

/***
    // assertions
    assert( err_buf_p ) ;
    assert( res_glbl_name ) ;

    assert( cell_name ) ;
    assert( realm_name ) ;
    assert( server_name ) ;
***/
    // setup for proper call

    switch( call_type )
    {
    case MANIPULATE_APPLY :
        pEntEntries->num_entries_to_change  = num_manip_entries ;
        break ;

    case REPLACE_APPLY :
        // sec_acl initialization done by init_sec_acl()
        break;
    }

    return TRUE ;

} // read_input_file


/**************************************************************************
*
* bld_sec_acl_entry() - Build sec_acl_entry in sec_acl_entry_t structure
*
* note:     if sec_id_uuid & sec_id_name are both null, then error
*           likewise for realm.
*           if sec_id_uuid is null, then use pgo stuff to get uuid
*           if sec_rl_id_uuid is null, then use ?? to get uuid
*
\*************************************************************************/
void
bld_sec_acl_entry(
    sec_acl_entry_t *   sae_p,              // where to build it
    long int            perms ,
    sec_acl_entry_type_t   sec_acl_entry_type ,
    char *              sec_id_uuid,        // ptr to uuid, char string
    char *              sec_id_name,        // ptr to name
    char *              sec_rl_id_uuid,     // ptr to realm uuid char string
    char *              sec_rl_id_name,     // ptr to realm name
    error_status_t *    pStatus
)
{
    error_status_t  c_stat ;

    int             usr_grp_status ;
    uuid_t          nil_uuid ;

    *pStatus = error_status_ok ;

    sae_p->perms = perms ;
    sae_p->entry_info.entry_type = sec_acl_entry_type ;

    switch( sae_p->entry_info.entry_type )
    {
    case sec_acl_e_type_extended :
        // punt this for now !!
        sae_p->entry_info.tagged_union.extended_info = NULL ;
        return ;
//      break ;

    case sec_acl_e_type_user_obj :       // all done for these
    case sec_acl_e_type_group_obj :
    case sec_acl_e_type_other_obj :
    case sec_acl_e_type_mask_obj :
    case sec_acl_e_type_unauthenticated :
    case sec_acl_e_type_any_other :
    case sec_acl_e_type_user_obj_deleg :
    case sec_acl_e_type_group_obj_deleg :
    case sec_acl_e_type_other_obj_deleg :
    case sec_acl_e_type_any_other_deleg :
        return ;
//      break ;

    default :
        break ;
    }

    // get a nil uuid
    uuid_create_nil( &nil_uuid, pStatus );
    STAT_CHK_PRINTF( *pStatus,"uuid_create_nil() Failure!") ;

    // check for name or uuid
    if( sec_id_uuid == NULL && sec_id_name == NULL )
    {
        *pStatus = DSSAPPLY_NO_NAME_AND_UUID_STRINGS ;
        return ;
    }

    switch( sae_p->entry_info.entry_type )
    {
    case sec_acl_e_type_foreign_user :
    case sec_acl_e_type_foreign_group :
    case sec_acl_e_type_for_user_deleg :
    case sec_acl_e_type_for_group_deleg :
        if( sec_rl_id_uuid == NULL && sec_rl_id_name == NULL )
        {
            *pStatus = DSSAPPLY_NO_NAME_AND_UUID_STRINGS ;
            return ;
        }
        break ;

    default :
        break ;
    }

    switch( sae_p->entry_info.entry_type )
    {
    case sec_acl_e_type_user :          // sec_id_t    id
    case sec_acl_e_type_group :
    case sec_acl_e_type_foreign_other :
    case sec_acl_e_type_user_deleg :
    case sec_acl_e_type_group_deleg :
    case sec_acl_e_type_for_other_deleg :
        if( sec_id_uuid )
        {
            uuid_from_string( sec_id_uuid,
                &sae_p->entry_info.tagged_union.id.uuid, &c_stat ) ;
            STAT_CHK_PRINTF( c_stat,
                "uuid_from_string(&sae_p->entry_info.id.uuid) Error!") ;
        }
        else
            sae_p->entry_info.tagged_union.id.uuid = nil_uuid ;

        if ( sec_id_name != NULL )
            sae_p->entry_info.tagged_union.id.name = sec_id_name ;
        break ;

    case sec_acl_e_type_foreign_user :  // sec_id_foreign_t  foreign_id
    case sec_acl_e_type_foreign_group :
    case sec_acl_e_type_for_user_deleg :
    case sec_acl_e_type_for_group_deleg :

        if( sec_id_uuid )
        {
            uuid_from_string( sec_id_uuid,
                &sae_p->entry_info.tagged_union.foreign_id.id.uuid, &c_stat ) ;
            STAT_CHK_PRINTF( c_stat,
                "uuid_from_string(&sae_p->entry_info.foreign_id.id.uuid) Error!") ;
        }
        else
            sae_p->entry_info.tagged_union.id.uuid = nil_uuid ;

        if ( sec_id_name != NULL )
            sae_p->entry_info.tagged_union.foreign_id.id.name=sec_id_name;

        if( sec_rl_id_uuid )
        {
            uuid_from_string( sec_rl_id_uuid,
                &sae_p->entry_info.tagged_union.foreign_id.realm.uuid, &c_stat ) ;
            STAT_CHK_PRINTF( c_stat,
                "uuid_from_string(&sae_p->entry_info.foreign_id.realm.uuid) Error!") ;
        }
        else
            sae_p->entry_info.tagged_union.foreign_id.realm.uuid = nil_uuid ;

        if ( sec_rl_id_name != NULL )
            sae_p->entry_info.tagged_union.foreign_id.realm.name=sec_rl_id_name;
        break ;

    default :
        break ;

    } //switch

    *pStatus = error_status_ok ;

    return ;

} // bld_sec_acl_entry()


/**************************************************************************
*
* det_sec_acl_entry_type()
*
* note:
*
\*************************************************************************/
void
det_sec_acl_entry_type(
    char *                 saet_cptr ,      // sec_acl_entry_type text
    sec_acl_entry_type_t * saet_p,          // sec_acl_entry_type num
//  sec_acl_entry_class_t *  pSae_class,    // sec_acl_entry class
    error_status_t *       dsaet_stat
)
{
    // note that order is important for substring descrimination
    if( !strncmp( saet_cptr, "user_obj_deleg", 14 ) )
        *saet_p = sec_acl_e_type_user_obj_deleg  ;
    else if( !strncmp( saet_cptr, "user_obj", 8 ) )
        *saet_p = sec_acl_e_type_user_obj ;
    else if( !strncmp( saet_cptr, "user_deleg", 10 ) )
        *saet_p = sec_acl_e_type_user_deleg ;
    else if( !strncmp( saet_cptr, "user", 4 ) )
        *saet_p = sec_acl_e_type_user ;

    else if( !strncmp( saet_cptr, "group_obj_deleg", 15 ) )
        *saet_p = sec_acl_e_type_group_obj_deleg ;
    else if( !strncmp( saet_cptr, "group_obj", 9 ) )
        *saet_p = sec_acl_e_type_group_obj ;
    else if( !strncmp( saet_cptr, "group_deleg", 11 ) )
        *saet_p = sec_acl_e_type_group_deleg ;
    else if( !strncmp( saet_cptr, "group", 5 ) )
        *saet_p = sec_acl_e_type_group ;

    else if( !strncmp( saet_cptr, "other_obj_deleg", 15 ) )
        *saet_p = sec_acl_e_type_other_obj_deleg ;
    else if( !strncmp( saet_cptr, "other_obj", 9 ) )
        *saet_p = sec_acl_e_type_other_obj ;

    else if( !strncmp( saet_cptr, "any_other_deleg", 15 ) )
        *saet_p = sec_acl_e_type_any_other_deleg ;
    else if( !strncmp( saet_cptr, "any_other", 9 ) )
        *saet_p = sec_acl_e_type_any_other ;

    else if( !strncmp( saet_cptr, "for_user_deleg", 14 ) )
        *saet_p = sec_acl_e_type_for_user_deleg ;
    else if( !strncmp( saet_cptr, "foreign_user", 12 ) )
        *saet_p = sec_acl_e_type_foreign_user ;

    else if( !strncmp( saet_cptr, "foreign_other", 13 ) )
        *saet_p = sec_acl_e_type_foreign_other ;
    else if( !strncmp( saet_cptr, "for_other_deleg", 15 ) )
        *saet_p = sec_acl_e_type_for_other_deleg ;

    else if( !strncmp( saet_cptr, "for_group_deleg", 15 ) )
        *saet_p = sec_acl_e_type_for_group_deleg ;
    else if( !strncmp( saet_cptr, "foreign_group", 13 ) )
        *saet_p = sec_acl_e_type_foreign_group ;

    else if( !strncmp( saet_cptr, "extended", 8 ) )
        *saet_p = sec_acl_e_type_extended ;
    else if( !strncmp( saet_cptr, "mask_obj", 8 ) )
        *saet_p = sec_acl_e_type_mask_obj ;
    else if( !strncmp( saet_cptr, "unauthenticated", 15 ) )
        *saet_p = sec_acl_e_type_unauthenticated ;
    else
    {
        *dsaet_stat = ~error_status_ok ;   // none found
        *saet_p = sec_acl_e_type_unauthenticated |  // gen illegal
                  sec_acl_e_type_mask_obj ;
    }

    return ;

} // det_sec_acl_entry_type()


/**************************************************************************
*
* parse_perms()
*
* note:     as of 951201, new mappings will occur:
*
*               a -> w
*               c -> i
*               l -> r
*               p -> c
*
\*************************************************************************/
unsigned32
parse_perms(
    char *  perms_ptr
)
{
    int         j ;
    unsigned32  new_perms ;

    new_perms = 0 ;

    if( !strncmp( perms_ptr, "none", 4 ) )
        return 0 ;

    // locate & copy permissions
    if( *perms_ptr != '\0' )
    {
        // parse permissions
        for( j=0; *(perms_ptr+j) != '\0' ; j++ )
        {
            switch( *(perms_ptr+j) )
            {
                case '\n' :
                case ':' :
                case ' ' :
                    break ;
                case 'c' :
                case 'C' :
//                  new_perms |= sec_acl_perm_create ;
                    new_perms |= sec_acl_perm_control ;
                    break ;
                case 'd' :
                case 'D' :
                    new_perms |= sec_acl_perm_delete ;
                    break ;
                case 'i' :
                case 'I' :
                    new_perms |= sec_acl_perm_insert ;
                    break ;
                case 'r' :
                case 'R' :
                    new_perms |= sec_acl_perm_read ;
                    break ;
                case 't' :
                case 'T' :
                    new_perms |= sec_acl_perm_test ;
                    break ;
                case 'w' :
                case 'W' :
                    new_perms |= sec_acl_perm_write ;
                    break ;
                case 'x' :
                case 'X' :
                    new_perms |= sec_acl_perm_execute ;
                    break ;
                case 'z' :  // set an invalid permission
                case 'Z' :
                    printf("\n**Invalid Permission=Z being Set!" ) ;
                    new_perms |= sec_acl_perm_attribute ;
                    break ;
                default :
                    printf("\n**Invalid Permission='%c' in Perms='%s' NOT Set!\n",
                            *(perms_ptr+j), perms_ptr ) ;

            } // switch

        } // for

    } // if

    return( new_perms ) ;

} // parse_perms()


/**************************************************************************
*
* bld_id_to_repl()
*
\*************************************************************************/
void
bld_id_to_repl(
    id_to_replace_t *   itr_p ,
    boolean32           itr_is_user ,          // user or group
    boolean32           itr_old_local ,
    char *              id_old_name ,
    char *              id_old_uuid ,
    boolean32           itr_new_local ,
    char *              id_new_name ,
    char *              id_new_uuid ,
    error_status_t *    pStatus
)
{
    uuid_t      nil_uuid ;
    int         usr_grp_status ;

    uuid_create_nil( &nil_uuid, pStatus );
    STAT_CHK_PRINTF( *pStatus,"uuid_create_nil() Failure!") ;

    if( (id_old_name == NULL && id_old_uuid == NULL) ||
        (id_new_name == NULL && id_new_uuid == NULL) )
    {
        *pStatus = DSSAPPLY_NO_NAME_AND_UUID_STRINGS ;
        return ;
    }

    itr_p->fOldIsLocal = itr_old_local ;
    if( itr_old_local )
    {
        itr_p->old_id.local.name = id_old_name ;
        if( id_old_uuid )
        {
            uuid_from_string( id_old_uuid, &itr_p->old_id.local.uuid, pStatus )  ;
            STAT_CHK_PRINTF( *pStatus,"uuid_from_string(id_old_uuid) Failure!") ;
        }
        else
            itr_p->old_id.local.uuid = nil_uuid ;
    }
    else
    {
        itr_p->old_id.foreign.id.name = id_old_name ;
        if( id_old_uuid )
        {
            uuid_from_string( id_old_uuid, &itr_p->old_id.foreign.id.uuid, pStatus )  ;
            STAT_CHK_PRINTF( *pStatus,"uuid_from_string(id_old_uuid) Failure!") ;
        }
        else
            itr_p->old_id.foreign.id.uuid = nil_uuid ;
    }

    itr_p->fNewIsLocal = itr_new_local ;
    if( itr_new_local )
    {
        itr_p->new_id.local.name = id_new_name ;
        if( id_new_uuid )
        {
            uuid_from_string( id_new_uuid, &itr_p->new_id.local.uuid, pStatus )  ;
            STAT_CHK_PRINTF( *pStatus,"uuid_from_string(id_new_uuid) Failure!") ;
        }
        else
            itr_p->new_id.local.uuid = nil_uuid ;
    }
    else
    {
        itr_p->new_id.foreign.id.name = id_new_name ;
        if( id_new_uuid )
        {
            uuid_from_string( id_new_uuid, &itr_p->new_id.foreign.id.uuid, pStatus )  ;
            STAT_CHK_PRINTF( *pStatus,"uuid_from_string(id_new_uuid) Failure!") ;
        }
        else
            itr_p->new_id.foreign.id.uuid = nil_uuid ;
    }

    *pStatus = error_status_ok ;

    return ;

} // bld_id_to_repl()


/**************************************************************************
*
* init_globals()
*
\*************************************************************************/
void
init_globals( void )
{
    int             j ;
    error_status_t  Status ;

    sec_id_pac_t    PAC ;

    num_errors = 0 ;

    num_sec_acl_entries = 0 ;

    sec_acl_type       = sec_acl_type_object ;

    // reset pointers

    pEntEntries     = NULL ;
    sae_p           = NULL ;
    err_buf_p       = NULL ;

    // initialize arrays
    for( j=0; j< UUID_NAME_LEN; j++ )
        sec_mgr_uuid_text[ j ] = '\0' ;

    // create sec_acl_manager_type uuid
    strcpy( sec_mgr_uuid_text, DIR_ACL_MGR ) ;     // from acl_mgr_def.h
    uuid_from_string( sec_mgr_uuid_text, &sec_mgr_uuid, &Status ) ;
    STAT_CHK_PRINTF( Status, "uuid_from_String(sec_mgr_uuid) Failed!\n" ) ;

    // get default realm
    get_login_PAC(
        &PAC,
        &Status ) ;
    if( Status != error_status_ok )
    {
        printf("\n**\aget_login_PAC() Error!!\n" ) ;
        DosExit(0,0);
    }
    else
        default_realm = PAC.realm ;

} // init_globals()


/**************************************************************************
*
* init_itr() - initialize itr structure
*
\*************************************************************************/
void
init_itr(
    id_to_replace_t *  itr_p
)
{

} // init_itr()


/**************************************************************************
*
* init_sec_acl() - initialize sec_acl[]
*
* note: there is assumed to be only on sec_acl_t in a sec_acl_list
*
\*************************************************************************/
void
init_sec_acl(
    sec_acl_t *         sa_p ,          // ptr to sec_acl_t to initialize
    unsigned32          num_sec_acl_entriess ,
    sec_acl_entry_t *   sae_p ,
    error_status_t *    isa_stat
)
{
    // create default realm data
/*****
    // note will later use default realm data from login pac
    uuid_create_nil( &( sa_p->default_realm.uuid ), isa_stat );
    STAT_CHK_PRINTF( *isa_stat,"uuid_create_nil() Failure!") ;

    sa_p->default_realm.name = NULL ;
*******/
    sa_p->default_realm = default_realm ;

    sa_p->sec_acl_manager_type = sec_mgr_uuid ;

    sa_p->num_entries = num_sec_acl_entries ;
    sa_p->sec_acl_entries = sae_p ;

} // init_sec_acl()


/**************************************************************************
*
* init_sec_acl_entries() - initialize sec_acl_entries[]
*
\*************************************************************************/
void
init_sec_acl_entries(
    sec_acl_entry_t *   sae_p ,              // ptr to sec_acl_
    unsigned32          num_sec_acl_entries ,
    error_status_t *    isae_stat
)
{
    int             j ;

    for( j=0; j<num_sec_acl_entries; j++ )
    {
        ( sae_p+j )->perms = 0 ;

        ( sae_p+j )->entry_info.entry_type = sec_acl_e_type_foreign_user ;

        uuid_create_nil( &( ( sae_p+j )->
                entry_info.tagged_union.foreign_id.id.uuid), isae_stat );
        STAT_CHK_PRINTF( *isae_stat,"uuid_create_nil() failure!") ;

        ( sae_p+j )->entry_info.tagged_union.foreign_id.id.name = NULL ;

        uuid_create_nil( &( ( sae_p+j )->
                entry_info.tagged_union.foreign_id.realm.uuid), isae_stat );
        STAT_CHK_PRINTF( *isae_stat,"uuid_create_nil() failure!") ;

        ( sae_p+j )->entry_info.tagged_union.foreign_id.realm.name = NULL ;

        ( sae_p+j )->entry_info.entry_type = sec_acl_e_type_extended ;
    }

    return ;

} // init_sec_acl_entries()



/**************************************************************************
*
*   parse_apply_err()
*
\*************************************************************************/
void
parse_apply_err(
    unsigned long       ulMsgID,
    unsigned char * *   ppErr_Text ,
    error_status_t *    pStatus
)
{



   char           szError[512];
   unsigned long  ulMsgLen=0;
   APIRET         apiRC=0;

   // Get OS/2 message text...
   //
   apiRC = DosGetMessage(NULL, 0, szError, sizeof(szError), ulMsgID,
                                 "dss.msg", &ulMsgLen);

   if (apiRC == NO_ERROR || apiRC == ERROR_MR_MSG_TOO_LONG)
   {

      szError[ulMsgLen-2] = '\0';
      printf("\n ** ERROR **\n %s \n", szError);
   }
   else
   {
      // Something went wrong getting the message text.  At least
      // show the message number...
      //
      printf("Can't get DSS.MSG file (%d).  \n", ulMsgID );
   }

   *pStatus = error_status_ok ;

   return;

} // parse_apply_err()


/**************************************************************************
*
*   get_login_PAC()
*
\*************************************************************************/
void
get_login_PAC(
    sec_id_pac_t *  PAC,
    error_status_t * st
)
{
    error_status_t          stat ;

    sec_login_net_info_t    net_info, *net_info_p ;

    sec_login_handle_t      login_context ;

    if( debug )
        printf("\n  sec_login_get_current_context().." ) ;

    sec_login_get_current_context(
        &login_context,
        &stat ) ;

    if( stat != error_status_ok )
    {
        printf("\n** sec_login_get_current_context() Error! " ) ;
        *st = ~error_status_ok ;
        return ;
    }
    else {
           sec_login_certify_identity(login_context,&stat);
           if( stat!=error_status_ok) {
                                       *st = ~error_status_ok ;
                                       return;
                                      }
           if( debug )
                   printf(" Done! " ) ;

         }


    net_info_p = NULL ;         // to keep compiler happy

    if( debug )
       printf("\n  sec_login_inquire_net_info().." ) ;
    sec_login_inquire_net_info(
        login_context,
        &net_info,         // call allocates storage
        &stat ) ;

    if( stat != error_status_ok )
    {
        printf("\n** sec_login_inquire_net_info() Error! " ) ;
        *st = ~error_status_ok ;
        return ;
    }
    else
        if( debug )
            printf(" Done! " ) ;

    if( debug )
        printf("\n Login PAC Retrieved OK. ") ;

    net_info_p = &net_info;

    *PAC = net_info_p->pac ;

    sec_login_free_net_info( net_info_p ) ;

    *st = error_status_ok ;

} // get_login_PAC()



/**************************************************************************
*
* make_uuid_string()
* input  = uuid(12345678-c761-11ce-8b50-10005a7b953d)\n
* output = 12345678-c761-11ce-8b50-10005a7b953d
*
\*************************************************************************/
void
make_uuid_string(
    char *      str
)
{
    char *  cptr ;
    int     j ;

    while( *str++ != '(' ) ;

    cptr = str ;

    j = 0 ;
    while( *( str + j ) != ')' )
        j++ ;

    *( str + j ) = '\0' ;

    return ;

} // make_uuid_string()


/***************************************************************************

    the following code from applyc.cpp

***************************************************************************/

/*------------------------------------------------------------------------
**
** connect_to_server
**
**------------------------------------------------------------------------
*/
BOOL
connect_to_server(
    handle_t    *pHandle,
    const char  *pszCell,
    const char  *pszRealm,
    const char  *pszServer
)
{
   char                 szCDSBindingLocation[1000];
   rpc_ns_handle_t      import_context;
   unsigned32           status = rpc_s_ok;

   sprintf(szCDSBindingLocation, "/.../%s/subsys/realms/%s/servers/%s",
            pszCell, pszRealm, pszServer);

   if( debug )
       printf("\nCDS Binding Loc=%s",szCDSBindingLocation ) ;

   // Begin the binding import loop.
   //
   rpc_ns_binding_import_begin(
       rpc_c_ns_syntax_default,
       (unsigned char *)szCDSBindingLocation,
       apply_v1_0_c_ifspec,
       NULL,
       &import_context,
       &status);

   if (status == rpc_s_ok)
   {
      // Import the first (and only) server...
      //
      rpc_ns_binding_import_next(
         import_context,
         pHandle,
         &status);

      // Delete the import context.
      //
      if (status == rpc_s_ok)
      {
         rpc_ns_binding_import_done(
            &import_context,
            &status);

         if (status != rpc_s_ok)
            printf("\n**rpc_ns_binding_import_done() Failed!\n");
      }
      else
         printf("\n**rpc_ns_binding_import_next() Failed!\n");
   }
   else
      printf("\n**rpc_ns_binding_import_begin() Failed\n");

   return (status == rpc_s_ok);
}


/****************************************************************************\
*
* function:   STAT_CHK()
*
* synopsis:
*
* note:
*
\***************************************************************************/
error_status_t
STAT_CHK(
    error_status_t      status_to_check ,
    char *              log_text ,
    unsigned32          action
)
{
    if( status_to_check != error_status_ok )
    {
//        LogError( &status_to_check, log_text ) ;

        if( action == ABORT )
            exit( status_to_check ) ;
    }

    return( status_to_check ) ;

} // STAT_CHK()




//**************************  end of DSSAPPLY.C  *************************
