/**************************************************************************/
/*                                                                        */
/*              IBM OS/2(tm) Directory and Security Services (DSS)        */
/*                            Version 5.0                                 */
/*                   (C) Copyright IBM Corp. 1995                         */
/*                  Licensed Materials - Property of IBM                  */
/*                                                                        */
/**************************************************************************/
/********************************************************************/

/********************************************************************
 *								    *
 *  About this file ...  CONFIG.H				    *
 *								    *
 *  This file contains information about the NetConfig APIs.	    *
 *								    *
 ********************************************************************/


#ifdef  ANY_32_BIT
#pragma pack(1)
#endif


#ifndef NETCONFIG_INCLUDED

#define NETCONFIG_INCLUDED


/****************************************************************
 *                                                              *
 *              Function prototypes                             *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  NetConfigGet ( const unsigned char LSFAR *     pszComponent,
                 const unsigned char LSFAR *     pszParameter,
                 unsigned char LSFAR *           pbBuffer,
                 unsigned short                  usBuffer,
                 unsigned short LSFAR *          pusParmlen );

extern API_FUNCTION
  NetConfigGetAll ( const unsigned char LSFAR *     pszComponent,
                    unsigned char LSFAR *           pbBuffer,
                    unsigned short                  usBuffer,
                    unsigned short LSFAR *          pusReturned,
                    unsigned short LSFAR *          pusTotalAvail );

extern API_FUNCTION
  NetConfigGet2 ( const unsigned char LSFAR *     pszServer,
                  const unsigned char LSFAR *     pszReserved,
                  const unsigned char LSFAR *     pszComponent,
                  const unsigned char LSFAR *     pszParameter,
                  const unsigned char LSFAR *     pbBuffer,
                  unsigned short                  usBuffer,
                  unsigned short LSFAR *          pusParmlen );

extern API_FUNCTION
  NetConfigGetAll2 ( const unsigned char LSFAR *     pszServer,
                     const unsigned char LSFAR *     pszReserved,
                     const unsigned char LSFAR *     pszComponent,
                     unsigned char LSFAR *           pbBuffer,
                     unsigned short                  usBuffer,
                     unsigned short LSFAR *          pusReturned,
                     unsigned short LSFAR *          pusTotalAvail );

/* -------------------- Begin F2359 --------------------- */

#ifdef PURE_32
/****************************************************************
 *                                                              *
 *       Function prototypes for "pure" 32-bit code             *
 *                                                              *
 ****************************************************************/

extern API32_FUNCTION
  Net32ConfigGet2 ( const unsigned char * pszServer,
                    const unsigned char * pszReserved,
                    const unsigned char * pszComponent,
                    const unsigned char * pszParameter,
                    const unsigned char * pbBuffer,
                    unsigned long         ulBuffer,
                    unsigned long       * pulParmlen );

extern API32_FUNCTION
  Net32ConfigGetAll2 ( const unsigned char * pszServer,
                       const unsigned char * pszReserved,
                       const unsigned char * pszComponent,
                       unsigned char       * pbBuffer,
                       unsigned long         ulBuffer,
                       unsigned long       * pulReturned,
                       unsigned long       * pulTotalAvail );
#endif /* PURE_32 */

/* --------------------  End  F2359 --------------------- */


#endif /* NETCONFIG_INCLUDED */

#ifdef ANY_32_BIT
/*#pragma linkage (NetConfigGet, far16 pascal) */
/*#pragma linkage (NetConfigGetAll, far16 pascal) */
/*#pragma linkage (NetConfigGet2, far16 pascal) */
/*#pragma linkage (NetConfigGetAll2, far16 pascal) */
#pragma pack()
#endif

