
/*****************************************************************************/
 /*                                                                           */
 /* PROLOG                                                                    */
 /*                                                                           */
 /* COMPONENT_NAME: header file for Acl_Mgr_Init()                      */
 /*                                                                           */
 /* FILE_ID: acl_mgr_def.h                                                       */
 /*                                                                           */
 /* ORIGINS:  This code is new function for LS Enterprise, It uses external   */
 /* and internal IBM LAN Server and external DCE 1.1 interfaces               */
 /*                                                                           */
 /* (C) COPYRIGHT International Business Machines Corp. 1995                  */
 /* All Rights Reserved                                                       */
 /* Licensed Materials - Property of IBM                                      */
 /*    10H9754                                                                */
 /*                                                                           */
 /* US Government User Restricted Rights - Use, duplication                   */
 /* or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
 /*                                                                           */
 /* END_PROLOG                                                                */
 /*                                                                           */
 /*****************************************************************************/

 /*****************************************************************************/
 /*                                                                           */
 /* CHANGE_HISTORY                                                            */
 /*                                                                           */
 /* MARK  DEF/FEA  YYMMMDD RELEASE WHO  DESCRIPTION                           */
 /* ------------------------------------------------------------------------- */
 /*                95Jun10       1.0   Yi Fang   Initial code                         */
 /*       32367    96Feb26         YF  GetFileAttr SMB success w/any perm.   */
 /*                                                                           */
 /* END_HISTORY                                                               */
 /*                                                                           */
 /*****************************************************************************/

 /*
  * WARNING:  Changes to the permission sets in this file must be mirrored
  * to netihas2.h which is the file used by 16 bit code to define the perms
  * without dce defines
  */




/* define permissions */
#define sec_acl_perm_permission sec_acl_perm_control
#define sec_acl_perm_create sec_acl_perm_insert
#define sec_acl_perm_attribute sec_acl_perm_write
#define sec_acl_perm_list sec_acl_perm_read
#define sec_acl_perm_manage sec_acl_perm_unused_00000100
#define sec_acl_perm_view sec_acl_perm_read
#define sec_acl_perm_local_admin_only sec_acl_perm_write

#define DIR_MAX_PERM  sec_acl_perm_write|sec_acl_perm_insert|\
                                sec_acl_perm_delete|sec_acl_perm_control|\
                                sec_acl_perm_test|sec_acl_perm_read
#define FILE_MAX_PERM sec_acl_perm_delete|\
                       sec_acl_perm_execute|sec_acl_perm_control|\
                       sec_acl_perm_test|sec_acl_perm_read|\
                       sec_acl_perm_write

#define MEDIA_MAX_PERM  sec_acl_perm_insert|sec_acl_perm_delete|\
                        sec_acl_perm_execute|sec_acl_perm_control|\
                        sec_acl_perm_test|sec_acl_perm_read |\
                        sec_acl_perm_write


#define PRINT_MAX_PERM  sec_acl_perm_insert|sec_acl_perm_delete|\
                        sec_acl_perm_manage|sec_acl_perm_control|\
                        sec_acl_perm_test|sec_acl_perm_read

#define COMM_MAX_PERM sec_acl_perm_delete|sec_acl_perm_manage|\
                                sec_acl_perm_control|\
                                sec_acl_perm_test|sec_acl_perm_read|\
                                sec_acl_perm_write

#define SERVER_MAX_PERM sec_acl_perm_delete|sec_acl_perm_read|\
                        sec_acl_perm_manage|sec_acl_perm_control|\
                        sec_acl_perm_test|sec_acl_perm_write|\
                        sec_acl_perm_execute

#define PIPE_MAX_PERM     sec_acl_perm_delete|sec_acl_perm_control|\
                          sec_acl_perm_test | sec_acl_perm_read|\
                          sec_acl_perm_write

#define DEV_DIR_MAX_PERM     sec_acl_perm_control|sec_acl_perm_insert|\
                             sec_acl_perm_test|sec_acl_perm_manage


#define AUDIT_MAX_PERM       sec_acl_perm_control|sec_acl_perm_read|\
                             sec_acl_perm_write|sec_acl_perm_test

#define ANY_PERM (unsigned long)-1 //32367a

/* define data base file name */

#define BY_ACL  "db_acl.acl"
#define BY_OBJECT  "db_obj.acl"
#define BY_NAME  "db_nam.acl"

#define ERR_CHECK_RET(st) {if (st !=error_status_ok) return;}

/* define server uuid used for register acl mgr interface */
#define SER_UUID "fbcd3781-74c6-11ce-8fa0-08005acd42a8"

/* define all acl mgr uuid */
#define DIR_ACL_MGR   "632e4dc1-78d1-11ce-87bc-08005acd42a8"
#define FILE_ACL_MGR   "92fa53a0-78d1-11ce-a206-08005acd42a8"
#define MEDIA_ACL_MGR  "5c2289e1-74f5-11ce-9b6a-08005acd42a8"
#define PRINT_ACL_MGR   "abbb4d41-78d1-11ce-b531-08005acd42a8"
#define COMM_ACL_MGR   "c20182e1-78d1-11ce-b7b2-08005acd42a8"
#define SERVER_ACL_MGR   "d8e66980-78d1-11ce-8377-08005acd42a8"
#define PIPE_ACL_MGR   "2ecf6980-79a6-11ce-9069-08005acd42a8"
#define DEV_DIR_ACL_MGR  "736b3ce0-1e92-11cf-ad01-08005a72d461"
#define AUDIT_ACL_MGR  "cf52c3c0-1e92-11cf-a96b-08005a72d461"
#define SIZE 300
#define SIZE1 1024




