/**********************************************************************
*                                                                     *
* DRUSRCTL.DLL                                                        *
*                                                                     *
* Copyright C. Wohlgemuth 2001                                        *
*                                                                     *
* This Rexx DLL contains a new  controls for use with                 *
* DrDialog.                                                           *
*                                                                     *
**********************************************************************/
/*
 * Copyright (c) Chris Wohlgemuth 2001 
 * All rights reserved.
 *
 * http://www.geocities.com/SiliconValley/Sector/5785/
 * http://www.os2world.com/cdwriting
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The authors name may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */



/* Include files */

#define  INCL_PM
#define  INCL_WINSYS
#define  INCL_DOS
#define  INCL_DOSMISC
#define  INCL_DOSNMPIPES
#define  INCL_ERRORS
#define  INCL_REXXSAA
#define  _DLL
#define  _MT
#include <os2.h>
#include <rexxsaa.h>
#include <malloc.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

#define DRDCTRL_VERSION "0.1.1"

/* Window ULONG for the percent bar */
#define QWL_PERCENT 4 /* The location in the window words to store the percent value */
#define QWL_TEXTPTR 8 /* The ptr to our percent bar text */

/* Window ULONG for the bubble help control */
#define QWL_DELAY        4
/*#define QWL_TEXTPTR 8   already defined for percent bar */
#define QWL_SHOWTIME     12
#define QWL_SHOWBUBBLE   16
#define QWL_DELTAPOS     20
#define BUBBLEHELP_ULONGS 24

#define BUBBLE_DELAY_TIMER  1
#define BUBBLE_SHOW_TIMER   2
#define BUBBLE_CHECK_TIMER  3



#define xVal  12      /* x-distance of Bubble */
#define yVal  8      /* y-distance of Bubble */

/*********************************************************************/
/*  Declare all exported functions as REXX functions.                */
/*********************************************************************/

RexxFunctionHandler DRCtrlDropFuncs;
RexxFunctionHandler DRCtrlRegister;
RexxFunctionHandler DRCtrlLoadFuncs;
RexxFunctionHandler DRCtrlVersion;

/*********************************************************************/
/* RxFncTable                                                        */
/*   Array of names of the REXXUTIL functions.                       */
/*   This list is used for registration and deregistration.          */
/*********************************************************************/

static PSZ  RxFncTable[] =
   {
      "DRCtrlRegister",
      "DRCtrlLoadFuncs",
      "DRCtrlDropFuncs",
      "DRCtrlVersion",
   };

/*********************************************************************/
/* Numeric Error Return Strings                                      */
/*********************************************************************/

#define  NO_UTIL_ERROR    "0"          /* No error whatsoever        */
#define  ERROR_NOMEM      "2"          /* Insufficient memory        */
#define  ERROR_FILEOPEN   "3"          /* Error opening text file    */

/*********************************************************************/
/* Alpha Numeric Return Strings                                      */
/*********************************************************************/

#define  ERROR_RETSTR   "ERROR:"
#define  EMPTY_RETSTR   ""

/*********************************************************************/
/* Numeric Return calls                                              */
/*********************************************************************/

#define  INVALID_ROUTINE 40            /* Raise Rexx error           */
#define  VALID_ROUTINE    0            /* Successful completion      */

/*********************************************************************/
/* Some useful macros                                                */
/*********************************************************************/

#define BUILDRXSTRING(t, s) { \
  strcpy((t)->strptr,(s));\
  (t)->strlength = strlen((s)); \
}

/*
 * Paint the percent bar and print the label if necessary.
 */

static VOID _paintPercent(int iPercent, HWND hwnd, HPS hps)
{
    POINTL  ptl, ptlText, aptlText[TXTBOX_COUNT];
    RECTL   rcl, rcl2;
    BOOL    bVertical=FALSE;
    CHAR  * ptrChr=NULL;

    WinQueryWindowRect(hwnd, &rcl);
    /* Check if it's a vertical percent bar */
    if(rcl.xRight<rcl.yTop)
      bVertical=TRUE;
    else
      bVertical=FALSE;

    GpiCreateLogColorTable(hps, 0, LCOLF_RGB, 0, 0, NULL);
    
    /* Draw the bar border */
    WinDrawBorder(hps, &rcl, 1,1,0,0, 0x800);    
    
    rcl.xLeft = 1;
    rcl.xRight -= 1;
    rcl.yBottom = 1;
    rcl.yTop -= 1;
    
    if((ptrChr=(char*)WinQueryWindowPtr(hwnd,QWL_TEXTPTR))!=NULLHANDLE)
      {
        /* Text size */
        GpiQueryTextBox(hps, strlen(ptrChr), ptrChr,
                        TXTBOX_COUNT, (PPOINTL)&aptlText);
   
        ptlText.x = rcl.xLeft+(((rcl.xRight-rcl.xLeft)
                                 -(aptlText[TXTBOX_BOTTOMRIGHT].x-aptlText[TXTBOX_BOTTOMLEFT].x))/2);
        ptlText.y = 3 + rcl.yBottom+(((rcl.yTop-rcl.yBottom)
                                      -(aptlText[TXTBOX_TOPLEFT].y-aptlText[TXTBOX_BOTTOMLEFT].y))/2);
      }

    if(!bVertical) {
      rcl2.xLeft = rcl.xLeft;
      rcl2.xRight = (rcl.xRight-rcl.xLeft)*iPercent/100; 
      rcl2.yBottom = rcl.yBottom;
      rcl2.yTop = rcl.yTop-1;
      rcl.xLeft=rcl2.xRight+1;
    }
    else {
      rcl2.xLeft = rcl.xLeft;
      rcl2.xRight = rcl.xRight-1;
      rcl2.yBottom = rcl.yBottom;
      rcl2.yTop = (rcl.yTop-rcl.yBottom)*iPercent/100; 
      rcl.yBottom=rcl2.yTop+1;
    }

    /* Background */
    WinFillRect(hps, &rcl,
                WinQuerySysColor(HWND_DESKTOP, SYSCLR_DIALOGBACKGROUND, 0));

    /* Percentbar */
    if ((rcl2.xRight > rcl2.xLeft && !bVertical)||(rcl2.yTop > rcl2.yBottom && bVertical)) {
      ULONG ulBG;

      /* Find color. This color is the background color set within DrDialog */
      if(!WinQueryPresParam(hwnd, PP_BACKGROUNDCOLOR, PP_BACKGROUNDCOLORINDEX, NULL, sizeof(ulBG),
                        &ulBG, QPF_ID2COLORINDEX|QPF_NOINHERIT ))
        ulBG=0x002020ff;
      GpiSetColor(hps,ulBG );

      rcl2.yBottom+=1;
      rcl2.xLeft+=1;

      WinFillRect(hps, &rcl2, ulBG);
      WinDrawBorder(hps, &rcl2, 1,1,0,0, 0x400);
    }

    /* now print the percentage */
    if(ptrChr!=NULLHANDLE)
      {
        ULONG ulFG; 
       
        /* Find color. This color is the foreground color set within DrDialog */
        if(!WinQueryPresParam(hwnd, PP_FOREGROUNDCOLOR, PP_FOREGROUNDCOLORINDEX, NULL, sizeof(ulFG),
                              &ulFG, QPF_ID2COLORINDEX|QPF_NOINHERIT ))
          ulFG=WinQuerySysColor(HWND_DESKTOP, SYSCLR_BUTTONDEFAULT, 0);
        GpiSetColor(hps,ulFG );
        GpiMove(hps, &ptlText);
        GpiCharString(hps, strlen(ptrChr), ptrChr);
      }
}


/*
 * This is the window proc for the percentbar control
 */

static MRESULT EXPENTRY _percentBarProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  MRESULT mrc;
  HPS hps;
  PWNDPARAMS pwp;
  int iPercent;
  RECTL rcl;

  switch(msg) {

  case WM_SETWINDOWPARAMS:
    {
      pwp=(PWNDPARAMS)mp1;
      if(pwp->fsStatus==WPM_TEXT) {
        /* The text changed */
        char *ptr;
        char *ptr2;

        /* Get the current percent value for the control */
        iPercent=atol(pwp->pszText);
        if(iPercent>100)
          iPercent=100;
        if(iPercent<0)
          iPercent=0;

        /* Check if there is some text for the bar */
        if((ptr=strchr(pwp->pszText, '#'))!=NULLHANDLE) {
          /* Everything after the '#' is treated as the label */
          if((ptr2=(char*)WinQueryWindowPtr(hwnd,QWL_TEXTPTR))!=NULLHANDLE)
            free(ptr2); /* Free the old text */
          WinSetWindowPtr(hwnd,QWL_TEXTPTR, NULLHANDLE);
          if(*(ptr++)!=0) {
            /* There's additional text to print */
            if((ptr2=malloc(strlen(ptr)+1))!=NULLHANDLE) {
              strcpy(ptr2,ptr);
              WinSetWindowPtr(hwnd,QWL_TEXTPTR,ptr2);
            }
          }
        }
        mrc = WinDefWindowProc(hwnd, msg, mp1, mp2);
        WinSetWindowULong(hwnd, QWL_PERCENT,iPercent);
        WinInvalidateRect(hwnd, NULLHANDLE,TRUE);
        return mrc;
      }
      break;
    }
  case WM_DESTROY:
    {
      char *ptrText;
      /* Free the memory allocated for the text */
      if((ptrText=(char*)WinQueryWindowPtr(hwnd,QWL_TEXTPTR))!=NULLHANDLE)
        free(ptrText);
      break;
    }
  case WM_PRESPARAMCHANGED:
    /* The color or the font has changed  */
    /* Force a repaint of the percent bar */
    mrc = WinDefWindowProc(hwnd, msg, mp1, mp2);
    if(LONGFROMMP(mp1)==PP_FOREGROUNDCOLOR)
      WinInvalidateRect(hwnd, NULLHANDLE,TRUE);
    else if(LONGFROMMP(mp1)==PP_BACKGROUNDCOLOR)
      WinInvalidateRect(hwnd, NULLHANDLE,TRUE);
    else if(LONGFROMMP(mp1)==PP_FONTNAMESIZE)
      WinInvalidateRect(hwnd, NULLHANDLE,TRUE);
    return mrc;
  case WM_PAINT:
    {
      hps=WinBeginPaint(hwnd, NULLHANDLE, NULLHANDLE);
      _paintPercent(WinQueryWindowULong(hwnd,QWL_PERCENT), hwnd, hps);
      WinEndPaint(hps);
    return (MRESULT) FALSE;
    }
  
  default:
    break;
  }

  mrc = WinDefWindowProc(hwnd, msg, mp1, mp2);
  return (mrc);
}

static MRESULT EXPENTRY _bubbleHelpProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  MRESULT mrc;
  HPS hps;
  PWNDPARAMS pwp;
  RECTL rcl;
  static HWND hwndBubbleWindow;
  POINTL ptl;
  POINTL aptlPoints[TXTBOX_COUNT];

  switch(msg) {
  case WM_SETWINDOWPARAMS:
    {
      pwp=(PWNDPARAMS)mp1;
      if(pwp->fsStatus==WPM_TEXT) {
        /* The text changed */
        char *ptr;
        char *ptr2;

        if((ptr2=(char*)WinQueryWindowPtr(hwnd,QWL_TEXTPTR))!=NULLHANDLE)
          free(ptr2); /* Free the old text */
        WinSetWindowPtr(hwnd,QWL_TEXTPTR, NULLHANDLE);

        if(strlen(pwp->pszText)) {
          /* Set the delay */
          if(strstr(pwp->pszText,"#delay")!=NULLHANDLE) {
            ptr=pwp->pszText;
            ptr+=strlen("#delay");
            WinSetWindowULong(hwnd,QWL_DELAY, atol(ptr));
            return (MRESULT)0;
          }
          /* Set the time to show the bubble */
          if(strstr(pwp->pszText,"#show")!=NULLHANDLE) {
            ptr=pwp->pszText;
            ptr+=strlen("#show");
            WinSetWindowULong(hwnd,QWL_SHOWTIME, atol(ptr));
            return (MRESULT)0;
          }
#if 0
          if(strstr(pwp->pszText,"#deltax")!=NULLHANDLE) {
            ULONG ulDelta;
            SHORT dx;
            ptr=pwp->pszText;
            ptr+=strlen("#deltax");
            dx=atoi(ptr);
            ulDelta=WinQueryWindowULong(hwnd, QWL_DELTAPOS) & 0x0000FFFF;
            WinSetWindowULong(hwnd,QWL_DELTAPOS, (ULONG)((LONG)dx));
            return (MRESULT)0;
          }

          if(strstr(pwp->pszText,"#deltay")!=NULLHANDLE) {
            ULONG ulDelta;
            ptr=pwp->pszText;
            ptr+=strlen("#deltay");
            ulDelta=WinQueryWindowULong(hwnd, QWL_DELTAPOS)& 0xFFFF0000;
            WinSetWindowULong(hwnd,QWL_DELTAPOS, (atol(ptr)&0x0000FFFF)+ulDelta);
            return (MRESULT)0;
          }
#endif
          /* There's text to save */
          if((ptr2=malloc(strlen(pwp->pszText)))!=NULLHANDLE) {
            strcpy(ptr2, pwp->pszText);
            WinSetWindowPtr(hwnd,QWL_TEXTPTR,ptr2);
            WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_DELAY_TIMER);  /* stop the running timer */
            WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_SHOW_TIMER);  /* stop the running timer */
            WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_CHECK_TIMER);
            if(hwndBubbleWindow){
              WinDestroyWindow(hwndBubbleWindow);/*  close the bubblewindow  */
              hwndBubbleWindow=NULLHANDLE;
            }
            /* Start a timer */
            WinStartTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_DELAY_TIMER,
                          WinQueryWindowULong(hwnd,QWL_DELAY)); /* New timer for delay */
            WinSetWindowULong(hwnd, QWL_SHOWBUBBLE,1);/* Mark that we have bubble text */
          }
        }
        else {
          /* No text */
            WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_DELAY_TIMER);  /* stop the running timer */
            WinSetWindowULong(hwnd, QWL_SHOWBUBBLE,0);/* Mouse left control. We need no bubble */
        }
        return (MRESULT)0;
      }/* WPM_TEXT */
      break;
    }
  case WM_TIMER:
    switch (SHORT1FROMMP(mp1))
      {
      case BUBBLE_DELAY_TIMER: /* Intervall timer */
        {
          HWND hwndBubbleClient;
          ULONG style=FCF_BORDER;
          int deltaY=0;
          int deltaX=0;
          char * winText;
          char chrTBFlyFontName[100];
          ULONG  attrFound;
          ULONG  len;
          RGB rgb;
          SHORT dx;

#if 0
          deltaY=WinQueryWindowULong(hwnd, QWL_DELTAPOS)& 0x0000FFFF;
#endif

          WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_DELAY_TIMER);  /* stop the running timer */
          /*  we have to build a new information window  */
          if(hwndBubbleWindow){
            WinDestroyWindow(hwndBubbleWindow);/*  close the bubblewindow  */
            hwndBubbleWindow=NULLHANDLE;
          }
          /* Query the pointer position */
          WinQueryPointerPos(HWND_DESKTOP,&ptl);
          
          /* Create help window */
          if((hwndBubbleWindow=WinCreateStdWindow(HWND_DESKTOP,
                                              0,
                                              &style,
                                              WC_STATIC,
                                              "The window",
                                              SS_TEXT|DT_CENTER|DT_VCENTER,
                                              NULLHANDLE,
                                              400,
                                              &hwndBubbleClient))==NULLHANDLE)
            return (MRESULT) 0;

          /* Set the font for the help */
          if(WinQueryPresParam(hwnd ,
                               PP_FONTNAMESIZE,0,&attrFound,sizeof(chrTBFlyFontName),
                               chrTBFlyFontName,QPF_NOINHERIT))
            WinSetPresParam(hwndBubbleClient,PP_FONTNAMESIZE,
                            sizeof(chrTBFlyFontName),
                            chrTBFlyFontName);
          /* Query the current background colour */
          if(WinQueryPresParam(hwnd,
                                PP_BACKGROUNDCOLOR,0,&attrFound,sizeof(rgb),
                                &rgb, QPF_NOINHERIT))
            WinSetPresParam(hwndBubbleClient,
                            PP_BACKGROUNDCOLOR,(ULONG)sizeof(rgb), &rgb );
            /* Query the current foreground colour */
          if(WinQueryPresParam(hwnd,
                               PP_FOREGROUNDCOLOR,0,&attrFound,sizeof(rgb),
                               &rgb,QPF_NOINHERIT))
            WinSetPresParam(hwndBubbleClient,
                            PP_FOREGROUNDCOLOR,(ULONG)sizeof(rgb), &rgb);          
          /* Set bubble text */
          if((winText=(char*)WinQueryWindowPtr(hwnd,QWL_TEXTPTR))!=NULLHANDLE)
            WinSetWindowText(hwndBubbleClient,winText);
          else {
            WinDestroyWindow(hwndBubbleWindow);/*  close the bubblewindow  */
            hwndBubbleWindow=NULLHANDLE;
          }

          /* Calculate text size in pixel */
          hps=WinBeginPaint(hwndBubbleClient,(HPS)NULL,(PRECTL)NULL);
          GpiQueryTextBox(hps,strlen(winText),winText,TXTBOX_COUNT,aptlPoints);
          WinEndPaint(hps);

          /* Calculate bubble positon and show bubble */
          WinQueryWindowRect(HWND_DESKTOP,&rcl);/* Query desktop size */

          deltaX=(aptlPoints[TXTBOX_BOTTOMRIGHT].x+7+xVal+ptl.x+deltaX 
            > rcl.xRight
                  ? -(aptlPoints[TXTBOX_BOTTOMRIGHT].x-(rcl.xRight-ptl.x)+7+7+xVal)
                  /*                 ? -(aptlPoints[TXTBOX_BOTTOMRIGHT].x-(rcl.xRight-ptl.x)+7+7+xVal)*/
 
                  /*? -(rcl.xRight-(aptlPoints[TXTBOX_BOTTOMRIGHT].x-aptlPoints[TXTBOX_BOTTOMLEFT].x))*/
                  /*     ? -(aptlPoints[TXTBOX_BOTTOMRIGHT].x-aptlPoints[TXTBOX_BOTTOMLEFT].x-xVal-xVal-7 )*/
            : deltaX ) ;  


#if 0
          deltaX+=(aptlPoints[TXTBOX_BOTTOMRIGHT].x-aptlPoints[TXTBOX_BOTTOMLEFT].x+7+xVal+ptl.x+deltaX 
            > rcl.xRight 
            ? -((aptlPoints[TXTBOX_BOTTOMRIGHT].x-aptlPoints[TXTBOX_BOTTOMLEFT].x)-rcl.xRight+deltaX)
                   /*            ? -(aptlPoints[TXTBOX_BOTTOMRIGHT].x-aptlPoints[TXTBOX_BOTTOMLEFT].x-xVal-xVal-7 )*/
            : 0) ;  
#endif     
          deltaY=(aptlPoints[TXTBOX_TOPLEFT].y-aptlPoints[TXTBOX_BOTTOMLEFT].y+2+yVal+ptl.y 
            > rcl.yTop 
            ? deltaY-aptlPoints[TXTBOX_TOPLEFT].y-aptlPoints[TXTBOX_BOTTOMLEFT].y-2*yVal-7
            : 0 );

          WinSetWindowPos(hwndBubbleWindow,
                          HWND_DESKTOP,
                          ptl.x+xVal+deltaX,ptl.y+yVal+deltaY,  
                          aptlPoints[TXTBOX_BOTTOMRIGHT].x-aptlPoints[TXTBOX_BOTTOMLEFT].x+8,
                          aptlPoints[TXTBOX_TOPLEFT].y-aptlPoints[TXTBOX_BOTTOMLEFT].y+2,
                          SWP_SIZE|SWP_MOVE|SWP_SHOW);
          WinStartTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_SHOW_TIMER, 
                        WinQueryWindowULong(hwnd,QWL_SHOWTIME)); /* New timer for delay */
          WinStartTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_CHECK_TIMER, (ULONG) 100); /* New timer for checking if mouse left */
          return (MRESULT) 0;
        }
        break;
      case BUBBLE_SHOW_TIMER: /* Show timer */
        WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_SHOW_TIMER);  /* stop the running timer */
        WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_CHECK_TIMER);  /* stop the running timer */
        if(hwndBubbleWindow){
          WinDestroyWindow(hwndBubbleWindow);/*  close the bubblewindow  */
          hwndBubbleWindow=NULLHANDLE;
        }
        return (MRESULT) 0;
      case BUBBLE_CHECK_TIMER: /* Check for mouse leaving the control */
        if(WinQueryWindowULong(hwnd,QWL_SHOWBUBBLE)==0) {
          if(hwndBubbleWindow){
            WinDestroyWindow(hwndBubbleWindow);/*  close the bubblewindow  */
            hwndBubbleWindow=NULLHANDLE;
          }
          WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_SHOW_TIMER);  /* stop the running timer */
          WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_CHECK_TIMER);  /* stop the running timer */
        }
        return (MRESULT) 0;
      default:
        break;
      }
    break;
  case WM_DESTROY:
    {
      char *ptrText;
      /* Free the memory allocated for the text */
      if((ptrText=(char*)WinQueryWindowPtr(hwnd,QWL_TEXTPTR))!=NULLHANDLE)
        free(ptrText);
      WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_DELAY_TIMER);  /* stop the running timer */
      WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,BUBBLE_SHOW_TIMER);  /* stop the running timer */
      break;
    }
  case WM_PAINT:
    {
      hps=WinBeginPaint(hwnd, NULLHANDLE, NULLHANDLE);
#if 0
      WinQueryWindowRect(hwnd, &rcl);
      WinFillRect(hps,&rcl, CLR_RED);
#endif
      WinEndPaint(hps);
    return (MRESULT) FALSE;
    }
  
  default:
    break;
  }

  return WinDefWindowProc(hwnd, msg, mp1, mp2);

}

ULONG DRCtrlVersion(CHAR *name, ULONG numargs, RXSTRING args[],
                     CHAR *queuename, RXSTRING *retstr)
{
  retstr->strlength = 0;               /* set return value           */
  /* check arguments            */
  if (numargs > 0)
    return INVALID_ROUTINE;
  

  sprintf(retstr->strptr, "%s", DRDCTRL_VERSION);
  retstr->strlength = strlen(retstr->strptr);
  return VALID_ROUTINE;
}

/*************************************************************************
* Function:  DRCtrlDropFuncs                                             *
*                                                                        *
* Syntax:    call DRCtrlDropFuncs                                        *
*                                                                        *
* Params:    none                                                        *
*                                                                        *
* Return:    null string                                                 *
*************************************************************************/

ULONG DRCtrlDropFuncs(CHAR *name, ULONG numargs, RXSTRING args[],
                          CHAR *queuename, RXSTRING *retstr)
{
  INT     entries;                     /* Num of entries             */
  INT     j;                           /* Counter                    */

  if (numargs != 0)                    /* no arguments for this      */
    return INVALID_ROUTINE;            /* raise an error             */

  retstr->strlength = 0;               /* return a null string result*/

  entries = sizeof(RxFncTable)/sizeof(PSZ);

  for (j = 0; j < entries; j++)
    RexxDeregisterFunction(RxFncTable[j]);

  return VALID_ROUTINE;                /* no error on call           */
}


/*************************************************************************
*                                                                        *
* Register the percent bar control with the calling PM process           *
*                                                                        *
*************************************************************************/

ULONG DRCtrlRegister(CHAR *name, ULONG numargs, RXSTRING args[],
                     CHAR *queuename, RXSTRING *retstr)
{

  WinRegisterClass(WinQueryAnchorBlock(HWND_DESKTOP),"DRD_PERCENTBAR",_percentBarProc,0L,12);
  WinRegisterClass(WinQueryAnchorBlock(HWND_DESKTOP),"DRD_BUBBLEHELP",_bubbleHelpProc,0L, BUBBLEHELP_ULONGS);

  return VALID_ROUTINE;                /* no error on call           */
}


/*************************************************************************
* Function:  DRCtrlLoadFuncs                                             *
*                                                                        *
* Syntax:    call DRCtrlLoadFuncs                                        *
*                                                                        *
* Params:    none                                                        *
*                                                                        *
* Return:    null string                                                 *
*************************************************************************/

ULONG DRCtrlLoadFuncs(CHAR *name, ULONG numargs, RXSTRING args[],
                           CHAR *queuename, RXSTRING *retstr)
{
  INT    entries;                      /* Num of entries             */
  INT    j;                            /* Counter                    */

  retstr->strlength = 0;               /* set return value           */
                                       /* check arguments            */

  if (numargs > 0)
    return INVALID_ROUTINE;

  entries = sizeof(RxFncTable)/sizeof(PSZ);

  for (j = 0; j < entries; j++) {
    RexxRegisterFunctionDll(RxFncTable[j],
          "DRUSRCTL", RxFncTable[j]);
  }

  return VALID_ROUTINE;
}


